/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy.ui.wizard.spaces;

import com.ibm.informix.deploy.DeploymentController;
import com.ibm.informix.deploy.archive.FileBundle;
import com.ibm.informix.deploy.job.DataSpacesJob;
import com.ibm.informix.deploy.ui.wizard.config.ConfigurationProvider;
import com.ibm.informix.deploy.ui.wizard.spaces.SpacesComposite;
import com.ibm.informix.deploy.ui.wizard.spaces.SpacesConfigComposite;
import com.ibm.informix.ui.configuration.space.DataSpacesTree;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;

public class SpacesUIJob
extends DataSpacesJob
implements ConfigurationProvider {
    private final SpacesComposite spacesComposite;

    public SpacesUIJob(DeploymentController deploymentController, SpacesComposite spacesComposite) {
        super(deploymentController);
        this.spacesComposite = spacesComposite;
    }

    public void run() {
        this.publishUpdate("Gathering the list of files");
        this.spacesComposite.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                SpacesUIJob.this.setSpacesBundle(SpacesUIJob.getFileBundle(SpacesUIJob.this.spacesComposite.getDataSpacesTree()));
            }
        });
        super.run();
    }

    @Override
    public void createConfiguration(Composite composite) {
        new SpacesConfigComposite(this.spacesComposite, composite, 0);
    }

    public static FileBundle getFileBundle(DataSpacesTree dataSpacesTree) {
        FileBundle fileBundle = new FileBundle();
        SpacesUIJob.fillBundle(fileBundle, dataSpacesTree.getTree().getItems());
        return fileBundle;
    }

    private static void fillBundle(FileBundle fileBundle, TreeItem[] treeItemArray) {
        TreeItem[] treeItemArray2 = treeItemArray;
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray2[n2];
            if (treeItem.getItems().length == 0) {
                SpacesUIJob.addDataFile((FileBundle)fileBundle, (String)treeItem.getText());
            } else {
                SpacesUIJob.fillBundle(fileBundle, treeItem.getItems());
            }
            ++n2;
        }
    }
}

