/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy.ui.wizard.summary;

import com.ibm.informix.deploy.DeploymentController;
import com.ibm.informix.deploy.ui.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SummaryComposite
extends Composite {
    private final Label infoLabel;
    private final Label serverLabel;
    private final Label spacesLabel;
    private final Text detailsText;
    private final Group packageGroup;
    private final DeploymentController controller;

    public SummaryComposite(Composite composite, int n, DeploymentController deploymentController) {
        super(composite, n);
        this.controller = deploymentController;
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 30;
        this.setLayout((Layout)gridLayout);
        this.infoLabel = new Label((Composite)this, 16448);
        this.infoLabel.setText(Messages.Summary_success);
        this.infoLabel.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.packageGroup = new Group((Composite)this, 0);
        this.packageGroup.setText(Messages.Summary_snapshotsLocation);
        this.packageGroup.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        GridLayout gridLayout2 = new GridLayout(2, false);
        gridLayout2.horizontalSpacing = 30;
        gridLayout2.verticalSpacing = 15;
        this.packageGroup.setLayout((Layout)gridLayout2);
        new Label((Composite)this.packageGroup, 0).setText(String.valueOf(Messages.Summary_serverLocation) + ':');
        this.serverLabel = new Label((Composite)this.packageGroup, 64);
        this.serverLabel.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        new Label((Composite)this.packageGroup, 0).setText(String.valueOf(Messages.Summary_spacesLocation) + ':');
        this.spacesLabel = new Label((Composite)this.packageGroup, 64);
        this.spacesLabel.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.detailsText = new Text((Composite)this, 66);
        this.detailsText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.detailsText.setEditable(false);
        this.detailsText.setVisible(false);
    }

    public void populate() {
        this.serverLabel.setText(Messages.getServerSummary(this.controller.getConfiguration()));
        this.spacesLabel.setText(Messages.getSpacesSummary(this.controller.getConfiguration()));
    }

    public void populate(String string) {
        this.packageGroup.setVisible(false);
        this.detailsText.setVisible(true);
        this.infoLabel.setText(Messages.Summary_errorOccured);
        this.detailsText.setText(string);
    }
}

