/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy;

import com.ibm.informix.configuration.InformixInstance;
import com.ibm.informix.deploy.archive.Format;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DeploymentConfiguration {
    public boolean includeData = false;
    public boolean includeServer = true;
    public boolean commandLine = false;
    public boolean acceptAll = false;
    public boolean verbose = false;
    public boolean help = false;
    public boolean version = false;
    public boolean userFilename = false;
    String snapshotFilename;
    Format archiveFormat = Format.getDefault();
    public InformixInstance templateInstance;

    public InformixInstance getTemplateInstance() {
        return this.templateInstance;
    }

    public void setTemplateInstance(InformixInstance informixInstance) {
        this.templateInstance = informixInstance;
        if (!this.userFilename) {
            this.snapshotFilename = null;
        }
    }

    public String getSnapshotFilename() {
        if (this.snapshotFilename == null) {
            String string = new SimpleDateFormat("_yyyyMMdd-HHmm").format(new Date());
            this.snapshotFilename = new File(this.getTemplateInstance().getDatabaseServerName() + string + this.getArchiveFormat().getExtension()).getAbsolutePath();
        }
        if (this.snapshotFilename.endsWith(this.archiveFormat.getExtension())) {
            return this.snapshotFilename;
        }
        return String.valueOf(this.snapshotFilename) + this.archiveFormat.getExtension();
    }

    public void setSnapshotFilename(String string) {
        this.snapshotFilename = string;
        this.userFilename = true;
        if (this.archiveFormat == null) {
            this.setArchiveFormat(Format.getFormatForFile(string));
        }
    }

    public Format getArchiveFormat() {
        return this.archiveFormat == null ? Format.getDefault() : this.archiveFormat;
    }

    public void setArchiveFormat(Format format) {
        this.archiveFormat = format;
    }

    public String getSpacesPackageName() {
        String string = this.getSnapshotFilename();
        Format format = this.getArchiveFormat();
        int n = string.indexOf(format.getExtension());
        return String.valueOf(string.substring(0, n)) + "_db" + format.getExtension();
    }

    public boolean isComplete() {
        return (this.includeServer || this.includeData) && this.templateInstance != null;
    }
}

