/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy;

import com.ibm.informix.deploy.IProgressListener;
import com.ibm.informix.deploy.Messages;
import java.util.ArrayList;
import java.util.List;

public class ProgressPublisher {
    private final List<IProgressListener> progressListeners = new ArrayList<IProgressListener>(1);

    public boolean registerListener(IProgressListener iProgressListener) {
        return this.progressListeners.add(iProgressListener);
    }

    public boolean registerListeners(List<IProgressListener> list) {
        return this.progressListeners.addAll(list);
    }

    public List<IProgressListener> getListeners() {
        return this.progressListeners;
    }

    public boolean unregisterListener(IProgressListener iProgressListener) {
        return this.progressListeners.remove(iProgressListener);
    }

    public void unregisterAllListeners() {
        this.progressListeners.clear();
    }

    public void publishStart() {
        for (IProgressListener iProgressListener : this.progressListeners) {
            iProgressListener.fireStart();
        }
    }

    public void publishUpdate(double d) {
        for (IProgressListener iProgressListener : this.progressListeners) {
            iProgressListener.fireUpdate(d);
        }
    }

    public void publishUpdate(String string) {
        for (IProgressListener iProgressListener : this.progressListeners) {
            iProgressListener.fireUpdate(string);
        }
    }

    public void publishComplete() {
        for (IProgressListener iProgressListener : this.progressListeners) {
            iProgressListener.fireComplete();
        }
    }

    public void publishError(Throwable throwable) {
        for (IProgressListener iProgressListener : this.progressListeners) {
            iProgressListener.fireError(throwable);
        }
    }

    public void publishError(Exception exception, String string) throws Exception {
        this.publishError(new Exception(String.valueOf(string) + ':' + Messages.NEW_LINE + exception.getMessage(), exception));
        throw exception;
    }
}

