/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy;

import com.ibm.arcs.basic.tuple.Triple;
import com.ibm.arcs.database.DatabaseProtocol;
import com.ibm.arcs.database.connection.ConnectionParameters;
import com.ibm.arcs.database.connection.ConnectionParametersBuilder;
import com.ibm.arcs.host.Host;
import com.ibm.arcs.host.HostCatalog;
import com.ibm.arcs.host.HostName;
import com.ibm.arcs.host.HostPort;
import com.ibm.arcs.host.KernelType;
import com.ibm.informix.configuration.EnvironmentReader;
import com.ibm.informix.configuration.EnvironmentVariable;
import com.ibm.informix.configuration.SQLHostsReader;
import com.ibm.informix.connection.InformixDatabaseServerName;
import com.ibm.informix.connection.listener.InformixServerConnectionType;
import com.ibm.informix.connection.listener.InformixSystemDatabases;
import com.ibm.informix.deploy.Messages;
import com.ibm.informix.protocol.drda.DrdaProtocol;
import org.eclipse.osgi.util.NLS;

public class Utility {
    public static ConnectionParameters getConnectionFromEnvironment() throws Exception {
        return Utility.getConnectionFromEnvironment("", "");
    }

    public static ConnectionParameters getConnectionFromEnvironment(String string, String string2) throws Exception {
        EnvironmentReader environmentReader = new EnvironmentReader();
        String string3 = environmentReader.get(EnvironmentVariable.INFORMIXSERVER);
        if (string3 == null || string3.trim().isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(EnvironmentVariable.INFORMIXSERVER.getDisplayName()) + " environment variable is not set");
        }
        KernelType kernelType = HostCatalog.getLocalHost().getOperatingEnvironment().getKernel().getKernelType();
        SQLHostsReader sQLHostsReader = new SQLHostsReader(kernelType, environmentReader.get(EnvironmentVariable.INFORMIXSQLHOSTS));
        InformixDatabaseServerName informixDatabaseServerName = Utility.findDatabaseServerName(string3, sQLHostsReader);
        if (informixDatabaseServerName != null) {
            Triple triple = sQLHostsReader.getValue(informixDatabaseServerName);
            DatabaseProtocol databaseProtocol = ((InformixServerConnectionType)triple.getFirst()).getDatabaseProtocol();
            String string4 = ((HostName)triple.getSecond()).getName();
            int n = ((HostPort)triple.getThird()).getHostPortNumber();
            return Utility.getConnectionParameters(string3, string4, String.valueOf(n), databaseProtocol, string, string2);
        }
        throw new RuntimeException("Unable to retrieve server information from the environment");
    }

    private static final InformixDatabaseServerName findDatabaseServerName(String string, SQLHostsReader sQLHostsReader) {
        for (InformixDatabaseServerName informixDatabaseServerName : sQLHostsReader.getKeySet()) {
            if (!informixDatabaseServerName.getName().equalsIgnoreCase(string)) continue;
            return informixDatabaseServerName;
        }
        return null;
    }

    public static ConnectionParameters getConnectionParameters(String string, String string2, String string3, DatabaseProtocol databaseProtocol) {
        return Utility.getConnectionParameters(string, string2, string3, databaseProtocol, "", "");
    }

    public static ConnectionParameters getConnectionParameters(String string, String string2, String string3, DatabaseProtocol databaseProtocol, String string4, String string5) {
        if (Host.isLocalHost((String)string2)) {
            HostName hostName;
            if (string5.isEmpty() && Host.isLocalHost((String)"localhost")) {
                string2 = "localhost";
            }
            try {
                hostName = HostCatalog.getLocalHostNameWithName((String)string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                hostName = HostCatalog.getNewHost().addHostName(string2);
            }
            ConnectionParametersBuilder connectionParametersBuilder = databaseProtocol.getConnectionParametersBuilder();
            connectionParametersBuilder.setHostName(hostName);
            connectionParametersBuilder.setHostPort(Integer.valueOf(string3).intValue());
            connectionParametersBuilder.setDatabaseServerName(string);
            connectionParametersBuilder.setDatabaseName(databaseProtocol instanceof DrdaProtocol ? InformixSystemDatabases.SYSMASTER.getName() : "");
            connectionParametersBuilder.setUserName(string4);
            connectionParametersBuilder.setUserPassword(string5);
            return connectionParametersBuilder.getConnectionParameters();
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.Connection_ErrorNotLocalhost, (Object)string2));
    }
}

