/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy.archive;

import com.ibm.arcs.basic.file.UnixFile;
import com.ibm.arcs.host.HostCatalog;
import com.ibm.arcs.host.KernelType;
import com.ibm.informix.deploy.ProgressPublisher;
import com.ibm.informix.deploy.archive.ArchiveOutputStream;
import com.ibm.informix.deploy.archive.FileBundle;
import com.ibm.informix.deploy.archive.Format;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tools.bzip2.CBZip2OutputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;

public class Archiver
extends ProgressPublisher {
    private static final int BUFFER_SIZE = 2048;
    private static final int PERCENTBASE = 100;
    private final FileBundle fileBundle;
    private static final long MAX_FILE_SIZE = 0x100000000L;

    public Archiver(FileBundle fileBundle) {
        this.fileBundle = fileBundle;
    }

    public void create(Format format, String string) throws Exception {
        this.publishStart();
        this.fileBundle.reset();
        switch (format) {
            case ZIP: {
                this.createZip(string);
                break;
            }
            default: {
                this.createTar(string, format);
            }
        }
        this.validate(new File(string));
        this.publishComplete();
    }

    private void createZip(final String string) throws Exception {
        ArchiveOutputStream archiveOutputStream = new ArchiveOutputStream(){
            private ZipOutputStream zipOutput;

            @Override
            public void createOutputStream() throws Exception {
                this.zipOutput = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            }

            @Override
            public OutputStream getOutputStream() {
                return this.zipOutput;
            }

            @Override
            public void putNextEntry(File file, String string2) throws Exception {
                this.zipOutput.putNextEntry(new ZipEntry(string2));
            }

            @Override
            public void closeEntry() throws Exception {
                this.zipOutput.closeEntry();
            }

            @Override
            public void close() throws Exception {
                this.zipOutput.close();
            }
        };
        this.createArchive(archiveOutputStream);
    }

    private void createTar(final String string, final Format format) throws Exception {
        ArchiveOutputStream archiveOutputStream = new ArchiveOutputStream(){
            private TarOutputStream tarOutput;
            private final boolean isUnix = HostCatalog.getLocalHost().getOperatingEnvironment().getKernel().getKernelType() != KernelType.Windows;

            @Override
            public void createOutputStream() throws Exception {
                FilterOutputStream filterOutputStream = new BufferedOutputStream(new FileOutputStream(string));
                switch (format) {
                    case BZIP2: {
                        ((OutputStream)filterOutputStream).write(66);
                        ((OutputStream)filterOutputStream).write(90);
                        filterOutputStream = new CBZip2OutputStream((OutputStream)filterOutputStream);
                        break;
                    }
                    case GZIP: {
                        filterOutputStream = new GZIPOutputStream(filterOutputStream);
                    }
                }
                this.tarOutput = new TarOutputStream((OutputStream)filterOutputStream);
                this.tarOutput.setLongFileMode(2);
            }

            @Override
            public OutputStream getOutputStream() {
                return this.tarOutput;
            }

            @Override
            public void putNextEntry(File file, String string2) throws Exception {
                TarEntry tarEntry = new TarEntry(file);
                tarEntry.setName(string2);
                if (this.isUnix) {
                    try {
                        Archiver.setUnixProperties(tarEntry);
                    }
                    catch (Exception exception) {}
                } else {
                    tarEntry.setMode(48);
                }
                this.tarOutput.putNextEntry(tarEntry);
            }

            @Override
            public void closeEntry() throws Exception {
                this.tarOutput.closeEntry();
            }

            @Override
            public void close() throws Exception {
                this.tarOutput.close();
            }
        };
        this.createArchive(archiveOutputStream);
    }

    private void createArchive(ArchiveOutputStream archiveOutputStream) throws Exception {
        byte[] byArray = new byte[2048];
        int n = 0;
        int n2 = this.fileBundle.size();
        archiveOutputStream.createOutputStream();
        while (this.fileBundle.next()) {
            this.publishUpdate(this.fileBundle.getSourceFileName());
            ++n;
            File file = new File(this.fileBundle.getSourceFileName());
            this.validate(file);
            BufferedInputStream bufferedInputStream = null;
            if (!file.isDirectory()) {
                try {
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (!file.exists()) continue;
                    throw fileNotFoundException;
                }
            }
            archiveOutputStream.putNextEntry(file, this.fileBundle.getDestinationFileName());
            if (!file.isDirectory()) {
                Archiver.copy(bufferedInputStream, archiveOutputStream.getOutputStream(), byArray);
                bufferedInputStream.close();
            }
            archiveOutputStream.closeEntry();
            this.publishUpdate(n * 100 / n2);
        }
        archiveOutputStream.close();
    }

    private static void setUnixProperties(TarEntry tarEntry) throws Exception {
        UnixFile unixFile = new UnixFile(tarEntry.getFile());
        tarEntry.setNames(unixFile.userName, unixFile.groupName);
        tarEntry.setMode(unixFile.mode.getMode());
    }

    private static void copy(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws Exception {
        int n;
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    private void validate(File file) throws IllegalArgumentException {
        if (file.length() > 0x100000000L) {
            throw new IllegalArgumentException(String.valueOf(this.fileBundle.getSourceFileName()) + " is too large (>4GB) for the standard ZIP format: " + file.length() + " bytes");
        }
    }
}

