/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy.job;

import com.ibm.informix.bundle.Bundle;
import com.ibm.informix.bundle.FeatureMember;
import com.ibm.informix.bundle.InstalledBundle;
import com.ibm.informix.configuration.InformixInstance;
import com.ibm.informix.deploy.DeploymentController;
import com.ibm.informix.deploy.IProgressListener;
import com.ibm.informix.deploy.Messages;
import com.ibm.informix.deploy.ProgressPublisher;
import com.ibm.informix.deploy.archive.Archiver;
import com.ibm.informix.deploy.archive.FileBundle;
import com.ibm.informix.deploy.job.DeploymentJob;
import java.io.File;

public class BundleJob
extends ProgressPublisher
implements DeploymentJob,
IProgressListener {
    protected final DeploymentController controller;
    private FileBundle serverBundle;

    public BundleJob(DeploymentController deploymentController) {
        this.controller = deploymentController;
    }

    @Override
    public String getName() {
        return "Package the Informix Instance";
    }

    @Override
    public void run() {
        try {
            this.publishStart();
            this.packageServer();
            this.publishComplete();
        }
        catch (Exception exception) {}
    }

    private void packageServer() throws Exception {
        try {
            this.archive(this.getServerBundle(), this.controller.getConfiguration().getSnapshotFilename());
        }
        catch (Exception exception) {
            this.publishError(exception, Messages.Packager_ErrorCreateInstanceSnapshot);
        }
    }

    protected void setServerBundle(FileBundle fileBundle) {
        this.serverBundle = fileBundle;
    }

    private FileBundle getServerBundle() throws Exception {
        if (this.serverBundle == null) {
            this.publishUpdate("Gathering the list of files");
            InformixInstance informixInstance = this.controller.getConfiguration().getTemplateInstance();
            InstalledBundle installedBundle = new InstalledBundle(informixInstance);
            String string = informixInstance.getInformixDir();
            if (!string.endsWith(File.separator)) {
                string = String.valueOf(string) + File.separator;
            }
            FileBundle fileBundle = new FileBundle(string, "", "", "");
            this.fillBundle(fileBundle, (Bundle)installedBundle);
            this.serverBundle = fileBundle;
        }
        return this.serverBundle;
    }

    private void archive(FileBundle fileBundle, String string) throws Exception {
        Archiver archiver = new Archiver(fileBundle);
        archiver.registerListener(this);
        archiver.create(this.controller.getConfiguration().getArchiveFormat(), string);
    }

    @Override
    public void fireStart() {
    }

    @Override
    public void fireUpdate(double d) {
        this.publishUpdate(d);
    }

    @Override
    public void fireUpdate(String string) {
        this.publishUpdate(string);
    }

    @Override
    public void fireComplete() {
    }

    @Override
    public void fireError(Throwable throwable) {
        this.publishError(throwable);
    }

    private void fillBundle(FileBundle fileBundle, Bundle bundle) {
        for (FeatureMember featureMember : bundle.getFeatureMembers()) {
            fileBundle.addFile(featureMember.getName());
        }
    }
}

