/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy.job;

import com.ibm.informix.administration.commands.ServerBlock;
import com.ibm.informix.configuration.space.InformixChunk;
import com.ibm.informix.configuration.space.InformixDataSpace;
import com.ibm.informix.deploy.DeploymentController;
import com.ibm.informix.deploy.IProgressListener;
import com.ibm.informix.deploy.Messages;
import com.ibm.informix.deploy.ProgressPublisher;
import com.ibm.informix.deploy.archive.Archiver;
import com.ibm.informix.deploy.archive.FileBundle;
import com.ibm.informix.deploy.job.DeploymentJob;
import java.io.File;
import java.sql.SQLException;

public class DataSpacesJob
extends ProgressPublisher
implements DeploymentJob,
IProgressListener {
    protected final DeploymentController controller;
    private FileBundle spacesBundle;

    public DataSpacesJob(DeploymentController deploymentController) {
        this.controller = deploymentController;
    }

    @Override
    public String getName() {
        return "Package the Data Spaces";
    }

    public FileBundle getSpacesBundle() throws Exception {
        if (this.spacesBundle == null) {
            FileBundle fileBundle = new FileBundle();
            for (InformixDataSpace informixDataSpace : this.controller.getConfiguration().getTemplateInstance().getInformixDataSpaces()) {
                for (InformixChunk informixChunk : informixDataSpace.getChunks()) {
                    DataSpacesJob.addDataFile(fileBundle, informixChunk.getPath());
                }
            }
            this.spacesBundle = fileBundle;
        }
        return this.spacesBundle;
    }

    public void setSpacesBundle(FileBundle fileBundle) {
        this.spacesBundle = fileBundle;
    }

    protected static void addDataFile(FileBundle fileBundle, String string) {
        String string2 = string.substring(string.lastIndexOf(File.separator) + 1);
        fileBundle.addFile(string, string2);
    }

    @Override
    public void run() {
        try {
            this.publishStart();
            this.packageSpaces();
            this.publishComplete();
        }
        catch (Exception exception) {}
    }

    private void packageSpaces() throws Exception {
        Exception exception;
        block15: {
            exception = null;
            this.publishUpdate("Blocking the instance");
            ServerBlock serverBlock = null;
            try {
                try {
                    try {
                        serverBlock = new ServerBlock(this.controller.getConfiguration().getTemplateInstance().getConnectionParameters());
                        serverBlock.executeAdmin();
                        this.archive(this.getSpacesBundle(), this.controller.getConfiguration().getSpacesPackageName());
                    }
                    catch (SQLException sQLException) {
                        this.publishError(sQLException, Messages.Packager_ErrorBlockInstance);
                    }
                    catch (Exception exception2) {
                        this.publishError(exception2, Messages.Packager_ErrorCreateDataSnapshot);
                    }
                }
                catch (Exception exception3) {
                    exception = exception3;
                    this.publishUpdate("Unblocking the instance");
                    try {
                        serverBlock.undo();
                    }
                    catch (Exception exception4) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                this.publishUpdate("Unblocking the instance");
                try {
                    serverBlock.undo();
                }
                catch (Exception exception5) {}
                throw throwable;
            }
            this.publishUpdate("Unblocking the instance");
            try {
                serverBlock.undo();
            }
            catch (Exception exception6) {}
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void archive(FileBundle fileBundle, String string) throws Exception {
        Archiver archiver = new Archiver(fileBundle);
        archiver.registerListener(this);
        archiver.create(this.controller.getConfiguration().getArchiveFormat(), string);
    }

    @Override
    public void fireStart() {
    }

    @Override
    public void fireUpdate(double d) {
        this.publishUpdate(d);
    }

    @Override
    public void fireUpdate(String string) {
        this.publishUpdate(string);
    }

    @Override
    public void fireComplete() {
    }

    @Override
    public void fireError(Throwable throwable) {
        this.publishError(throwable);
    }
}

