/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.protocol.drda;

import com.ibm.arcs.database.DatabaseName;
import com.ibm.arcs.database.DatabaseProtocol;
import com.ibm.arcs.database.DatabaseServerName;
import com.ibm.arcs.database.connection.AbstractConnectionParameters;
import com.ibm.arcs.host.HostName;
import com.ibm.arcs.host.HostPort;
import com.ibm.arcs.serialization.xml.XmlSerializer;
import com.ibm.arcs.serialization.xml.catalog.HybridXmlSerializerCatalog;
import com.ibm.arcs.serialization.xml.catalog.XmlSerializerCatalog;
import com.ibm.db2.jcc.DB2Driver;
import com.ibm.informix.connection.InformixConnectionParameters;
import com.ibm.informix.connection.listener.InformixListenerParameters;
import com.ibm.informix.connection.listener.InformixSystemDatabases;
import com.ibm.informix.protocol.drda.DrdaConnectionParametersBuilder;
import com.ibm.informix.protocol.drda.DrdaProtocol;
import java.sql.Driver;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;

public final class DrdaConnectionParameters
extends AbstractConnectionParameters
implements InformixConnectionParameters {
    private static final DB2Driver db2Driver = new DB2Driver();
    private final InformixListenerParameters informixListenerParameters;

    public DrdaConnectionParameters(InformixListenerParameters informixListenerParameters, String string, String string2, DatabaseName databaseName, List<String> list, Map<String, Class<?>> map) {
        super(DrdaConnectionParameters.class, (Driver)db2Driver, (DatabaseProtocol)new DrdaProtocol(), databaseName, string, string2, list, map);
        this.informixListenerParameters = informixListenerParameters;
        this.validateDatabaseConnectionProtocol();
    }

    private boolean validateDatabaseConnectionProtocol() {
        DatabaseProtocol databaseProtocol = this.informixListenerParameters.getDatabaseProtocol();
        if (databaseProtocol.getClass().equals(DrdaProtocol.class)) {
            return true;
        }
        throw new RuntimeException("Listener parameters contains invalid database connection protocol for a DRDA connection");
    }

    public DrdaConnectionParametersBuilder getConnectionParametersBuilder() {
        DrdaConnectionParametersBuilder drdaConnectionParametersBuilder = new DrdaConnectionParametersBuilder();
        drdaConnectionParametersBuilder.setDatabaseProtocol(this.getDatabaseProtocol());
        drdaConnectionParametersBuilder.setInformixServerConnectionType(this.informixListenerParameters.getInformixServerConnectionType());
        drdaConnectionParametersBuilder.setHostName(this.getHostName());
        drdaConnectionParametersBuilder.setHostPort(this.getHostPort());
        drdaConnectionParametersBuilder.setDatabaseServerName(this.getDatabaseServerName());
        drdaConnectionParametersBuilder.setDatabaseName(this.getDatabaseName());
        drdaConnectionParametersBuilder.setUserName(this.getUserName());
        drdaConnectionParametersBuilder.setUserPassword(this.getUserPassword());
        drdaConnectionParametersBuilder.addJdbcParameter(this.getJdbcParameters());
        drdaConnectionParametersBuilder.addToTypeMap(this.getTypeMapAdditions());
        return drdaConnectionParametersBuilder;
    }

    public InformixListenerParameters getListenerParameters() {
        return this.informixListenerParameters;
    }

    public boolean isNetworkCapable() {
        return this.informixListenerParameters.getInformixServerConnectionType().isNetworkCapable();
    }

    public DatabaseServerName getDatabaseServerName() {
        return this.informixListenerParameters.getDatabaseServerName();
    }

    public HostName getHostName() {
        return this.informixListenerParameters.getHostName();
    }

    public HostPort getHostPort() {
        return this.informixListenerParameters.getHostPort();
    }

    public String toString() {
        try {
            HybridXmlSerializerCatalog hybridXmlSerializerCatalog = HybridXmlSerializerCatalog.getSharedInstance();
            XmlSerializer xmlSerializer = hybridXmlSerializerCatalog.getSerializerForClass(DrdaConnectionParameters.class);
            return xmlSerializer.toHierarchicalParameter((Object)this, (XmlSerializerCatalog)hybridXmlSerializerCatalog).toString();
        }
        catch (CoreException coreException) {
            throw new RuntimeException(coreException.getCause());
        }
    }

    private final String buildUrl(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("jdbc:" + this.getDatabaseProtocol().getJdbcSubProtocol());
        String string = bl ? "********" : this.getUserPassword();
        stringBuilder.append("://" + this.informixListenerParameters.getHostName() + ":" + this.informixListenerParameters.getHostPort());
        if (this.getDatabaseName().getName().trim().length() == 0) {
            stringBuilder.append("/" + InformixSystemDatabases.SYSMASTER.getName());
        } else {
            stringBuilder.append("/" + this.getDatabaseName().getName());
        }
        if (this.hasUserName() || this.hasExtraJdbcParameters()) {
            stringBuilder.append(':');
        }
        if (this.hasUserName()) {
            stringBuilder.append("user=" + this.getUserName() + ";password=" + string + ";");
        }
        this.appendExtraJdbcParametersToUrl(stringBuilder);
        return stringBuilder.toString();
    }

    protected void appendExtraJdbcParametersToUrl(StringBuilder stringBuilder) {
        if (this.hasExtraJdbcParameters()) {
            for (String string : this.getJdbcParameters()) {
                stringBuilder.append(String.valueOf(string) + ";");
            }
        }
    }

    private String getUrl(boolean bl) {
        return this.buildUrl(bl);
    }

    public String getUrl() {
        return this.getUrl(false);
    }

    public String getUrlWithHiddenPassword() {
        return this.getUrl(true);
    }
}

