/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.protocol.drda;

import com.ibm.arcs.database.DatabaseProtocol;
import com.ibm.informix.connection.InformixConnectionParametersBuilder;
import com.ibm.informix.connection.listener.InformixListenerParameters;
import com.ibm.informix.protocol.drda.DrdaConnectionParameters;
import com.ibm.informix.protocol.drda.DrdaProtocol;

public class DrdaConnectionParametersBuilder
extends InformixConnectionParametersBuilder {
    public DrdaConnectionParametersBuilder() {
        this.setDatabaseProtocol(new DrdaProtocol());
    }

    public DrdaConnectionParameters getConnectionParameters() {
        this.validate();
        if (this.getDatabaseProtocol() instanceof DrdaProtocol) {
            InformixListenerParameters informixListenerParameters = new InformixListenerParameters(this.getDatabaseServerName(), this.getInformixServerConnectionType(), this.getHostName(), this.getHostPort());
            return new DrdaConnectionParameters(informixListenerParameters, this.getUserName(), this.getUserPassword(), this.getDatabaseName(), this.getAllJdbcParameters(), this.getTypeMap());
        }
        throw new RuntimeException("unsupported database protocol");
    }

    public void setDatabaseProtocol(DatabaseProtocol databaseProtocol) {
        Class<?> clazz = databaseProtocol.getClass();
        if (!clazz.equals(DrdaProtocol.class)) {
            throw new IllegalArgumentException("cannot set the protocol used by a DrdaConnectionParametersBuilder to " + databaseProtocol.getName());
        }
        super.setDatabaseProtocol(databaseProtocol);
    }
}

