/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.protocol.drda;

import com.ibm.arcs.basic.uniqueid.RandomIdGenerator;
import com.ibm.db2.jcc.DB2ConnectionPoolDataSource;
import com.ibm.db2.jcc.DB2DataSource;
import com.ibm.db2.jcc.DB2PooledConnection;
import com.ibm.informix.protocol.drda.DrdaConnectionParameters;
import com.ibm.informix.protocol.drda.DrdaProtocol;
import java.io.PrintWriter;
import java.sql.SQLException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrdaConnectionPoolDataSource
implements ConnectionPoolDataSource {
    private static final String namingPrefix = "db2Jcc";
    private static final int initialPoolSizeDefault = 10;
    private static final int minPoolSizeDefault = 10;
    private static final int maximumPoolSizeDefault = 50;
    private static final int maximumConnections = 10;
    private static final int maxIdleTimeDefault = 60;
    private static final long serviceIntervalDefault = 50L;
    private static final RandomIdGenerator idGenerator = new RandomIdGenerator(System.currentTimeMillis());
    private final DrdaConnectionParameters connectionParameters;
    private final DB2ConnectionPoolDataSource connectionPoolDataSource;
    private final int id;
    private final Logger logger;

    public DrdaConnectionPoolDataSource(DrdaConnectionParameters drdaConnectionParameters) throws CoreException {
        if (!drdaConnectionParameters.getDatabaseProtocol().getClass().equals(DrdaProtocol.class)) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.informix.connection", "Database protocol of supplied ConnectionParameters is not DrdaProtocol", (Throwable)new IllegalArgumentException("The database protocol of the supplied DrdaConnectionParameters is unsupported by this class.")));
        }
        this.logger = LoggerFactory.getLogger(DrdaConnectionPoolDataSource.class);
        this.connectionParameters = drdaConnectionParameters;
        this.id = idGenerator.next();
        this.connectionPoolDataSource = this.createNewDataSource();
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        DB2PooledConnection dB2PooledConnection = null;
        if (this.connectionParameters.isNetworkCapable()) {
            try {
                dB2PooledConnection = (DB2PooledConnection)this.connectionPoolDataSource.getPooledConnection();
                if (dB2PooledConnection != null) {
                    this.logger.debug("Connection established");
                }
            }
            catch (SQLException sQLException) {
                this.logger.error("SQLException while retrieving a connection", (Throwable)sQLException);
                throw sQLException;
            }
        }
        return dB2PooledConnection;
    }

    @Override
    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException("getConnection method with alternate username and password is not supported with ConnectionParameters");
    }

    private String getDataSourceId() {
        return "db2JccDs" + Integer.toString(this.id);
    }

    private String getConnectionPoolDataSourceId() {
        return "db2JccCpds" + Integer.toString(this.id);
    }

    private final DB2ConnectionPoolDataSource createNewDataSource() throws CoreException {
        DB2ConnectionPoolDataSource dB2ConnectionPoolDataSource = DrdaConnectionPoolDataSource.createNewConnectionPoolDataSource(this.connectionParameters);
        return dB2ConnectionPoolDataSource;
    }

    private static final DB2ConnectionPoolDataSource createNewConnectionPoolDataSource(DrdaConnectionParameters drdaConnectionParameters) {
        DB2ConnectionPoolDataSource dB2ConnectionPoolDataSource = new DB2ConnectionPoolDataSource();
        dB2ConnectionPoolDataSource.setServerName(drdaConnectionParameters.getHostName().getName());
        dB2ConnectionPoolDataSource.setPortNumber(drdaConnectionParameters.getHostPort().getHostPortNumber());
        dB2ConnectionPoolDataSource.setDatabaseName(drdaConnectionParameters.getDatabaseName().getName());
        dB2ConnectionPoolDataSource.setUser(drdaConnectionParameters.getUserName());
        dB2ConnectionPoolDataSource.setPassword(drdaConnectionParameters.getUserPassword());
        dB2ConnectionPoolDataSource.setDriverType(4);
        DrdaConnectionPoolDataSource.setConnectionPoolDataSourceDefaultValues(dB2ConnectionPoolDataSource);
        return dB2ConnectionPoolDataSource;
    }

    private static final void setConnectionPoolDataSourceDefaultValues(DB2ConnectionPoolDataSource dB2ConnectionPoolDataSource) {
    }

    private static final Context createNewContext(DB2ConnectionPoolDataSource dB2ConnectionPoolDataSource, String string, String string2) throws SQLException, NamingException {
        DrdaConnectionPoolDataSource.establishContextProperties();
        InitialContext initialContext = new InitialContext();
        initialContext.bind(string2, (Object)dB2ConnectionPoolDataSource);
        DB2DataSource dB2DataSource = new DB2DataSource();
        dB2DataSource.setDataSourceName(string2);
        initialContext.bind(string, (Object)dB2DataSource);
        return initialContext;
    }

    private static final void establishContextProperties() {
        System.setProperty("java.naming.provider.url", "file:/tmp");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.connectionPoolDataSource.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.connectionPoolDataSource.getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.connectionPoolDataSource.setLogWriter(printWriter);
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        this.connectionPoolDataSource.setLoginTimeout(n);
    }
}

