/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.protocol.drda;

import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.arcs.database.DatabaseProtocol;
import com.ibm.arcs.database.connection.ConnectionParameters;
import com.ibm.arcs.database.connection.ConnectionParametersWrapper;
import com.ibm.arcs.serialization.xml.XmlSerializer;
import com.ibm.arcs.serialization.xml.catalog.HybridXmlSerializerCatalog;
import com.ibm.arcs.serialization.xml.catalog.XmlSerializerCatalog;
import com.ibm.informix.connection.listener.InformixListenerParameters;
import com.ibm.informix.protocol.drda.DrdaConnectionParameters;
import com.ibm.informix.protocol.drda.DrdaConnectionParametersBuilder;
import com.ibm.informix.protocol.drda.DrdaConnectionPoolDataSource;
import javax.sql.ConnectionPoolDataSource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DrdaProtocol
implements DatabaseProtocol {
    private static final String jdbcSubProtocol = "ids";

    public String getName() {
        return "DRDA";
    }

    public String getJdbcSubProtocol() {
        return jdbcSubProtocol;
    }

    public boolean isNetworkCapable() {
        return true;
    }

    public DrdaConnectionParametersBuilder getConnectionParametersBuilder() {
        return new DrdaConnectionParametersBuilder();
    }

    public InformixListenerParameters createListenerParameters(HierarchicalParameter hierarchicalParameter) throws CoreException {
        HybridXmlSerializerCatalog hybridXmlSerializerCatalog = HybridXmlSerializerCatalog.getSharedInstance();
        XmlSerializer xmlSerializer = hybridXmlSerializerCatalog.getSerializerForClass(InformixListenerParameters.class);
        Object object = xmlSerializer.fromXml(hierarchicalParameter, (XmlSerializerCatalog)hybridXmlSerializerCatalog);
        if (object instanceof InformixListenerParameters) {
            InformixListenerParameters informixListenerParameters = (InformixListenerParameters)object;
            return informixListenerParameters;
        }
        throw new CoreException((IStatus)new Status(4, "com.ibm.informix.connection", "Unable to create InformixListenerParameters from specified HierarchicalParameter", (Throwable)new IllegalArgumentException("deserialized object is not of type informix listener parameters")));
    }

    public ConnectionParameters createConnectionParameters(HierarchicalParameter hierarchicalParameter) throws CoreException {
        HybridXmlSerializerCatalog hybridXmlSerializerCatalog = HybridXmlSerializerCatalog.getSharedInstance();
        XmlSerializer xmlSerializer = hybridXmlSerializerCatalog.getSerializerForClass(DrdaConnectionParameters.class);
        Object object = xmlSerializer.fromXml(hierarchicalParameter, (XmlSerializerCatalog)hybridXmlSerializerCatalog);
        if (object instanceof ConnectionParameters) {
            ConnectionParameters connectionParameters = (ConnectionParameters)object;
            return connectionParameters;
        }
        throw new CoreException((IStatus)new Status(4, "com.ibm.informix.connection", "Unable to create DrdaConnectionParameters from specified HierarchicalParameter", (Throwable)new IllegalArgumentException("deserialized object is not of type DrdaConnectionParameters")));
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(ConnectionParameters connectionParameters) throws CoreException {
        if (connectionParameters instanceof ConnectionParametersWrapper) {
            connectionParameters = ((ConnectionParametersWrapper)connectionParameters).unwrap();
        }
        DrdaConnectionParameters drdaConnectionParameters = (DrdaConnectionParameters)connectionParameters;
        return new DrdaConnectionPoolDataSource(drdaConnectionParameters);
    }

    public boolean equals(Object object) {
        return object instanceof DrdaProtocol;
    }
}

