/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.protocol.sqli;

import com.ibm.arcs.database.DatabaseName;
import com.ibm.arcs.database.DatabaseProtocol;
import com.ibm.arcs.database.DatabaseServerName;
import com.ibm.arcs.database.connection.AbstractConnectionParameters;
import com.ibm.arcs.host.HostName;
import com.ibm.arcs.host.HostPort;
import com.ibm.arcs.serialization.xml.XmlSerializer;
import com.ibm.arcs.serialization.xml.catalog.HybridXmlSerializerCatalog;
import com.ibm.arcs.serialization.xml.catalog.XmlSerializerCatalog;
import com.ibm.informix.connection.InformixConnectionParameters;
import com.ibm.informix.connection.listener.InformixListenerParameters;
import com.ibm.informix.protocol.sqli.SqliConnectionParametersBuilder;
import com.ibm.informix.protocol.sqli.SqliProtocol;
import com.informix.jdbc.IfxDriver;
import java.sql.Driver;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;

public class SqliConnectionParameters
extends AbstractConnectionParameters
implements InformixConnectionParameters {
    private static final IfxDriver ifxDriver = new IfxDriver();
    private final InformixListenerParameters informixListenerParameters;

    public SqliConnectionParameters(InformixListenerParameters informixListenerParameters, String string, String string2, DatabaseName databaseName, List<String> list, Map<String, Class<?>> map) {
        super(SqliConnectionParameters.class, (Driver)ifxDriver, (DatabaseProtocol)new SqliProtocol(), databaseName, string, string2, list, map);
        this.informixListenerParameters = informixListenerParameters;
        this.validateDatabaseConnectionProtocol();
    }

    private boolean validateDatabaseConnectionProtocol() {
        DatabaseProtocol databaseProtocol = this.informixListenerParameters.getDatabaseProtocol();
        if (databaseProtocol.getClass().equals(SqliProtocol.class)) {
            return true;
        }
        throw new RuntimeException("Listener parameters contains invalid database connection protocol for a SQLI connection");
    }

    public SqliConnectionParametersBuilder getConnectionParametersBuilder() {
        SqliConnectionParametersBuilder sqliConnectionParametersBuilder = new SqliConnectionParametersBuilder();
        sqliConnectionParametersBuilder.setDatabaseProtocol(this.getDatabaseProtocol());
        sqliConnectionParametersBuilder.setInformixServerConnectionType(this.informixListenerParameters.getInformixServerConnectionType());
        sqliConnectionParametersBuilder.setHostName(this.getHostName());
        sqliConnectionParametersBuilder.setHostPort(this.getHostPort());
        sqliConnectionParametersBuilder.setDatabaseServerName(this.getDatabaseServerName());
        sqliConnectionParametersBuilder.setDatabaseName(this.getDatabaseName());
        sqliConnectionParametersBuilder.setUserName(this.getUserName());
        sqliConnectionParametersBuilder.setUserPassword(this.getUserPassword());
        sqliConnectionParametersBuilder.addJdbcParameter(this.getJdbcParameters());
        sqliConnectionParametersBuilder.addToTypeMap(this.getTypeMapAdditions());
        return sqliConnectionParametersBuilder;
    }

    public InformixListenerParameters getListenerParameters() {
        return this.informixListenerParameters;
    }

    public DatabaseServerName getDatabaseServerName() {
        return this.informixListenerParameters.getDatabaseServerName();
    }

    public HostName getHostName() {
        return this.informixListenerParameters.getHostName();
    }

    public HostPort getHostPort() {
        return this.informixListenerParameters.getHostPort();
    }

    public boolean isNetworkCapable() {
        return this.informixListenerParameters.getInformixServerConnectionType().isNetworkCapable();
    }

    public String getUrl() {
        return this.getUrl(false);
    }

    public String getUrlWithHiddenPassword() {
        return this.getUrl(true);
    }

    public String toString() {
        try {
            HybridXmlSerializerCatalog hybridXmlSerializerCatalog = HybridXmlSerializerCatalog.getSharedInstance();
            XmlSerializer xmlSerializer = hybridXmlSerializerCatalog.getSerializerForClass(((Object)((Object)this)).getClass());
            return xmlSerializer.toHierarchicalParameter((Object)this, (XmlSerializerCatalog)hybridXmlSerializerCatalog).toString();
        }
        catch (CoreException coreException) {
            throw new RuntimeException(coreException.getCause());
        }
    }

    private String getUrl(boolean bl) {
        return this.buildUrl(bl);
    }

    private final String buildUrl(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("jdbc:" + this.getDatabaseProtocol().getJdbcSubProtocol());
        String string = bl ? "********" : this.getUserPassword();
        stringBuilder.append("://" + this.informixListenerParameters.getHostName());
        stringBuilder.append(":" + this.informixListenerParameters.getHostPort());
        if (this.getDatabaseName().getName().trim().length() > 0) {
            stringBuilder.append("/" + this.getDatabaseName().getName());
        }
        stringBuilder.append(":INFORMIXSERVER=" + this.informixListenerParameters.getDatabaseServerName().getName());
        if (this.hasUserName() || this.hasExtraJdbcParameters()) {
            stringBuilder.append(';');
        }
        if (this.hasUserName()) {
            stringBuilder.append("user=" + this.getUserName() + ";password=" + string);
            if (this.hasExtraJdbcParameters()) {
                stringBuilder.append(';');
            }
        }
        this.appendExtraJdbcParametersToUrl(stringBuilder);
        return stringBuilder.toString();
    }
}

