/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.protocol.sqli;

import com.ibm.arcs.database.DatabaseProtocol;
import com.ibm.informix.connection.InformixConnectionParametersBuilder;
import com.ibm.informix.connection.listener.InformixListenerParameters;
import com.ibm.informix.protocol.sqli.SqliConnectionParameters;
import com.ibm.informix.protocol.sqli.SqliProtocol;

public class SqliConnectionParametersBuilder
extends InformixConnectionParametersBuilder {
    public SqliConnectionParametersBuilder() {
        this.setDatabaseProtocol(new SqliProtocol());
    }

    public SqliConnectionParameters getConnectionParameters() {
        this.validate();
        if (this.getDatabaseProtocol() instanceof SqliProtocol) {
            InformixListenerParameters informixListenerParameters = new InformixListenerParameters(this.getDatabaseServerName(), this.getInformixServerConnectionType(), this.getHostName(), this.getHostPort());
            return new SqliConnectionParameters(informixListenerParameters, this.getUserName(), this.getUserPassword(), this.getDatabaseName(), this.getAllJdbcParameters(), this.getTypeMap());
        }
        throw new RuntimeException("unsupported database protocol");
    }

    public void setDatabaseProtocol(DatabaseProtocol databaseProtocol) {
        Class<?> clazz = databaseProtocol.getClass();
        if (!clazz.equals(SqliProtocol.class)) {
            throw new IllegalArgumentException("cannot set the protocol used by a SqliConnectionParametersBuilder to " + databaseProtocol.getName());
        }
        super.setDatabaseProtocol(databaseProtocol);
    }
}

