/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.protocol.sqli;

import com.ibm.arcs.basic.uniqueid.RandomIdGenerator;
import com.ibm.informix.protocol.sqli.SqliConnectionParameters;
import com.ibm.informix.protocol.sqli.SqliProtocol;
import com.informix.jdbcx.IfxConnectionPoolDataSource;
import com.informix.jdbcx.IfxDataSource;
import com.informix.jdbcx.IfxPooledConnection;
import java.io.PrintWriter;
import java.sql.SQLException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqliConnectionPoolDataSource
implements ConnectionPoolDataSource {
    private static final String namingPrefix = "ifxJdbc";
    private static final int initialPoolSizeDefault = 10;
    private static final int minPoolSizeDefault = 10;
    private static final int maximumPoolSizeDefault = 50;
    private static final int maximumConnections = 10;
    private static final int maxIdleTimeDefault = 60;
    private static final long serviceIntervalDefault = 50L;
    private static final RandomIdGenerator idGenerator = new RandomIdGenerator(System.currentTimeMillis());
    private final SqliConnectionParameters connectionParameters;
    private final IfxConnectionPoolDataSource connectionPoolDataSource;
    private final int id;
    private final Logger logger;

    public SqliConnectionPoolDataSource(SqliConnectionParameters sqliConnectionParameters) throws CoreException {
        if (!(sqliConnectionParameters.getDatabaseProtocol() instanceof SqliProtocol)) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.informix.connection", "Database protocol of supplied ConnectionParameters is not SqliProtocol", (Throwable)new IllegalArgumentException("The database protocol of the supplied SqliConnectionParameters is unsupported by this class.")));
        }
        this.logger = LoggerFactory.getLogger(SqliConnectionPoolDataSource.class);
        this.connectionParameters = sqliConnectionParameters;
        this.id = idGenerator.next();
        this.connectionPoolDataSource = this.createNewDataSource();
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        IfxPooledConnection ifxPooledConnection = null;
        if (this.connectionParameters.isNetworkCapable()) {
            try {
                ifxPooledConnection = (IfxPooledConnection)this.connectionPoolDataSource.getPooledConnection();
                if (ifxPooledConnection != null) {
                    this.logger.debug("Connection established");
                }
            }
            catch (SQLException sQLException) {
                this.logger.error("SQLException while retrieving a connection", (Throwable)sQLException);
                throw sQLException;
            }
        }
        return ifxPooledConnection;
    }

    @Override
    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException("getConnection method with alternate username and password is not supported with ConnectionParameters");
    }

    private String getDataSourceId() {
        return "ifxJdbcDs" + Integer.toString(this.id);
    }

    private String getConnectionPoolDataSourceId() {
        return "ifxJdbcCpds" + Integer.toString(this.id);
    }

    private final IfxConnectionPoolDataSource createNewDataSource() throws CoreException {
        IfxConnectionPoolDataSource ifxConnectionPoolDataSource = SqliConnectionPoolDataSource.createNewConnectionPoolDataSource(this.connectionParameters);
        return ifxConnectionPoolDataSource;
    }

    private static final IfxConnectionPoolDataSource createNewConnectionPoolDataSource(SqliConnectionParameters sqliConnectionParameters) {
        IfxConnectionPoolDataSource ifxConnectionPoolDataSource = new IfxConnectionPoolDataSource();
        ifxConnectionPoolDataSource.setIfxIFXHOST(sqliConnectionParameters.getHostName().getName());
        ifxConnectionPoolDataSource.setPortNumber(sqliConnectionParameters.getHostPort().getHostPortNumber());
        ifxConnectionPoolDataSource.setServerName(sqliConnectionParameters.getDatabaseServerName().getName());
        ifxConnectionPoolDataSource.setDatabaseName(sqliConnectionParameters.getDatabaseName().getName());
        ifxConnectionPoolDataSource.setUser(sqliConnectionParameters.getUserName());
        ifxConnectionPoolDataSource.setPassword(sqliConnectionParameters.getUserPassword());
        SqliConnectionPoolDataSource.setConnectionPoolDataSourceDefaultValues(ifxConnectionPoolDataSource);
        return ifxConnectionPoolDataSource;
    }

    private static final void setConnectionPoolDataSourceDefaultValues(IfxConnectionPoolDataSource ifxConnectionPoolDataSource) {
    }

    private static final Context createNewContext(IfxConnectionPoolDataSource ifxConnectionPoolDataSource, String string, String string2) throws SQLException, NamingException {
        SqliConnectionPoolDataSource.establishContextProperties();
        InitialContext initialContext = new InitialContext();
        initialContext.bind(string2, (Object)ifxConnectionPoolDataSource);
        IfxDataSource ifxDataSource = new IfxDataSource();
        ifxDataSource.setDataSourceName(string2);
        initialContext.bind(string, (Object)ifxDataSource);
        return initialContext;
    }

    private static final void establishContextProperties() {
        System.setProperty("java.naming.provider.url", "file:/tmp");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.connectionPoolDataSource.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.connectionPoolDataSource.getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.connectionPoolDataSource.setLogWriter(printWriter);
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        this.connectionPoolDataSource.setLoginTimeout(n);
    }
}

