/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.ui;

import com.ibm.arcs.status.ui.AbstractStatusPublishingComposite;
import com.ibm.informix.ui.Messages;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class OnconfigLocationComposite
extends AbstractStatusPublishingComposite {
    private Label onconfigLocationLabel;
    private File onconfigPath = null;
    private Text onconfigText;
    private Button browseButton;
    private int priority;
    private boolean isVisible = true;
    private Status statusOK;
    private static final String[] FileDialogNamesFilter = new String[]{Messages.Label_AllFilesFilter};
    private static final String[] FileDialogExtensionsFilter = new String[]{"*.*"};

    public OnconfigLocationComposite(final Composite composite, int n, int n2) {
        super(composite, n);
        this.setLayout((Layout)new FormLayout());
        this.priority = n2;
        this.statusOK = new Status(0, "com.ibm.informix.ui", n2, "", null);
        this.onconfigLocationLabel = new Label((Composite)this, 0);
        this.onconfigLocationLabel.setText(Messages.Label_OnConfigFileLocation);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        this.onconfigLocationLabel.setLayoutData((Object)formData);
        this.onconfigText = new Text((Composite)this, 2048);
        this.onconfigText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                OnconfigLocationComposite.this.onconfigPath = new File(OnconfigLocationComposite.this.onconfigText.getText());
                if (OnconfigLocationComposite.this.onconfigText.getText().equals("")) {
                    OnconfigLocationComposite.this.onconfigPath = null;
                }
                OnconfigLocationComposite.this.verifyAndPublishStatus();
            }
        });
        this.onconfigText.setEnabled(true);
        this.onconfigText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                OnconfigLocationComposite.this.onconfigPath = new File(OnconfigLocationComposite.this.onconfigText.getText());
                if (OnconfigLocationComposite.this.onconfigText.getText().equals("")) {
                    OnconfigLocationComposite.this.onconfigPath = null;
                }
                OnconfigLocationComposite.this.verifyAndPublishStatus();
            }
        });
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.onconfigLocationLabel, 0, 128);
        formData.left = new FormAttachment((Control)this.onconfigLocationLabel, 5, 131072);
        this.onconfigText.setLayoutData((Object)formData);
        this.browseButton = new Button((Composite)this, 0);
        this.browseButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                FileDialog fileDialog = new FileDialog(composite.getShell(), 4096);
                fileDialog.setFileName(OnconfigLocationComposite.this.onconfigText.getText());
                fileDialog.setFilterNames(FileDialogNamesFilter);
                fileDialog.setFilterExtensions(FileDialogExtensionsFilter);
                String string = fileDialog.open();
                if (string != null) {
                    OnconfigLocationComposite.this.onconfigText.setText(string);
                }
            }
        });
        this.browseButton.setEnabled(true);
        formData.right = new FormAttachment((Control)this.browseButton, -5, 16384);
        formData.right = new FormAttachment((Control)this.browseButton, -5, 16384);
        FormData formData2 = new FormData();
        formData2.right = new FormAttachment(100, 0);
        formData2.top = new FormAttachment((Control)this.onconfigText, 0, 128);
        this.browseButton.setLayoutData((Object)formData2);
        this.browseButton.setText(Messages.Label_OnConfileFileBrowseButton);
    }

    public String getValue() {
        return this.onconfigText.getText();
    }

    public IStatus getStatus() {
        if (this.isVisible) {
            if (this.getValue().length() == 0) {
                Status status = new Status(4, "com.ibm.informix.ui", this.priority, Messages.Error_OnConfigFileLocationIsRequired, null);
                return status;
            }
            if (!this.onconfigPath.exists()) {
                Status status = new Status(4, "com.ibm.informix.ui", this.priority, Messages.Error_OnConfigFileDoesNotExist, null);
                return status;
            }
            if (this.onconfigPath.isDirectory()) {
                Status status = new Status(4, "com.ibm.informix.ui", this.priority, Messages.Error_OnConfigFileCannotBeADirectory, null);
                return status;
            }
            if (!this.onconfigPath.canRead()) {
                Status status = new Status(4, "com.ibm.informix.ui", this.priority, Messages.Error_OnConfigFileIsNotReadable, null);
                return status;
            }
        }
        Status status = this.statusOK;
        return status;
    }

    public void disableLocation() {
        this.isVisible = false;
        this.onconfigLocationLabel.setVisible(false);
        this.onconfigText.setVisible(false);
        this.browseButton.setVisible(false);
        this.publishStatus((IStatus)this.statusOK);
    }

    public void enableLocation() {
        this.isVisible = true;
        this.onconfigLocationLabel.setVisible(true);
        this.onconfigText.setVisible(true);
        this.browseButton.setVisible(true);
        this.publishStatus((IStatus)this.statusOK);
    }

    public void editLabelText(String string) {
        this.onconfigLocationLabel.setText(string);
    }
}

