/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.ui;

import com.ibm.arcs.status.ui.AbstractStatusPublishingComposite;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SQLHostsLocationComposite
extends AbstractStatusPublishingComposite {
    private Text sqlText;
    private Button sqlBrowseButton;
    private File sqlHostPath = null;
    private Label sqlLocationLabel;
    private final int priority;
    private boolean isVisible = true;
    private Status statusOK;
    private static final String[] FileDialogNamesFilter = new String[]{"All Files(*.*)"};
    private static final String[] FileDialogExtensionsFilter = new String[]{"*.*"};

    public SQLHostsLocationComposite(final Composite composite, int n, int n2) {
        super(composite, n);
        this.setLayout((Layout)new FormLayout());
        this.priority = n2;
        this.statusOK = new Status(0, "onconfigFile", n2, "everything is alright", null);
        this.sqlLocationLabel = new Label((Composite)this, 0);
        this.sqlLocationLabel.setText("SQL Host File Location");
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        this.sqlLocationLabel.setLayoutData((Object)formData);
        this.sqlLocationLabel.setEnabled(true);
        this.sqlText = new Text((Composite)this, 2048);
        this.sqlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                SQLHostsLocationComposite.this.sqlHostPath = new File(SQLHostsLocationComposite.this.sqlText.getText());
                if (SQLHostsLocationComposite.this.sqlText.getText().equals("")) {
                    SQLHostsLocationComposite.this.sqlHostPath = null;
                }
                SQLHostsLocationComposite.this.verifyAndPublishStatus();
            }
        });
        this.sqlText.setEnabled(true);
        this.sqlText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                SQLHostsLocationComposite.this.sqlHostPath = new File(SQLHostsLocationComposite.this.sqlText.getText());
                if (SQLHostsLocationComposite.this.sqlText.getText().equals("")) {
                    SQLHostsLocationComposite.this.sqlHostPath = null;
                }
                SQLHostsLocationComposite.this.verifyAndPublishStatus();
            }
        });
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment((Control)this.sqlLocationLabel, 0, 128);
        formData2.left = new FormAttachment((Control)this.sqlLocationLabel, 5, 131072);
        this.sqlText.setLayoutData((Object)formData2);
        this.sqlBrowseButton = new Button((Composite)this, 0);
        this.sqlBrowseButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                FileDialog fileDialog = new FileDialog(composite.getShell(), 4096);
                fileDialog.setFileName(SQLHostsLocationComposite.this.sqlText.getText());
                fileDialog.setFilterNames(FileDialogNamesFilter);
                fileDialog.setFilterExtensions(FileDialogExtensionsFilter);
                String string = fileDialog.open();
                if (string != null) {
                    SQLHostsLocationComposite.this.sqlText.setText(string);
                }
            }
        });
        this.sqlBrowseButton.setEnabled(true);
        formData2.right = new FormAttachment((Control)this.sqlBrowseButton, -5, 16384);
        FormData formData3 = new FormData();
        formData3.right = new FormAttachment(100, 0);
        formData3.top = new FormAttachment((Control)this.sqlText, 0, 128);
        this.sqlBrowseButton.setLayoutData((Object)formData3);
        this.sqlBrowseButton.setText("Browse");
    }

    public String getValue() {
        return this.sqlText.getText();
    }

    public IStatus getStatus() {
        if (this.isVisible) {
            if (this.getValue().length() == 0) {
                Status status = new Status(4, "sqlHostFile", this.priority, "SQL Host File Location is required", null);
                return status;
            }
            if (!this.sqlHostPath.exists()) {
                Status status = new Status(4, "sqlHostFile", this.priority, "SQL host file does not exist", null);
                return status;
            }
            if (this.sqlHostPath.isDirectory()) {
                Status status = new Status(4, "sqlHostFile", this.priority, "SQL host file cannot be a directory", null);
                return status;
            }
            if (!this.sqlHostPath.canRead()) {
                Status status = new Status(4, "sqlHostFileFile", this.priority, "SQL host file is not readable, must change permissions", null);
                return status;
            }
        }
        Status status = this.statusOK;
        return status;
    }

    public void updateSQLHostsFileLocationVisibility(boolean bl) {
        if (bl) {
            this.enableLocation();
        } else {
            this.disableLocation();
        }
    }

    public void disableLocation() {
        this.isVisible = false;
        this.sqlLocationLabel.setVisible(false);
        this.sqlText.setVisible(false);
        this.sqlBrowseButton.setVisible(false);
        this.publishStatus((IStatus)this.statusOK);
    }

    public void enableLocation() {
        this.isVisible = true;
        this.sqlLocationLabel.setVisible(true);
        this.sqlText.setVisible(true);
        this.sqlBrowseButton.setVisible(true);
        this.publishStatus((IStatus)this.statusOK);
    }

    public void editLabelText(String string) {
        this.sqlLocationLabel.setText(string);
    }
}

