/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.ui.configuration.space;

import com.ibm.arcs.status.ui.AbstractStatusPublishingComposite;
import com.ibm.informix.configuration.space.InformixChunk;
import com.ibm.informix.configuration.space.InformixDataSpace;
import com.ibm.informix.ui.configuration.space.DataSpacesTreeColumn;
import com.ibm.informix.ui.configuration.space.DataSpacesTreeListener;
import com.ibm.informix.ui.configuration.space.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class DataSpacesTree
extends AbstractStatusPublishingComposite {
    private final Tree dataSpacesTree;
    private final List<DataSpacesTreeListener> listeners;
    private final List<DataSpacesTreeColumn> columns;
    private final int priority;
    private final boolean showChunks;
    private static final int NAME_INDEX = 0;

    public DataSpacesTree(Composite composite, int n, int n2, boolean bl) {
        super(composite, 0);
        this.setLayout((Layout)new FillLayout());
        this.listeners = new ArrayList<DataSpacesTreeListener>(1);
        this.columns = new ArrayList<DataSpacesTreeColumn>(1);
        this.priority = n2;
        this.showChunks = bl;
        this.dataSpacesTree = this.createSpacesTree(n);
        TreeColumn treeColumn = new TreeColumn(this.dataSpacesTree, 16384, 0);
        treeColumn.setWidth(630);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.dataSpacesTree.setEnabled(bl);
    }

    private Tree createSpacesTree(int n) {
        Tree tree = new Tree((Composite)this, n);
        tree.setToolTipText(Messages.Data_DataAssociation);
        tree.setHeaderVisible(true);
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DataSpacesTree.this.notifyListeners(selectionEvent);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                DataSpacesTree.this.notifyListeners(selectionEvent);
            }
        });
        return tree;
    }

    private void createHeader(DataSpacesTreeColumn dataSpacesTreeColumn, int n) {
        TreeColumn treeColumn = new TreeColumn(this.dataSpacesTree, dataSpacesTreeColumn.getStyle(), n);
        treeColumn.setWidth(dataSpacesTreeColumn.getWidth());
    }

    public void addListener(DataSpacesTreeListener dataSpacesTreeListener) {
        this.listeners.add(dataSpacesTreeListener);
    }

    private void notifyListeners(SelectionEvent selectionEvent) {
        for (DataSpacesTreeListener dataSpacesTreeListener : this.listeners) {
            dataSpacesTreeListener.itemSelected(selectionEvent);
        }
    }

    public synchronized int addColumn(DataSpacesTreeColumn dataSpacesTreeColumn) {
        this.columns.add(dataSpacesTreeColumn);
        int n = this.dataSpacesTree.getColumnCount();
        this.createHeader(dataSpacesTreeColumn, n);
        return n;
    }

    private void onCreate(TreeItem treeItem) {
        for (DataSpacesTreeColumn dataSpacesTreeColumn : this.columns) {
            dataSpacesTreeColumn.onCreate(treeItem);
        }
    }

    private void onChildrenCreate(TreeItem treeItem) {
        for (DataSpacesTreeColumn dataSpacesTreeColumn : this.columns) {
            dataSpacesTreeColumn.onChildrenCreate(treeItem);
        }
    }

    public void populate(Collection<InformixDataSpace> collection) throws Exception {
        for (InformixDataSpace informixDataSpace : collection) {
            TreeItem treeItem = new TreeItem(this.dataSpacesTree, 0);
            treeItem.setText(0, informixDataSpace.getName());
            treeItem.setData((Object)informixDataSpace);
            treeItem.setExpanded(false);
            DataSpacesTree.setFont(treeItem, 1);
            this.onCreate(treeItem);
            if (!this.showChunks) continue;
            for (InformixChunk informixChunk : informixDataSpace.getChunks()) {
                TreeItem treeItem2 = new TreeItem(treeItem, 0);
                treeItem2.setText(0, informixChunk.getPath());
                treeItem2.setData((Object)informixChunk);
                this.onCreate(treeItem2);
            }
            this.onChildrenCreate(treeItem);
        }
        this.endWait();
    }

    private static void setFont(TreeItem treeItem, int n) {
        FontData[] fontDataArray;
        FontData[] fontDataArray2 = fontDataArray = treeItem.getFont(0).getFontData();
        int n2 = fontDataArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FontData fontData = fontDataArray2[n3];
            fontData.setStyle(fontData.getStyle() | n);
            ++n3;
        }
        treeItem.setFont(new Font((Device)treeItem.getDisplay(), fontDataArray));
    }

    public void unload() {
        this.startWait();
        this.dataSpacesTree.removeAll();
    }

    private void startWait() {
        TreeColumn[] treeColumnArray = this.dataSpacesTree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn treeColumn = treeColumnArray[n2];
            treeColumn.setText("Loading...");
            ++n2;
        }
    }

    private void endWait() {
        this.dataSpacesTree.getColumn(0).setText("Name");
        int n = 0;
        while (n < this.columns.size()) {
            this.dataSpacesTree.getColumn(n + 1).setText(this.columns.get(n).getName());
            ++n;
        }
    }

    public IStatus getStatus() {
        return Status.OK_STATUS;
    }

    public void setToolTipText(String string) {
        this.dataSpacesTree.setToolTipText(string);
    }

    public Tree getTree() {
        return this.dataSpacesTree;
    }
}

