/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.ui.configuration.space;

import com.ibm.arcs.basic.unit.ByteUnit;
import com.ibm.arcs.basic.unit.ByteValue;
import com.ibm.informix.configuration.space.InformixChunk;
import com.ibm.informix.ui.configuration.space.DataSpacesTree;
import com.ibm.informix.ui.configuration.space.DataSpacesTreeColumn;
import com.ibm.informix.ui.configuration.space.DataSpacesTreeListener;
import java.io.File;
import java.math.RoundingMode;
import java.text.NumberFormat;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.TreeItem;

public class SizeColumn
implements DataSpacesTreeColumn,
DataSpacesTreeListener {
    public final int index;
    public static final ByteUnit CHUNK_BYTEUNIT = ByteUnit.MEBIBYTE;
    public static final ByteUnit SPACE_BYTEUNIT = ByteUnit.GIBIBYTE;
    public static final NumberFormat CHUNK_FORMAT;
    public static final NumberFormat SPACE_FORMAT;
    public static final String SIZE = "SIZE_INDEX";
    public static final String TOTAL = "TOTAL_INDEX";
    public static final ByteValue ZERO;
    private static final String ZERO_GROUP;

    static {
        ZERO = new ByteValue(0L, SPACE_BYTEUNIT);
        CHUNK_FORMAT = NumberFormat.getIntegerInstance();
        CHUNK_FORMAT.setRoundingMode(RoundingMode.CEILING);
        SPACE_FORMAT = NumberFormat.getNumberInstance();
        ZERO_GROUP = SizeColumn.getSize(ZERO, SPACE_FORMAT, SPACE_BYTEUNIT);
        SPACE_FORMAT.setMinimumFractionDigits(2);
        SPACE_FORMAT.setMaximumFractionDigits(2);
        SPACE_FORMAT.setRoundingMode(RoundingMode.CEILING);
    }

    public SizeColumn(DataSpacesTree dataSpacesTree) {
        this.index = dataSpacesTree.addColumn(this);
        dataSpacesTree.addListener(this);
    }

    @Override
    public void onCreate(TreeItem treeItem) {
        if (treeItem.getData() instanceof InformixChunk) {
            File file = new File(((InformixChunk)treeItem.getData()).getPath());
            if (file.exists()) {
                ByteValue byteValue = new ByteValue(file.length(), ByteUnit.BYTE);
                treeItem.setText(this.index, SizeColumn.getSize(byteValue, CHUNK_FORMAT, CHUNK_BYTEUNIT));
                treeItem.setData(SIZE, (Object)byteValue.convertTo(CHUNK_BYTEUNIT));
                TreeItem treeItem2 = treeItem.getParentItem();
                treeItem2.setData(SIZE, (Object)((ByteValue)treeItem2.getData(SIZE)).add(byteValue));
            }
        } else {
            treeItem.setData(SIZE, (Object)ZERO);
        }
    }

    @Override
    public void onChildrenCreate(TreeItem treeItem) {
        ByteValue byteValue = (ByteValue)treeItem.getData(SIZE);
        treeItem.setData(TOTAL, (Object)byteValue);
        treeItem.setText(this.index, SizeColumn.getSize(byteValue, SPACE_FORMAT, SPACE_BYTEUNIT));
    }

    @Override
    public String getName() {
        return "Size";
    }

    @Override
    public int getWidth() {
        return 150;
    }

    @Override
    public int getStyle() {
        return 131072;
    }

    @Override
    public void itemSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.detail == 32) {
            TreeItem treeItem = (TreeItem)selectionEvent.item;
            this.ascend(treeItem.getParentItem(), this.descend(treeItem, treeItem.getChecked()), treeItem.getChecked());
        }
    }

    private ByteValue descend(TreeItem treeItem, boolean bl) {
        ByteValue byteValue;
        if (treeItem.getItemCount() > 0) {
            if (bl) {
                byteValue = (ByteValue)treeItem.getData(TOTAL);
                treeItem.setData(SIZE, (Object)byteValue);
                treeItem.setText(this.index, SizeColumn.getSize(byteValue, SPACE_FORMAT, SPACE_BYTEUNIT));
            } else {
                byteValue = (ByteValue)treeItem.getData(SIZE);
                treeItem.setData(SIZE, (Object)ZERO);
                treeItem.setText(this.index, ZERO_GROUP);
            }
            TreeItem[] treeItemArray = treeItem.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem treeItem2 = treeItemArray[n2];
                this.descend(treeItem2, bl);
                ++n2;
            }
        } else {
            byteValue = (ByteValue)treeItem.getData(SIZE);
        }
        return byteValue;
    }

    private void ascend(TreeItem treeItem, ByteValue byteValue, boolean bl) {
        if (treeItem != null) {
            ByteValue byteValue2 = (ByteValue)treeItem.getData(SIZE);
            ByteValue byteValue3 = bl ? byteValue2.add(byteValue) : byteValue2.subtract(byteValue);
            treeItem.setData(SIZE, (Object)byteValue3);
            treeItem.setText(this.index, SizeColumn.getSize(byteValue3, SPACE_FORMAT, SPACE_BYTEUNIT));
            this.ascend(treeItem.getParentItem(), byteValue, bl);
        }
    }

    public static String getSize(ByteValue byteValue, NumberFormat numberFormat, ByteUnit byteUnit) {
        return String.valueOf(numberFormat.format(byteValue.convertTo(byteUnit).getValue())) + ' ' + byteUnit.getAbbreviation();
    }
}

