/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.ui.connection;

import com.ibm.arcs.database.DatabaseProtocol;
import com.ibm.arcs.database.connection.ConnectionParameters;
import com.ibm.arcs.database.connection.ConnectionParametersBuilder;
import com.ibm.arcs.database.ui.connection.jdbcparameters.JdbcParametersComposite;
import com.ibm.arcs.host.Host;
import com.ibm.arcs.host.HostCatalog;
import com.ibm.arcs.host.HostName;
import com.ibm.arcs.host.ui.widgets.HostComposite;
import com.ibm.arcs.host.ui.widgets.HostNameText;
import com.ibm.arcs.host.ui.widgets.HostPortText;
import com.ibm.arcs.host.ui.widgets.PortComposite;
import com.ibm.arcs.status.publish.IStatusPublisher;
import com.ibm.arcs.status.ui.group.GroupStatusPublishingComposite;
import com.ibm.arcs.ui.widgets.PasswordComposite;
import com.ibm.arcs.ui.widgets.PasswordText;
import com.ibm.arcs.ui.widgets.UsernameComposite;
import com.ibm.arcs.ui.widgets.UsernameText;
import com.ibm.informix.connection.listener.InformixSystemDatabases;
import com.ibm.informix.ui.Messages;
import com.ibm.informix.ui.connection.DBNameComposite;
import com.ibm.informix.ui.connection.DbNameText;
import com.ibm.informix.ui.connection.InformixProtocolCombo;
import com.ibm.informix.ui.connection.InformixProtocolComposite;
import com.ibm.informix.ui.connection.InstanceNameComposite;
import com.ibm.informix.ui.connection.InstanceNameText;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ConnectionParametersComposite
extends GroupStatusPublishingComposite {
    protected HostComposite hostComposite = new HostComposite((Composite)this, 0, 0);
    protected InformixProtocolComposite databaseProtocolComposite = new InformixProtocolComposite((Composite)this, 0, 1);
    protected PortComposite portComposite = new PortComposite((Composite)this, 0, 2);
    protected DBNameComposite dbNameComposite = new DBNameComposite((Composite)this, 0, 3);
    protected InstanceNameComposite serverNameComposite = new InstanceNameComposite((Composite)this, 0, 4);
    protected UsernameComposite usernameComposite = new UsernameComposite((Composite)this, 0, 5);
    protected PasswordComposite passwordComposite = new PasswordComposite((Composite)this, 0, 6);
    protected JdbcParametersComposite jdbcParametersComposite = new JdbcParametersComposite((Composite)this, 0);

    public ConnectionParametersComposite(Composite composite, int n) {
        super(composite, n);
        this.initStatusListeners();
        this.setLayout();
    }

    protected void initStatusListeners() {
        this.addStatusPublisher((IStatusPublisher)this.getHostText());
        this.addStatusPublisher((IStatusPublisher)this.getDatabaseProtocolCombo());
        this.addStatusPublisher((IStatusPublisher)this.getPortText());
        this.addStatusPublisher((IStatusPublisher)this.getServerText());
        this.addStatusPublisher((IStatusPublisher)this.getUsernameText());
        this.addStatusPublisher((IStatusPublisher)this.getPasswordText());
        this.addStatusPublisher((IStatusPublisher)this.getDbNameText());
        this.addStatusPublisher((IStatusPublisher)this.jdbcParametersComposite);
    }

    protected void checkSubclass() {
    }

    protected void setLayout() {
        this.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.right = new FormAttachment(95, 0);
        formData.left = new FormAttachment(0, 10);
        formData.top = new FormAttachment(0, 10);
        this.hostComposite.setLayoutData((Object)formData);
        FormData formData2 = new FormData();
        formData2.right = new FormAttachment((Control)this.hostComposite, 0, 131072);
        formData2.left = new FormAttachment((Control)this.hostComposite, 0, 16384);
        formData2.top = new FormAttachment((Control)this.hostComposite, 10, -1);
        this.databaseProtocolComposite.setLayoutData(formData2);
        FormData formData3 = new FormData();
        formData3.right = new FormAttachment((Control)this.hostComposite, 0, 131072);
        formData3.left = new FormAttachment((Control)this.hostComposite, 0, 16384);
        formData3.top = new FormAttachment((Control)this.databaseProtocolComposite, 10, 1024);
        this.portComposite.setLayoutData((Object)formData3);
        FormData formData4 = new FormData();
        formData4.right = new FormAttachment((Control)this.hostComposite, 0, 131072);
        formData4.left = new FormAttachment((Control)this.hostComposite, 0, 16384);
        formData4.top = new FormAttachment((Control)this.portComposite, 10, -1);
        this.dbNameComposite.setLayoutData(formData4);
        FormData formData5 = new FormData();
        formData5.right = new FormAttachment((Control)this.hostComposite, 0, 131072);
        formData5.left = new FormAttachment((Control)this.hostComposite, 0, 16384);
        formData5.top = new FormAttachment((Control)this.dbNameComposite, 10, -1);
        this.serverNameComposite.setLayoutData(formData5);
        FormData formData6 = new FormData();
        formData6.right = new FormAttachment((Control)this.hostComposite, 0, 131072);
        formData6.left = new FormAttachment((Control)this.hostComposite, 0, 16384);
        formData6.top = new FormAttachment((Control)this.serverNameComposite, 10, -1);
        this.usernameComposite.setLayoutData((Object)formData6);
        FormData formData7 = new FormData();
        formData7.right = new FormAttachment((Control)this.hostComposite, 0, 131072);
        formData7.left = new FormAttachment((Control)this.hostComposite, 0, 16384);
        formData7.top = new FormAttachment((Control)this.usernameComposite, 10, -1);
        this.passwordComposite.setLayoutData((Object)formData7);
        FormData formData8 = new FormData();
        formData8.right = new FormAttachment((Control)this.hostComposite, 0, 131072);
        formData8.top = new FormAttachment((Control)this.passwordComposite, 6);
        formData8.bottom = new FormAttachment(100, -10);
        formData8.left = new FormAttachment((Control)this.hostComposite, 0, 16384);
        this.jdbcParametersComposite.setLayoutData((Object)formData8);
    }

    private HostNameText getHostText() {
        return this.hostComposite.getHostNameText();
    }

    private InformixProtocolCombo getDatabaseProtocolCombo() {
        return this.databaseProtocolComposite.combo;
    }

    private HostPortText getPortText() {
        return this.portComposite.getPortText();
    }

    private DbNameText getDbNameText() {
        return this.dbNameComposite.getDbNameText();
    }

    private InstanceNameText getServerText() {
        return this.serverNameComposite.serverText;
    }

    private UsernameText getUsernameText() {
        return this.usernameComposite.getUsernameText();
    }

    private PasswordText getPasswordText() {
        return this.passwordComposite.getPasswordText();
    }

    public ConnectionParameters getConnectionParameters() {
        DatabaseProtocol databaseProtocol = this.getDatabaseProtocolCombo().getProtocol();
        ConnectionParametersBuilder connectionParametersBuilder = databaseProtocol.getConnectionParametersBuilder();
        if (this.getDatabaseProtocolCombo().isValid() && this.getHostText().isValid() && this.getPortText().isValid() && this.getServerText().isValid() && this.getUsernameText().isValid() && this.getPasswordText().isValid() && this.getDbNameText().isValid()) {
            connectionParametersBuilder.setDatabaseServerName(this.getServerText().getText());
            connectionParametersBuilder.setUserName(this.getUsernameText().getText());
            connectionParametersBuilder.setUserPassword(this.getPasswordText().getText());
            String string = this.getDbNameText().getText();
            if (string == null || string.isEmpty()) {
                connectionParametersBuilder.setDatabaseName(InformixSystemDatabases.SYSMASTER.getName());
            } else {
                connectionParametersBuilder.setDatabaseName(string);
            }
        } else {
            throw new RuntimeException(Messages.Error_InvalidParameters);
        }
        connectionParametersBuilder.addJdbcParameter(this.jdbcParametersComposite.getParametersAsStrings());
        connectionParametersBuilder.setHostName(this.getHostName());
        connectionParametersBuilder.setHostPort(Integer.parseInt(this.getPortText().getText()));
        return connectionParametersBuilder.getConnectionParameters();
    }

    private final HostName getHostName() {
        HostName hostName = null;
        Host host = null;
        if (this.getHostText().isLocalHost()) {
            hostName = HostCatalog.getLocalHostNameWithName((String)this.getHostText().getText());
            if (hostName == null) {
                host = HostCatalog.getNewHost();
                hostName = host.addHostName(this.getHostText().getText());
            }
        } else {
            host = HostCatalog.getNewHost();
            hostName = host.addHostName(this.getHostText().getText());
        }
        return hostName;
    }
}

