/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.ui.connection;

import com.ibm.arcs.database.DatabaseProtocol;
import com.ibm.arcs.status.ui.AbstractStatusPublishingComposite;
import com.ibm.arcs.status.ui.widgets.IValidatedTextField;
import com.ibm.informix.connection.InformixService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class InformixProtocolCombo
extends AbstractStatusPublishingComposite
implements IValidatedTextField {
    private final Combo combo;
    private final int priority;
    private final Status statusOK;
    private final Map<String, DatabaseProtocol> nameProtocolMap = new HashMap<String, DatabaseProtocol>();

    public InformixProtocolCombo(Composite composite, int n, int n2) {
        super(composite, 0);
        this.setLayout((Layout)new FillLayout());
        this.priority = n2;
        this.statusOK = new Status(0, "com.ibm.informix.ui", this.priority, "", null);
        this.combo = new Combo((Composite)this, 8 | n);
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                InformixProtocolCombo.this.verifyAndPublishStatus();
            }
        });
        this.populateComboItems();
    }

    private void populateComboItems() {
        this.populateNameProtocolMap();
        Set<String> set = this.nameProtocolMap.keySet();
        for (String string : set) {
            this.combo.add(string);
        }
        if (set.size() > 0) {
            this.combo.select(0);
        }
    }

    private void populateNameProtocolMap() {
        InformixService informixService = new InformixService();
        List list = informixService.getProtocols();
        for (DatabaseProtocol databaseProtocol : list) {
            this.nameProtocolMap.put(databaseProtocol.getName(), databaseProtocol);
        }
    }

    public boolean isValid() {
        return true;
    }

    public String getText() {
        return this.combo.getText();
    }

    public Status getStatus() {
        return this.statusOK;
    }

    public DatabaseProtocol getProtocol() {
        String string = this.combo.getText();
        return this.nameProtocolMap.get(string);
    }

    public Collection<DatabaseProtocol> getProtocols() {
        return Collections.unmodifiableCollection(this.nameProtocolMap.values());
    }

    public boolean setSelected(DatabaseProtocol databaseProtocol) {
        int n = 0;
        while (n < this.combo.getItemCount()) {
            if (this.combo.getItem(n).equalsIgnoreCase(databaseProtocol.getName())) {
                this.combo.select(n);
                return true;
            }
            ++n;
        }
        return false;
    }
}

