/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.ui.connection.wizards;

import com.ibm.arcs.database.connection.ConnectionParameters;
import com.ibm.arcs.ui.dialog.DialogUtil;
import com.ibm.informix.ui.connection.wizards.NewConnectionParameterFileWizardPage;
import com.ibm.informix.ui.connection.wizards.NewConnectionParameterWizardPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewConnectionParametersWizard
extends Wizard
implements INewWizard {
    private NewConnectionParameterWizardPage parameterWizardPage;
    private NewConnectionParameterFileWizardPage newFilePage;
    private IWorkbench workbench;

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
        this.parameterWizardPage = new NewConnectionParameterWizardPage();
        this.addPage((IWizardPage)this.parameterWizardPage);
        this.newFilePage = new NewConnectionParameterFileWizardPage(iStructuredSelection);
        this.addPage((IWizardPage)this.newFilePage);
    }

    public boolean canFinish() {
        return this.parameterWizardPage.isPageComplete() && this.newFilePage.isPageComplete();
    }

    public boolean performFinish() {
        ConnectionParameters connectionParameters = this.parameterWizardPage.getConnectionParameters();
        this.newFilePage.setConnectionParameters(connectionParameters);
        IFile iFile = this.newFilePage.createNewFile();
        if (iFile == null) {
            return false;
        }
        this.selectAndReveal((IResource)iFile);
        IWorkbenchWindow iWorkbenchWindow = this.getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage iWorkbenchPage;
            if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
                IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
            }
        }
        catch (PartInitException partInitException) {
            DialogUtil.openError((Shell)iWorkbenchWindow.getShell(), (String)"Problems Opening Editor", (String)partInitException.getMessage(), (PartInitException)partInitException);
        }
        return true;
    }

    protected void selectAndReveal(IResource iResource) {
        BasicNewResourceWizard.selectAndReveal((IResource)iResource, (IWorkbenchWindow)this.getWorkbench().getActiveWorkbenchWindow());
    }

    private IWorkbench getWorkbench() {
        return this.workbench;
    }
}

