/*
 * Decompiled with CFR 0.152.
 */
package com.informix.timeseries.field;

import com.informix.timeseries.field.AbstractTimeSeriesField;
import com.informix.timeseries.field.TimeSeriesField;
import com.informix.timeseries.field.TimeSeriesFieldFactory;
import com.informix.timeseries.field.definition.ByteTimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinition;

public class ByteTimeSeriesField
extends AbstractTimeSeriesField<byte[]>
implements TimeSeriesField<byte[]> {
    public ByteTimeSeriesField(String fieldName) {
        this(fieldName, new ByteTimeSeriesFieldDefinition());
    }

    public ByteTimeSeriesField(String fieldName, int length) {
        this(fieldName, new ByteTimeSeriesFieldDefinition(length));
    }

    protected ByteTimeSeriesField(String fieldName, TimeSeriesFieldDefinition<byte[]> fieldDefinition) {
        super(fieldName, fieldDefinition);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ByteTimeSeriesField [fieldName=");
        builder.append(this.fieldName);
        builder.append(", definition=");
        builder.append(this.definition);
        builder.append(']');
        return builder.toString();
    }

    public static class Factory
    implements TimeSeriesFieldFactory<byte[]> {
        @Override
        public TimeSeriesField<byte[]> parse(String s) {
            String trimmed = s.trim();
            int index = trimmed.indexOf(32);
            String fieldName = trimmed.substring(0, index);
            String fieldDefArg = trimmed.substring(index + 1);
            return new ByteTimeSeriesField(fieldName, ByteTimeSeriesFieldDefinition.parseFieldDefinition(fieldDefArg));
        }
    }
}

