/*
 * Decompiled with CFR 0.152.
 */
package com.informix.timeseries.field.definition;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.timeseries.field.definition.AbstractInformixFieldDefinition;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinitionFactory;
import com.informix.timeseries.field.definition.TimeSeriesFieldType;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Date;

public class ByteTimeSeriesFieldDefinition
extends AbstractInformixFieldDefinition<byte[]>
implements TimeSeriesFieldDefinition<byte[]> {
    private static final int DEFAULT_LENGTH = 2048;
    private final int length;

    public ByteTimeSeriesFieldDefinition() {
        this(2048);
    }

    public ByteTimeSeriesFieldDefinition(int length) {
        super(TimeSeriesFieldType.LONGVARCHAR);
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public String toSqlString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFieldType().getInformixTypeName());
        sb.append('(');
        sb.append(this.length);
        sb.append(')');
        return sb.toString();
    }

    public static ByteTimeSeriesFieldDefinition parseFieldDefinition(String s) {
        String trimmed = s.trim();
        if (trimmed.startsWith(TimeSeriesFieldType.LONGVARCHAR.getInformixTypeName())) {
            if (trimmed.equalsIgnoreCase(TimeSeriesFieldType.LONGVARCHAR.getInformixTypeName())) {
                return new ByteTimeSeriesFieldDefinition();
            }
            int startParenIndex = trimmed.indexOf(40);
            int endParenIndex = trimmed.lastIndexOf(41);
            try {
                String varcharLengthArg = trimmed.substring(startParenIndex + 1, endParenIndex).trim();
                int length = Integer.parseInt(varcharLengthArg);
                return new ByteTimeSeriesFieldDefinition(length);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("the parenthesis are missing or out of order", e);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("the length could not be parsed as an int", e);
            }
        }
        throw new IllegalArgumentException(MessageFormat.format("the field definition must begin with ''{0}''", new Object[]{TimeSeriesFieldType.LONGVARCHAR}));
    }

    @Override
    public byte[] read(IfmxUDTSQLInput stream, IfxResultSetMetaData metaData, Integer fieldIndex) throws SQLException {
        int length = metaData.getEncodedLength(fieldIndex.intValue());
        byte[] bytes = stream.readBytes(length);
        return bytes;
    }

    @Override
    public void write(IfmxUDTSQLOutput stream, byte[] bytes) throws SQLException {
        int i = 0;
        while (i < bytes.length) {
            stream.writeByte(bytes[i]);
            ++i;
        }
    }

    @Override
    public String convertValueToString(Object value) {
        if (value == null) {
            return "null::lvarchar";
        }
        if (value instanceof Byte) {
            return ((Byte)value).toString();
        }
        throw new IllegalArgumentException(MessageFormat.format("the value must be of type {0} (was {1})", Byte.class, value.getClass()));
    }

    @Override
    public byte[] convertValueTo(Object value) throws IllegalArgumentException {
        if (value == null || value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof Number) {
            if (value instanceof Double) {
                ByteBuffer bb = ByteBuffer.allocate(8);
                bb.putDouble((Double)value);
                return bb.array();
            }
            if (value instanceof Float) {
                ByteBuffer bb = ByteBuffer.allocate(4);
                bb.putFloat(((Float)value).floatValue());
                return bb.array();
            }
            if (value instanceof Long) {
                ByteBuffer bb = ByteBuffer.allocate(8);
                bb.putLong((Long)value);
                return bb.array();
            }
            if (value instanceof Integer) {
                ByteBuffer bb = ByteBuffer.allocate(4);
                bb.putInt((Integer)value);
                return bb.array();
            }
            if (value instanceof Short) {
                ByteBuffer bb = ByteBuffer.allocate(2);
                bb.putShort((Short)value);
                return bb.array();
            }
            if (value instanceof Byte) {
                ByteBuffer bb = ByteBuffer.allocate(1);
                bb.put((Byte)value);
                return bb.array();
            }
            throw new IllegalArgumentException(MessageFormat.format("could not convert a value of type {0} to {1}", value.getClass().getName(), "byte[]"));
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return new byte[]{1};
            }
            return new byte[1];
        }
        if (value instanceof Date) {
            ByteBuffer bb = ByteBuffer.allocate(8);
            bb.putLong(((Date)value).getTime());
            return bb.array();
        }
        if (value instanceof String) {
            return ((String)value).getBytes();
        }
        throw new IllegalArgumentException(MessageFormat.format("could not convert a value of type {0} to {1}", value.getClass().getName(), "byte[]"));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.length;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ByteTimeSeriesFieldDefinition)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteTimeSeriesFieldDefinition other = (ByteTimeSeriesFieldDefinition)obj;
        return this.length == other.length;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ByteTimeSeriesFieldDefinition [length=");
        builder.append(this.length);
        builder.append(']');
        return builder.toString();
    }

    public static class Factory
    implements TimeSeriesFieldDefinitionFactory<byte[]> {
        @Override
        public TimeSeriesFieldDefinition<byte[]> parse(String s) {
            return ByteTimeSeriesFieldDefinition.parseFieldDefinition(s);
        }
    }
}

