/*
 * Decompiled with CFR 0.152.
 */
package com.informix.timeseries.field.definition;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.lang.Decimal;
import com.informix.lang.Interval;
import com.informix.lang.JavaToIfxType;
import com.informix.timeseries.IfmxTimeSeries;
import com.informix.timeseries.IfxDateTimeCode;
import com.informix.timeseries.field.definition.AbstractInformixFieldDefinition;
import com.informix.timeseries.field.definition.DecimalTimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.ObjectConversionUtilities;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinitionFactory;
import com.informix.timeseries.field.definition.TimeSeriesFieldType;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;

public class DateTimeTimeSeriesFieldDefinition
extends AbstractInformixFieldDefinition<java.util.Date>
implements TimeSeriesFieldDefinition<java.util.Date> {
    private static final byte DEFAULT_START_CODE = 0;
    private static final byte DEFAULT_END_CODE = 15;
    private final byte startCode;
    private final byte endCode;

    public DateTimeTimeSeriesFieldDefinition() {
        this(0, 15);
    }

    public DateTimeTimeSeriesFieldDefinition(byte startCode, byte endCode) {
        super(TimeSeriesFieldType.DATETIME);
        if (Interval.getFieldName((byte)startCode).length() == 0) {
            throw new IllegalArgumentException(MessageFormat.format("the start code {0} is not recognized", startCode));
        }
        if (Interval.getFieldName((byte)endCode).length() == 0) {
            throw new IllegalArgumentException(MessageFormat.format("the end code {0} is not recognized", endCode));
        }
        if (startCode > endCode) {
            throw new IllegalArgumentException(MessageFormat.format("the start code, {0}, must be the same or a larger time scale than the end code, {1}.", Interval.getFieldName((byte)startCode), Interval.getFieldName((byte)endCode)));
        }
        this.startCode = startCode;
        this.endCode = endCode;
    }

    public byte getStartCode() {
        return this.startCode;
    }

    public byte getEndCode() {
        return this.endCode;
    }

    @Override
    public String toSqlString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFieldType().getInformixTypeName());
        sb.append(' ');
        sb.append(Interval.getFieldName((byte)this.getStartCode()));
        sb.append(" to ");
        sb.append(Interval.getFieldName((byte)this.getEndCode()));
        return sb.toString();
    }

    public static DateTimeTimeSeriesFieldDefinition parseFieldDefinition(String s) {
        String trimmed = s.trim();
        if (trimmed.startsWith(TimeSeriesFieldType.DATETIME.getInformixTypeName())) {
            if (trimmed.equalsIgnoreCase(TimeSeriesFieldType.DATETIME.getInformixTypeName())) {
                return new DateTimeTimeSeriesFieldDefinition();
            }
            int startIndex = trimmed.indexOf(32);
            try {
                String startEndArg = trimmed.substring(startIndex + 1).trim();
                int toIndex = startEndArg.indexOf("to");
                if (toIndex == -1) {
                    throw new IllegalArgumentException("could not find 'to' in the definition");
                }
                String startArg = startEndArg.substring(0, toIndex - 1).trim();
                String endArg = startEndArg.substring(toIndex + 2).trim();
                IfxDateTimeCode startCode = IfxDateTimeCode.findByFieldName(startArg);
                IfxDateTimeCode endCode = IfxDateTimeCode.findByFieldName(endArg);
                if (startCode == null) {
                    throw new IllegalArgumentException(MessageFormat.format("the start name ''{0}'' is not supported", startArg));
                }
                if (endCode == null) {
                    throw new IllegalArgumentException(MessageFormat.format("the end name ''{0}'' is not supported", startArg));
                }
                return new DateTimeTimeSeriesFieldDefinition(startCode.fieldId(), endCode.fieldId());
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("the position of 'to' in the field definition is incorrect", e);
            }
        }
        throw new IllegalArgumentException(MessageFormat.format("the field definition must begin with ''{0}''", TimeSeriesFieldType.DATETIME.getInformixTypeName()));
    }

    @Override
    public java.util.Date read(IfmxUDTSQLInput stream, IfxResultSetMetaData metaData, Integer fieldIndex) throws SQLException {
        int precision = metaData.getEncodedLength(fieldIndex.intValue());
        Decimal decVal = DecimalTimeSeriesFieldDefinition.readDecimal(stream, precision, true);
        Calendar cal = Calendar.getInstance(IfmxTimeSeries.getDefaultTimeZone());
        return decVal.timestampValue(cal);
    }

    @Override
    public void write(IfmxUDTSQLOutput stream, java.util.Date value) throws SQLException {
        Timestamp timestamp;
        if (value instanceof Timestamp) {
            timestamp = (Timestamp)value;
        } else if (value instanceof java.util.Date) {
            timestamp = new Timestamp(value.getTime());
        } else {
            throw new SQLException(MessageFormat.format("the value must be of type {0} (was {1})", java.util.Date.class.getName(), value.getClass().getName()));
        }
        Decimal decVal = JavaToIfxType.convertTimestampToDecimal((Timestamp)timestamp);
        DecimalTimeSeriesFieldDefinition.writeDecimal(stream, decVal);
    }

    @Override
    public String convertValueToString(Object value) {
        if (value == null) {
            return "null::" + this.toSqlString();
        }
        if (value instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)value;
            StringBuilder sb = new StringBuilder();
            sb.append('\'');
            boolean appendedInPreviousPhase = false;
            if (this.startCode <= 0 && this.endCode >= 0) {
                sb.append(String.format("%04d", 1900 + date.getYear()));
                appendedInPreviousPhase = true;
            }
            if (this.startCode <= 2 && this.endCode >= 2) {
                if (appendedInPreviousPhase) {
                    sb.append('-');
                }
                sb.append(String.format("%02d", date.getMonth() + 1));
                appendedInPreviousPhase = true;
            }
            if (this.startCode <= 4 && this.endCode >= 4) {
                if (appendedInPreviousPhase) {
                    sb.append('-');
                }
                sb.append(String.format("%02d", date.getDate()));
                appendedInPreviousPhase = true;
            }
            if (this.startCode <= 6 && this.endCode >= 6) {
                if (appendedInPreviousPhase) {
                    sb.append(' ');
                }
                sb.append(String.format("%02d", date.getHours()));
                appendedInPreviousPhase = true;
            }
            if (this.startCode <= 8 && this.endCode >= 8) {
                if (appendedInPreviousPhase) {
                    sb.append(':');
                }
                sb.append(String.format("%02d", date.getMinutes()));
                appendedInPreviousPhase = true;
            }
            if (this.startCode <= 10 && this.endCode >= 10) {
                if (appendedInPreviousPhase) {
                    sb.append(':');
                }
                sb.append(String.format("%02d", date.getSeconds()));
                appendedInPreviousPhase = true;
            }
            if (this.endCode > 10) {
                if (appendedInPreviousPhase) {
                    sb.append('.');
                }
                String nanoString = date instanceof Timestamp ? String.format("%09d", ((Timestamp)date).getNanos()) : String.format("%03d00", date.getTime() % 1000L);
                if (this.endCode == 11) {
                    sb.append(nanoString.substring(0, 1));
                } else if (this.endCode == 12) {
                    sb.append(nanoString.substring(0, 2));
                } else if (this.endCode == 13) {
                    sb.append(nanoString.substring(0, 3));
                } else if (this.endCode == 14) {
                    sb.append(nanoString.substring(0, 4));
                } else if (this.endCode == 15) {
                    sb.append(nanoString.substring(0, 5));
                }
            }
            sb.append('\'');
            sb.append("::");
            sb.append(this.toSqlString());
            return sb.toString();
        }
        throw new IllegalArgumentException(MessageFormat.format("the value must be of type {0} (was {1})", java.util.Date.class.getName(), value.getClass().getName()));
    }

    @Override
    public java.util.Date convertValueTo(Object value) throws IllegalArgumentException {
        if (value == null || value instanceof java.util.Date) {
            return (java.util.Date)value;
        }
        Long l = ObjectConversionUtilities.convertObjectToLong(value, Date.class.getName());
        return new java.util.Date(l);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.endCode;
        result = 31 * result + this.startCode;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DateTimeTimeSeriesFieldDefinition)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateTimeTimeSeriesFieldDefinition other = (DateTimeTimeSeriesFieldDefinition)obj;
        if (this.endCode != other.endCode) {
            return false;
        }
        return this.startCode == other.startCode;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DateTimeTimeSeriesFieldDefinition [startCode=");
        builder.append(this.startCode);
        builder.append(", endCode=");
        builder.append(this.endCode);
        builder.append(']');
        return builder.toString();
    }

    public static class Factory
    implements TimeSeriesFieldDefinitionFactory<java.util.Date> {
        @Override
        public TimeSeriesFieldDefinition<java.util.Date> parse(String s) {
            return DateTimeTimeSeriesFieldDefinition.parseFieldDefinition(s);
        }
    }
}

