/*
 * Decompiled with CFR 0.152.
 */
package com.informix.timeseries.field.definition;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.lang.Decimal;
import com.informix.timeseries.field.definition.AbstractInformixFieldDefinition;
import com.informix.timeseries.field.definition.ObjectConversionUtilities;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinitionFactory;
import com.informix.timeseries.field.definition.TimeSeriesFieldType;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;

public class DecimalTimeSeriesFieldDefinition
extends AbstractInformixFieldDefinition<BigDecimal>
implements TimeSeriesFieldDefinition<BigDecimal> {
    private static final int DEFAULT_PRECISION = 16;
    private static final int DEFAULT_SCALE = 0;
    private final int precision;
    private final int scale;

    public DecimalTimeSeriesFieldDefinition() {
        this(16, 0);
    }

    public DecimalTimeSeriesFieldDefinition(int precision) {
        this(precision, 0);
    }

    public DecimalTimeSeriesFieldDefinition(int precision, int scale) {
        super(TimeSeriesFieldType.DECIMAL);
        this.precision = precision;
        this.scale = scale;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public String toSqlString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFieldType().getInformixTypeName());
        sb.append('(');
        sb.append(this.precision);
        if (this.scale > 0) {
            sb.append(',');
            sb.append(this.scale);
        }
        sb.append(')');
        return sb.toString();
    }

    public static DecimalTimeSeriesFieldDefinition parseFieldDefinition(String s) {
        String trimmed = s.trim();
        if (trimmed.startsWith(TimeSeriesFieldType.DECIMAL.getInformixTypeName())) {
            if (trimmed.equalsIgnoreCase(TimeSeriesFieldType.DECIMAL.getInformixTypeName())) {
                return new DecimalTimeSeriesFieldDefinition();
            }
            int startParenIndex = trimmed.indexOf(40);
            int endParenIndex = trimmed.lastIndexOf(41);
            try {
                int scale;
                int precision;
                String precisionScaleArg = trimmed.substring(startParenIndex + 1, endParenIndex).trim();
                int commaIndex = precisionScaleArg.indexOf(44);
                if (commaIndex >= 0) {
                    String precisionArg = precisionScaleArg.substring(0, commaIndex).trim();
                    String scaleArg = precisionScaleArg.substring(commaIndex + 1).trim();
                    precision = Integer.parseInt(precisionArg);
                    scale = Integer.parseInt(scaleArg);
                } else {
                    precision = Integer.parseInt(precisionScaleArg);
                    scale = 0;
                }
                return new DecimalTimeSeriesFieldDefinition(precision, scale);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("the parenthesis are missing or out of order", e);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("the precision or scale could not be parsed as an int", e);
            }
        }
        throw new IllegalArgumentException(MessageFormat.format("the field definition must begin with ''{0}''", TimeSeriesFieldType.DECIMAL.getInformixTypeName()));
    }

    @Override
    public BigDecimal read(IfmxUDTSQLInput stream, IfxResultSetMetaData metaData, Integer index) throws SQLException {
        int precision = metaData.getEncodedLength(index.intValue());
        Decimal decVal = DecimalTimeSeriesFieldDefinition.readDecimal(stream, precision, false);
        return decVal.numericValue();
    }

    @Override
    public void write(IfmxUDTSQLOutput stream, BigDecimal value) throws SQLException {
        Decimal ifxDecimal = new Decimal(value);
        DecimalTimeSeriesFieldDefinition.writeDecimal(stream, ifxDecimal);
    }

    static Decimal readDecimal(IfmxUDTSQLInput stream, int precision, boolean isTimeStamp) throws SQLException {
        byte[] buf = stream.readBytes(DecimalTimeSeriesFieldDefinition.getByteCount(precision) + 1);
        return new Decimal(buf, (short)precision, isTimeStamp);
    }

    static int getByteCount(int len) {
        return (Decimal.tuLen((short)((short)len)) + (Decimal.tuEnd((byte)((byte)len)) & 1) + 1) / 2;
    }

    static void writeDecimal(IfmxUDTSQLOutput stream, Decimal decVal) throws SQLException {
        byte[] buf = decVal.javaToIfx();
        int i = 2;
        while (i < buf.length) {
            stream.writeByte(buf[i]);
            ++i;
        }
    }

    @Override
    public String convertValueToString(Object value) {
        if (value == null) {
            return "null::decimal";
        }
        if (value instanceof BigDecimal) {
            return String.valueOf(((BigDecimal)value).toString()) + "::" + this.toSqlString();
        }
        throw new IllegalArgumentException(MessageFormat.format("the value must be of type {0} (was {1})", BigDecimal.class, value.getClass()));
    }

    @Override
    public BigDecimal convertValueTo(Object value) throws IllegalArgumentException {
        return ObjectConversionUtilities.convertObjectToBigDecimal(value);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.precision;
        result = 31 * result + this.scale;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DecimalTimeSeriesFieldDefinition)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DecimalTimeSeriesFieldDefinition other = (DecimalTimeSeriesFieldDefinition)obj;
        if (this.precision != other.precision) {
            return false;
        }
        return this.scale == other.scale;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DecimalTimeSeriesFieldDefinition [precision=");
        builder.append(this.precision);
        builder.append(", scale=");
        builder.append(this.scale);
        builder.append(']');
        return builder.toString();
    }

    public static class Factory
    implements TimeSeriesFieldDefinitionFactory<BigDecimal> {
        @Override
        public TimeSeriesFieldDefinition<BigDecimal> parse(String s) {
            return DecimalTimeSeriesFieldDefinition.parseFieldDefinition(s);
        }
    }
}

