/*
 * Decompiled with CFR 0.152.
 */
package com.informix.timeseries.field.definition;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.timeseries.field.definition.AbstractInformixFieldDefinition;
import com.informix.timeseries.field.definition.ObjectConversionUtilities;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinitionFactory;
import com.informix.timeseries.field.definition.TimeSeriesFieldType;
import java.sql.SQLException;
import java.text.MessageFormat;

public class Int8TimeSeriesFieldDefinition
extends AbstractInformixFieldDefinition<Long>
implements TimeSeriesFieldDefinition<Long> {
    public Int8TimeSeriesFieldDefinition() {
        super(TimeSeriesFieldType.INT8);
    }

    public static Int8TimeSeriesFieldDefinition parseFieldDefinition(String s) {
        String trimmed = s.trim();
        if (trimmed.equalsIgnoreCase(TimeSeriesFieldType.INT8.getInformixTypeName())) {
            return new Int8TimeSeriesFieldDefinition();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Long read(IfmxUDTSQLInput stream, IfxResultSetMetaData metaData, Integer index) throws SQLException {
        Long value = stream.readLong();
        stream.skipBytes(2);
        return value;
    }

    @Override
    public void write(IfmxUDTSQLOutput stream, Long value) throws SQLException {
        if (!(value instanceof Long)) {
            throw new SQLException(MessageFormat.format("the value must be of type {0} (was {1})", Long.class.getName(), value.getClass().getName()));
        }
        stream.writeLong(value.longValue());
        if (!stream.getAutoAlignment()) {
            byte zero = 0;
            stream.writeByte(zero);
            stream.writeByte(zero);
        }
    }

    @Override
    public String convertValueToString(Object value) {
        if (value == null) {
            return "null::int8";
        }
        if (value instanceof Long) {
            return String.valueOf(((Long)value).toString()) + "::" + this.toSqlString();
        }
        throw new IllegalArgumentException(MessageFormat.format("the value must be of type {0} (was {1})", Long.class, value.getClass()));
    }

    @Override
    public Long convertValueTo(Object value) throws IllegalArgumentException {
        return ObjectConversionUtilities.convertObjectToLong(value);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Int8TimeSeriesFieldDefinition []");
        return builder.toString();
    }

    public static class Factory
    implements TimeSeriesFieldDefinitionFactory<Long> {
        @Override
        public TimeSeriesFieldDefinition<Long> parse(String s) {
            return Int8TimeSeriesFieldDefinition.parseFieldDefinition(s);
        }
    }
}

