/*
 * Decompiled with CFR 0.152.
 */
package com.informix.timeseries.field.definition;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.lang.Decimal;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.lang.JavaToIfxType;
import com.informix.timeseries.IfxDateTimeCode;
import com.informix.timeseries.field.definition.AbstractInformixFieldDefinition;
import com.informix.timeseries.field.definition.DecimalTimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinitionFactory;
import com.informix.timeseries.field.definition.TimeSeriesFieldType;
import java.sql.SQLException;
import java.text.MessageFormat;

public class IntervalTimeSeriesFieldDefinition
extends AbstractInformixFieldDefinition<Interval>
implements TimeSeriesFieldDefinition<Interval> {
    private static final byte DEFAULT_START_CODE = 4;
    private static final byte DEFAULT_END_CODE = 13;
    private static final int DEFAULT_PRECISION = 0;
    private final byte startCode;
    private final int startPrecision;
    private final byte endCode;
    private final int endPrecision;

    public IntervalTimeSeriesFieldDefinition() {
        this(4, 13);
    }

    public IntervalTimeSeriesFieldDefinition(byte startCode, byte endCode) {
        this(startCode, 0, endCode, 0);
    }

    public IntervalTimeSeriesFieldDefinition(byte startCode, int startPrecision, byte endCode, int endPrecision) {
        super(TimeSeriesFieldType.INTERVAL);
        if (Interval.getFieldName((byte)startCode).length() == 0) {
            throw new IllegalArgumentException(MessageFormat.format("the start code {0} is not recognized", startCode));
        }
        if (Interval.getFieldName((byte)endCode).length() == 0) {
            throw new IllegalArgumentException(MessageFormat.format("the end code {0} is not recognized", endCode));
        }
        if (startCode > endCode) {
            throw new IllegalArgumentException(MessageFormat.format("the start code, {0}, must be the same or a larger time scale than the end code, {1}.", Interval.getFieldName((byte)startCode), Interval.getFieldName((byte)endCode)));
        }
        this.startCode = startCode;
        this.startPrecision = startPrecision;
        this.endCode = endCode;
        this.endPrecision = endPrecision;
    }

    public byte getStartCode() {
        return this.startCode;
    }

    public int getStartPrecision() {
        return this.startPrecision;
    }

    public byte getEndCode() {
        return this.endCode;
    }

    public int getEndPrecision() {
        return this.endPrecision;
    }

    @Override
    public String toSqlString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFieldType().getInformixTypeName());
        sb.append(' ');
        sb.append(Interval.getFieldName((byte)this.getStartCode()));
        if (this.startPrecision != 0) {
            sb.append('(');
            sb.append(this.startPrecision);
            sb.append(')');
        }
        sb.append(" to ");
        sb.append(Interval.getFieldName((byte)this.getEndCode()));
        if (this.endPrecision != 0) {
            sb.append('(');
            sb.append(this.endPrecision);
            sb.append(')');
        }
        return sb.toString();
    }

    public static IntervalTimeSeriesFieldDefinition parseFieldDefinition(String s) {
        String trimmed = s.trim();
        if (trimmed.startsWith(TimeSeriesFieldType.INTERVAL.getInformixTypeName())) {
            if (trimmed.equalsIgnoreCase(TimeSeriesFieldType.INTERVAL.getInformixTypeName())) {
                return new IntervalTimeSeriesFieldDefinition();
            }
            int startIndex = trimmed.indexOf(32);
            try {
                String startEndArg = trimmed.substring(startIndex + 1).trim();
                int toIndex = startEndArg.indexOf("to");
                if (toIndex == -1) {
                    throw new IllegalArgumentException("could not find 'to' in the definition");
                }
                String startArg = startEndArg.substring(0, toIndex - 1).trim();
                String endArg = startEndArg.substring(toIndex + 2).trim();
                int startPrecision = 0;
                if (startArg.contains("(")) {
                    int startParenIndex = startArg.indexOf(40);
                    int endParenIndex = startArg.indexOf(41);
                    startArg = startArg.substring(0, startParenIndex - 1);
                    String precisionArg = trimmed.substring(startParenIndex + 1, endParenIndex).trim();
                    startPrecision = Integer.parseInt(precisionArg);
                }
                int endPrecision = 0;
                if (endArg.contains("(")) {
                    int startParenIndex = endArg.indexOf(40);
                    int endParenIndex = endArg.indexOf(41);
                    endArg = endArg.substring(0, startParenIndex - 1);
                    String precisionArg = trimmed.substring(startParenIndex + 1, endParenIndex).trim();
                    endPrecision = Integer.parseInt(precisionArg);
                }
                IfxDateTimeCode startCode = IfxDateTimeCode.findByFieldName(startArg);
                IfxDateTimeCode endCode = IfxDateTimeCode.findByFieldName(endArg);
                if (startCode == null) {
                    throw new IllegalArgumentException(MessageFormat.format("the start name ''{0}'' is not supported", startArg));
                }
                if (endCode == null) {
                    throw new IllegalArgumentException(MessageFormat.format("the end name ''{0}'' is not supported", startArg));
                }
                return new IntervalTimeSeriesFieldDefinition(startCode.fieldId(), startPrecision, endCode.fieldId(), endPrecision);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("the position of 'to' in the field definition is incorrect", e);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("the precision of the start or end could not be parsed as an int", e);
            }
        }
        throw new IllegalArgumentException(MessageFormat.format("the field definition must begin with ''{0}''", TimeSeriesFieldType.INTERVAL.getInformixTypeName()));
    }

    @Override
    public Interval read(IfmxUDTSQLInput stream, IfxResultSetMetaData metaData, Integer fieldIndex) throws SQLException {
        int precision = metaData.getEncodedLength(fieldIndex.intValue());
        Decimal decVal = DecimalTimeSeriesFieldDefinition.readDecimal(stream, precision, true);
        return decVal.intervalValue();
    }

    @Override
    public void write(IfmxUDTSQLOutput stream, Interval value) throws SQLException {
        if (!(value instanceof Interval)) {
            throw new SQLException(MessageFormat.format("the value must be of type {0} (was {1})", Interval.class.getName(), value.getClass().getName()));
        }
        Interval interval = value;
        Decimal ifxDecimal = interval instanceof IntervalYM ? JavaToIfxType.convertIntervalToDecimal((IntervalYM)((IntervalYM)interval)) : JavaToIfxType.convertIntervalToDecimal((IntervalDF)((IntervalDF)interval));
        DecimalTimeSeriesFieldDefinition.writeDecimal(stream, ifxDecimal);
    }

    @Override
    public String convertValueToString(Object value) {
        if (value == null) {
            return "null::" + this.toSqlString();
        }
        if (value instanceof Interval) {
            StringBuilder sb = new StringBuilder();
            sb.append('\'');
            sb.append(((Interval)value).toString());
            sb.append('\'');
            sb.append("::");
            sb.append(this.toSqlString());
            return sb.toString();
        }
        throw new IllegalArgumentException(MessageFormat.format("the value must be of type {0} (was {1})", Long.class, value.getClass()));
    }

    @Override
    public Interval convertValueTo(Object value) throws IllegalArgumentException {
        if (value == null || value instanceof Interval) {
            return (Interval)value;
        }
        if (value instanceof String) {
            try {
                if (this.startCode < 4 && this.endCode < 4 && this.startCode <= this.endCode) {
                    return new IntervalYM((String)value);
                }
                if (this.startCode > 2 && this.endCode > 2 && this.startCode <= this.endCode) {
                    return new IntervalDF((String)value);
                }
                throw new IllegalArgumentException("invalid start/end codes for interval");
            }
            catch (SQLException e) {
                throw new IllegalArgumentException(MessageFormat.format("unable to create Interval from String ''{0}''", value), e);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.endCode;
        result = 31 * result + this.endPrecision;
        result = 31 * result + this.startCode;
        result = 31 * result + this.startPrecision;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof IntervalTimeSeriesFieldDefinition)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntervalTimeSeriesFieldDefinition other = (IntervalTimeSeriesFieldDefinition)obj;
        if (this.endCode != other.endCode) {
            return false;
        }
        if (this.endPrecision != other.endPrecision) {
            return false;
        }
        if (this.startCode != other.startCode) {
            return false;
        }
        return this.startPrecision == other.startPrecision;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IntervalTimeSeriesFieldDefinition [startCode=");
        builder.append(this.startCode);
        builder.append(", startPrecision=");
        builder.append(this.startPrecision);
        builder.append(", endCode=");
        builder.append(this.endCode);
        builder.append(", endPrecision=");
        builder.append(this.endPrecision);
        builder.append(']');
        return builder.toString();
    }

    public static class Factory
    implements TimeSeriesFieldDefinitionFactory<Interval> {
        @Override
        public TimeSeriesFieldDefinition<Interval> parse(String s) {
            return IntervalTimeSeriesFieldDefinition.parseFieldDefinition(s);
        }
    }
}

