/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm.crypto;

import com.informix.csm.crypto.IfxCipherElem;
import com.informix.csm.crypto.IfxCryptoCtx;
import com.informix.csm.crypto.IfxCryptoUtils;
import com.informix.csm.crypto.IfxEDPkt;
import com.informix.csm.crypto.IfxEncPkt;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

class IfxCipher {
    static final int EA_DES = 1;
    static final int EA_DES3 = 2;
    static final int EA_DESX = 3;
    static final int EA_IDEA = 4;
    static final int EA_BF1 = 5;
    static final int EA_BF2 = 6;
    static final int EA_BF3 = 7;
    static final int EA_EDE = 8;
    static final int EA_BF_1 = 9;
    static final int EA_BF_2 = 10;
    static final int EA_BF_3 = 11;
    static final int EA_RC2A = 12;
    static final int EA_RC2B = 13;
    static final int EA_RC2C = 14;
    static final int EA_RC5A1 = 15;
    static final int EA_RC5B1 = 16;
    static final int EA_RC5C1 = 17;
    static final int EA_RC5A2 = 18;
    static final int EA_RC5B2 = 19;
    static final int EA_RC5C2 = 20;
    static final int EM_VOID = 0;
    static final int EM_ECB = 1;
    static final int EM_CBC = 2;
    static final int EM_CFB = 3;
    static final int EM_OFB = 4;
    static final int EM_MIN = 1;
    static final int EM_MAX = 4;
    private static Hashtable CipherModes;
    private static IfxCipher[] Ciphers;
    static final int EA_MIN = 1;
    static final int EA_MAX;
    String name;
    String algorithm;
    int Cipher;
    int KeySize;
    int RC2Key;
    int RC5Rounds;
    boolean[] supportedMode;

    IfxCipher() {
    }

    IfxCipher(String string, String string2, int n, int n2, int n3, int n4, boolean[] blArray) {
        this.name = string;
        this.algorithm = string2;
        this.Cipher = n;
        this.KeySize = n2;
        this.RC2Key = n3;
        this.RC5Rounds = n4;
        this.supportedMode = blArray;
    }

    int getKeySize() {
        return this.KeySize;
    }

    int getRC2Key() {
        return this.RC2Key;
    }

    int getRC5Rounds() {
        return this.RC5Rounds;
    }

    String getAlgorithmName() {
        return this.algorithm;
    }

    int getCipherType() {
        return this.Cipher;
    }

    String getName() {
        return this.name;
    }

    static IfxCipher FindCipherByID(int n) {
        for (int i = 0; i < Ciphers.length; ++i) {
            if (Ciphers[i] == null || IfxCipher.Ciphers[i].Cipher != n) continue;
            return Ciphers[i];
        }
        return null;
    }

    static IfxCipher FindCipherByName(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < Ciphers.length; ++i) {
            if (Ciphers[i] == null || string.compareTo(IfxCipher.Ciphers[i].name) != 0) continue;
            return Ciphers[i];
        }
        return null;
    }

    static int FindModeByName(String string) {
        Object var1_1 = null;
        var1_1 = CipherModes.get(string);
        if (var1_1 != null) {
            return var1_1;
        }
        return 0;
    }

    static String FindNameByMode(int n) {
        Enumeration enumeration = CipherModes.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (n != IfxCipher.FindModeByName(string)) continue;
            return string;
        }
        return null;
    }

    static boolean isCipherElementValid(IfxCipherElem ifxCipherElem) {
        int n = ifxCipherElem.getCipherType();
        int n2 = ifxCipherElem.getMode();
        IfxCipher ifxCipher = IfxCipher.FindCipherByID(n);
        return n2 >= 1 && n2 <= 4 && ifxCipher != null && IfxCipher.isModeValidForCipher(n2, ifxCipher);
    }

    static boolean isModeValidForCipher(int n, IfxCipher ifxCipher) {
        if (n > 4 || n < 1) {
            return false;
        }
        try {
            return ifxCipher.supportedMode[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    boolean isModeValidForThisCipher(int n) {
        return IfxCipher.isModeValidForCipher(n, this);
    }

    static int insertCipher(IfxCipherElem ifxCipherElem, Vector vector) {
        IfxCipherElem ifxCipherElem2;
        int n;
        int n2 = 0;
        for (n = vector.size() - 1; n >= 0 && ifxCipherElem.isStrongerThan(ifxCipherElem2 = (IfxCipherElem)vector.get(n)); --n) {
        }
        vector.add(n + 1, ifxCipherElem);
        return n2;
    }

    static int addAllCiphers(Vector vector) {
        int n = 0;
        int n2 = 0;
        for (n2 = 0; n2 < Ciphers.length; ++n2) {
            IfxCipher ifxCipher = Ciphers[n2];
            if (ifxCipher == null) continue;
            for (int i = 0; i < ifxCipher.supportedMode.length; ++i) {
                if (!ifxCipher.supportedMode[i] || IfxCipher.registerCipher(ifxCipher.getCipherType(), i + 1, vector) != -1) continue;
                return -1;
            }
        }
        n = IfxCipher.remCipherMode(IfxCipher.FindNameByMode(1), vector);
        if (n != 0) {
            return n;
        }
        n = IfxCipher.remCipherMode(IfxCipher.FindCipherByID(3).getName(), vector);
        if (n != 0) {
            return n;
        }
        n = IfxCipher.remCipherMode(IfxCipher.FindCipherByID(11).getName(), vector);
        if (n != 0) {
            return n;
        }
        return 0;
    }

    static int registerCipher(int n, int n2, Vector vector) {
        int n3 = 0;
        IfxCipherElem ifxCipherElem = new IfxCipherElem(n, n2);
        if (!IfxCipher.isCipherElementValid(ifxCipherElem)) {
            n3 = -16;
        } else if (IfxCipherElem.isCipherInList(ifxCipherElem, vector)) {
            n3 = -19;
        } else {
            n3 = IfxCipher.insertCipher(ifxCipherElem, vector);
            if (n3 != 0) {
                // empty if block
            }
        }
        if (n3 != 0) {
            IfxCryptoCtx.printError(null, "RegisterCipher", n3);
        }
        return n3;
    }

    static int remCipherMode(String string, Vector vector) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (CipherModes.containsKey(string)) {
            n2 = (Integer)CipherModes.get(string);
            n3 = 1;
        }
        if (n3 == 0) {
            for (n4 = 0; n4 < Ciphers.length; ++n4) {
                if (Ciphers[n4] == null || Ciphers[n4].getName().compareTo(string) != 0) continue;
                n2 = Ciphers[n4].getCipherType();
                n3 = 2;
                break;
            }
        }
        if (n3 == 0) {
            String string2 = null;
            int n5 = string.length();
            for (n4 = 0; n4 < Ciphers.length; ++n4) {
                if (Ciphers[n4] == null || !Ciphers[n4].getName().startsWith(string)) continue;
                n3 = 3;
                string2 = Ciphers[n4].getName();
                IfxCipher.remCipherMode(string2, vector);
            }
        }
        if (n == 0 && n3 != 3) {
            if (n3 == 0) {
                n = -16;
            } else {
                for (int i = 0; i < vector.size(); ++i) {
                    IfxCipherElem ifxCipherElem = (IfxCipherElem)vector.get(i);
                    if ((n3 != 1 || ifxCipherElem.getMode() != n2) && (n3 != 2 || ifxCipherElem.getCipherType() != n2)) continue;
                    vector.remove(i);
                    --i;
                }
            }
        }
        if (n != 0) {
            IfxCryptoCtx.printError(null, "RemCipherMode", n);
        }
        return n;
    }

    static int cryptoSwitchCipher(IfxEncPkt ifxEncPkt, IfxEDPkt ifxEDPkt, IfxCryptoCtx ifxCryptoCtx) {
        IfxCipherElem ifxCipherElem;
        int n = 0;
        ifxEDPkt.IV.Hash = null;
        try {
            ifxCipherElem = (IfxCipherElem)ifxEncPkt.NegoaitedCipherList.get(ifxEDPkt.CurrentCipher);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            try {
                ifxCipherElem = (IfxCipherElem)ifxEncPkt.NegoaitedCipherList.firstElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                ifxCipherElem = null;
            }
            ifxEDPkt.CurrentCipher = 0;
        }
        if (ifxCipherElem == null) {
            n = -21;
        } else {
            n = IfxCipher.initCipher(ifxEncPkt, ifxEDPkt, ifxCipherElem.getCipherType(), ifxCipherElem.getMode());
            if (n == 0) {
                ifxEDPkt.timeLastCipherSwitch = IfxCryptoUtils.getCurrentTimeinSec();
                if ((ifxCryptoCtx.DebugFlags & 0x600) > 0) {
                    // empty if block
                }
            }
        }
        if (n != 0) {
            IfxCryptoCtx.printError(ifxEncPkt, "CryptoSwitchCipher", n);
        }
        return n;
    }

    static int initCipher(IfxEncPkt ifxEncPkt, IfxEDPkt ifxEDPkt, int n, int n2) {
        IfxCipherElem ifxCipherElem;
        int n3 = 0;
        int n4 = 0;
        if (n < 1 || n > EA_MAX) {
            return -8;
        }
        if (n2 < 1 || n2 > 4) {
            return -8;
        }
        n4 = n - 1;
        IfxCipher ifxCipher = IfxCipher.FindCipherByID(n);
        if (ifxCipher == null) {
            return -8;
        }
        if (!ifxCipher.isModeValidForThisCipher(n2)) {
            return -9;
        }
        ifxEDPkt.MacKey = ifxEncPkt.NegotiatedMacKey;
        ifxEDPkt.MacLevel = ifxEncPkt.NegotiatedMacLevel;
        ifxEDPkt.cipherElem = ifxCipherElem = new IfxCipherElem(n, n2);
        ifxEDPkt.IV.Hash = null;
        ifxEDPkt.MAC.Hash = null;
        ifxEDPkt.KeySize = ifxCipher.KeySize;
        ifxEDPkt.RC2Key = ifxCipher.RC2Key;
        ifxEDPkt.RC5Rounds = ifxCipher.RC5Rounds;
        if (ifxEDPkt.IV.SubDir >= 0) {
            ifxEDPkt.IV.init(0, 1, ifxEDPkt.SecretKey.length - 2);
        } else {
            ifxEDPkt.IV.init(ifxEDPkt.SecretKey.length - 2, -1, 0);
        }
        if (ifxEDPkt.MAC.SubDir >= 0) {
            ifxEDPkt.MAC.init(0, 1, ifxEDPkt.MacKey.length - 2);
        } else {
            ifxEDPkt.MAC.init(ifxEDPkt.MacKey.length - 2, -1, 0);
        }
        return n3;
    }

    static String getPaddingScheme(IfxCipherElem ifxCipherElem) {
        int n = ifxCipherElem.getMode();
        int n2 = ifxCipherElem.getCipherType();
        if (n == 3 || n == 4) {
            return "NoPadding";
        }
        return "PKCS5Padding";
    }

    static {
        if (CipherModes == null) {
            CipherModes = new Hashtable();
            CipherModes.put("ecb", 1);
            CipherModes.put("cbc", 2);
            CipherModes.put("cfb", 3);
            CipherModes.put("ofb", 4);
        }
        Ciphers = new IfxCipher[]{new IfxCipher("des", "DES", 1, 0, 0, 0, new boolean[]{false, true, true, true}), new IfxCipher("des3", "DESede", 2, 0, 0, 0, new boolean[]{false, true, true, true}), new IfxCipher("desx", "desx", 3, 0, 0, 0, new boolean[]{false, true, false, false}), new IfxCipher("bf-1", "Blowfish", 5, 16, 0, 0, new boolean[]{false, true, true, true}), new IfxCipher("bf-2", "Blowfish", 6, 16, 0, 0, new boolean[]{false, true, true, true}), new IfxCipher("bf-3", "Blowfish", 7, 16, 0, 0, new boolean[]{false, true, true, true}), new IfxCipher("ede", "DESede", 8, 0, 0, 0, new boolean[]{false, true, true, true}), new IfxCipher("bf1", "Blowfish", 9, 8, 0, 0, new boolean[]{false, true, true, true}), new IfxCipher("bf2", "Blowfish", 10, 16, 0, 0, new boolean[]{false, true, true, true}), new IfxCipher("bf3", "Blowfish", 11, 24, 0, 0, new boolean[]{false, true, true, true})};
        EA_MAX = Ciphers.length + 1;
    }
}

