/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm.crypto;

import com.informix.csm.IfxCsmBuffer;
import com.informix.csm.IfxCsmException;
import com.informix.csm.IfxCsmReadBuffer;
import com.informix.csm.crypto.IfxCHash;
import com.informix.csm.crypto.IfxCipher;
import com.informix.csm.crypto.IfxCipherElem;
import com.informix.csm.crypto.IfxCryptoCtx;
import com.informix.csm.crypto.IfxCryptoEngine;
import com.informix.csm.crypto.IfxCryptoUtils;
import com.informix.csm.crypto.IfxEncPkt;
import com.informix.csm.crypto.IfxMACSecretKeys;
import com.informix.csm.crypto.IfxMsgHdr;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import javax.crypto.KeyAgreement;

class IfxCryptoSession {
    static final int CRYPTO_DATAMSG = 1;
    static final int CRYPTO_SWITCH1 = 2;
    static final int CRYPTO_SWITCH2 = 3;
    static final int CRYPTO_MAC = 4;
    static final int CRYPTO_PK = 5;
    static final int CRYPTO_CIPHERS = 6;
    static final int CRYPTO_MACKEY = 7;
    static final int CRYPTO_NEWPK = 8;
    static final int CRYPTO_NEWPKACK1 = 9;
    static final int CRYPTO_NEWPKACK2 = 10;
    static final int CRYPTO_USERINIT = 11;
    static final int CRYPTO_DEBUGEV = 12;
    static final int CRYPTO_MACKEYTIME = 13;
    static final int CRYPTO_MACKEYNAME = 14;
    static final int CRYPTO_MACKEYVALUE = 15;
    static final int CRYPTO_MACLEVELS = 16;
    static final int CRYPTO_ORMAC = 17;
    static final int ENC_ORIGINATOR = 1;
    static final int ENC_SWITCHCIPHER = 2;
    static final int ENC_SWITCHCIPHER_RESP = 4;
    static final int ENC_SWITCHSECRET = 8;
    static final int ENC_SWITCHSECRET_RESP = 16;
    static final int ENC_SWITCHSECRET_ACK = 32;
    static final int ENC_SWITCHSECRET_INP = 64;
    static final int ENC_TRACESET = 128;
    static final short ENC_MAC_OFF = 1;
    static final short ENC_MAC_LOW = 2;
    static final short ENC_MAC_MED = 3;
    static final short ENC_MAC_HIGH = 4;
    static final int ENC_MAX_ORMAC_SIZE = 16;
    static final int CRYPTO_MEMTR = 1;
    static final int CRYPTO_LOCKTR = 2;
    static final int CRYPTO_ERRORTR = 4;
    static final int CRYPTO_MEMLEAK = 8;
    static final int CRYPTO_HIGHMSGTR = 64;
    static final int CRYPTO_MEDMSGTR = 96;
    static final int CRYPTO_LOWHMSGTR = 112;
    static final int CRYPTO_HIGHINT = 1024;
    static final int CRYPTO_MEDINT = 1536;
    static final int CRYPTO_LOWINT = 1792;
    static final int CRYPTO_LOGMSG = 0x10000000;
    static final int CRYPTO_DEBUGACTIVE = 0x20000000;
    static final int CRYPTO_SELECTIVE = 0x40000000;
    static final int CRYPTO_SERVER = 1;
    static final int CryptoServerFlag = 1;
    static final int CRYPTO_INITIATOR = 1;
    static final int CRYPTO_ACCEPTOR = 2;
    static final int CRYPTO_NEITHER = 3;
    static final int ERR_NOMEM = -1;
    static final int ERR_RAND = -2;
    static final int ERR_DH = -3;
    static final int ERR_PUBLIC_KEY = -4;
    static final int ERR_ACCEPT_KEY = -5;
    static final int ERR_ENCRYPT = -6;
    static final int ERR_DECRYPT = -7;
    static final int ERR_BADFUN = -8;
    static final int ERR_NOTSUPPORTED = -9;
    static final int ERR_CIPHERSETUP = -10;
    static final int ERR_CLEANUP = -11;
    static final int ERR_MACKEY = -12;
    static final int ERR_CORRUPTMSG = -13;
    static final int ERR_LOCK = -14;
    static final int ERR_DEBUG = -15;
    static final int ERR_CIPHER = -16;
    static final int ERR_UNKNOWNPARM = -17;
    static final int ERR_SESSIONINIT = -18;
    static final int ERR_DUPCIPHER = -19;
    static final int ERR_NOCIPHERS = -20;
    static final int ERR_SWITCH = -21;
    static final int ERR_PARM = -22;
    static final int ERR_PARMTIME = -23;
    static final int ERR_PARMDEBUG = -24;
    static final int ERR_PARMMAC = -25;
    static final int ERR_NOMAC = -26;
    static final int ERR_MACLEVEL = -27;
    static final int ERR_MACFILE = -28;
    static final String s_crypto_enomem = "Memory Allocation Failed";
    static final String s_crypto_erand = "Random Generator Failed";
    static final String s_crypto_edh = "Diffie-Hellman Failure";
    static final String s_crypto_epkey = "Failure during public key generation";
    static final String s_crypto_eacceptkey = "Failure during acceptance of public key";
    static final String s_crypto_eencrypt = "Failure during encryption";
    static final String s_crypto_edecrypt = "Failure encountered during decryption";
    static final String s_crypto_unsupported = "Unsupported cipher/mode/option";
    static final String s_crypto_ecypsetup = "Failure during cipher setup";
    static final String s_crypto_ecleanup = "Failure during cleanup";
    static final String s_crypto_emackey = "Failure during MAC key generation";
    static final String s_crypto_ecorruptmsg = "Received corrupt message";
    static final String s_crypto_elock = "Failure during lock creation/destruction";
    static final String s_crypto_edebug = "Failure during debug setup";
    static final String s_crypto_ecipher = "Unknown cipher/mode requested";
    static final String s_crypto_eparm = "Unknown initialization parameter";
    static final String s_crypto_esession = "Session could not be initialized";
    static final String s_crypto_edup = "Duplicate cipher registered";
    static final String s_crypto_enegot = "No ciphers were registered or no common cipher could be negotiated";
    static final String s_crypto_eswitch = "Failure during cipher renegotiation";
    static final String s_crypto_eparme = "Failure during parameter processing";
    static final String s_crypto_eswitchparm = "Illegal switch parameter";
    static final String s_crypto_edebugparm = "Error with debug parameter";
    static final String s_crypto_emacparm = "Error with MAC parameter";
    static final String s_crypto_emacnegot = "Common MAC key could not be negotiated";
    static final String s_crypto_emaclevel = "Invalid MAC level entered";
    static final String s_crypto_emacfile = "MAC key file could not be read or is invalid";
    static final String s_crypto_unknown = "Unknown error";
    static final String s_csmenc_err_pack_buffer = "Can not pack output buffer";
    static final String s_csmenc_err_memalloc = "Memory allocation failure";
    static final String s_csmenc_err_savein_buffer = "Failure attempting to combine buffers";
    static final String s_csmenc_err_process_saved = "Unable to process a staged buffer";
    static final String s_csmenc_err_wrong_msgtype = "Received message type %d but expecting %d";
    static final String s_csmenc_err_abort = "CSM abort";
    static final String s_csmenc_err_auth_failed = "Authentication failed";
    private static Hashtable errorMessageHashtable = new Hashtable();
    IfxCryptoCtx cryptoCtx;
    IfxEncPkt encPkt;

    IfxCryptoSession() {
    }

    int csmCryptoInit(String string, long l) throws IfxCsmException {
        int n = 0;
        if (this.cryptoCtx != null) {
            return n;
        }
        this.cryptoCtx = new IfxCryptoCtx();
        this.cryptoCtx.initContext(this, string);
        return n;
    }

    int csmCryptoDecrypt(IfxCsmBuffer ifxCsmBuffer, IfxCsmBuffer ifxCsmBuffer2) throws IfxCsmException {
        int n = 0;
        this.encPkt.Decrypt.In = ifxCsmBuffer;
        n = this.decrypt(this.encPkt);
        if (n == 0) {
            this.encPkt.Decrypt.In.reset();
            ifxCsmBuffer2.initialize(this.encPkt.Decrypt.Out);
        }
        return n;
    }

    int csmCryptoEncrypt(IfxCsmReadBuffer ifxCsmReadBuffer, IfxCsmBuffer ifxCsmBuffer) throws IfxCsmException {
        int n = 0;
        this.encPkt.Encrypt.In.initialize(ifxCsmReadBuffer);
        n = this.encrypt(this.encPkt);
        if (n == 0) {
            this.encPkt.Encrypt.In.reset();
            ifxCsmBuffer.initialize(this.encPkt.Encrypt.Out);
        }
        return n;
    }

    int csmCryptoInitSession(int n, IfxCsmBuffer ifxCsmBuffer) throws IfxCsmException {
        int n2 = 0;
        IfxCsmBuffer ifxCsmBuffer2 = new IfxCsmBuffer();
        IfxCsmBuffer ifxCsmBuffer3 = new IfxCsmBuffer();
        byte[] byArray = null;
        IfxMsgHdr ifxMsgHdr = new IfxMsgHdr();
        int n3 = 0;
        if (this.cryptoCtx.isDebugFlagSet(1536)) {
            // empty if block
        }
        this.encPkt = new IfxEncPkt(n, this.cryptoCtx);
        byArray = IfxCryptoEngine.generatePublicKey(this.encPkt);
        n2 = IfxCipherElem.cryptoGetCiphers(ifxCsmBuffer2, this.cryptoCtx);
        if (n2 == 0 && (n2 = IfxMACSecretKeys.cryptoGetMAC(ifxCsmBuffer3, this.cryptoCtx)) == 0) {
            n3 = byArray.length + 4 + ifxCsmBuffer2.getCount() + 4 + ifxCsmBuffer3.getCount() + 4 + 4 + 4;
            if (this.encPkt.isFlagSet(128)) {
                n3 += this.cryptoCtx.DebugEV.length + 4;
            }
            IfxCsmBuffer ifxCsmBuffer4 = new IfxCsmBuffer(n3);
            if (this.encPkt.isFlagSet(128)) {
                ifxMsgHdr.setMsgType(12);
                ifxMsgHdr.setMsgSize(this.cryptoCtx.DebugEV.length);
                ifxCsmBuffer4.write(ifxMsgHdr.getCMsgHdr());
                ifxCsmBuffer4.write(this.cryptoCtx.DebugEV);
            }
            ifxMsgHdr.setMsgType(6);
            ifxMsgHdr.setMsgSize(ifxCsmBuffer2.getCount());
            ifxCsmBuffer4.write(ifxMsgHdr.getCMsgHdr());
            ifxCsmBuffer4.write(ifxCsmBuffer2.toByteArray());
            ifxMsgHdr.setMsgType(16);
            ifxMsgHdr.setMsgSize(4);
            ifxCsmBuffer4.write(ifxMsgHdr.getCMsgHdr());
            ifxCsmBuffer4.write(IfxCryptoUtils.JavaToIfxInt(this.cryptoCtx.MacLevel, 4));
            ifxMsgHdr.setMsgType(7);
            ifxMsgHdr.setMsgSize(ifxCsmBuffer3.getCount());
            ifxCsmBuffer4.write(ifxMsgHdr.getCMsgHdr());
            ifxCsmBuffer4.write(ifxCsmBuffer3.toByteArray());
            ifxMsgHdr.setMsgType(5);
            ifxMsgHdr.setMsgSize(byArray.length);
            ifxCsmBuffer4.write(ifxMsgHdr.getCMsgHdr());
            ifxCsmBuffer4.write(byArray);
            if (this.encPkt.Encrypt.In.getCount() != 0) {
                n2 = -18;
            } else {
                this.encPkt.Encrypt.In = ifxCsmBuffer4;
                n2 = this.encrypt(this.encPkt);
                if (n2 == 0) {
                    ifxCsmBuffer.initialize(this.encPkt.Encrypt.Out);
                    this.encPkt.Encrypt.In = new IfxCsmBuffer();
                    this.encPkt.Encrypt.Out = new IfxCsmBuffer();
                }
            }
        }
        return n2;
    }

    int csmCryptoAcceptConnection(IfxCsmBuffer ifxCsmBuffer) throws IfxCsmException {
        int n = 0;
        IfxMsgHdr ifxMsgHdr = new IfxMsgHdr();
        this.encPkt.Decrypt.In = ifxCsmBuffer;
        n = this.decrypt(this.encPkt);
        if (n == 0) {
            this.encPkt.Decrypt.In = new IfxCsmBuffer();
            IfxCsmReadBuffer ifxCsmReadBuffer = new IfxCsmReadBuffer(this.encPkt.Decrypt.Out);
            while (ifxCsmReadBuffer.available() > 0) {
                ifxMsgHdr.setMsgHdr(IfxCryptoUtils.readByteInputStream(ifxCsmReadBuffer, 4));
                switch (ifxMsgHdr.getType()) {
                    case 7: {
                        n = IfxMACSecretKeys.negotiateMac(this.encPkt, IfxCryptoUtils.readByteInputStream(ifxCsmReadBuffer, ifxMsgHdr.getMsgSize()), this.cryptoCtx);
                        break;
                    }
                    case 5: {
                        byte[] byArray = IfxCryptoUtils.readByteInputStream(ifxCsmReadBuffer, ifxMsgHdr.getMsgSize());
                        byte[] byArray2 = null;
                        byArray2 = IfxCryptoEngine.acceptPublicKey(this.encPkt.DH, byArray);
                        if (byArray2.length < byArray.length) {
                            byte[] byArray3 = new byte[byArray.length];
                            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                            byArray2 = byArray3;
                        }
                        this.encPkt.Encrypt.SecretKey = byArray2;
                        this.encPkt.Decrypt.SecretKey = IfxCryptoUtils.createCopy(byArray2);
                        this.encPkt.DH = null;
                        break;
                    }
                    case 6: {
                        n = IfxCipherElem.negotiateCipher(this.encPkt, IfxCryptoUtils.readByteInputStream(ifxCsmReadBuffer, ifxMsgHdr.getMsgSize()), this.cryptoCtx);
                        break;
                    }
                    case 16: {
                        int n2 = IfxCryptoUtils.readInt(ifxCsmReadBuffer, 4);
                        if (IfxCryptoUtils.isFlagSet(n2 &= this.cryptoCtx.MacLevel, 8)) {
                            this.encPkt.NegotiatedMacLevel = (short)4;
                            break;
                        }
                        if (IfxCryptoUtils.isFlagSet(n2, 4)) {
                            this.encPkt.NegotiatedMacLevel = (short)3;
                            break;
                        }
                        if (IfxCryptoUtils.isFlagSet(n2, 2)) {
                            this.encPkt.NegotiatedMacLevel = (short)2;
                            break;
                        }
                        if (IfxCryptoUtils.isFlagSet(n2, 1)) {
                            this.encPkt.NegotiatedMacLevel = 1;
                            break;
                        }
                        n = -26;
                        break;
                    }
                    case 12: {
                        byte[] byArray = IfxCryptoUtils.readByteInputStream(ifxCsmReadBuffer, ifxMsgHdr.getMsgSize());
                        if (!this.cryptoCtx.isDebugFlagSet(0x40000000) || this.cryptoCtx.DebugEV == null || !Arrays.equals(byArray, this.cryptoCtx.DebugEV)) break;
                        this.encPkt.setFlag(128);
                        break;
                    }
                    default: {
                        n = -13;
                    }
                }
                if (n == 0) continue;
            }
            this.encPkt.setFlag(4);
            this.encPkt.Encrypt.CurrentCipher = -1;
            this.encPkt.CipherSwitchTime = this.cryptoCtx.CipherSwitchTime;
            this.encPkt.SecretSwitchTime = this.cryptoCtx.SecretSwitchTime;
            this.encPkt.Encrypt.timeLastKeySwitch = this.encPkt.Decrypt.timeLastKeySwitch = IfxCryptoUtils.getCurrentTimeinSec();
            this.encPkt.Decrypt.timeLastCipherSwitch = this.encPkt.Decrypt.timeLastKeySwitch;
            this.encPkt.Encrypt.timeLastCipherSwitch = this.encPkt.Decrypt.timeLastKeySwitch;
        }
        return n;
    }

    static String csmCryptoErrDesc(int n) {
        String string = null;
        string = (String)errorMessageHashtable.get(n);
        if (string == null) {
            string = s_crypto_unknown;
        }
        return string;
    }

    static String csmCryptoErrDesc(int n, Exception exception) {
        return IfxCryptoSession.csmCryptoErrDesc(n) + "\n" + exception.toString();
    }

    static IfxCsmException getCsmErrException(int n, Exception exception) {
        return new IfxCsmException(-5010, IfxCryptoSession.csmCryptoErrDesc(n, exception));
    }

    static IfxCsmException getCsmErrException(int n) {
        return new IfxCsmException(-5010, IfxCryptoSession.csmCryptoErrDesc(n));
    }

    int encrypt(IfxEncPkt ifxEncPkt) throws IfxCsmException {
        int n;
        block35: {
            block37: {
                IfxCryptoEngine ifxCryptoEngine;
                byte[] byArray;
                IfxMsgHdr ifxMsgHdr;
                int n2;
                byte[] byArray2;
                IfxCsmBuffer ifxCsmBuffer;
                block36: {
                    n = 0;
                    byte[] byArray3 = null;
                    ifxCsmBuffer = null;
                    byArray2 = new byte[]{};
                    n2 = 0;
                    Object var7_7 = null;
                    ifxMsgHdr = new IfxMsgHdr();
                    int n3 = 0;
                    if (ifxEncPkt.CipherSwitchTime > 0L && IfxCryptoUtils.getCurrentTimeinSec() > ifxEncPkt.Encrypt.timeLastCipherSwitch + ifxEncPkt.CipherSwitchTime) {
                        ifxEncPkt.setFlag(2);
                    }
                    if (ifxEncPkt.SecretSwitchTime > 0L && !ifxEncPkt.isFlagSet(64) && ifxEncPkt.DH == null && IfxCryptoUtils.getCurrentTimeinSec() > ifxEncPkt.Encrypt.timeLastKeySwitch + ifxEncPkt.SecretSwitchTime) {
                        ifxEncPkt.setFlag(8);
                    }
                    n3 = ifxEncPkt.Encrypt.In.getCount() + 4;
                    if (ifxEncPkt.isFlagSet(6)) {
                        n3 += 6;
                    }
                    if (ifxEncPkt.isFlagSet(8)) {
                        if (this.cryptoCtx.isDebugFlagSet(1024)) {
                            // empty if block
                        }
                        ifxEncPkt.setFlag(64);
                        byArray3 = IfxCryptoEngine.generatePublicKey(ifxEncPkt.Encrypt);
                        n3 += 4 + byArray3.length;
                    }
                    if (ifxEncPkt.isFlagSet(16)) {
                        n3 += 4 + ifxEncPkt.Decrypt.PublicKey.length;
                    }
                    if (ifxEncPkt.isFlagSet(32)) {
                        n3 += 4;
                    }
                    ifxCsmBuffer = new IfxCsmBuffer(n3);
                    ifxMsgHdr.setMsgHdr(1, ifxEncPkt.Encrypt.In.getCount());
                    ifxCsmBuffer.write(ifxMsgHdr.getCMsgHdr());
                    try {
                        ifxEncPkt.Encrypt.In.writeTo(ifxCsmBuffer);
                    }
                    catch (IOException iOException) {
                        n = -6;
                        break block35;
                    }
                    if (ifxEncPkt.isFlagSet(6)) {
                        int n4 = (int)Math.round(Math.random() * 127.0);
                        ifxEncPkt.Encrypt.CurrentCipher = n4 % ifxEncPkt.NegoaitedCipherList.size();
                        ifxMsgHdr.setMsgSize(2);
                        if (ifxEncPkt.isFlagSet(4)) {
                            ifxMsgHdr.setMsgType(2);
                        } else {
                            ifxMsgHdr.setMsgType(3);
                        }
                        ifxCsmBuffer.write(ifxMsgHdr.getCMsgHdr());
                        ifxCsmBuffer.write(IfxCryptoUtils.JavaToIfxInt(ifxEncPkt.Encrypt.CurrentCipher, 2));
                        if (this.cryptoCtx.isDebugFlagSet(1024)) {
                            // empty if block
                        }
                    }
                    if (ifxEncPkt.isFlagSet(8)) {
                        ifxMsgHdr.setMsgType(8);
                        ifxMsgHdr.setMsgSize(byArray3.length);
                        if (this.cryptoCtx.isDebugFlagSet(1024)) {
                            // empty if block
                        }
                        ifxCsmBuffer.write(ifxMsgHdr.getCMsgHdr());
                        ifxCsmBuffer.write(byArray3);
                        byArray3 = null;
                        ifxEncPkt.clearFlag(8);
                    }
                    if (ifxEncPkt.isFlagSet(16)) {
                        byte[] byArray4 = ifxEncPkt.Decrypt.PublicKey;
                        ifxMsgHdr.setMsgType(9);
                        ifxMsgHdr.setMsgSize(byArray4.length);
                        if (this.cryptoCtx.isDebugFlagSet(1024)) {
                            // empty if block
                        }
                        ifxCsmBuffer.write(ifxMsgHdr.getCMsgHdr());
                        ifxCsmBuffer.write(byArray4);
                        ifxEncPkt.Decrypt.PublicKey = null;
                        ifxEncPkt.clearFlag(16);
                    }
                    if (ifxEncPkt.isFlagSet(32)) {
                        if (this.cryptoCtx.isDebugFlagSet(1024)) {
                            // empty if block
                        }
                        ifxMsgHdr.setMsgType(10);
                        ifxMsgHdr.setMsgSize(0);
                        ifxCsmBuffer.write(ifxMsgHdr.getCMsgHdr());
                    }
                    byArray = ifxCsmBuffer.toByteArray();
                    ifxCryptoEngine = new IfxCryptoEngine(ifxEncPkt, 1);
                    if (this.cryptoCtx.isDebugFlagSet(64)) {
                        // empty if block
                    }
                    if (ifxEncPkt.Encrypt.MacLevel == 1) break block36;
                    n = IfxCHash.generateHash(ifxEncPkt.Encrypt.MAC, 36, ifxEncPkt.Encrypt.MacKey);
                    if (n != 0) break block35;
                    if (this.cryptoCtx.isDebugFlagSet(64)) {
                        // empty if block
                    }
                    if (ifxEncPkt.Encrypt.MacLevel == 4 || ifxEncPkt.Encrypt.MacLevel == 3 && ifxCsmBuffer.getCount() > 16) {
                        byArray2 = IfxCryptoEngine.internalGenerateHMAC(ifxEncPkt.Encrypt.MAC.Hash, byArray);
                        n2 = 4;
                    } else {
                        byArray2 = new byte[1];
                        System.arraycopy(ifxEncPkt.Encrypt.MAC.Hash, 0, byArray2, 0, 1);
                        byte[] byArray5 = byArray;
                        for (int i = 0; i < byArray5.length; ++i) {
                            byArray2[0] = (byte)(byArray2[0] ^ byArray5[i]);
                        }
                        n2 = 17;
                    }
                    if (this.cryptoCtx.isDebugFlagSet(64)) {
                        // empty if block
                    }
                }
                if (this.cryptoCtx.isDebugFlagSet(64)) {
                    // empty if block
                }
                ifxCryptoEngine.initCipher();
                if (this.cryptoCtx.isDebugFlagSet(64)) {
                    // empty if block
                }
                int n5 = ifxCsmBuffer.getCount() + 4 + byArray2.length + ifxCryptoEngine.getBlockSize();
                ifxEncPkt.Encrypt.Out = new IfxCsmBuffer(n5);
                if (ifxEncPkt.Encrypt.MacLevel != 1) {
                    ifxMsgHdr.setMsgType(n2);
                    ifxMsgHdr.setMsgSize(byArray2.length);
                    ifxEncPkt.Encrypt.Out.write(ifxCryptoEngine.updateCipher(ifxMsgHdr.getCMsgHdr()));
                    if (byArray2 != null) {
                        ifxEncPkt.Encrypt.Out.write(ifxCryptoEngine.updateCipher(byArray2));
                    }
                }
                ifxEncPkt.Encrypt.Out.write(ifxCryptoEngine.updateCipher(byArray));
                ifxEncPkt.Encrypt.Out.write(ifxCryptoEngine.doFinal());
                if (this.cryptoCtx.isDebugFlagSet(64)) {
                    // empty if block
                }
                if (!ifxEncPkt.isFlagSet(6)) break block37;
                n = IfxCipher.cryptoSwitchCipher(ifxEncPkt, ifxEncPkt.Encrypt, this.cryptoCtx);
                if (n != 0) break block35;
                ifxEncPkt.clearFlag(6);
            }
            if (ifxEncPkt.isFlagSet(32)) {
                if (this.cryptoCtx.isDebugFlagSet(1024)) {
                    // empty if block
                }
                ifxEncPkt.Encrypt.SecretKey = null;
                ifxEncPkt.Encrypt.SecretKey = ifxEncPkt.Encrypt.NextKey;
                ifxEncPkt.Encrypt.NextKey = null;
                ifxEncPkt.Encrypt.timeLastKeySwitch = IfxCryptoUtils.getCurrentTimeinSec();
                ifxEncPkt.clearFlag(96);
            }
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    int decrypt(IfxEncPkt var1_1) throws IfxCsmException {
        block28: {
            block31: {
                block34: {
                    block35: {
                        block32: {
                            block33: {
                                block30: {
                                    block29: {
                                        block27: {
                                            var2_2 = 0;
                                            var3_3 = null;
                                            var4_4 = null;
                                            var5_5 = false;
                                            var6_6 = new IfxMsgHdr();
                                            var7_7 = null;
                                            if (this.cryptoCtx.isDebugFlagSet(64)) {
                                                // empty if block
                                            }
                                            var8_8 = new IfxCryptoEngine(var1_1, 2);
                                            if (this.cryptoCtx.isDebugFlagSet(64)) {
                                                // empty if block
                                            }
                                            var8_8.initCipher();
                                            if (this.cryptoCtx.isDebugFlagSet(64)) {
                                                // empty if block
                                            }
                                            var7_7 = var8_8.doFinal(var1_1.Decrypt.In.toByteArray());
                                            var9_9 = new ByteArrayInputStream(var7_7);
                                            if (this.cryptoCtx.isDebugFlagSet(64)) {
                                                // empty if block
                                            }
                                            var6_6.setMsgHdr(IfxCryptoUtils.readByteInputStream(var9_9, 4));
                                            var10_10 = var6_6.getMsgSize() + 4;
                                            if (var10_10 <= var7_7.length) break block27;
                                            var2_2 = -7;
                                            break block28;
                                        }
                                        if (var1_1.Decrypt.MacLevel == 1) break block29;
                                        var2_2 = IfxCHash.generateHash(var1_1.Decrypt.MAC, 36, var1_1.Decrypt.MacKey);
                                        if (var2_2 != 0) break block28;
                                        if (this.cryptoCtx.isDebugFlagSet(64)) {
                                            // empty if block
                                        }
                                    }
                                    if (var1_1.Decrypt.MacLevel != 1) break block30;
                                    if (var6_6.getType() != 4 && var6_6.getType() != 17) break block31;
                                    var2_2 = -7;
                                    break block28;
                                }
                                if (var1_1.Decrypt.MacLevel != 4 && (var1_1.Decrypt.MacLevel != 3 || var7_7.length - var10_10 <= 16)) break block32;
                                if (var6_6.getType() == 4) break block33;
                                var2_2 = -7;
                                break block28;
                            }
                            var4_4 = IfxCryptoEngine.internalGenerateHMAC(var1_1.Decrypt.MAC.Hash, var7_7, var10_10, var7_7.length - var10_10);
                            break block34;
                        }
                        var4_4 = new byte[1];
                        if (var6_6.getType() == 17) break block35;
                        var2_2 = -7;
                        break block28;
                    }
                    var4_4[0] = var1_1.Decrypt.MAC.Hash[0];
                    for (var11_11 = var10_10; var11_11 < var7_7.length; ++var11_11) {
                        var4_4[0] = (byte)(var4_4[0] ^ var7_7[var11_11]);
                    }
                }
                if ((this.cryptoCtx.DebugFlags & 64) > 0) {
                    // empty if block
                }
            }
            if (var1_1.Decrypt.MacLevel == 1) ** GOTO lbl64
            if (var6_6.getMsgSize() != var4_4.length || !IfxCryptoUtils.areArrayElemntsEqual(var4_4, 0, var7_7, 4, var4_4.length)) {
                var2_2 = -13;
            } else {
                var9_9.skip(var6_6.getMsgSize());
                var6_6.setMsgHdr(IfxCryptoUtils.readByteInputStream(var9_9, 4));
lbl64:
                // 2 sources

                var1_1.Decrypt.Out.reset();
                while (true) {
                    if (this.cryptoCtx.isDebugFlagSet(1024)) {
                        // empty if block
                    }
                    switch (var6_6.getType()) {
                        case 1: {
                            var11_12 = new IfxCsmBuffer();
                            try {
                                var1_1.Decrypt.Out.writeTo(var11_12);
                            }
                            catch (Exception var12_14) {
                                var2_2 = -7;
                                break;
                            }
                            var11_12.write(IfxCryptoUtils.readByteInputStream(var9_9, var6_6.getMsgSize()));
                            var1_1.Decrypt.Out = null;
                            var1_1.Decrypt.Out = var11_12;
                            break;
                        }
                        case 3: {
                            var1_1.setFlag(4);
                        }
                        case 2: {
                            if (this.cryptoCtx.isDebugFlagSet(1024)) {
                                // empty if block
                            }
                            var1_1.Decrypt.CurrentCipher = IfxCryptoUtils.readInt(var9_9, 2);
                            var2_2 = IfxCipher.cryptoSwitchCipher(var1_1, var1_1.Decrypt, this.cryptoCtx);
                            break;
                        }
                        case 8: {
                            var12_13 = IfxCryptoEngine.generateDHKeyAgreement();
                            var13_15 = null;
                            if (this.cryptoCtx.isDebugFlagSet(1024)) {
                                // empty if block
                            }
                            var13_15 = IfxCryptoUtils.readByteInputStream(var9_9, var6_6.getMsgSize());
                            var1_1.Decrypt.PublicKey = IfxCryptoEngine.generatePublicKey((KeyAgreement)var12_13);
                            var1_1.Decrypt.NextKey = IfxCryptoEngine.acceptPublicKey((KeyAgreement)var12_13, var13_15);
                            var1_1.setFlag(16);
                            var12_13 = null;
                            break;
                        }
                        case 9: {
                            var12_13 = null;
                            var12_13 = IfxCryptoUtils.readByteInputStream(var9_9, var6_6.getMsgSize());
                            if (this.cryptoCtx.isDebugFlagSet(1024)) {
                                // empty if block
                            }
                            var1_1.Encrypt.NextKey = IfxCryptoEngine.acceptPublicKey(var1_1.Encrypt.DH, (byte[])var12_13);
                            var1_1.setFlag(32);
                            break;
                        }
                        case 10: {
                            if (this.cryptoCtx.isDebugFlagSet(1024)) {
                                // empty if block
                            }
                            var1_1.Decrypt.SecretKey = var1_1.Decrypt.NextKey;
                            var1_1.Decrypt.NextKey = null;
                            var1_1.Decrypt.timeLastKeySwitch = IfxCryptoUtils.getCurrentTimeinSec();
                            break;
                        }
                        default: {
                            var2_2 = -13;
                        }
                    }
                    if (var2_2 != 0 || var9_9.available() <= 0) break;
                    var6_6.setMsgHdr(IfxCryptoUtils.readByteInputStream(var9_9, 4));
                }
                if (var2_2 != 0 || this.cryptoCtx.isDebugFlagSet(64)) {
                    // empty if block
                }
            }
        }
        if (var2_2 != 0) {
            IfxCryptoCtx.printError(var1_1, "Decrypt", var2_2);
        }
        var7_7 = null;
        return var2_2;
    }

    static {
        errorMessageHashtable.put(-1, s_crypto_enomem);
        errorMessageHashtable.put(-2, s_crypto_erand);
        errorMessageHashtable.put(-3, s_crypto_edh);
        errorMessageHashtable.put(-4, s_crypto_epkey);
        errorMessageHashtable.put(-5, s_crypto_eacceptkey);
        errorMessageHashtable.put(-6, s_crypto_eencrypt);
        errorMessageHashtable.put(-7, s_crypto_edecrypt);
        errorMessageHashtable.put(-8, s_crypto_unsupported);
        errorMessageHashtable.put(-9, s_crypto_unsupported);
        errorMessageHashtable.put(-10, s_crypto_ecypsetup);
        errorMessageHashtable.put(-11, s_crypto_ecleanup);
        errorMessageHashtable.put(-12, s_crypto_emackey);
        errorMessageHashtable.put(-13, s_crypto_ecorruptmsg);
        errorMessageHashtable.put(-14, s_crypto_elock);
        errorMessageHashtable.put(-15, s_crypto_edebug);
        errorMessageHashtable.put(-16, s_crypto_ecipher);
        errorMessageHashtable.put(-17, s_crypto_eparm);
        errorMessageHashtable.put(-18, s_crypto_esession);
        errorMessageHashtable.put(-19, s_crypto_edup);
        errorMessageHashtable.put(-20, s_crypto_enegot);
        errorMessageHashtable.put(-21, s_crypto_eswitch);
        errorMessageHashtable.put(-22, s_crypto_eparme);
        errorMessageHashtable.put(-23, s_crypto_eswitchparm);
        errorMessageHashtable.put(-24, s_crypto_edebugparm);
        errorMessageHashtable.put(-25, s_crypto_emacparm);
        errorMessageHashtable.put(-26, s_crypto_emacnegot);
        errorMessageHashtable.put(-27, s_crypto_emaclevel);
        errorMessageHashtable.put(-28, s_crypto_emacfile);
    }
}

