/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm.crypto;

import com.informix.csm.IfxCsmException;
import com.informix.csm.crypto.IfxCipher;
import com.informix.csm.crypto.IfxCryptoCtx;
import com.informix.csm.crypto.IfxCryptoSession;
import com.informix.csm.crypto.IfxCryptoUtils;
import com.informix.csm.crypto.IfxEDPkt;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Vector;
import javax.crypto.KeyAgreement;

class IfxEncPkt {
    int SessionID;
    KeyAgreement DH;
    Vector NegoaitedCipherList;
    byte[] NegotiatedMacKey;
    long CipherSwitchTime;
    long SecretSwitchTime;
    char MacLevel;
    short NegotiatedMacLevel;
    int Flags;
    IfxEDPkt Encrypt;
    IfxEDPkt Decrypt;
    IfxCryptoCtx cryptoCtx;

    private void initIfxEncPkt() {
        this.NegoaitedCipherList = new Vector();
        this.Encrypt = new IfxEDPkt();
        this.Decrypt = new IfxEDPkt();
    }

    public IfxEncPkt(IfxCryptoCtx ifxCryptoCtx) {
        this.cryptoCtx = ifxCryptoCtx;
        this.initIfxEncPkt();
    }

    public IfxEncPkt(int n, IfxCryptoCtx ifxCryptoCtx) throws IfxCsmException {
        this(ifxCryptoCtx);
        int n2;
        int n3;
        int n4 = 0;
        byte[] byArray = null;
        BigInteger bigInteger = null;
        bigInteger = new BigInteger("A98395B2CA23C77DDA371E56145E3E4788EEC651BDA0A6D684CF6B5868B9", 16);
        byArray = IfxCryptoUtils.bigIntegerToBinary(bigInteger);
        this.Encrypt.SecretKey = byArray;
        this.Decrypt.SecretKey = IfxCryptoUtils.createCopy(byArray);
        byArray = null;
        this.NegotiatedMacKey = this.cryptoCtx.DefaultMAC.Key;
        this.NegotiatedMacLevel = (short)4;
        switch (n) {
            case 1: {
                n3 = 1;
                n2 = -1;
                break;
            }
            case 2: {
                n3 = -1;
                n2 = 1;
                break;
            }
            default: {
                n3 = 1;
                n2 = 1;
            }
        }
        this.Encrypt.IV.SubDir = n3;
        this.Encrypt.MAC.SubDir = n3;
        this.Decrypt.IV.SubDir = n2;
        this.Decrypt.MAC.SubDir = n2;
        n4 = IfxCipher.initCipher(this, this.Encrypt, 2, 2);
        if (n4 == 0 && (n4 = IfxCipher.initCipher(this, this.Decrypt, 2, 2)) == 0) {
            this.Encrypt.CurrentCipher = -1;
            this.Decrypt.CurrentCipher = -1;
            this.SessionID = ++ifxCryptoCtx.SessionID;
            if (ifxCryptoCtx.DebugEV != null) {
                try {
                    if (IfxCryptoUtils.isClassInClasspath(new String(ifxCryptoCtx.DebugEV, "ASCII"))) {
                        this.setFlag(128);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw IfxCryptoSession.getCsmErrException(-15, unsupportedEncodingException);
                }
            }
        }
        byArray = null;
        bigInteger = null;
        if (n4 != 0) {
            throw IfxCryptoSession.getCsmErrException(n4);
        }
    }

    void setFlag(int n) {
        this.Flags |= n;
    }

    boolean isFlagSet(int n) {
        return IfxCryptoUtils.isFlagSet(this.Flags, n);
    }

    void clearFlag(int n) {
        this.Flags &= ~n;
    }
}

