/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm.crypto;

import com.informix.csm.IfxCsm;
import com.informix.csm.IfxCsmBuffer;
import com.informix.csm.IfxCsmDescriptor;
import com.informix.csm.IfxCsmException;
import com.informix.csm.IfxCsmReadBuffer;
import com.informix.csm.crypto.IfxCryptoSession;
import com.informix.csm.crypto.IfxGssMsgHdr;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class IfxGssCsm
implements IfxCsm {
    private static final int ENC_CSM_FLAG_INITSTRING_PENDING = 1;
    private static final String ENC_CSM_CONTEXT_ID = "CSMENC";
    private static final int GSS_CSM_STATE_UNINITIALIZED = -1;
    private static final int ENC_CSM_STATE_INITIAL = 0;
    private static final int ENC_CSM_STATE_INITSTRING = 1;
    private static final int ENC_CSM_STATE_INITSTRINGDEFER = 21;
    private static final int ENC_CSM_STATE_INITSTRINGPENDING = 3;
    private static final int ENC_CSM_STATE_AUTHPENDING = 4;
    private static final int ENC_CSM_STATE_INITSTRING_SEND = 5;
    private static final int ENC_CSM_STATE_INITPW_SEND = 6;
    private static final int ENC_CSM_STATE_INITDONE = 7;
    private static final int ENC_CSM_STATE_ACTIVE = 8;
    private static final int ENC_CSM_STATE_MORE_INPUT_NEEDED = 9;
    private static final int ENC_CSM_STATE_MORE_OUTPUT_AVAILABLE = 10;
    private static final int ENC_CSM_STATE_SENDTOPEER_DONE = 11;
    private static final int ENC_CSM_STATE_RELEASE_CONTEXT = 12;
    private static final int ENC_CSM_STATE_READY = 13;
    private static final int ENC_CSM_STATE_ABORT = 14;
    private static final int ENC_CSM_STATE_ABORT_FINAL = 15;
    private static final int ENC_CSM_STATE_INIT_SEND = 20;
    private static final int ENC_CSM_MSG_TYPE_INITSTRING = 9;
    private static final int ENC_CSM_MSG_TYPE_AUTHENTICATION = 8;
    private static final int ENC_CSM_MSG_TYPE_DATA = 10;
    private static final int ENC_CSM_MSG_TYPE_RELEASE_CONTEXT = 4;
    private static final int ENC_CSM_MSG_TYPE_ABORT = 5;
    private static final int ENC_CSM_MSG_TYPE_PWD = 6;
    private static final int ENC_CSM_MSG_TYPE_ID = 7;
    private static final int CSM_GSS_MSG_TYPE_DATA = 1;
    private static final int CSM_GSS_MSG_TYPE_CREATE_CONTEXT = 2;
    private static final int CSM_GSS_MSG_TYPE_RELEASE_CONTEXT = 3;
    private static final String GSS_KRB5_OID = "1.2.840.113554.1.2.2";
    private static final int ENC_CSM_PWD_REQD_FLAG = 1;
    private static final int ENC_CSM_PWD_NOT_GIVEN = 16;
    String csmContextId;
    int contextFlags;
    int state = -1;
    int csm_error;
    GSSManager manager = null;
    GSSContext context = null;
    byte[] token = new byte[0];
    IfxCsmDescriptor csmDesc;
    IfxCsmBuffer savedBuffer;
    IfxCryptoSession cryptoSession;
    IfxCsmBuffer outHandshake;
    IfxCsmBuffer outPw;
    String csmString;

    public IfxGssCsm(IfxCsmDescriptor ifxCsmDescriptor) throws IfxCsmException {
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
        this.csmDesc = ifxCsmDescriptor;
        this.savedBuffer = new IfxCsmBuffer();
        this.state = -1;
        this.csmDesc.setLoadState(0);
        this.csmDesc.setLoadState(2);
        this.csmString = this.csmDesc.getInitString();
        this.csmDesc.setLoadState(1);
    }

    public IfxCsmDescriptor getDescriptor() {
        return this.csmDesc;
    }

    @Override
    public int ifxCsmInit(String string, long l, IfxCsm.Status status) throws IfxCsmException {
        int n = 0;
        status.reset();
        this.cryptoSession = new IfxCryptoSession();
        n = this.cryptoSession.csmCryptoInit(string, l);
        if (n != 0) {
            status.setCsmErr(-5006);
            status.setCsmString(IfxCryptoSession.csmCryptoErrDesc(n));
            return 1;
        }
        status.setCsmCode(1L);
        return 0;
    }

    @Override
    public int ifxCsmTerminate(IfxCsm.Status status) {
        int n = 0;
        return n;
    }

    @Override
    public long ifxCsmGetAttributeFlags(IfxCsm.Status status) {
        return 2L;
    }

    @Override
    public int ifxCsmCreateContext(IfxCsm.Credentials credentials, IfxCsmReadBuffer ifxCsmReadBuffer, IfxCsmBuffer ifxCsmBuffer, String string, IfxCsm.Status status) throws IfxCsmException {
        boolean bl = false;
        IfxCsmBuffer ifxCsmBuffer2 = new IfxCsmBuffer();
        IfxCsmBuffer ifxCsmBuffer3 = new IfxCsmBuffer();
        IfxCsmBuffer ifxCsmBuffer4 = new IfxCsmBuffer();
        IfxGssMsgHdr ifxGssMsgHdr = new IfxGssMsgHdr();
        boolean bl2 = false;
        int n = 0;
        boolean bl3 = false;
        int n2 = 0;
        ifxCsmBuffer.reset();
        status.reset();
        if (this.state == -1) {
            try {
                this.gssInitializeCsmContext();
                this.token = this.context.initSecContext(this.token, 0, this.token.length);
                ifxCsmBuffer2.write(this.token);
            }
            catch (Exception exception) {
                this.gssDestroyCsmContext();
                status.setCsmErr(-5010);
                throw IfxCryptoSession.getCsmErrException(-5010, exception);
            }
            this.savedBuffer = new IfxCsmBuffer();
            this.contextFlags = n;
            this.outHandshake = new IfxCsmBuffer();
            n2 = 2;
            if (this.encPackBuffer(ifxCsmBuffer2, this.outHandshake, n2, status) == 1) {
                status.setCsmErr(-5010);
                ifxCsmBuffer2.reset();
                return this.err1IfxCsmCreateContext(ifxCsmBuffer, status);
            }
            ifxCsmBuffer2.reset();
            if (ifxCsmReadBuffer != null && ifxCsmReadBuffer.available() > 0) {
                this.outHandshake.reset();
                this.outHandshake.write(ifxCsmBuffer.toByteArray());
                this.state = 3;
            } else {
                this.state = 1;
            }
        }
        if (this.state == 7) {
            return this.exitIfxCsmCreateContext(ifxCsmBuffer3, ifxCsmBuffer2, ifxCsmBuffer, status);
        }
        if (this.state == 14) {
            this.state = 15;
        } else if (ifxCsmReadBuffer != null && ifxCsmReadBuffer.available() > 0) {
            if (this.encSaveInBuffer(ifxCsmReadBuffer, status) == 1) {
                status.setCsmErr(-5010);
                status.setCsmString("Failure attempting to combine buffers");
                throw IfxCryptoSession.getCsmErrException(-5010);
            }
            if (this.encProcessSavedBuffer(ifxGssMsgHdr, ifxCsmBuffer3, status) == 1) {
                status.setCsmErr(-5010);
                status.setCsmString("Unable to process a staged buffer");
                throw IfxCryptoSession.getCsmErrException(-5010);
            }
            if (status.getCsmCode() == 5L) {
                return 0;
            }
            if (ifxGssMsgHdr.getType() == 5) {
                this.encGetAbortToken(ifxCsmBuffer3, status);
                this.state = 15;
                this.savedBuffer.reset();
                return this.exitIfxCsmCreateContext(ifxCsmBuffer3, ifxCsmBuffer2, ifxCsmBuffer, status);
            }
            if (ifxGssMsgHdr.getType() != 2) {
                status.setCsmErr(-5012);
                status.setCsmString("Received message type %d but expecting %d" + ifxGssMsgHdr.getType() + 2);
                this.gssDestroyCsmContext();
                return this.err1IfxCsmCreateContext(ifxCsmBuffer, status);
            }
            if (!this.context.isEstablished()) {
                this.token = new byte[ifxCsmBuffer3.getCount()];
                this.token = ifxCsmBuffer3.toByteArrayWithReset();
                try {
                    this.token = this.context.initSecContext(this.token, 0, this.token.length);
                    if (this.context.isEstablished()) {
                        if (this.context.getMutualAuthState()) {
                            this.state = 7;
                        }
                        return this.exitIfxCsmCreateContext(ifxCsmBuffer3, ifxCsmBuffer2, ifxCsmBuffer, status);
                    }
                    ifxCsmBuffer2.write(this.token);
                }
                catch (Exception exception) {
                    this.gssDestroyCsmContext();
                    status.setCsmErr(-5010);
                    throw IfxCryptoSession.getCsmErrException(-5010, exception);
                }
            }
            this.outPw = new IfxCsmBuffer();
            n2 = 2;
            if (this.encPackBuffer(ifxCsmBuffer2, this.outPw, n2, status) == 1) {
                status.setCsmErr(-5010);
                status.setCsmString("Can not pack output buffer");
                this.gssDestroyCsmContext();
                ifxCsmBuffer2.reset();
                return this.err1IfxCsmCreateContext(ifxCsmBuffer, status);
            }
            ifxCsmBuffer2.reset();
            if (this.state == 1) {
                this.state = 6;
            } else if (this.state == 3) {
                this.state = 5;
            }
        }
        return this.exitIfxCsmCreateContext(ifxCsmBuffer3, ifxCsmBuffer2, ifxCsmBuffer, status);
    }

    @Override
    public int ifxCsmProcessOutMessage(IfxCsmReadBuffer ifxCsmReadBuffer, IfxCsmBuffer ifxCsmBuffer, IfxCsm.Status status) throws IfxCsmException {
        status.reset();
        if (ifxCsmReadBuffer == null || ifxCsmReadBuffer.available() == 0) {
            status.setCsmCode(1L);
            return 0;
        }
        IfxCsmBuffer ifxCsmBuffer2 = new IfxCsmBuffer();
        MessageProp messageProp = null;
        messageProp = this.csmDesc.getSsoEnc() ? new MessageProp(0, true) : new MessageProp(0, false);
        this.token = new byte[ifxCsmReadBuffer.getCount()];
        this.token = ifxCsmReadBuffer.getBuf();
        try {
            byte[] byArray = this.context.wrap(this.token, 0, this.token.length, messageProp);
            ifxCsmBuffer2.write(byArray);
        }
        catch (Exception exception) {
            status.setCsmErr(-5010);
            status.setCsmString("Failure attempting to combine buffers");
            this.gssDestroyCsmContext();
            throw IfxCryptoSession.getCsmErrException(-5010);
        }
        int n = 1;
        if (this.encPackBuffer(ifxCsmBuffer2, ifxCsmBuffer, n, status) == 1) {
            ifxCsmBuffer2 = null;
            return 1;
        }
        ifxCsmBuffer2 = null;
        status.setCsmCode(1L);
        return 0;
    }

    @Override
    public int ifxCsmProcessInMessage(IfxCsmReadBuffer ifxCsmReadBuffer, IfxCsmBuffer ifxCsmBuffer, IfxCsm.Status status) throws IfxCsmException {
        int n = 1;
        status.reset();
        if (this.state != 10 && (ifxCsmReadBuffer == null || ifxCsmReadBuffer.available() == 0)) {
            status.setCsmCode(5L);
            return 0;
        }
        if (this.state != 10 && this.encSaveInBuffer(ifxCsmReadBuffer, status) == 1) {
            return 1;
        }
        this.state = 13;
        IfxGssMsgHdr ifxGssMsgHdr = new IfxGssMsgHdr();
        if (ifxCsmBuffer.getCount() > 0) {
            IfxCsmBuffer ifxCsmBuffer2 = new IfxCsmBuffer();
            n = this.encProcessSavedBuffer(ifxGssMsgHdr, ifxCsmBuffer2, status);
            try {
                ifxCsmBuffer2.writeTo(ifxCsmBuffer);
            }
            catch (IOException iOException) {
                status.setCsmErr(-5010);
                return 1;
            }
        } else {
            n = this.encProcessSavedBuffer(ifxGssMsgHdr, ifxCsmBuffer, status);
        }
        if (ifxGssMsgHdr.MsgType == 5) {
            this.encGetAbortToken(ifxCsmBuffer, status);
            return 1;
        }
        return n;
    }

    private int encSaveInBuffer(IfxCsmReadBuffer ifxCsmReadBuffer, IfxCsm.Status status) throws IfxCsmException {
        if (ifxCsmReadBuffer == null || ifxCsmReadBuffer.available() == 0) {
            return 0;
        }
        IfxCsmBuffer ifxCsmBuffer = new IfxCsmBuffer();
        ifxCsmBuffer.initialize(ifxCsmReadBuffer);
        try {
            ifxCsmBuffer.writeTo(this.savedBuffer);
        }
        catch (IOException iOException) {
            status.setCsmErr(-5010);
            return 1;
        }
        return 0;
    }

    private int encProcessSavedBuffer(IfxGssMsgHdr ifxGssMsgHdr, IfxCsmBuffer ifxCsmBuffer, IfxCsm.Status status) throws IfxCsmException {
        int n = 1;
        if (this.savedBuffer.getCount() < 8) {
            status.setCsmCode(5L);
            return 0;
        }
        this.getMsgHdr(this.savedBuffer, ifxGssMsgHdr);
        if (this.savedBuffer.getCount() < ifxGssMsgHdr.MsgSize + 8) {
            status.setCsmCode(5L);
            return 0;
        }
        switch (ifxGssMsgHdr.MsgType) {
            case 3: 
            case 4: {
                status.setCsmErr(-5008);
                this.state = 12;
                return 1;
            }
            case 5: {
                n = this.encProcessSavedBufferAbort(ifxCsmBuffer, status);
                if (n != 0) {
                    ifxCsmBuffer.reset();
                }
                return n;
            }
            case 1: 
            case 8: {
                return this.encProcessSavedBufferData(ifxCsmBuffer, status, true);
            }
            case 2: 
            case 9: {
                return this.encProcessSavedBufferData(ifxCsmBuffer, status, false);
            }
        }
        status.setCsmErr(-5000);
        return 1;
    }

    private int encGetAbortToken(ByteArrayOutputStream byteArrayOutputStream, IfxCsm.Status status) {
        int n = 0;
        return n;
    }

    @Override
    public int ifxCsmAbortContext(Object object, IfxCsm.AbortInfo abortInfo, IfxCsm.Status status) {
        int n = 0;
        return n;
    }

    private void getMsgHdr(IfxCsmBuffer ifxCsmBuffer, IfxGssMsgHdr ifxGssMsgHdr) {
        byte[] byArray = new byte[8];
        ifxCsmBuffer.read(byArray, 0, 8);
        ifxGssMsgHdr.setMsgHdr(byArray);
    }

    private int encProcessSavedBufferAbort(ByteArrayOutputStream byteArrayOutputStream, IfxCsm.Status status) {
        return this.encGetTokenFromSavedBuffer(byteArrayOutputStream, status);
    }

    private int encGetTokenFromSavedBuffer(ByteArrayOutputStream byteArrayOutputStream, IfxCsm.Status status) {
        IfxGssMsgHdr ifxGssMsgHdr = new IfxGssMsgHdr();
        this.getMsgHdr(this.savedBuffer, ifxGssMsgHdr);
        byte[] byArray = new byte[ifxGssMsgHdr.MsgSize + 8];
        this.savedBuffer.readWithReset(byArray, 0, ifxGssMsgHdr.MsgSize + 8);
        byteArrayOutputStream.reset();
        byteArrayOutputStream.write(byArray, 8, ifxGssMsgHdr.MsgSize);
        if (this.savedBuffer.getCount() == 0) {
            this.savedBuffer.reset();
            status.setCsmCode(1L);
            return 0;
        }
        this.state = 10;
        status.setCsmCode(2L);
        return 0;
    }

    private int encProcessSavedBufferData(IfxCsmBuffer ifxCsmBuffer, IfxCsm.Status status, boolean bl) throws IfxCsmException {
        IfxCsmBuffer ifxCsmBuffer2 = new IfxCsmBuffer();
        if (this.encGetTokenFromSavedBuffer(ifxCsmBuffer2, status) == 1) {
            return 1;
        }
        if (bl) {
            MessageProp messageProp = new MessageProp(0, false);
            this.token = new byte[ifxCsmBuffer2.getCount()];
            this.token = ifxCsmBuffer2.toByteArrayWithReset();
            try {
                byte[] byArray = this.context.unwrap(this.token, 0, this.token.length, messageProp);
                ifxCsmBuffer.write(byArray);
            }
            catch (Exception exception) {
                status.setCsmErr(-5010);
                status.setCsmString("Failure attempting to combine buffers");
                this.gssDestroyCsmContext();
                throw IfxCryptoSession.getCsmErrException(-5010);
            }
        }
        try {
            ifxCsmBuffer2.writeTo(ifxCsmBuffer);
        }
        catch (IOException iOException) {
            ifxCsmBuffer.reset();
            status.setCsmErr(-5010);
            return 1;
        }
        return 0;
    }

    private void gssDestroyCsmContext() {
        if (this.context != null) {
            try {
                this.context.dispose();
            }
            catch (GSSException gSSException) {
                // empty catch block
            }
        }
    }

    private int encPackBuffer(IfxCsmBuffer ifxCsmBuffer, IfxCsmBuffer ifxCsmBuffer2, int n, IfxCsm.Status status) {
        int n2 = 0;
        if (ifxCsmBuffer != null) {
            n2 = ifxCsmBuffer.getCount();
        }
        IfxGssMsgHdr ifxGssMsgHdr = new IfxGssMsgHdr(n, n2);
        int n3 = ifxCsmBuffer2.size() + 8 + n2;
        IfxCsmBuffer ifxCsmBuffer3 = new IfxCsmBuffer(n3);
        try {
            if (ifxCsmBuffer2.size() > 0) {
                ifxCsmBuffer2.writeTo(ifxCsmBuffer3);
            }
            ifxCsmBuffer3.write(ifxGssMsgHdr.getCMsgHdr());
            if (n2 > 0) {
                ifxCsmBuffer.writeTo(ifxCsmBuffer3);
            }
        }
        catch (IOException iOException) {
            status.setCsmErr(-5010);
            return 1;
        }
        ifxCsmBuffer2.initialize(ifxCsmBuffer3);
        return 0;
    }

    private void gssInitializeCsmContext() throws GSSException {
        this.state = 0;
        this.csmContextId = ENC_CSM_CONTEXT_ID;
        this.manager = GSSManager.getInstance();
        Oid oid = new Oid(GSS_KRB5_OID);
        GSSName gSSName = this.manager.createName(this.csmDesc.getSsoString(), null);
        this.context = this.manager.createContext(gSSName, oid, null, 0);
        this.context.requestMutualAuth(true);
        if (this.csmDesc.getSsoEnc()) {
            this.context.requestConf(true);
            this.context.requestInteg(true);
        } else {
            this.context.requestConf(false);
            this.context.requestInteg(false);
        }
        if (this.savedBuffer != null) {
            this.savedBuffer.reset();
        }
        this.outHandshake = null;
    }

    private int exitIfxCsmCreateContext(IfxCsmBuffer ifxCsmBuffer, IfxCsmBuffer ifxCsmBuffer2, IfxCsmBuffer ifxCsmBuffer3, IfxCsm.Status status) throws IfxCsmException {
        if (ifxCsmBuffer != null) {
            ifxCsmBuffer.reset();
        }
        switch (this.state) {
            case 7: {
                status.setCsmCode(1L);
                this.state = 13;
                return 0;
            }
            case 1: {
                ifxCsmBuffer3.reset();
                ifxCsmBuffer3.write(this.outHandshake.toByteArrayWithReset());
                status.setCsmCode(3L);
                return 0;
            }
            case 5: {
                ifxCsmBuffer3.reset();
                ifxCsmBuffer3.write(this.outHandshake.toByteArrayWithReset());
                status.setCsmCode(4L);
                this.state = 6;
                return 0;
            }
            case 6: {
                ifxCsmBuffer3.reset();
                ifxCsmBuffer3.write(this.outPw.toByteArrayWithReset());
                status.setCsmCode(3L);
                return 0;
            }
            case 14: {
                if (ifxCsmBuffer3.size() > 0) {
                    ifxCsmBuffer3.reset();
                }
                ifxCsmBuffer2 = new IfxCsmBuffer();
                this.encMakeAbortToken(ifxCsmBuffer2, status);
                int n = 5;
                if (this.encPackBuffer(ifxCsmBuffer2, ifxCsmBuffer3, n, status) == 1) {
                    status.setCsmErr(-5010);
                    status.setCsmString("Can not pack output buffer");
                    this.gssDestroyCsmContext();
                    return this.err1IfxCsmCreateContext(ifxCsmBuffer3, status);
                }
                status.setCsmCode(4L);
                status.setCsmErr(0);
                return 0;
            }
            case 15: {
                status.setCsmErr(-5000);
                status.setCsmString("CSM abort");
                this.gssDestroyCsmContext();
                status.setCsmCode(1L);
                return 1;
            }
            case 13: {
                status.setCsmCode(1L);
                return 1;
            }
            case 0: {
                return 1;
            }
        }
        return 1;
    }

    private int err1IfxCsmCreateContext(ByteArrayOutputStream byteArrayOutputStream, IfxCsm.Status status) throws IfxCsmException {
        byteArrayOutputStream.reset();
        status.setCsmCode(1L);
        throw IfxCryptoSession.getCsmErrException(-5010);
    }

    private void encMakeAbortToken(IfxCsmBuffer ifxCsmBuffer, IfxCsm.Status status) {
    }

    @Override
    public int ifxCsmReleaseContext(IfxCsmReadBuffer ifxCsmReadBuffer, IfxCsmBuffer ifxCsmBuffer, IfxCsm.Status status) throws IfxCsmException {
        int n = 1;
        return n;
    }

    @Override
    public int ifxCsmAcceptContext(Object object, IfxCsm.Credentials credentials, IfxCsmReadBuffer ifxCsmReadBuffer, IfxCsmBuffer ifxCsmBuffer, String string, IfxCsm.Status status) throws IfxCsmException {
        int n = 1;
        return n;
    }
}

