/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm.crypto;

import com.informix.csm.IfxCsmBuffer;
import com.informix.csm.IfxCsmException;
import com.informix.csm.crypto.IfxCryptoCtx;
import com.informix.csm.crypto.IfxCryptoSession;
import com.informix.csm.crypto.IfxCryptoUtils;
import com.informix.csm.crypto.IfxEncPkt;
import com.informix.csm.crypto.IfxMsgHdr;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Vector;

class IfxMACSecretKeys {
    private static final String MAC_KEY = "E8E9E2F5A602620751599970DE3DDDA3CF170FF4CBC279D831A1459BA2C01E9075941B94B2CD91D8B01F82E1BFDA6F423D0B66C91DA87F3F67225B608B842493072372204E951E276A437E89A2FA32F8C9A6DE7D3CABA351896597A52A4F4F15A5043D2EC4D8E6EB05DCB5D75469CD23E9E321670D07E80AF4AB4548139F0E1FE1B515B775A3656008C8440720007FD4AC4345E8F1C6908505F5D666F0DF0CBECD247028676A14B3E4908B8B58EAEF89AB1AF349A98395B2CA23C77DDA371E56145E3E4788EEC651BDA0A6D684CF6B5868B9FA701866D8DB348DF73F824759C9E5A49A0BD64407BAA04D7DC75E07F12865331874EBD58AED4CEE87E66EA5E24D7EBEF6D6164C5FB19B1E55D7D6E7412E831D8344264E95431FA86FB2851DFAE05B12C8316EA14D2EAE8B3415A0D92FFDC55A1101C25428E4AA6F4FCD39131BC907B8EF6E57FF3A84BB3FBEA94D8612D70973CE2B327083E542630B9697524D561448CC5C11ACA63557077DFA93EFBD51F20415C0E90C35C5E6826EAF91DF58D2DE800E8A648A70C8E20C5B7A7CA2C3692D94C14D922A95D7C42110DD243B0A5178B1FEEDEFEACB0DD0D0F103AEE9619E4A372EC0915A808E443DC37EF2F590D1B8D372D1CA5B9A2AE8AD500C5FC39906D7637C91532078F076207F0CC48F614600722BDB";
    private static final byte[] DEFAULT_KEY_NAME = new byte[]{100, 101, 102, 97, 117, 108, 116};
    static final String MAC_ALGORITHM = "HmacSHA1";
    static final int MAC_HASHKEY_SIZE = 36;
    static final int MAC_NAMESZ = 8;
    static final int MAC_KEYSZ = 512;
    static final int MAC_RDBUFFSZ = 2048;
    static final int MAC_LEVELSZ = 4;
    private static final int MACLIST_COUNT_CSIZE = 2;
    static final int MACKEYTIME_TSEC_CSIZE = 4;
    static final int MACKEYTIME_TMSEC_CSIZE = 4;
    static final int MACKEYTIME_SIZE = 8;
    Vector list = new Vector();
    String File;
    long TimeSec;
    long TimeMs;
    byte[] Name;
    byte[] Key;

    long getTimeSec() {
        return this.TimeSec;
    }

    long getTimeMs() {
        return this.TimeMs;
    }

    byte[] getName() {
        return this.Name;
    }

    byte[] getFixLenName() {
        byte[] byArray = new byte[8];
        if (this.Name != null) {
            System.arraycopy(this.Name, 0, byArray, 0, this.Name.length >= 8 ? 8 : this.Name.length);
        }
        return byArray;
    }

    boolean isNewerThan(IfxMACSecretKeys ifxMACSecretKeys) {
        return this.TimeSec > ifxMACSecretKeys.getTimeSec() || this.TimeSec == ifxMACSecretKeys.getTimeSec() && this.TimeMs > ifxMACSecretKeys.getTimeMs();
    }

    static IfxMACSecretKeys findMacKey(byte[] byArray, long l, long l2, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            IfxMACSecretKeys ifxMACSecretKeys = (IfxMACSecretKeys)vector.get(i);
            if (!Arrays.equals(ifxMACSecretKeys.getFixLenName(), byArray) || ifxMACSecretKeys.getTimeSec() != l || ifxMACSecretKeys.getTimeMs() != l2) continue;
            return ifxMACSecretKeys;
        }
        return null;
    }

    static int registerMAC(IfxCryptoCtx ifxCryptoCtx, String string) throws IfxCsmException {
        int n;
        block17: {
            IfxMACSecretKeys ifxMACSecretKeys;
            int n2;
            Vector vector;
            IfxMACSecretKeys ifxMACSecretKeys2;
            block19: {
                IfxMsgHdr ifxMsgHdr;
                ByteArrayInputStream byteArrayInputStream;
                IfxEncPkt ifxEncPkt;
                byte[] byArray;
                FileInputStream fileInputStream;
                block18: {
                    n = 0;
                    ifxMACSecretKeys2 = null;
                    Object var4_4 = null;
                    fileInputStream = null;
                    byArray = null;
                    ifxEncPkt = null;
                    byteArrayInputStream = null;
                    ifxMsgHdr = new IfxMsgHdr();
                    vector = ifxCryptoCtx.registeredMAC;
                    if (!string.equalsIgnoreCase("default") && !string.equalsIgnoreCase("builtin")) break block18;
                    ifxMACSecretKeys2 = ifxCryptoCtx.DefaultMAC;
                    break block19;
                }
                ifxMACSecretKeys2 = new IfxMACSecretKeys();
                try {
                    fileInputStream = new FileInputStream(string);
                    byArray = fileInputStream.available() > 2048 ? new byte[2048] : new byte[fileInputStream.available()];
                    fileInputStream.read(byArray);
                    fileInputStream.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    n = -28;
                    break block17;
                }
                catch (IOException iOException) {
                    n = -28;
                    break block17;
                }
                try {
                    ifxEncPkt = new IfxEncPkt(3, ifxCryptoCtx);
                }
                catch (IfxCsmException ifxCsmException) {
                    throw IfxCryptoSession.getCsmErrException(-18, ifxCsmException);
                }
                ifxEncPkt.Decrypt.In.resetAndwrite(byArray);
                n = ifxCryptoCtx.parentSession.decrypt(ifxEncPkt);
                if (n == 0) {
                    byteArrayInputStream = new ByteArrayInputStream(ifxEncPkt.Decrypt.Out.toByteArray());
                    ifxEncPkt = null;
                }
                if (n != 0) break block17;
                while (byteArrayInputStream.available() > 0) {
                    ifxMsgHdr.setMsgHdr(IfxCryptoUtils.readByteInputStream(byteArrayInputStream, 4));
                    switch (ifxMsgHdr.getType()) {
                        case 13: {
                            ifxMACSecretKeys2.TimeSec = IfxCryptoUtils.readUInt4(byteArrayInputStream, 4);
                            ifxMACSecretKeys2.TimeMs = IfxCryptoUtils.readUInt4(byteArrayInputStream, 4);
                            break;
                        }
                        case 14: {
                            ifxMACSecretKeys2.Name = IfxCryptoUtils.readByteInputStream(byteArrayInputStream, ifxMsgHdr.getMsgSize());
                            break;
                        }
                        case 15: {
                            ifxMACSecretKeys2.Key = IfxCryptoUtils.readByteInputStream(byteArrayInputStream, ifxMsgHdr.getMsgSize());
                            break;
                        }
                        default: {
                            n = -25;
                        }
                    }
                    if (n == 0) continue;
                }
                ifxMACSecretKeys2.File = string;
            }
            for (n2 = vector.size() - 1; n2 >= 0 && !ifxMACSecretKeys2.isNewerThan(ifxMACSecretKeys = (IfxMACSecretKeys)vector.get(n2)); --n2) {
            }
            vector.add(n2 + 1, ifxMACSecretKeys2);
            ifxMACSecretKeys2 = null;
        }
        if (n != 0) {
            IfxCryptoCtx.printError(null, "registereMAC", n);
        }
        return n;
    }

    static int cryptoGetMAC(IfxCsmBuffer ifxCsmBuffer, IfxCryptoCtx ifxCryptoCtx) {
        Vector vector = ifxCryptoCtx.registeredMAC;
        int n = 0;
        boolean bl = false;
        if (vector == null || vector.isEmpty()) {
            n = -26;
        } else {
            ifxCsmBuffer.reset();
            ifxCsmBuffer.write(IfxCryptoUtils.JavaToIfxInt(vector.size(), 2));
            for (int i = 0; i < vector.size(); ++i) {
                IfxMACSecretKeys ifxMACSecretKeys = (IfxMACSecretKeys)vector.get(i);
                ifxCsmBuffer.write(IfxCryptoUtils.JavaToIfxLong(ifxMACSecretKeys.getTimeSec(), 4));
                ifxCsmBuffer.write(IfxCryptoUtils.JavaToIfxLong(ifxMACSecretKeys.getTimeMs(), 4));
                ifxCsmBuffer.write(ifxMACSecretKeys.getFixLenName());
            }
        }
        if (n != 0) {
            IfxCryptoCtx.printError(null, "CryptoGetMAC", n);
        }
        return n;
    }

    static int negotiateMac(IfxEncPkt ifxEncPkt, byte[] byArray, IfxCryptoCtx ifxCryptoCtx) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n = 0;
        int n2 = 0;
        IfxMACSecretKeys ifxMACSecretKeys = null;
        Vector vector = ifxCryptoCtx.registeredMAC;
        n2 = IfxCryptoUtils.readInt(byteArrayInputStream, 2);
        while (n2-- > 0) {
            long l = IfxCryptoUtils.readUInt4(byteArrayInputStream, 4);
            long l2 = IfxCryptoUtils.readUInt4(byteArrayInputStream, 4);
            byte[] byArray2 = IfxCryptoUtils.readByteInputStream(byteArrayInputStream, 8);
            IfxMACSecretKeys ifxMACSecretKeys2 = IfxMACSecretKeys.findMacKey(byArray2, l, l2, vector);
            if (ifxMACSecretKeys2 == null) continue;
            if (ifxMACSecretKeys == null) {
                ifxMACSecretKeys = ifxMACSecretKeys2;
                continue;
            }
            if (ifxMACSecretKeys2.getTimeSec() <= ifxMACSecretKeys.getTimeSec() && (ifxMACSecretKeys2.getTimeSec() != ifxMACSecretKeys.getTimeSec() || ifxMACSecretKeys2.getTimeMs() <= ifxMACSecretKeys.getTimeMs())) continue;
            ifxMACSecretKeys = ifxMACSecretKeys2;
        }
        if (ifxMACSecretKeys == null) {
            n = -26;
        } else {
            ifxEncPkt.NegotiatedMacKey = ifxMACSecretKeys.Key;
            if ((ifxCryptoCtx.DebugFlags & 0x600) > 0) {
                // empty if block
            }
        }
        return n;
    }

    static IfxMACSecretKeys generateDefaultMacKey() {
        IfxMACSecretKeys ifxMACSecretKeys = new IfxMACSecretKeys();
        BigInteger bigInteger = new BigInteger(MAC_KEY, 16);
        ifxMACSecretKeys.Key = IfxCryptoUtils.bigIntegerToBinary(bigInteger);
        ifxMACSecretKeys.Name = DEFAULT_KEY_NAME;
        return ifxMACSecretKeys;
    }
}

