/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.memoryUtil;
import java.math.BigDecimal;
import java.sql.SQLException;

public class IfxFloat
extends IfxObject {
    private double value;

    IfxFloat() throws SQLException {
        this.setIfxType(3);
    }

    IfxFloat(double d) throws SQLException {
        this.setIfxType(3);
        this.value = d;
        this.unnullify();
    }

    IfxFloat(Double d) throws SQLException {
        this.setIfxType(3);
        if (d != null) {
            this.value = d;
            this.unnullify();
        }
    }

    IfxFloat(float f) throws SQLException {
        this.setIfxType(3);
        this.value = f;
        this.unnullify();
    }

    IfxFloat(Float f) throws SQLException {
        this.setIfxType(3);
        if (f != null) {
            this.value = f.floatValue();
            this.unnullify();
        }
    }

    @Override
    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxDouble(this.value);
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] byArray = new byte[8];
            memoryUtil.byfill(byArray, (byte)-1);
            return byArray;
        }
        return JavaToIfxType.JavaToIfxDouble(this.value);
    }

    @Override
    public void fromIfx(byte[] byArray) {
        this.fromIfx(byArray, 0, byArray.length);
    }

    @Override
    public void fromIfx(byte[] byArray, int n, int n2) {
        boolean bl = true;
        bl = IfxFloat.isIfxNull(byArray, n, n2);
        if (!bl) {
            this.unnullify();
            this.value = IfxToJavaType.IfxToJavaDouble(byArray, n);
        } else {
            this.nullify();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this.isNull() || object == null) {
            return false;
        }
        if (object instanceof IfxFloat) {
            IfxFloat ifxFloat = (IfxFloat)object;
            if (ifxFloat.isNull()) {
                return false;
            }
            return this.value == ifxFloat.value;
        }
        return false;
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return new Double(this.value);
    }

    @Override
    public byte toByte() throws SQLException {
        this.clearWarning();
        byte by = this.isNull() ? (byte)0 : (byte)this.value;
        return by;
    }

    @Override
    public void fromByte(byte by) throws SQLException {
        this.value = by;
        this.unnullify();
    }

    @Override
    public void fromByte(Byte by) throws SQLException {
        if (by == null) {
            this.nullify();
        } else {
            this.value = by.doubleValue();
            this.unnullify();
        }
    }

    @Override
    public double toDouble() {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value;
    }

    @Override
    public void fromDouble(double d) throws SQLException {
        this.value = d;
        this.unnullify();
    }

    @Override
    public void fromDouble(Double d) throws SQLException {
        if (d == null) {
            this.nullify();
        } else {
            this.value = d;
            this.unnullify();
        }
    }

    @Override
    public short toShort() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            short s = 0;
            return 0;
        }
        short s = (short)this.value;
        return s;
    }

    @Override
    public void fromShort(short s) throws SQLException {
        this.value = s;
        this.unnullify();
    }

    @Override
    public void fromShort(Short s) throws SQLException {
        if (s == null) {
            this.nullify();
        } else {
            this.value = s.doubleValue();
            this.unnullify();
        }
    }

    @Override
    public int toInt() throws SQLException {
        this.clearWarning();
        int n = this.isNull() ? 0 : (int)this.value;
        return n;
    }

    @Override
    public void fromInt(int n) throws SQLException {
        this.value = n;
        this.unnullify();
    }

    @Override
    public void fromInt(Integer n) throws SQLException {
        if (n == null) {
            this.nullify();
        } else {
            this.value = n.doubleValue();
            this.unnullify();
        }
    }

    @Override
    public long toLong() throws SQLException {
        this.clearWarning();
        long l = this.isNull() ? 0L : (long)this.value;
        return l;
    }

    @Override
    public void fromLong(long l) throws SQLException {
        this.value = l;
        this.unnullify();
    }

    @Override
    public void fromLong(Long l) throws SQLException {
        if (l == null) {
            this.nullify();
        } else {
            this.value = l.doubleValue();
            this.unnullify();
        }
    }

    @Override
    public float toFloat() throws SQLException {
        this.clearWarning();
        float f = this.isNull() ? 0.0f : (float)this.value;
        return f;
    }

    @Override
    public void fromFloat(float f) throws SQLException {
        this.value = f;
        this.unnullify();
    }

    @Override
    public void fromFloat(Float f) throws SQLException {
        if (f == null) {
            this.nullify();
        } else {
            this.value = f.doubleValue();
            this.unnullify();
        }
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal(this.value);
    }

    @Override
    public void fromDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.nullify();
        } else {
            this.value = bigDecimal.doubleValue();
            this.unnullify();
        }
    }

    @Override
    public boolean toBoolean() throws SQLException {
        boolean bl = this.isNull() ? false : this.value != 0.0;
        return bl;
    }

    @Override
    public void fromBoolean(boolean bl) throws SQLException {
        this.value = bl ? 1 : 0;
        this.unnullify();
    }

    @Override
    public void fromBoolean(Boolean bl) throws SQLException {
        if (bl == null) {
            this.nullify();
        } else {
            this.value = bl == true ? 1 : 0;
            this.unnullify();
        }
    }

    @Override
    public String toString() {
        String string = this.isNull() ? null : Double.toString(this.value);
        return string;
    }

    @Override
    public void fromString(String string) throws SQLException {
        if (string == null) {
            this.nullify();
        } else {
            try {
                this.value = Double.valueOf(string.trim());
                this.unnullify();
            }
            catch (Exception exception) {
                this.nullify();
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
    }

    static boolean isIfxNull(double d) {
        byte[] byArray = JavaToIfxType.JavaToIfxDouble(d);
        return IfxFloat.isIfxNull(byArray);
    }

    static boolean isIfxNull(byte[] byArray) {
        return IfxFloat.isIfxNull(byArray, 0, byArray.length);
    }

    static boolean isIfxNull(byte[] byArray, int n, int n2) {
        for (int i = 0; i < 8; ++i) {
            if (byArray[i + n] == -1) continue;
            return false;
        }
        return true;
    }

    static double getIfxNull() {
        byte[] byArray = new byte[8];
        double d = 0.0;
        for (int i = 0; i < 8; ++i) {
            byArray[i] = -1;
            d = IfxToJavaType.IfxToJavaDouble(byArray);
        }
        return d;
    }
}

