/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.dateUtil;
import com.informix.util.stringUtil;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class IfxNativeSQL {
    static final char LBRACE = '{';
    static final char RBRACE = '}';
    static final String SLBRACE = "{";
    static final String SRBRACE = "}";
    static final String SLPAREN = "(";
    static final String SRPAREN = ")";
    static final char LPAREN = '(';
    static final char RPAREN = ')';
    static final String SBPAREN = "()";
    static final char DQUOTE = '\"';
    static final String SDQUOTE = "\"";
    static final String SQUOTE = "'";
    static final char QUOTE = '\'';
    static final char LBRACK = '[';
    static final char RBRACK = ']';
    static final String SLBRACK = "[";
    static final String SRBRACK = "]";
    static final char COMMA = ',';
    static final String SCOMMA = ",";
    static final char SEMICOLON = ';';
    static final String SSEMICOLON = ";";
    static final char SPACE = ' ';
    static final String SSPACE = " ";
    static final char TAB = '\t';
    static final String STAB = "\t";
    private String oldString = null;
    private String newString = null;
    private IfxConnection conn = null;
    private Trace trace = null;
    private static Hashtable funcTable = null;

    IfxNativeSQL(String string, IfxConnection ifxConnection) throws SQLException {
        if (string == null) {
            this.oldString = null;
            this.newString = null;
            throw IfxErrMsg.getSQLException(-79708, ifxConnection);
        }
        this.oldString = string;
        this.conn = ifxConnection;
        this.newString = this.parseSQLString(string);
    }

    String getNewString() {
        return this.newString;
    }

    String parseSQLString(String string) throws SQLException {
        String string2 = "";
        boolean bl = this.conn.isANSIJoin();
        String string3 = "";
        int n = 0;
        boolean bl2 = true;
        int n2 = -1;
        if (string.indexOf(123) == -1 || string.indexOf(125) == -1) {
            return string;
        }
        String string4 = "{} \t";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string4, true);
        String string5 = "";
        String string6 = "";
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string7;
            String string8;
            Object object2;
            Object object3;
            String string9;
            String string10;
            Object object4;
            Object object5;
            if (string6.trim().length() > 0) {
                string5 = string6.toLowerCase();
            }
            string6 = stringTokenizer.nextToken();
            String string11 = "";
            n2 = IfxNativeSQL.trackQuotes(string6, n2);
            if (!string6.equals(SLBRACE)) {
                if (!bl && string6.equalsIgnoreCase("WHERE")) {
                    if (string2.length() > 0) {
                        string3 = string3 + "and";
                        continue;
                    }
                    string3 = string3 + string6;
                    continue;
                }
                string3 = string3 + string6;
                continue;
            }
            if (IfxNativeSQL.isWithinQuotes(n2)) {
                string3 = string3 + string6;
                continue;
            }
            if (this.using9xSyntax(string5)) {
                string3 = string3 + string6;
                continue;
            }
            while (stringTokenizer.hasMoreTokens() && !string6.equals(SRBRACE)) {
                string5 = string6;
                string6 = stringTokenizer.nextToken();
                if (string6.equals(SRBRACE)) continue;
                string11 = string11 + string6;
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string11);
            String string12 = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : "";
            if (string12.equals("call")) {
                n = 1;
            } else {
                object5 = new StringTokenizer(string11);
                if (((StringTokenizer)object5).countTokens() < 4) {
                    n = 0;
                } else {
                    ((StringTokenizer)object5).nextToken();
                    n = !((StringTokenizer)object5).nextToken().equals("=") ? 0 : (!((StringTokenizer)object5).nextToken().equalsIgnoreCase("call") ? 0 : 2);
                }
            }
            if (n > 0) {
                if (!stringTokenizer2.hasMoreTokens()) {
                    throw IfxErrMsg.getSQLException(-79710, SLBRACE + string11 + SRBRACE, this.conn);
                }
                if (n == 1) {
                    object5 = stringTokenizer2.nextToken(SRBRACE).trim();
                    if (((String)object5).indexOf(SLPAREN) == -1) {
                        string3 = string3 + "execute procedure " + (String)object5 + SBPAREN;
                        continue;
                    }
                    string3 = string3 + "execute procedure " + (String)object5;
                    continue;
                }
                stringTokenizer2.nextToken();
                stringTokenizer2.nextToken();
                object5 = stringTokenizer2.nextToken(SRBRACE).trim();
                object4 = this.conn.isUSVER() ? "execute function " : "execute procedure ";
                string3 = string3 + (String)object4 + (String)object5;
                if (((String)object5).indexOf(SLPAREN) != -1) continue;
                string3 = string3 + SBPAREN;
                continue;
            }
            if (string12.equals("d") && stringTokenizer2.hasMoreTokens()) {
                object5 = stringTokenizer2.nextToken(SRBRACE).trim();
                object4 = null;
                string10 = ((String)object5).substring(0, 1);
                string9 = ((String)object5).substring(((String)object5).length() - 1, ((String)object5).length());
                object3 = ((String)object5).substring(1, ((String)object5).length() - 1);
                if (!string10.equals(SQUOTE) || !string9.equals(SQUOTE)) {
                    throw IfxErrMsg.getSQLMinorException(-79710, SDQUOTE + string + SDQUOTE, -80004, "''' ", this.conn);
                }
                object4 = dateUtil.convertNativeSQLDate((String)object3, this.conn);
                string3 = string3 + SQUOTE + (String)object4 + SQUOTE;
                continue;
            }
            if (string12.equals("t") && stringTokenizer2.hasMoreTokens()) {
                object5 = stringTokenizer2.nextToken(SRBRACE).trim();
                object4 = null;
                boolean bl3 = true;
                string10 = ((String)object5).substring(0, 1);
                string9 = ((String)object5).substring(((String)object5).length() - 1, ((String)object5).length());
                object2 = ((String)object5).substring(1, ((String)object5).length() - 1);
                if (!string10.equals(SQUOTE) || !string9.equals(SQUOTE)) {
                    throw IfxErrMsg.getSQLMinorException(-79710, SDQUOTE + string + SDQUOTE, -80004, "''' ", this.conn);
                }
                object4 = dateUtil.convertNativeSQLDateTime((String)object2, this.conn, bl3);
                string3 = string3 + SQUOTE + (String)object4 + SQUOTE;
                continue;
            }
            if (string12.equals("ts") && stringTokenizer2.hasMoreTokens()) {
                object5 = stringTokenizer2.nextToken(SRBRACE).trim();
                object4 = null;
                boolean bl4 = false;
                string10 = ((String)object5).substring(0, 1);
                string9 = ((String)object5).substring(((String)object5).length() - 1, ((String)object5).length());
                object2 = ((String)object5).substring(1, ((String)object5).length() - 1);
                if (!string10.equals(SQUOTE) || !string9.equals(SQUOTE)) {
                    throw IfxErrMsg.getSQLMinorException(-79710, SDQUOTE + string + SDQUOTE, -80004, "''' ", this.conn);
                }
                object4 = dateUtil.convertNativeSQLDateTime((String)object2, this.conn, bl4);
                string3 = string3 + SQUOTE + (String)object4 + SQUOTE;
                continue;
            }
            if (string12.equals("fn") && stringTokenizer2.hasMoreTokens()) {
                object5 = stringTokenizer2.nextToken(SRBRACE);
                object2 = new StringTokenizer((String)object5, SBPAREN);
                if (!((StringTokenizer)object2).hasMoreTokens()) {
                    throw IfxErrMsg.getSQLException(-79710, SDQUOTE + stringTokenizer2 + SDQUOTE, this.conn);
                }
                object4 = ((StringTokenizer)object2).nextToken().trim();
                object3 = ((StringTokenizer)object2).hasMoreTokens() ? ((StringTokenizer)object2).nextToken(SBPAREN) : "";
                string8 = (String)funcTable.get(((String)object4).toLowerCase());
                string7 = (String)funcTable.get(((String)object4).toUpperCase());
                if (string8 != null) {
                    string3 = string3 + string8 + SLPAREN + (String)object3 + SRPAREN;
                    continue;
                }
                if (string7 != null) {
                    string3 = string3 + string7;
                    continue;
                }
                if (((String)object4).equalsIgnoreCase("cot")) {
                    string3 = string3 + SLPAREN + "cos" + SLPAREN + (String)object3 + SRPAREN + "/sin" + SLPAREN + (String)object3 + SRPAREN + SRPAREN;
                    continue;
                }
                if (((String)object4).equalsIgnoreCase("degrees")) {
                    string3 = string3 + SLPAREN + (String)object3 + " * 180 / " + Math.PI + SRPAREN;
                    continue;
                }
                if (((String)object4).equalsIgnoreCase("pi")) {
                    string3 = string3 + Math.PI;
                    continue;
                }
                if (((String)object4).equalsIgnoreCase("radians")) {
                    string3 = string3 + SLPAREN + (String)object3 + " * " + Math.PI + " / 180" + SRPAREN + SSPACE;
                    continue;
                }
                if (((String)object4).equalsIgnoreCase("rand")) {
                    object = new Random(stringUtil.stringToInt((String)object3));
                    string3 = string3 + ((Random)object).nextFloat();
                    continue;
                }
                if (((String)object4).equalsIgnoreCase("concat")) {
                    object = new StringTokenizer((String)object3, SCOMMA);
                    String string13 = "";
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        string13 = string13 + ((StringTokenizer)object).nextToken();
                        if (!((StringTokenizer)object).hasMoreTokens()) continue;
                        string13 = string13 + " || ";
                    }
                    string3 = string3 + string13;
                    continue;
                }
                if (((String)object4).equalsIgnoreCase("left")) {
                    object = new StringTokenizer((String)object3, SCOMMA);
                    if (((StringTokenizer)object).countTokens() != 2) continue;
                    String string14 = ((StringTokenizer)object).nextToken().trim();
                    String string15 = ((StringTokenizer)object).nextToken().trim();
                    int n3 = stringUtil.stringToInt(string15) + 1;
                    string3 = string3 + ' ' + string14 + '[' + "1, " + n3 + ']';
                    continue;
                }
                if (((String)object4).equalsIgnoreCase("ltrim")) {
                    string3 = string3 + "trim " + SLPAREN + "LEADING FROM " + (String)object3 + SRPAREN;
                    continue;
                }
                if (((String)object4).equalsIgnoreCase("rtrim")) {
                    string3 = string3 + "trim " + SLPAREN + "TRAILING FROM " + (String)object3 + SRPAREN;
                    continue;
                }
                if (((String)object4).equalsIgnoreCase("dayofweek")) {
                    string3 = string3 + SLPAREN + "weekday" + SLPAREN + (String)object3 + SRPAREN + "+1" + SRPAREN;
                    continue;
                }
                if (((String)object4).equalsIgnoreCase("hour")) {
                    string3 = string3 + "extend" + SLPAREN + (String)object3 + ", hour to hour" + SRPAREN;
                    continue;
                }
                if (((String)object4).equalsIgnoreCase("minute")) {
                    string3 = string3 + "extend" + SLPAREN + (String)object3 + ", minute to minute" + SRPAREN;
                    continue;
                }
                if (((String)object4).equalsIgnoreCase("second")) {
                    string3 = string3 + "extend" + SLPAREN + (String)object3 + ", second to second" + SRPAREN;
                    continue;
                }
                if (((String)object4).equalsIgnoreCase("database")) {
                    object = this.conn.getDbName();
                    if (object == null) continue;
                    string3 = string3 + (String)object;
                    continue;
                }
                if (((String)object4).equalsIgnoreCase("ifnull")) {
                    object = new StringTokenizer((String)object3, SCOMMA);
                    if (((StringTokenizer)object).countTokens() != 2) {
                        throw IfxErrMsg.getSQLException(-79713, SDQUOTE + (String)object5 + SDQUOTE, this.conn);
                    }
                    String string16 = ((StringTokenizer)object).nextToken().trim();
                    String string17 = ((StringTokenizer)object).nextToken().trim();
                    string3 = string3 + "ifnull('" + string16 + "', " + string17 + SRPAREN;
                    continue;
                }
                if (((String)object4).equalsIgnoreCase("convert")) {
                    object = new StringTokenizer((String)object3, SCOMMA);
                    if (((StringTokenizer)object).countTokens() != 2) {
                        throw IfxErrMsg.getSQLException(-79713, SDQUOTE + (String)object5 + SDQUOTE, this.conn);
                    }
                    String string18 = ((StringTokenizer)object).nextToken().trim();
                    String string19 = ((StringTokenizer)object).nextToken().trim();
                    if (string19.equalsIgnoreCase("BINARY") || string19.equalsIgnoreCase("BIT") || string19.equalsIgnoreCase("LONGVARBINARY") || string19.equalsIgnoreCase("VARBINARY")) {
                        throw IfxErrMsg.getSQLException(-79714, ": " + string19, this.conn);
                    }
                    string3 = string3 + string18;
                    continue;
                }
                string3 = string3 + (String)object4 + SLPAREN + (String)object3 + SRPAREN;
                continue;
            }
            if (string12.equals("escape") && stringTokenizer2.hasMoreTokens()) {
                object4 = stringTokenizer2.nextToken(SRBRACE);
                object5 = new StringTokenizer((String)object4, SSPACE);
                if (!((StringTokenizer)object5).hasMoreTokens()) continue;
                string3 = string3 + "escape " + ((StringTokenizer)object5).nextToken();
                continue;
            }
            if (string12.equals("oj") && stringTokenizer2.hasMoreTokens()) {
                object5 = stringTokenizer2.nextToken(SRBRACE);
                object4 = new StringTokenizer((String)object5, SSPACE, true);
                object3 = new Vector();
                string8 = "";
                string7 = "";
                while (((StringTokenizer)object4).hasMoreTokens()) {
                    string8 = ((StringTokenizer)object4).nextToken();
                    string7 = "";
                    if (string8.equalsIgnoreCase("ON") || string8.equalsIgnoreCase("LEFT") || string8.equalsIgnoreCase("RIGHT") || string8.equalsIgnoreCase("FULL")) {
                        throw IfxErrMsg.getSQLMinorException(-79715, -80005, SDQUOTE + (String)object5 + SDQUOTE, this.conn);
                    }
                    while (!(!((StringTokenizer)object4).hasMoreTokens() || string8.equalsIgnoreCase("LEFT") || string8.equalsIgnoreCase("RIGHT") || string8.equalsIgnoreCase("FULL") || string8.equalsIgnoreCase("OUTER") || string8.equalsIgnoreCase("JOIN") || string8.equalsIgnoreCase("ON"))) {
                        string7 = string7 + string8;
                        string8 = ((StringTokenizer)object4).nextToken();
                    }
                    if (bl) {
                        string3 = string3 + string7.trim();
                    } else {
                        ((Vector)object3).add(string7.trim());
                    }
                    if (!((StringTokenizer)object4).hasMoreTokens()) {
                        throw IfxErrMsg.getSQLMinorException(-79715, -80005, SDQUOTE + (String)object5 + SDQUOTE, this.conn);
                    }
                    object2 = string8;
                    if (((String)object2).equalsIgnoreCase("ON")) {
                        object = "";
                        while (((StringTokenizer)object4).hasMoreTokens()) {
                            object2 = ((StringTokenizer)object4).nextToken();
                            if (bl) {
                                object = (String)object + (String)object2;
                                continue;
                            }
                            if (((String)object2).equalsIgnoreCase("ON")) {
                                object = (String)object + " and ";
                                continue;
                            }
                            object = (String)object + (String)object2;
                        }
                        if (bl) {
                            string2 = " on" + (String)object;
                            continue;
                        }
                        string2 = " where " + (String)object;
                        continue;
                    }
                    if (((String)object2).equalsIgnoreCase("LEFT") || ((String)object2).equalsIgnoreCase("RIGHT") || ((String)object2).equalsIgnoreCase("FULL")) {
                        if (((StringTokenizer)object4).countTokens() < 3) {
                            throw IfxErrMsg.getSQLMinorException(-79715, -80005, SDQUOTE + (String)object5 + SDQUOTE, this.conn);
                        }
                        if (!(((StringTokenizer)object4).nextToken().equals(SSPACE) && ((StringTokenizer)object4).nextToken().equalsIgnoreCase("OUTER") && ((StringTokenizer)object4).nextToken().equals(SSPACE) && ((StringTokenizer)object4).nextToken().equalsIgnoreCase("JOIN"))) {
                            throw IfxErrMsg.getSQLMinorException(-79715, -80005, SDQUOTE + (String)object5 + SDQUOTE, this.conn);
                        }
                        if (!bl) continue;
                        string3 = string3 + SSPACE + (String)object2 + " outer join ";
                        continue;
                    }
                    throw IfxErrMsg.getSQLMinorException(-79715, -80005, SDQUOTE + (String)object5 + SDQUOTE, this.conn);
                }
                if (!bl) {
                    object = "";
                    int n4 = 0;
                    int n5 = ((Vector)object3).size();
                    for (n4 = 0; n4 < n5; ++n4) {
                        object = n4 > 0 ? (String)object + ", outer(" + ((Vector)object3).elementAt(n4) : (String)object + ((Vector)object3).elementAt(n4);
                    }
                    for (n4 = 1; n4 <= n5 - 1; ++n4) {
                        object = (String)object + SRPAREN;
                    }
                    string3 = string3 + (String)object;
                }
                if (string2.length() <= 0) continue;
                string3 = string3 + string2;
                continue;
            }
            bl2 = false;
        }
        if (bl2) {
            return string3;
        }
        return string;
    }

    private boolean using9xSyntax(String string) {
        if (string == null) {
            return false;
        }
        boolean bl = false;
        String string2 = string.trim();
        if (string2.length() == 0 || !string2.endsWith("t")) {
            return bl;
        }
        int n = string2.length();
        String[] stringArray = new String[]{"multiset", "list", "set"};
        for (int i = 0; i < stringArray.length && !bl; ++i) {
            int n2 = stringArray[i].length();
            if (n2 > n || !string2.substring(n - n2, n).equals(stringArray[i])) continue;
            bl = true;
        }
        return bl;
    }

    private static int trackQuotes(String string, int n) {
        int n2 = n;
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\'': {
                    if (n2 == -1) {
                        n2 = c;
                        continue block4;
                    }
                    if (n2 != c) continue block4;
                    if (i + 1 < string.length() && string.charAt(i + 1) == '\'') {
                        ++i;
                        continue block4;
                    }
                    n2 = -1;
                    continue block4;
                }
                case '\"': {
                    if (n2 == -1) {
                        n2 = c;
                        continue block4;
                    }
                    if (n2 != c) continue block4;
                    if (i + 1 < string.length() && string.charAt(i + 1) == '\"') {
                        ++i;
                        continue block4;
                    }
                    n2 = -1;
                    continue block4;
                }
            }
        }
        return n2;
    }

    private static boolean isWithinQuotes(int n) {
        return n != -1;
    }

    static {
        if (funcTable == null) {
            funcTable = new Hashtable();
            funcTable.put("abs", "abs");
            funcTable.put("acos", "acos");
            funcTable.put("asin", "asin");
            funcTable.put("atan", "atan");
            funcTable.put("atan2", "atan2");
            funcTable.put("ceiling", "round");
            funcTable.put("exp", "exp");
            funcTable.put("floor", "trunc");
            funcTable.put("log", "logn");
            funcTable.put("log10", "log10");
            funcTable.put("mod", "mod");
            funcTable.put("power", "pow");
            funcTable.put("round", "round");
            funcTable.put("sin", "sin");
            funcTable.put("sign", "sign");
            funcTable.put("sqrt", "sqrt");
            funcTable.put("tan", "tan");
            funcTable.put("truncate", "trunc");
            funcTable.put("length", "length");
            funcTable.put("dayofmonth", "day");
            funcTable.put("month", "month");
            funcTable.put("year", "year");
            funcTable.put("CURDATE", "today");
            funcTable.put("CURTIME", "current");
            funcTable.put("NOW", "current");
            funcTable.put("USER", "user");
        }
    }
}

