/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxBaseType;
import com.informix.jdbc.IfxUDTInput;
import com.informix.jdbc.UDTSQLData;
import com.informix.util.IfxErrMsg;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.SQLData;
import java.sql.SQLException;

class IfxUDT
extends IfxBaseType {
    SQLData udtClass;

    IfxUDT() throws SQLException {
        this.setIfxType(44);
    }

    IfxUDT(byte[] byArray) throws SQLException {
        this.setIfxType(44);
        this.fromBytes(byArray);
    }

    IfxUDT(InputStream inputStream, int n) throws SQLException {
        this.setIfxType(44);
        this.fromInputStream(inputStream, n);
    }

    @Override
    public void fromObject(Object object) throws SQLException {
        if (object == null) {
            this.nullify();
            this.udtClass = null;
        } else {
            String string;
            if (!(object instanceof SQLData)) {
                throw IfxErrMsg.getSQLException(-79728, this.conn);
            }
            this.udtClass = (SQLData)object;
            if (!this.conn.isDirect()) {
                this.outputStream.reset();
                this.udtClass.writeSQL(this.outputStream);
            }
            if ((string = this.udtClass.getSQLTypeName()) != null) {
                this.setExtendedTypeName(string);
            }
            this.unnullify();
        }
    }

    @Override
    public Object toObject() throws SQLException {
        return this.toObject(false);
    }

    @Override
    public Object toObject(boolean bl) throws SQLException {
        boolean bl2 = this.isNull();
        Object var3_3 = null;
        if (bl2) {
            return null;
        }
        if (!bl && this.conn.isDirect() && this.udtClass != null) {
            return this.udtClass;
        }
        if (this.typeMap == null && (this.typeMap = this.conn.getTypeMap()) == null) {
            throw IfxErrMsg.getSQLException(-79769, this.conn);
        }
        Class clazz = (Class)this.typeMap.get(this.extendedName);
        if (clazz == null) {
            throw IfxErrMsg.getSQLException(-79769, this.conn);
        }
        try {
            this.udtClass = (SQLData)clazz.newInstance();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        if (this.inputStream == null && this.outputStream != null && this.outputStream.length() > 0) {
            this.inputStream = new IfxUDTInput(this.conn, this.outputStream.toByteArray(), 0, this.outputStream.length());
        }
        this.udtClass.readSQL(this.inputStream, this.extendedName);
        if (this.udtClass instanceof UDTSQLData) {
            return ((UDTSQLData)this.udtClass).getSQLDataObject();
        }
        return this.udtClass;
    }

    @Override
    public void fromBytes(byte[] byArray) throws SQLException {
        this.outputStream.reset();
        this.outputStream.writeBytes(byArray, byArray.length);
        this.inputStream = new IfxUDTInput(this.conn, byArray, 0, byArray.length);
        this.unnullify();
    }

    @Override
    public byte[] toBytes() throws SQLException {
        if (this.isNull() || this.inputStream == null) {
            return null;
        }
        return this.inputStream.toByteArray();
    }

    @Override
    public void fromInputStream(InputStream inputStream, int n) throws SQLException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        try {
            int n3;
            do {
                n3 = inputStream.read(byArray, n2, n);
                n2 += n3;
            } while ((n -= n3) > 0);
            this.outputStream.reset();
            this.outputStream.writeBytes(byArray, n);
            this.inputStream = new IfxUDTInput(this.conn, byArray, 0, n);
            this.unnullify();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public InputStream toBinaryStream() throws SQLException {
        if (this.isNull() || this.inputStream == null) {
            return null;
        }
        return new ByteArrayInputStream(this.inputStream.toByteArray());
    }

    @Override
    public void clear() {
        this.udtClass = null;
        this.nullify();
    }

    @Override
    public String toString() {
        if (this.conn.isDirect()) {
            if (this.isNull()) {
                return null;
            }
            if (this.udtClass != null) {
                return this.udtClass.toString();
            }
            return "null";
        }
        return super.toString();
    }
}

