/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxPreparedStatement;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxValue;
import com.informix.lang.IfxTypes;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;

public class IfxUpdateResultSet {
    protected Vector UpdateColVector = null;
    protected Trace trace = null;
    protected IfxConnection conn = null;
    protected IfxResultSetMetaData rsmd = null;
    protected IfxStatement stmt = null;
    protected Vector WhereVal = null;
    protected String updateCmd;
    protected String deleteCmd;
    protected String insertCmd;
    protected boolean MoveToInsert = true;
    protected boolean updatecanceled = false;

    public boolean rowUpdated() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.rowUpdated().", this.conn);
    }

    public boolean rowInserted() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.rowInserted().", this.conn);
    }

    public boolean rowDeleted() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.rowDeleted().", this.conn);
    }

    private void validate_updateXXX(int n) throws SQLException {
        if (this.stmt != null && this.stmt.getResultSetConcurrency() != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (this.UpdateColVector == null) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        if (n < 1 || n > this.UpdateColVector.size()) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
    }

    public void updateNull(int n) throws SQLException {
        IfxObject ifxObject = null;
        this.validate_updateXXX(n);
        ifxObject = (IfxObject)this.UpdateColVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n));
        }
        ifxObject.nullify();
        ifxObject.set_used_in_update(true);
        this.UpdateColVector.setElementAt(ifxObject, n - 1);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        IfxObject ifxObject = null;
        this.validate_updateXXX(n);
        ifxObject = (IfxObject)this.UpdateColVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n));
        }
        ifxObject.fromBoolean(bl);
        ifxObject.set_used_in_update(true);
        this.UpdateColVector.setElementAt(ifxObject, n - 1);
    }

    public void updateByte(int n, byte by) throws SQLException {
        IfxObject ifxObject = null;
        this.validate_updateXXX(n);
        ifxObject = (IfxObject)this.UpdateColVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n));
        }
        ifxObject.fromByte(by);
        ifxObject.set_used_in_update(true);
        this.UpdateColVector.setElementAt(ifxObject, n - 1);
    }

    public void updateShort(int n, short s) throws SQLException {
        IfxObject ifxObject = null;
        this.validate_updateXXX(n);
        ifxObject = (IfxObject)this.UpdateColVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n));
        }
        ifxObject.fromShort(s);
        ifxObject.set_used_in_update(true);
        this.UpdateColVector.setElementAt(ifxObject, n - 1);
    }

    public void updateArray(int n, Array array) throws SQLException {
        IfxObject ifxObject = null;
        this.validate_updateXXX(n);
        ifxObject = (IfxObject)this.UpdateColVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n));
        }
        ifxObject.fromObject(array);
        ifxObject.set_used_in_update(true);
        this.UpdateColVector.setElementAt(ifxObject, n - 1);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        IfxObject ifxObject = null;
        this.validate_updateXXX(n);
        ifxObject = (IfxObject)this.UpdateColVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n));
        }
        if (clob != null) {
            ifxObject.fromClob(clob);
        } else {
            ifxObject.nullify();
        }
        ifxObject.set_used_in_update(true);
        this.UpdateColVector.setElementAt(ifxObject, n - 1);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        IfxObject ifxObject = null;
        this.validate_updateXXX(n);
        ifxObject = (IfxObject)this.UpdateColVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n));
        }
        if (blob != null) {
            ifxObject.fromBlob(blob);
        } else {
            ifxObject.nullify();
        }
        ifxObject.set_used_in_update(true);
        this.UpdateColVector.setElementAt(ifxObject, n - 1);
    }

    public void updateInt(int n, int n2) throws SQLException {
        IfxObject ifxObject = null;
        this.validate_updateXXX(n);
        ifxObject = (IfxObject)this.UpdateColVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n));
        }
        ifxObject.fromInt(n2);
        ifxObject.set_used_in_update(true);
        this.UpdateColVector.setElementAt(ifxObject, n - 1);
    }

    public void updateLong(int n, long l) throws SQLException {
        IfxObject ifxObject = null;
        this.validate_updateXXX(n);
        ifxObject = (IfxObject)this.UpdateColVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n));
        }
        ifxObject.fromLong(l);
        ifxObject.set_used_in_update(true);
        this.UpdateColVector.setElementAt(ifxObject, n - 1);
    }

    public void updateFloat(int n, float f) throws SQLException {
        IfxObject ifxObject = null;
        this.validate_updateXXX(n);
        ifxObject = (IfxObject)this.UpdateColVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n));
        }
        ifxObject.fromFloat(f);
        ifxObject.set_used_in_update(true);
        this.UpdateColVector.setElementAt(ifxObject, n - 1);
    }

    public void updateDouble(int n, double d) throws SQLException {
        IfxObject ifxObject = null;
        this.validate_updateXXX(n);
        ifxObject = (IfxObject)this.UpdateColVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n));
        }
        ifxObject.fromDouble(d);
        ifxObject.set_used_in_update(true);
        this.UpdateColVector.setElementAt(ifxObject, n - 1);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        IfxObject ifxObject = null;
        this.validate_updateXXX(n);
        ifxObject = (IfxObject)this.UpdateColVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n));
        }
        ifxObject.fromDecimal(bigDecimal);
        ifxObject.set_used_in_update(true);
        this.UpdateColVector.setElementAt(ifxObject, n - 1);
    }

    public void updateString(int n, String string) throws SQLException {
        IfxObject ifxObject = null;
        this.validate_updateXXX(n);
        ifxObject = (IfxObject)this.UpdateColVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = this.rsmd.isVariableLengthType(n) ? IfxValue.makeInstanceFromIfxType(this.conn, 43) : IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n));
        }
        ifxObject.fromString(string);
        ifxObject.set_used_in_update(true);
        this.UpdateColVector.setElementAt(ifxObject, n - 1);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        IfxObject ifxObject = null;
        this.validate_updateXXX(n);
        ifxObject = (IfxObject)this.UpdateColVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n));
        }
        ifxObject.fromBytes(byArray);
        ifxObject.set_used_in_update(true);
        this.UpdateColVector.setElementAt(ifxObject, n - 1);
    }

    public void updateDate(int n, Date date) throws SQLException {
        IfxObject ifxObject = null;
        this.validate_updateXXX(n);
        ifxObject = (IfxObject)this.UpdateColVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n));
        }
        ifxObject.fromDate(date);
        ifxObject.set_used_in_update(true);
        this.UpdateColVector.setElementAt(ifxObject, n - 1);
    }

    public void updateTime(int n, Time time) throws SQLException {
        IfxObject ifxObject = null;
        this.validate_updateXXX(n);
        ifxObject = (IfxObject)this.UpdateColVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n));
        }
        ifxObject.fromTime(time);
        ifxObject.set_used_in_update(true);
        this.UpdateColVector.setElementAt(ifxObject, n - 1);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        IfxObject ifxObject = null;
        this.validate_updateXXX(n);
        ifxObject = (IfxObject)this.UpdateColVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n));
        }
        ifxObject.fromTimestamp(timestamp);
        ifxObject.set_used_in_update(true);
        this.UpdateColVector.setElementAt(ifxObject, n - 1);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        IfxObject ifxObject = null;
        this.validate_updateXXX(n);
        ifxObject = (IfxObject)this.UpdateColVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n));
        }
        ifxObject.fromAsciiStream(inputStream, n2);
        ifxObject.set_used_in_update(true);
        this.UpdateColVector.setElementAt(ifxObject, n - 1);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        IfxObject ifxObject = null;
        this.validate_updateXXX(n);
        ifxObject = (IfxObject)this.UpdateColVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n));
        }
        ifxObject.fromBinaryStream(inputStream, n2);
        ifxObject.set_used_in_update(true);
        this.UpdateColVector.setElementAt(ifxObject, n - 1);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        IfxObject ifxObject = null;
        this.validate_updateXXX(n);
        ifxObject = (IfxObject)this.UpdateColVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n));
        }
        ifxObject.fromCharacterStream(reader, n2);
        ifxObject.set_used_in_update(true);
        this.UpdateColVector.setElementAt(ifxObject, n - 1);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        IfxObject ifxObject = null;
        this.validate_updateXXX(n);
        ifxObject = (IfxObject)this.UpdateColVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n));
        }
        ifxObject.fromObject(object, n2);
        ifxObject.set_used_in_update(true);
        this.UpdateColVector.setElementAt(ifxObject, n - 1);
    }

    public void updateObject(int n, Object object) throws SQLException {
        IfxObject ifxObject = null;
        this.validate_updateXXX(n);
        ifxObject = (IfxObject)this.UpdateColVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n));
        }
        ifxObject.fromObject(object);
        ifxObject.set_used_in_update(true);
        this.UpdateColVector.setElementAt(ifxObject, n - 1);
    }

    public void insertRow() throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.conn.prepareStatement(this.insertCmd);
        }
        catch (SQLException sQLException) {
            this.clearUpdateColVector();
            throw sQLException;
        }
        int n = 1;
        for (int i = 0; i < this.UpdateColVector.size(); ++i) {
            IfxObject ifxObject;
            if (this.UpdateColVector.elementAt(i) == null || !(ifxObject = (IfxObject)this.UpdateColVector.elementAt(i)).get_used_in_update()) continue;
            int n2 = ifxObject.getIfxType();
            if (IfxTypes.isString(n2)) {
                preparedStatement.setString(n++, ifxObject.toString());
                continue;
            }
            if (n2 == 44 || n2 == 11 || n2 == 12) {
                ((IfxPreparedStatement)preparedStatement).set(n++, ifxObject);
                continue;
            }
            preparedStatement.setObject(n++, ifxObject.toObject());
        }
        preparedStatement.execute();
        preparedStatement.close();
    }

    public void updateRow() throws SQLException {
        int n;
        IfxObject ifxObject = null;
        int n2 = 0;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.conn.prepareStatement(this.updateCmd);
        }
        catch (SQLException sQLException) {
            this.clearUpdateColVector();
            throw sQLException;
        }
        for (n = 0; n < this.UpdateColVector.size(); ++n) {
            ifxObject = (IfxObject)this.UpdateColVector.elementAt(n);
            if (ifxObject == null || !ifxObject.get_used_in_update()) continue;
            int n3 = ifxObject.getIfxType();
            if (IfxTypes.isString(n3)) {
                preparedStatement.setString(++n2, ifxObject.toString());
                continue;
            }
            if (n3 == 44 || n3 == 11 || n3 == 12) {
                ((IfxPreparedStatement)preparedStatement).set(++n2, ifxObject);
                continue;
            }
            ((IfmxPreparedStatement)preparedStatement).IfxSetObject(++n2, ifxObject.toObject(), n3);
        }
        ++n2;
        for (n = 0; n < this.WhereVal.size(); ++n) {
            ifxObject = (IfxObject)this.WhereVal.elementAt(n);
            if (IfxTypes.isString(ifxObject.getIfxType())) {
                preparedStatement.setString(n2++, ifxObject.toString());
                continue;
            }
            preparedStatement.setObject(n2++, ifxObject.toObject());
        }
        preparedStatement.execute();
        preparedStatement.close();
    }

    public void deleteRow() throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.conn.prepareStatement(this.deleteCmd);
        }
        catch (SQLException sQLException) {
            this.clearUpdateColVector();
            throw sQLException;
        }
        int n = 1;
        for (int i = 0; i < this.WhereVal.size(); ++i) {
            IfxObject ifxObject = (IfxObject)this.WhereVal.elementAt(i);
            if (IfxTypes.isString(ifxObject.getIfxType())) {
                preparedStatement.setString(n++, ifxObject.toString());
                continue;
            }
            preparedStatement.setObject(n++, ifxObject.toObject());
        }
        preparedStatement.execute();
        preparedStatement.close();
    }

    public void refreshRow() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.refreshRow().", this.conn);
    }

    public void cancelRowUpdates() throws SQLException {
        if (this.MoveToInsert) {
            throw IfxErrMsg.getSQLException(-79819, this.conn);
        }
        this.clearUpdateColVector();
        this.updatecanceled = true;
    }

    public void moveToInsertRow() throws SQLException {
        if (this.stmt != null && this.stmt.getResultSetConcurrency() != 1008) {
            throw IfxErrMsg.getSQLException(-79763, this.conn);
        }
        this.MoveToInsert = true;
        this.UpdateColVector = new Vector();
        int n = this.rsmd.getColumnCount();
        this.UpdateColVector.setSize(n);
    }

    public void moveToCurrentRow() throws SQLException {
        if (this.stmt != null && this.stmt.getResultSetConcurrency() != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        this.clearUpdateColVector();
    }

    protected void clearUpdateColVector() {
        if (this.UpdateColVector != null) {
            for (int i = this.UpdateColVector.size() - 1; i >= 0; --i) {
                IfxObject ifxObject = (IfxObject)this.UpdateColVector.elementAt(i);
                if (ifxObject == null) continue;
                ifxObject.set_used_in_update(false);
            }
        }
        this.MoveToInsert = false;
    }
}

