/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.util.IfxErrMsg;
import com.informix.util.dateUtil;
import com.informix.util.memoryUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class IfxChar
extends IfxObject {
    private String value;
    private String valueTrimmed;
    private String trailing_trimmed;

    public IfxChar() throws SQLException {
        this.setIfxType(0);
    }

    public IfxChar(char[] cArray) throws SQLException {
        this.setIfxType(0);
        try {
            this.value = new String(cArray);
            if (this.value == null) {
                this.nullify();
            } else {
                this.unnullify();
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79702, this.conn);
        }
    }

    public IfxChar(String string) throws SQLException {
        this.setIfxType(0);
        if (string != null) {
            this.trimIfxChar(string);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this.isNull() || object == null || !(object instanceof IfxChar)) {
            return false;
        }
        IfxChar ifxChar = (IfxChar)object;
        if (ifxChar.isNull()) {
            return false;
        }
        return this.value.equals(ifxChar.value);
    }

    @Override
    public byte[] toIfx() throws SQLException {
        try {
            if (this.isNull()) {
                return null;
            }
            return ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxChar(this.value, this.conn.getdbEncoding());
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public byte[] toIfxTuple() throws SQLException {
        try {
            if (this.isNull()) {
                byte[] byArray = new byte[this.getEncodedLength()];
                memoryUtil.byfill(byArray, (byte)32);
                byArray[0] = 0;
                return byArray;
            }
            byte[] byArray = null;
            String string = this.conn.getdbEncoding();
            byArray = string != null ? this.value.getBytes(string) : this.value.getBytes();
            return byArray;
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public void fromIfx(byte[] byArray) throws SQLException {
        this.fromIfx(byArray, 0, byArray.length);
    }

    @Override
    public void fromIfx(byte[] byArray, int n, int n2) throws SQLException {
        try {
            if (byArray == null || byArray[n] == 0) {
                this.nullify();
                return;
            }
            String string = this.conn.getdbEncoding();
            this.value = ((IfxSqliConnect)this.conn).ifxtojava.IfxToJavaChar(byArray, n, n2, string);
            if (this.conn != null && this.conn.getTrimTrailingSpaces()) {
                this.trimIfxChar(this.value);
                this.value = this.trailing_trimmed;
            } else if (this.value == null) {
                this.nullify();
            } else {
                this.unnullify();
            }
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public String toString() {
        if (this.isNull()) {
            return null;
        }
        IfxSqliConnect cfr_ignored_0 = (IfxSqliConnect)this.conn;
        if (IfxSqliConnect.GclEnv) {
            IfxSqliConnect cfr_ignored_1 = (IfxSqliConnect)this.conn;
            if (IfxSqliConnect.ConnEst) {
                try {
                    byte[] byArray = ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxChar(this.value, ((IfxSqliConnect)this.conn).returnEnc());
                    this.value = ((IfxSqliConnect)this.conn).ifxtojava.IfxToJavaChar(byArray, 2, byArray.length - 2, ((IfxSqliConnect)this.conn).returnEnc());
                    IfxSqliConnect cfr_ignored_2 = (IfxSqliConnect)this.conn;
                    IfxSqliConnect.GclEnv = false;
                    return this.value;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
            }
        }
        return this.value;
    }

    @Override
    public void fromString(String string) throws SQLException {
        block4: {
            if (string == null) {
                this.nullify();
            } else {
                try {
                    String string2 = this.conn.getdbEncoding();
                    this.trimIfxChar(string);
                    byte[] byArray = ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxChar(string, string2);
                    this.value = ((IfxSqliConnect)this.conn).ifxtojava.IfxToJavaChar(byArray, 2, byArray.length - 2, string2);
                }
                catch (Exception exception) {
                    this.value = null;
                    exception.printStackTrace();
                    if (!(exception instanceof IOException)) break block4;
                    throw IfxErrMsg.getSQLException(-79783, this.conn);
                }
            }
        }
    }

    @Override
    public int toInt() throws SQLException {
        int n = 0;
        if (!this.isNull()) {
            try {
                this.trimIfxChar(this.value);
                n = Integer.parseInt(this.valueTrimmed);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
        return n;
    }

    @Override
    public void fromInt(int n) throws SQLException {
        this.value = Integer.toString(n);
        this.unnullify();
    }

    @Override
    public void fromInt(Integer n) throws SQLException {
        if (n == null) {
            this.nullify();
        } else {
            this.value = n.toString();
            this.unnullify();
        }
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        BigDecimal bigDecimal;
        if (this.isNull()) {
            return null;
        }
        try {
            this.trimIfxChar(this.value);
            bigDecimal = new BigDecimal(this.valueTrimmed);
        }
        catch (NumberFormatException numberFormatException) {
            throw IfxErrMsg.getSQLException(-79716, numberFormatException.toString(), this.conn);
        }
        return bigDecimal;
    }

    @Override
    public void fromDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.nullify();
        } else {
            this.value = bigDecimal.toString();
            this.unnullify();
        }
    }

    @Override
    public byte toByte() throws SQLException {
        byte by = 0;
        if (!this.isNull()) {
            try {
                this.trimIfxChar(this.value);
                by = Byte.parseByte(this.valueTrimmed);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
        return by;
    }

    @Override
    public void fromByte(byte by) throws SQLException {
        this.value = Byte.toString(by);
        this.unnullify();
    }

    @Override
    public void fromByte(Byte by) throws SQLException {
        if (by == null) {
            this.nullify();
        } else {
            this.value = by.toString();
            this.unnullify();
        }
    }

    @Override
    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        this.trimIfxChar(this.value);
        return this.valueTrimmed.equalsIgnoreCase("t") || this.valueTrimmed.equalsIgnoreCase("1") || this.valueTrimmed.equalsIgnoreCase("true");
    }

    @Override
    public void fromBoolean(boolean bl) throws SQLException {
        this.value = String.valueOf(bl);
        this.unnullify();
    }

    @Override
    public void fromBoolean(Boolean bl) throws SQLException {
        if (bl == null) {
            this.nullify();
        } else {
            this.value = bl.toString();
            this.unnullify();
        }
    }

    @Override
    public Date toDate() throws SQLException {
        Date date = null;
        if (!this.isNull()) {
            try {
                this.trimIfxChar(this.value);
                date = dateUtil.convertDateObj(this.valueTrimmed, this.conn);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
        return date;
    }

    @Override
    public void fromDate(Date date) throws SQLException {
        if (date == null) {
            this.nullify();
        } else {
            this.value = dateUtil.convertDateStr(date, this.conn);
            this.unnullify();
        }
    }

    @Override
    public float toFloat() throws SQLException {
        float f = 0.0f;
        if (!this.isNull()) {
            try {
                this.trimIfxChar(this.value);
                Float f2 = Float.valueOf(this.valueTrimmed);
                f = f2.floatValue();
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
        return f;
    }

    @Override
    public void fromFloat(float f) throws SQLException {
        this.value = String.valueOf(f);
        this.unnullify();
    }

    @Override
    public void fromFloat(Float f) throws SQLException {
        if (f == null) {
            this.nullify();
        } else {
            this.value = f.toString();
            this.unnullify();
        }
    }

    @Override
    public long toLong() throws SQLException {
        long l = 0L;
        if (!this.isNull()) {
            try {
                this.trimIfxChar(this.value);
                l = Long.parseLong(this.valueTrimmed);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
        return l;
    }

    @Override
    public void fromLong(long l) throws SQLException {
        this.value = String.valueOf(l);
        this.unnullify();
    }

    @Override
    public void fromLong(Long l) throws SQLException {
        if (l == null) {
            this.nullify();
        } else {
            this.value = l.toString();
            this.unnullify();
        }
    }

    @Override
    public short toShort() throws SQLException {
        short s = 0;
        if (!this.isNull()) {
            try {
                this.trimIfxChar(this.value);
                s = Short.parseShort(this.valueTrimmed);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
        return s;
    }

    @Override
    public void fromShort(short s) throws SQLException {
        this.value = String.valueOf(s);
        this.unnullify();
    }

    @Override
    public void fromShort(Short s) throws SQLException {
        if (s == null) {
            this.nullify();
        } else {
            this.value = s.toString();
            this.unnullify();
        }
    }

    @Override
    public Time toTime() throws SQLException {
        Time time = null;
        if (!this.isNull()) {
            try {
                boolean bl = true;
                this.trimIfxChar(this.value);
                Object object = dateUtil.convertDateTimeObj(this.valueTrimmed, this.conn, bl);
                long l = ((java.util.Date)object).getTime();
                time = new Time(l);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
        return time;
    }

    @Override
    public void fromTime(Time time) throws SQLException {
        if (time == null) {
            this.nullify();
        } else {
            long l = time.getTime();
            this.value = dateUtil.convertDateTimeStr(time, this.conn, l);
            this.unnullify();
        }
    }

    @Override
    public double toDouble() throws SQLException {
        double d = 0.0;
        if (!this.isNull()) {
            try {
                this.trimIfxChar(this.value);
                Double d2 = Double.valueOf(this.valueTrimmed);
                d = d2;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
        return d;
    }

    @Override
    public void fromDouble(double d) throws SQLException {
        this.value = String.valueOf(d);
        this.unnullify();
    }

    @Override
    public void fromDouble(Double d) throws SQLException {
        if (d == null) {
            this.nullify();
        } else {
            this.value = d.toString();
            this.unnullify();
        }
    }

    @Override
    public Timestamp toTimestamp() throws SQLException {
        Timestamp timestamp = null;
        if (!this.isNull()) {
            try {
                boolean bl = false;
                this.trimIfxChar(this.value);
                timestamp = (Timestamp)dateUtil.convertDateTimeObj(this.valueTrimmed, this.conn, bl);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
        return timestamp;
    }

    @Override
    public void fromTimestamp(Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.nullify();
        } else {
            long l = timestamp.getTime();
            this.value = dateUtil.convertDateTimeStr(timestamp, this.conn, l);
            this.unnullify();
        }
    }

    @Override
    public InputStream toAsciiStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        this.writeTrace(99, "IfxChar: toAsciiStream()");
        this.writeTrace(3, "IfxChar: toAsciiStream(): value = " + this.value);
        byte[] byArray = this.value.getBytes();
        return new ByteArrayInputStream(byArray);
    }

    @Override
    public void fromAsciiStream(InputStream inputStream, int n) throws SQLException {
        this.writeTrace(3, "IfxChar: fromAsciiStream()");
        if (inputStream != null) {
            this.writeTrace(3, "IfxChar: fromAsciiStream(): length = " + n);
            if (n == 0) {
                this.value = "";
            } else {
                byte[] byArray = new byte[n];
                int n2 = 0;
                try {
                    do {
                        int n3 = inputStream.read(byArray, n2, n);
                        this.writeTrace(3, "IfxChar: fromAsciiStream(): readLen = " + n3);
                        this.writeTrace(3, "IfxChar: fromAsciiStream(): length = " + (n -= n3));
                        this.writeTrace(3, "IfxChar: fromAsciiStream(): offset = " + (n2 += n3));
                    } while (n > 0);
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
                }
                this.value = new String(byArray);
                this.writeTrace(3, "IfxChar: value = " + this.value);
            }
            this.unnullify();
        }
    }

    @Override
    public void fromInputStream(InputStream inputStream, int n) throws SQLException {
        this.fromAsciiStream(inputStream, n);
    }

    @Override
    public InputStream toInputStream() throws SQLException {
        return this.toAsciiStream();
    }

    @Override
    public void fromCharacterStream(Reader reader, int n) throws SQLException {
        this.writeTrace(3, "IfxChar: fromCharacterStream()");
        if (reader != null) {
            this.writeTrace(3, "IfxChar: fromCharacterStream(): length = " + n);
            if (n == 0) {
                this.value = "";
            } else {
                char[] cArray = new char[n];
                int n2 = 0;
                BufferedReader bufferedReader = new BufferedReader(reader);
                try {
                    do {
                        int n3 = reader.read(cArray, n2, n);
                        this.writeTrace(3, "IfxChar: fromCharacterStream(): readLen = " + n3);
                        this.writeTrace(3, "IfxChar: fromCharacterStream(): length = " + (n -= n3));
                        this.writeTrace(3, "IfxChar: fromCharacterStream(): offset = " + (n2 += n3));
                    } while (n > 0);
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
                }
                this.value = new String(cArray);
                this.writeTrace(3, "IfxChar: value = " + this.value);
            }
            this.unnullify();
        }
    }

    @Override
    public Reader toCharacterStream() throws SQLException {
        this.writeTrace(3, "IfxChar: toCharacterStream()");
        if (this.isNull()) {
            return null;
        }
        this.writeTrace(3, "IfxChar: toCharacterStream(): value = " + this.value);
        return new StringReader(this.value);
    }

    private void trimIfxChar(String string) {
        int n;
        if (string == null) {
            this.value = string;
            this.valueTrimmed = string;
            this.nullify();
            return;
        }
        this.value = string;
        int n2 = string.length();
        for (n = n2 - 1; n >= 0 && string.charAt(n) == ' '; --n) {
        }
        this.valueTrimmed = n != n2 - 1 ? string.substring(0, ++n) : string;
        if (this.conn != null && this.conn.getTrimTrailingSpaces()) {
            this.trailing_trimmed = this.valueTrimmed;
        }
        n2 = this.valueTrimmed.length();
        for (n = 0; n < n2 && string.charAt(n) == ' '; ++n) {
        }
        if (n != 0) {
            this.valueTrimmed = this.valueTrimmed.substring(n, n2);
        }
        this.unnullify();
    }
}

