/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxVarChar;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import java.io.IOException;
import java.sql.SQLException;

public class IfxLvarchar
extends IfxVarChar {
    private static final int MAXLVARCHARLEN = 32739;

    IfxLvarchar() throws SQLException {
        this.setIfxType(43);
        this.setExtendedId(1);
    }

    public IfxLvarchar(String string) throws SQLException {
        this.value = string;
        if (this.value != null) {
            this.unnullify();
        }
        this.setIfxType(43);
        this.setExtendedId(1);
    }

    @Override
    public byte[] toIfx() throws SQLException {
        try {
            String string = this.conn.getdbEncoding();
            byte[] byArray = ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxLvarchar(this.value, string);
            byte[] byArray2 = new byte[byArray.length + 4];
            byte[] byArray3 = JavaToIfxType.JavaToIfxInt(byArray.length);
            System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
            System.arraycopy(byArray, 0, byArray2, 4, byArray.length);
            return byArray2;
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public byte[] toIfxTuple() throws SQLException {
        try {
            int n = 0;
            byte[] byArray = null;
            if (!this.isNull()) {
                String string = this.conn.getdbEncoding();
                byArray = string != null ? this.value.toString().getBytes(string) : this.value.toString().getBytes("ISO8859_1");
                n = this.encodedLength > 0 ? Math.min(byArray.length, this.encodedLength) : byArray.length;
            }
            int n2 = 5 + n;
            byte[] byArray2 = new byte[n2];
            byte[] byArray3 = JavaToIfxType.JavaToIfxInt(n);
            byArray2[0] = 0;
            System.arraycopy(byArray3, 0, byArray2, 1, byArray3.length);
            if (this.isNull()) {
                byArray2[0] = 1;
                return byArray2;
            }
            System.arraycopy(byArray, 0, byArray2, 5, n);
            return byArray2;
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public Object toObject(boolean bl) throws SQLException {
        return this.value;
    }

    @Override
    public void fromIfx(byte[] byArray) throws SQLException {
        this.fromIfx(byArray, 0, byArray.length);
    }

    @Override
    public void fromIfx(byte[] byArray, int n, int n2) throws SQLException {
        try {
            if (byArray.length < n + 1 + 4 || byArray[n] == 1) {
                this.value = null;
                this.nullify();
                return;
            }
            int n3 = IfxToJavaType.IfxToJavaInt(byArray, n + 1);
            if (n3 == 0) {
                this.value = new String("");
            } else {
                String string = this.conn.getdbEncoding();
                if (n2 > 0) {
                    n3 = Math.min(n3, n2);
                }
                if (byArray[n + 4 + n3] == 0) {
                    --n3;
                }
                this.value = ((IfxSqliConnect)this.conn).ifxtojava.IfxToJavaChar(byArray, n + 1 + 4, n3, string);
            }
            this.unnullify();
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public void fromString(String string) throws SQLException {
        this.fromString(string, false);
    }

    @Override
    public void fromString(String string, boolean bl) throws SQLException {
        block5: {
            if (string == null) {
                this.nullify();
            } else {
                try {
                    this.clearWarning();
                    this.value = bl ? string.trim() : string;
                    if (this.value.length() > 32739) {
                        this.value = this.value.substring(0, 32739);
                    }
                    String string2 = this.conn.getdbEncoding();
                    byte[] byArray = ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxChar(this.value, string2);
                    this.value = ((IfxSqliConnect)this.conn).ifxtojava.IfxToJavaChar(byArray, 2, byArray.length - 2, string2);
                    this.unnullify();
                }
                catch (Exception exception) {
                    this.value = null;
                    exception.printStackTrace();
                    if (!(exception instanceof IOException)) break block5;
                    throw IfxErrMsg.getSQLException(-79783, this.conn);
                }
            }
        }
    }
}

