/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.IfxDataInputStream;
import com.informix.asf.IfxDataOutputStream;
import com.informix.asf.SqliDbg;
import com.informix.jdbc.IfmxPAM;
import com.informix.jdbc.IfxBlob;
import com.informix.jdbc.IfxByteArrayInputStream;
import com.informix.jdbc.IfxCollection;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxFParam;
import com.informix.jdbc.IfxInputStream;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxPAMChallenge;
import com.informix.jdbc.IfxPAMResponse;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSet;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxRow;
import com.informix.jdbc.IfxRowColumn;
import com.informix.jdbc.IfxSmBlob;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxTmpFile;
import com.informix.jdbc.IfxValue;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.IfxMessage;
import com.informix.util.IfxWarnMsg;
import com.informix.util.Trace;
import com.informix.util.memoryUtil;
import com.informix.util.stringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class IfxSqli
implements IfxProtocol {
    private String routineDbName = null;
    private boolean descTrue = false;
    IfxResultSetMetaData desc;
    IfxResultSetMetaData idesc;
    private FileOutputStream BlobFd;
    private byte[] BlobBuffer;
    private short BufferOrStream;
    private int BlobWriteFailure;
    private int BlobWriteOffset;
    private int BlobRequestSize;
    private int amountRW;
    private String copyToFileName;
    private int copyToFileFlags;
    private int copyToFileMode;
    private int copyToFileAmount;
    private int copyToFileOffset;
    private File copyToFileFd;
    private RandomAccessFile loFile;
    private short statementID = (short)-1;
    private short statementType;
    protected IfxSqliConnect conn;
    protected Trace trace;
    protected Trace protoTrace;
    protected SqliDbg sqliTrace;
    private String dbEncoding;
    private boolean isText;
    private boolean convText;
    private long serial8Inserted;
    private long bigSerialInserted;
    private short xcEvent = (short)-1;
    private short xcNewLevel = (short)-1;
    private short xcOldLevel = (short)-1;
    private boolean isReleased = true;
    private int tupleBufferSize = -1;
    private boolean typeSent;
    private int sqlcode;
    private int isamcode;
    private String SQLState;
    private String message;
    private SQLWarning warn;
    private SQLException exception;
    private String sqlerrm;
    private int[] sqlerrd = new int[10];
    private StringBuffer serverWarningsString = new StringBuffer("        ");
    private short serverWarningsShort;
    private boolean OpenDBStmt;
    private String serverVersion;
    private byte[] serverProtocol = null;
    private Vector offsetVector = new Vector();
    private int totalTupleSize;
    private int curOffset;
    private int totalTuples;
    private int firstTuple;
    private int lastTuple;
    private int curRow = -1;
    private boolean doneCommit;
    private int Tupid;
    private int numberOfFetches = 0;
    private int numberOfTuplesReceived = 0;
    private int tupleSizeReceived = 0;
    private int fpHandle;
    private Vector fpRet;
    private Vector fpInput;
    private IfxFParam fparam;
    private boolean partialFParam;
    private int totalOutValues = 0;
    private int totalOutParams = 0;
    static final int IN = 0;
    static final int OUT = 1;
    static final int INOUT = 2;
    private short TxStmt;
    private static final short NON_TX_STMT = 0;
    private static final short BEG_TX_STMT = 1;
    private static final short END_TX_STMT = 2;
    protected static final int INFX_BUFSIZE = 4096;
    protected static final int INFX_MAXBUFSIZE = Short.MAX_VALUE;
    protected static final int INFX_MAX_BIGBUFSIZE = 0x200000;
    private final int INFX_MAXQUOTEDSTRINGSIZE = 65535;
    private IfxRowColumn rowColumn;
    private short SGK_statementType;
    private short SGK_statementID = (short)-1;
    private short SGK_TxStmt;
    private IfxResultSetMetaData SGK_desc = null;
    protected IfxRowColumn SGK_rowColumn;
    private Vector SGK_offsetVector = new Vector();
    private int SGK_totalTupleSize;
    private int SGK_curOffset;
    private int SGK_totalTuples;
    private int SGK_curRow = -1;
    protected IfxDataOutputStream os;
    protected IfxDataInputStream is;
    protected boolean SQ_CLOSERecvd;
    private boolean SQ_CLOSESent;
    private boolean first = true;
    private Vector DBList;
    boolean executeBatchInProgress;
    public ArrayList batchRowStatus;
    private int batchCount;
    private int batchRowSize;
    private boolean userPAMAuthorized = false;

    public IfxSqli(IfxSqliConnect ifxSqliConnect) {
        this.conn = ifxSqliConnect;
        this.sqliTrace = this.conn.asfconn.sqliTrace;
        this.offsetVector.setSize(500);
        this.offsetVector.setElementAt(new Integer(0), 0);
        this.os = this.conn.Ifxproto_send();
        this.is = this.conn.Ifxproto_receive();
        this.dbEncoding = this.conn.getdbEncoding();
        this.convText = this.conn.isConvText();
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return this.desc;
    }

    ResultSetMetaData getSGK_metaData() {
        return this.SGK_desc;
    }

    @Override
    public int getStatementType() {
        return this.statementType;
    }

    public void clearBatch() {
        this.batchCount = 0;
        this.batchRowStatus = null;
        this.executeBatchInProgress = false;
    }

    @Override
    public void clear() {
        this.serial8Inserted = 0L;
        this.bigSerialInserted = 0L;
        this.xcEvent = (short)-1;
        this.xcNewLevel = (short)-1;
        this.xcOldLevel = (short)-1;
        this.sqlcode = 0;
        this.isamcode = 0;
        this.SQLState = null;
        this.message = null;
        this.OpenDBStmt = false;
        this.sqlerrm = null;
        for (int n = 0; n < 10; n = (int)((short)(n + 1))) {
            this.sqlerrd[n] = 0;
            if (n >= 8) continue;
            this.serverWarningsString.setCharAt(n, ' ');
        }
        this.serverWarningsShort = 0;
        this.tupleBufferSize = -1;
        this.resetTuples();
        this.doneCommit = false;
        this.warn = null;
        if (this.rowColumn != null) {
            this.rowColumn.clear();
            this.rowColumn = null;
        }
    }

    private void resetTuples() {
        this.offsetVector.removeAllElements();
        this.offsetVector.setSize(500);
        this.offsetVector.setElementAt(new Integer(0), 0);
        this.totalTupleSize = 0;
        this.curOffset = 0;
        this.curRow = -1;
        this.totalTuples = 0;
        this.Tupid = 0;
        if (this.rowColumn != null) {
            this.rowColumn.reset();
        }
    }

    private void resetSGKTuples() {
        this.SGK_offsetVector.removeAllElements();
        this.SGK_offsetVector.setSize(10);
        this.SGK_offsetVector.setElementAt(new Integer(0), 0);
        this.SGK_totalTupleSize = 0;
        this.SGK_curOffset = 0;
        this.SGK_curRow = -1;
        this.SGK_totalTuples = 0;
        if (this.SGK_rowColumn != null) {
            this.SGK_rowColumn.reset();
        }
    }

    private void clearAll() {
        this.clear();
        this.isReleased = true;
        this.desc = null;
        this.idesc = null;
    }

    @Override
    public void executeBegin() throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendBegin();
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw this.handleSocketException(exception, this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendBegin() throws SQLException {
        try {
            this.os.writeSmallInt((short)35);
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    @Override
    public void executeCommit() throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendCommit();
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw this.handleSocketException(exception, this.conn);
        }
        this.conn.unlockSession();
        this.conn.markCursorsToClosed(true);
    }

    private void sendCommit() throws SQLException {
        try {
            this.os.writeSmallInt((short)19);
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    @Override
    public void executeRollback() throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendRollback();
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw this.handleSocketException(exception, this.conn);
        }
        this.conn.unlockSession();
        this.conn.markCursorsToClosed(false);
    }

    @Override
    public void executeGetDBList() throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendGetDBList();
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw this.handleSocketException(exception, this.conn);
        }
        this.conn.unlockSession();
    }

    @Override
    public Vector getDBList() {
        return this.DBList;
    }

    private void sendGetDBList() throws SQLException {
        try {
            this.os.writeSmallInt((short)26);
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private void receiveDBList() throws SQLException {
        try {
            String string;
            this.DBList = new Vector();
            while ((string = new String(this.is.readChar(this.dbEncoding))).length() != 0) {
                boolean bl = false;
                for (int i = 0; i < this.DBList.size(); ++i) {
                    String string2 = (String)this.DBList.elementAt(i);
                    if (string.compareToIgnoreCase(string2) >= 0) continue;
                    this.DBList.insertElementAt(string, i);
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.DBList.insertElementAt(string, this.DBList.size());
            }
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private void sendRollback() throws SQLException {
        try {
            this.os.writeSmallInt((short)20);
            this.os.writeSmallInt((short)0);
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    @Override
    public void executeCommand(Statement statement) throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            if (statement instanceof IfxPreparedStatement && ((IfxPreparedStatement)statement).usePut()) {
                this.initiateTransaction();
                this.sendPut((IfxPreparedStatement)statement);
            } else {
                this.sendCommand((IfxStatement)statement);
            }
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            if (this.TxStmt == 2 && this.sqlcode != -255) {
                this.conn.setTxEndState();
            }
            throw sQLException;
        }
        try {
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            if (this.TxStmt == 2 && this.sqlcode != -255) {
                this.conn.setTxEndState();
            }
            throw sQLException;
        }
        this.conn.unlockSession();
        this.callsetDatabaseOpen(this.parseDbName(statement));
        if (this.TxStmt == 1) {
            this.conn.setTxBeginState();
        } else if (this.TxStmt == 2) {
            this.conn.setTxEndState();
        } else if (!this.conn.inXATransaction() && (this.conn.isCommitNeeded() || this.conn.db_use_log && this.conn.autoCommit && statement instanceof IfxPreparedStatement && ((IfxPreparedStatement)statement).usePut())) {
            this.executeCommit();
            this.conn.setTxEndState();
            this.doneCommit = true;
        }
        if (this.desc != null) {
            this.desc.parseSetTableName(((IfxStatement)statement).commandString);
        }
    }

    private void sendCommand(IfxStatement ifxStatement) throws SQLException {
        if (!this.conn.autoCommit && !ifxStatement.commandString.trim().toLowerCase().startsWith("begin")) {
            this.initiateTransaction();
        }
        this.batchRowSize = ifxStatement.BatchVector.size();
        if (ifxStatement.executeBatchInProgress) {
            this.executeBatchInProgress = true;
        }
        if (ifxStatement instanceof IfxPreparedStatement) {
            this.sendExecute(ifxStatement);
        } else {
            int n;
            String[] stringArray = null;
            if (this.conn.isBatchUpdatePerSpec() && this.batchRowSize > 0 && this.executeBatchInProgress) {
                stringArray = new String[this.batchRowSize];
                for (n = 0; n < this.batchRowSize; ++n) {
                    stringArray[n] = (String)ifxStatement.BatchVector.elementAt(n);
                }
            } else {
                stringArray = new String[]{ifxStatement.commandString};
            }
            try {
                if (ifxStatement.commandString.length() > 65535) {
                    throw IfxErrMsg.getSQLException(-79864, this.conn);
                }
                n = 0;
                do {
                    this.os.writeSmallInt((short)1);
                    this.os.writeSmallInt((short)0);
                    this.os.writeChar(stringArray[n++], this.dbEncoding);
                    this.SGK_desc = null;
                    this.SGK_rowColumn = null;
                    if (ifxStatement.SGK_returnGeneratedKeys != 0) {
                        this.sendSGKPrepare(ifxStatement);
                    }
                    this.os.writeSmallInt((short)22);
                    this.resetSGKTuples();
                    this.os.writeSmallInt((short)7);
                    this.os.writeSmallInt((short)11);
                    this.isReleased = true;
                } while (this.conn.isBatchUpdatePerSpec() && n < this.batchRowSize && this.executeBatchInProgress);
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw this.handleSocketException(exception, this.conn);
            }
        }
    }

    private boolean sendBind(Vector vector, ResultSetMetaData resultSetMetaData, int n, int n2, int n3) throws SQLException {
        int n4 = 0;
        boolean bl = false;
        try {
            this.os.writeSmallInt((short)5);
            this.os.writeSmallInt((short)n);
            for (int i = n2; i < n3; ++i) {
                short s;
                IfxObject ifxObject = null;
                if (i < vector.size()) {
                    ifxObject = (IfxObject)vector.elementAt(i);
                }
                if (ifxObject == null) {
                    s = i % n + 1;
                    short s2 = 0;
                    if (resultSetMetaData == null || !((IfxResultSetMetaData)resultSetMetaData).hasDefaultValue(s)) {
                        throw IfxErrMsg.getSQLException(-79823, ((IfxResultSetMetaData)resultSetMetaData).getArgumentName(s), (IfxConnection)this.conn);
                    }
                    s2 = (short)((IfxResultSetMetaData)resultSetMetaData).getIfxColumnType(s);
                    this.os.writeSmallInt(s2);
                    this.os.writeSmallInt((short)-2);
                    this.os.writeSmallInt((short)0);
                    continue;
                }
                s = (short)ifxObject.getIfxType();
                if (s == 11 || s == 12) {
                    if (((IfxBlob)ifxObject).isIfxTextType()) {
                        s = 12;
                    }
                    if (!ifxObject.isNull()) {
                        ++n4;
                    }
                }
                if (s == 46) {
                    bl = true;
                }
                this.os.writeSmallInt(s);
                if (this.conn.isUSVER() && s > 18 && s != 52 && s != 53) {
                    String string = null;
                    String string2 = null;
                    string = ifxObject.getExtendedOwner();
                    string2 = ifxObject.getExtendedTypeName();
                    if (string == null) {
                        this.os.writeSmallInt((short)0);
                    } else {
                        this.os.writeChar(string);
                    }
                    this.os.writeChar(string2);
                }
                if (ifxObject.isNull()) {
                    this.os.writeSmallInt((short)-1);
                    this.os.writeSmallInt((short)0);
                    continue;
                }
                this.os.writeSmallInt((short)0);
                short s3 = ifxObject.getEncodedLength();
                this.os.writeSmallInt(s3);
                byte[] byArray = ifxObject.toIfx();
                this.os.writePadded(byArray);
                if (this.statementType == 1 || this.statementType == 12 || this.statementType == 38) {
                    this.conn.setDbName(ifxObject.toString());
                }
                if (this.statementType != 31) continue;
                this.conn.setDbName(null);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
        if (n4 > 0) {
            this.sendBlob(vector, n4, n2, n);
        }
        return bl;
    }

    @Override
    public void executePrepare(Statement statement) throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendPrepare((IfxStatement)statement);
            this.receiveMessage();
            ((IfxStatement)statement).setStatementType(this.statementType);
            if (this.desc != null) {
                this.desc.parseSetTableName(((IfxStatement)statement).commandString);
            }
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw this.handleSocketException(exception, this.conn);
        }
        this.conn.unlockSession();
        if (this.desc != null) {
            this.desc.parseSetTableName(((IfxStatement)statement).commandString);
        }
    }

    private void sendPrepare(IfxStatement ifxStatement) throws SQLException {
        String string = ifxStatement.commandString;
        try {
            if (string.length() > 65535) {
                throw IfxErrMsg.getSQLException(-79864, this.conn);
            }
            if (this.conn.db_use_log && !this.conn.autoCommit && this.conn.isBatchUpdatePerSpec() && ifxStatement instanceof IfxPreparedStatement) {
                IfxPreparedStatement ifxPreparedStatement = (IfxPreparedStatement)ifxStatement;
                if (ifxPreparedStatement.BatchVector.size() > 0 && !ifxPreparedStatement.usePut()) {
                    this.initiateTransaction();
                }
            }
            this.os.writeSmallInt((short)2);
            this.os.writeSmallInt((short)ifxStatement.numqmarks);
            this.os.writeChar(string, this.dbEncoding);
            this.SGK_desc = null;
            this.SGK_rowColumn = null;
            if (ifxStatement.SGK_returnGeneratedKeys != 0) {
                this.sendSGKPrepare(ifxStatement);
            }
            this.os.writeSmallInt((short)22);
            this.os.writeSmallInt((short)49);
            this.isReleased = false;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private void sendStatementExecute(IfxStatement ifxStatement) throws SQLException {
        this.sendExecute(ifxStatement);
        this.receiveMessage();
    }

    private void sendExecute(IfxStatement ifxStatement) throws SQLException {
        try {
            this.sendStatementID();
            if (!(ifxStatement instanceof IfxPreparedStatement)) {
                this.resetSGKTuples();
                this.os.writeSmallInt((short)7);
                return;
            }
            IfxPreparedStatement ifxPreparedStatement = (IfxPreparedStatement)ifxStatement;
            IfxResultSetMetaData ifxResultSetMetaData = ifxPreparedStatement.inputParamMeta;
            int n = ifxPreparedStatement.getqmarks();
            if (!(this.conn.isBatchUpdatePerSpec() && ifxStatement.executeBatchInProgress || ifxPreparedStatement.BatchVector.size() > 0 && !ifxPreparedStatement.executeBatchInProgress)) {
                Vector vector = null;
                vector = ifxPreparedStatement.BatchVector.size() == 0 ? ifxPreparedStatement.getVector() : ifxPreparedStatement.BatchParamVector;
                int n2 = vector.size();
                for (int i = 0; i < n && ifxPreparedStatement.BatchVector.size() == 0; ++i) {
                    IfxObject ifxObject = null;
                    if (i < vector.size()) {
                        ifxObject = (IfxObject)vector.elementAt(i);
                    }
                    if (ifxObject != null) continue;
                    int n3 = i % n + 1;
                    if (ifxResultSetMetaData != null && ifxResultSetMetaData.hasDefaultValue(n3)) continue;
                    throw IfxErrMsg.getSQLException(-79823, ifxPreparedStatement.namedCalls == 0L ? " index = " + n3 : ifxResultSetMetaData.getArgumentName(n3), (IfxConnection)this.conn);
                }
                this.sendBind(vector, ifxResultSetMetaData, n, 0, n);
            } else {
                if (this.conn.isBatchUpdatePerSpec() && ifxStatement.executeBatchInProgress) {
                    int n4 = ifxPreparedStatement.BatchVector.size();
                    for (int i = 0; i < n4; ++i) {
                        int n5 = i * n;
                        int n6 = n5 + n;
                        boolean bl = this.sendBind(ifxPreparedStatement.BatchParamVector, ifxResultSetMetaData, n, n5, n6);
                        this.os.writeSmallInt((short)7);
                        if (bl) {
                            this.receiveMessage();
                        }
                        if (!this.executeBatchInProgress || this.os.getBytesSentSinceLastEOT() < (this.conn.isXPSVER8_40() ? Short.MAX_VALUE : this.conn.getMaxFetchBufSize())) continue;
                        this.receiveMessage();
                        this.sendStatementID();
                    }
                    return;
                }
                int n7 = ifxPreparedStatement.BatchParamVector.size();
                this.sendBind(ifxPreparedStatement.BatchParamVector, ifxResultSetMetaData, 0, n7, n7);
            }
            this.resetSGKTuples();
            this.os.writeSmallInt((short)7);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    @Override
    public void executeStatementQuery(Statement statement) throws SQLException {
        this.executeStatementQuery(statement, false, null);
    }

    @Override
    public void executeStatementQuery(Statement statement, boolean bl) throws SQLException {
        this.executeStatementQuery(statement, bl, null);
    }

    @Override
    public void executeStatementQuery(Statement statement, boolean bl, ResultSetMetaData resultSetMetaData) throws SQLException {
        this.resetTuples();
        this.doneCommit = false;
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!(statement instanceof IfxPreparedStatement)) {
            try {
                this.sendPrepare((IfxStatement)statement);
                this.receiveMessage();
                if (this.desc != null) {
                    this.desc.parseSetTableName(((IfxStatement)statement).commandString);
                }
            }
            catch (SQLException sQLException) {
                this.conn.unlockSession();
                throw sQLException;
            }
            catch (Exception exception) {
                this.conn.unlockSession();
                throw this.handleSocketException(exception, this.conn);
            }
        }
        int n = 0;
        if (this.desc != null) {
            n = this.desc.getColumnCount();
        }
        if (this.statementType == 2 || this.statementType == 56 && n > 0) {
            try {
                if (!this.conn.autoCommit) {
                    this.initiateTransaction();
                }
                this.sendStatementQuery((IfxStatement)statement, bl, (IfxResultSetMetaData)resultSetMetaData);
            }
            catch (SQLException sQLException) {
                this.conn.unlockSession();
                throw sQLException;
            }
            catch (Exception exception) {
                this.conn.unlockSession();
                throw this.handleSocketException(exception, this.conn);
            }
        } else {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79750, this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendStatementQuery(IfxStatement ifxStatement, boolean bl, IfxResultSetMetaData ifxResultSetMetaData) throws SQLException {
        if (ifxStatement.currentResult != null) {
            ifxStatement.currentResult.withHold = bl;
        }
        this.sendQuery(ifxStatement, bl, ifxResultSetMetaData);
        if (ifxStatement.getResultSetType() == 1003) {
            IfxResultSetMetaData ifxResultSetMetaData2 = null;
            if (ifxStatement instanceof IfxPreparedStatement) {
                IfxPreparedStatement ifxPreparedStatement = (IfxPreparedStatement)ifxStatement;
                ifxResultSetMetaData2 = (IfxResultSetMetaData)ifxPreparedStatement.getOutPutMetaData();
            }
            if (this.desc.hasVariableLengthColumns) {
                this.receiveMessage();
            }
            if (ifxResultSetMetaData2 != null) {
                this.sendFetch(this.desc.hasVariableLengthColumns, ifxResultSetMetaData2);
            } else {
                this.sendFetch(this.desc.hasVariableLengthColumns, this.desc);
            }
            ifxStatement.cursorOpen = true;
        }
        this.receiveMessage();
    }

    private void sendType(IfxResultSetMetaData ifxResultSetMetaData, short s) throws SQLException {
        try {
            this.os.writeSmallInt((short)100);
            this.os.writeSmallInt(s);
            this.os.writeSmallInt((short)this.desc.getColumnCount());
            for (int i = 1; i <= this.desc.getColumnCount(); ++i) {
                IfxResultSetMetaData ifxResultSetMetaData2;
                if (ifxResultSetMetaData != null && ifxResultSetMetaData != this.desc && ifxResultSetMetaData.getColumnCount() >= i && ifxResultSetMetaData.getIfxColumnType(i) != 49) {
                    ifxResultSetMetaData2 = ifxResultSetMetaData;
                    this.desc.setIfxColumnType(i, ifxResultSetMetaData.getIfxColumnType(i));
                    this.desc.setExtendedName(i, ifxResultSetMetaData.getExtendedName(i));
                    this.desc.setColumnExtendedId(i, ifxResultSetMetaData.getColumnExtendedId(i));
                    this.desc.setEncodedLength(i, ifxResultSetMetaData.getEncodedLength(i));
                } else {
                    ifxResultSetMetaData2 = this.desc;
                }
                int n = ifxResultSetMetaData2.getIfxColumnType(i);
                boolean bl = ifxResultSetMetaData2.isVariableLengthType(i);
                if (bl && n != 13 && n != 16) {
                    short s2 = ifxResultSetMetaData2.isDistinct(i) ? (short)ifxResultSetMetaData2.getSourceType(i) : (short)ifxResultSetMetaData2.getColumnExtendedId(i);
                    n = s2 == 3 ? 46 : (s2 == 4 ? 47 : (s2 == 1 ? 43 : (s2 == 5 ? 45 : 44)));
                }
                this.os.writeSmallInt((short)n);
                if (bl && n != 13 && n != 16) {
                    this.os.writeChar(ifxResultSetMetaData2.getExtendedOwnerName(i));
                    this.os.writeChar(ifxResultSetMetaData2.getExtendedName(i));
                }
                this.os.writeInt(ifxResultSetMetaData2.getEncodedLength(i));
            }
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private void sendQuery(IfxStatement ifxStatement, boolean bl, IfxResultSetMetaData ifxResultSetMetaData) throws SQLException {
        try {
            int n;
            IfxPreparedStatement ifxPreparedStatement;
            this.sendStatementID();
            this.os.writeSmallInt((short)3);
            String string = ifxStatement.getCursorName();
            this.os.writeChar(string, this.dbEncoding);
            if (ifxStatement instanceof IfxPreparedStatement && !(ifxPreparedStatement = (IfxPreparedStatement)ifxStatement).usePut() && ifxPreparedStatement.inputvals > 0) {
                this.sendBind(ifxPreparedStatement.getVector(), ifxPreparedStatement.inputParamMeta, ifxPreparedStatement.numqmarks, 0, ifxPreparedStatement.numqmarks);
            }
            this.SQ_CLOSERecvd = false;
            this.SQ_CLOSESent = false;
            this.first = true;
            if (ifxStatement.getAutoFree()) {
                this.os.writeSmallInt((short)108);
            }
            if ((n = ifxStatement.getResultSetType()) == 1004) {
                this.os.writeSmallInt((short)24);
            }
            if (bl && this.statementType != 56) {
                this.os.writeSmallInt((short)43);
            }
            this.os.writeSmallInt((short)6);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
        ifxStatement.cursorOpen = true;
    }

    @Override
    public void executeOpenDatabase(String string, int n) throws SQLException {
        if (string == null) {
            return;
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.os.writeSmallInt((short)36);
            this.os.writeChar(string, this.dbEncoding);
            this.os.writeSmallInt((short)n);
            this.statementType = 1;
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw this.handleSocketException(exception, this.conn);
        }
        this.conn.unlockSession();
        this.callsetDatabaseOpen(string);
    }

    @Override
    public void executeClose(Statement statement) throws SQLException {
        if (this.conn.isCommitNeeded() && !this.doneCommit) {
            this.executeCommit();
            this.doneCommit = true;
        }
        if (((IfxStatement)statement).cursorOpen) {
            if (!this.conn.lockSession()) {
                throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
            }
            ((IfxStatement)statement).cursorOpen = false;
            if (!this.SQ_CLOSERecvd) {
                try {
                    this.sendClose((IfxStatement)statement);
                    this.receiveMessage();
                }
                catch (SQLException sQLException) {
                    this.conn.unlockSession();
                    throw sQLException;
                }
                catch (Exception exception) {
                    this.conn.unlockSession();
                    throw this.handleSocketException(exception, this.conn);
                }
            }
            this.conn.unlockSession();
        }
        if (((IfxStatement)statement).getAutoFree()) {
            this.clearAll();
        } else {
            this.clear();
        }
    }

    @Override
    public void executeRelease(Statement statement) throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!((IfxStatement)statement).getAutoFree() || this.conn.getAutoFree() && !this.SQ_CLOSERecvd && !this.SQ_CLOSESent || ((IfxStatement)statement).getAutoFree() && !this.SQ_CLOSERecvd && !this.SQ_CLOSESent) {
            try {
                if (!this.isReleased && this.statementID != -1) {
                    this.sendRelease((IfxStatement)statement);
                    this.statementID = (short)-1;
                    this.receiveMessage();
                }
            }
            catch (SQLException sQLException) {
                this.conn.unlockSession();
                throw sQLException;
            }
            catch (Exception exception) {
                this.conn.unlockSession();
                throw this.handleSocketException(exception, this.conn);
            }
        }
        this.conn.unlockSession();
        ((IfxStatement)statement).cursorOpen = false;
        this.clearAll();
    }

    void executeFetch() throws SQLException {
        this.resetTuples();
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendFetch(false, this.desc);
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw this.handleSocketException(exception, this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendFetch(boolean bl, IfxResultSetMetaData ifxResultSetMetaData) throws SQLException {
        int n = this.getTupleBufferSize();
        ++this.numberOfFetches;
        try {
            this.sendStatementID();
            if (bl) {
                this.sendType(ifxResultSetMetaData, (short)1);
            }
            this.os.writeSmallInt((short)9);
            if (this.conn.isXPSVER8_40()) {
                this.os.writeInt(n);
            } else {
                this.os.writeSmallInt((short)n);
            }
            if (this.conn.isFetchArr()) {
                this.os.writeSmallInt((short)0);
            }
            if (this.rowColumn == null) {
                this.rowColumn = new IfxRowColumn(this.conn, ifxResultSetMetaData, n);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private void sendClose(IfxStatement ifxStatement) throws SQLException {
        try {
            this.sendStatementID();
            this.os.writeSmallInt((short)10);
            this.SQ_CLOSESent = true;
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private void sendRelease(IfxStatement ifxStatement) throws SQLException {
        try {
            this.sendStatementID();
            this.os.writeSmallInt((short)11);
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    @Override
    public void executeCloseDatabase() throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        String string = this.conn.getConnectionDbName();
        if (string != null && string.length() != 0) {
            this.conn.unlockSession();
            return;
        }
        try {
            this.os.writeSmallInt((short)37);
            this.receiveMessage();
            this.conn.setDbName(null);
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw this.handleSocketException(exception, this.conn);
        }
        this.conn.unlockSession();
    }

    @Override
    public void executeExecute(Statement statement, boolean bl) throws SQLException {
        this.executeExecute(statement, bl, null);
    }

    @Override
    public void executeExecute(Statement statement, boolean bl, ResultSetMetaData resultSetMetaData) throws SQLException {
        this.resetTuples();
        this.doneCommit = false;
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!(statement instanceof IfxPreparedStatement)) {
            try {
                this.sendPrepare((IfxStatement)statement);
                this.receiveMessage();
                if (this.desc != null) {
                    this.desc.parseSetTableName(((IfxStatement)statement).commandString);
                }
            }
            catch (SQLException sQLException) {
                this.conn.unlockSession();
                throw sQLException;
            }
        }
        if (!this.conn.autoCommit) {
            try {
                this.initiateTransaction();
            }
            catch (SQLException sQLException) {
                this.conn.unlockSession();
                throw sQLException;
            }
        }
        try {
            if (this.statementType == 2 || this.statementType == 56 && this.desc != null && this.desc.getColumnCount() > 0) {
                this.sendStatementQuery((IfxStatement)statement, bl, (IfxResultSetMetaData)resultSetMetaData);
            } else {
                this.sendStatementExecute((IfxStatement)statement);
            }
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            if (this.TxStmt == 2 && this.sqlcode != -255) {
                this.conn.setTxEndState();
            }
            throw sQLException;
        }
        this.conn.unlockSession();
        this.callsetDatabaseOpen(this.parseDbName(statement));
        if (this.TxStmt == 1) {
            this.conn.setTxBeginState();
        } else if (this.TxStmt == 2) {
            this.conn.setTxEndState();
        } else if (this.conn.isCommitNeeded() && !this.isResultSet()) {
            this.executeCommit();
            this.doneCommit = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMessage() throws SQLException {
        short s = 0;
        this.clearExceptions();
        try {
            this.flip();
            try {
                do {
                    if (this.dispatchMsg(s = this.is.readSmallInt())) continue;
                    break;
                } while (s != 12 && s != 56);
            }
            finally {
                if (this.sqliTrace != null) {
                    this.sqliTrace.recordS2C();
                }
            }
        }
        catch (SQLException sQLException) {
            this.addException(sQLException);
        }
        catch (Exception exception) {
            this.addException(this.handleSocketException(exception, this.conn));
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public boolean dispatchMsg(int n) throws Exception {
        boolean bl = true;
        switch (n) {
            case 56: {
                this.sendExit();
                break;
            }
            case 8: {
                this.descTrue = true;
                this.receiveDescribe();
                break;
            }
            case 14: {
                this.receiveTuple();
                break;
            }
            case 25: {
                this.receiveTupleId();
                break;
            }
            case 15: {
                this.receiveDone();
                break;
            }
            case 39: {
                if (this.isText && this.convText) {
                    this.receiveText();
                    break;
                }
                this.receiveBlob();
                break;
            }
            case 97: {
                this.receiveLODATA();
                break;
            }
            case 13: {
                this.receiveError();
                break;
            }
            case 55: {
                this.receiveCost();
                break;
            }
            case 94: {
                this.receiveInsertDone();
                break;
            }
            case 99: {
                this.receiveXactstat();
                break;
            }
            case 10: {
                this.SQ_CLOSERecvd = true;
                break;
            }
            case 81: {
                this.receiveInfo();
                break;
            }
            case 53: {
                this.receiveVersion();
                break;
            }
            case 12: {
                break;
            }
            case 101: {
                this.receiveHandle();
                break;
            }
            case 103: {
                this.receiveFastPath();
                break;
            }
            case 98: {
                this.receiveSQFILE();
                break;
            }
            case 26: {
                this.receiveDBList();
                break;
            }
            case 104: {
                this.receiveFParam();
                break;
            }
            case 18: {
                this.receivePutErr();
                break;
            }
            case 86: {
                break;
            }
            case 125: {
                this.receiveIDescribe();
                break;
            }
            case 126: {
                this.receiveProtocols();
                break;
            }
            case 132: {
                this.receiveIFPDescribe();
                break;
            }
            case 135: {
                this.receiveSGKDescribe();
                break;
            }
            case 136: {
                this.receiveSGKTuple();
                break;
            }
            default: {
                this.setError(-408);
                bl = false;
            }
        }
        return bl;
    }

    protected void flip() throws SQLException {
        try {
            this.sendEOT();
            if (this.sqliTrace != null) {
                this.sqliTrace.recordC2S();
            }
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private void sendEOT(int n) throws IOException {
        this.os.writeSmallInt((short)12);
        this.os.flush();
        this.os.setByteCntAtEOT();
    }

    private void sendEOT() throws IOException {
        this.sendEOT(1);
    }

    private void sendACK() throws IOException {
        this.os.writeSmallInt((short)128);
    }

    private boolean receiveEOT() throws IOException {
        boolean bl = true;
        short s = this.is.readSmallInt();
        if (s != 12) {
            bl = false;
        }
        return bl;
    }

    private void sendStatementID() throws IOException {
        if (this.statementType == 0 && this.statementID == -1) {
            return;
        }
        this.os.writeSmallInt((short)4);
        this.os.writeSmallInt(this.statementID);
    }

    private void sendExit() throws SQLException {
        if (this.conn != null && !this.conn.isASF()) {
            this.conn.setDatabaseOpen(false, this.serverWarningsShort);
        }
        this.conn.close();
    }

    private void callsetDatabaseOpen(String string) throws SQLException {
        if (this.OpenDBStmt) {
            this.conn.setDbName(string);
            this.conn.setDatabaseOpen(this.OpenDBStmt, this.serverWarningsShort);
            this.dbEncoding = this.conn.getdbEncoding();
        }
    }

    private void setError(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(n, this.conn);
    }

    private void receiveDescribe() throws SQLException {
        short s = 0;
        int n = 0;
        String string = null;
        short[] sArray = null;
        try {
            this.statementType = this.is.readSmallInt();
            this.statementID = this.is.readSmallInt();
            n = this.is.readInt();
            this.setSQLerrd((short)3, n);
            short s2 = this.is.readSmallInt();
            s = this.is.readSmallInt();
            this.desc = new IfxResultSetMetaData(s, this.conn);
            this.desc.setTupleSize(s2);
            short s3 = this.is.readSmallInt();
            this.TxStmt = 0;
            if (this.statementType == 34) {
                this.TxStmt = 1;
            } else if (this.statementType == 35 || this.statementType == 36) {
                this.TxStmt = (short)2;
            }
            if (s > 0) {
                sArray = new short[s];
                for (short s4 = 1; s4 <= s; s4 = (short)(s4 + 1)) {
                    short s5;
                    sArray[s4 - 1] = this.is.readSmallInt();
                    if (this.conn.isUSVER()) {
                        n = this.is.readInt();
                        this.desc.setColumnStartPosition(s4, n);
                    } else {
                        s5 = this.is.readSmallInt();
                        this.desc.setColumnStartPosition(s4, s5);
                    }
                    s5 = this.is.readSmallInt();
                    this.desc.setIfxColumnType(s4, s5);
                    if (this.conn.isUSVER()) {
                        n = this.is.readInt();
                        this.desc.setColumnExtendedId(s4, n);
                        String string2 = new String(this.is.readChar(this.dbEncoding));
                        this.desc.setExtendedOwnerName(s4, string2);
                        string2 = new String(this.is.readChar());
                        this.desc.setExtendedName(s4, string2);
                        s5 = this.is.readSmallInt();
                        this.desc.setReference(s4, s5);
                        s5 = this.is.readSmallInt();
                        this.desc.setAlignment(s4, s5);
                        n = this.is.readInt();
                        this.desc.setSourceType(s4, n);
                        n = this.is.readInt();
                        this.desc.setEncodedLength(s4, n);
                        continue;
                    }
                    s5 = this.is.readSmallInt();
                    this.desc.setEncodedLength(s4, s5);
                }
                this.desc.setTextByteColumnCount();
            }
            if (s3 > 0) {
                byte[] byArray = new byte[s3];
                this.is.readPadded(byArray);
                string = this.conn.ifxtojava.IfxToJavaChar(byArray, this.dbEncoding);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
        if (string != null) {
            String string3 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0000");
            for (short s6 = 0; s6 < s; s6 = (short)(s6 + 1)) {
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    this.desc.setColumnName(s6 + 1, string3);
                    continue;
                }
                this.desc.setColumnName(s6 + 1, null);
            }
        }
        if (this.conn != null) {
            this.desc.setDelimIdent(this.conn.isDelimIdentSet());
        }
    }

    void setSQLerrd(short s, int n) throws SQLException {
        try {
            this.sqlerrd[s] = n;
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private void receiveInsertDone() throws SQLException {
        try {
            this.serial8Inserted = this.is.readLongInt();
            this.bigSerialInserted = this.is.readLongBigint();
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    String getServerWarningsString() {
        return this.serverWarningsString.toString();
    }

    @Override
    public long getSerial8Inserted() {
        return this.serial8Inserted;
    }

    @Override
    public long getBigSerialInserted() {
        return this.bigSerialInserted;
    }

    private void receiveDone() throws SQLException {
        this.OpenDBStmt = false;
        try {
            if (this.executeBatchInProgress && this.batchRowStatus == null) {
                this.batchRowStatus = new ArrayList();
            }
            if (this.statementType == 1 || this.statementType == 12 || this.statementType == 38) {
                this.OpenDBStmt = true;
            }
            if (this.statementType == 31) {
                this.conn.setDbName(null);
            }
            short s = this.is.readSmallInt();
            this.setWarnings(s, this.OpenDBStmt);
            int n = this.is.readInt();
            if (this.executeBatchInProgress) {
                this.batchRowStatus.add(this.batchCount++, new Integer(n));
            }
            this.setSQLerrd((short)2, n);
            n = this.is.readInt();
            if (n == 0 && this.statementType == 2 && !this.descTrue) {
                this.SQLState = IfxMessage.getSQLSTATE(100);
                this.message = IfxMessage.getMessage(36007, this.conn.getclLocale());
                this.addWarning(100, this.message);
            }
            this.descTrue = false;
            this.setSQLerrd((short)5, n);
            n = this.is.readInt();
            this.setSQLerrd((short)1, n);
            if (!this.OpenDBStmt && this.statementType == 31) {
                this.conn.setDatabaseOpen(this.OpenDBStmt, this.serverWarningsShort);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    @Override
    public int getEstimateNumberofRow() {
        return this.sqlerrd[0];
    }

    @Override
    public int getSerialInsert() {
        return this.sqlerrd[1];
    }

    int getISAMCode() {
        return this.isamcode;
    }

    @Override
    public int getNumberOfRowsProcessed() {
        return this.sqlerrd[2];
    }

    int getEstimatedCode() {
        return this.sqlerrd[3];
    }

    int getSQLStatementOffset() {
        return this.sqlerrd[4];
    }

    int getRowID() {
        return this.sqlerrd[5];
    }

    private void receiveCost() throws SQLException {
        try {
            int n = this.is.readInt();
            this.setSQLerrd((short)0, n);
            n = this.is.readInt();
            this.setSQLerrd((short)3, n);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private void receiveXactstat() throws SQLException {
        try {
            this.xcEvent = this.is.readSmallInt();
            this.xcNewLevel = this.is.readSmallInt();
            this.xcOldLevel = this.is.readSmallInt();
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    int getXCEvent() {
        return this.xcEvent;
    }

    int getNewLevel() {
        return this.xcNewLevel;
    }

    int getOldLevel() {
        return this.xcOldLevel;
    }

    private void receiveTuple() throws SQLException {
        ++this.numberOfTuplesReceived;
        try {
            short s = this.is.readSmallInt();
            int n = this.conn.isUSVER() ? this.is.readInt() : (int)this.is.readSmallInt();
            if (n > 0) {
                this.rowColumn.readTuple(this.is, this.totalTupleSize, n);
                this.totalTupleSize += n;
                this.tupleSizeReceived = Math.max(n, this.tupleSizeReceived);
                if (++this.totalTuples >= this.offsetVector.size()) {
                    this.offsetVector.setSize(this.totalTuples + 100);
                }
                this.offsetVector.setElementAt(new Integer(this.totalTupleSize), this.totalTuples);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    public void addException(SQLException sQLException) {
        if (this.exception == null) {
            this.exception = sQLException;
        } else {
            this.exception.setNextException(sQLException);
        }
    }

    private void addException(int n, String string) {
        String string2 = this.conn.getclLocale();
        SQLException sQLException = null;
        if (n == -9752 && this.conn.isNamedParametersSupported()) {
            String string3 = IfxMessage.getMessage(n, string, string2) + ":" + string;
            sQLException = new SQLException(string3, IfxMessage.getSQLSTATE(n), n);
        } else {
            sQLException = string != null && string.length() > 0 ? new SQLException(IfxMessage.getMessage(n, string, string2), IfxMessage.getSQLSTATE(n), n) : IfxErrMsg.getSQLException(n, this.conn);
        }
        this.addException(sQLException);
    }

    private void addException(String string, String string2, int n) {
        String string3 = this.conn.getclLocale();
        SQLException sQLException = null;
        sQLException = string == null || string.trim() == "" ? (string2 == null || string2.trim() == "" ? new SQLException(IfxMessage.getMessage(n, string3), IfxMessage.getSQLSTATE(n), n) : new SQLException(IfxMessage.getMessage(n, string3), string2, n)) : (string2 == null || string2.trim() == "" ? new SQLException(string, "U0001", n) : new SQLException(string, string2, n));
        this.addException(sQLException);
    }

    public SQLException getExceptions() {
        return this.exception;
    }

    private void addWarning(SQLWarning sQLWarning) {
        if (this.warn == null) {
            this.warn = sQLWarning;
        } else {
            this.warn.setNextException(sQLWarning);
        }
    }

    private void addWarning(int n, String string) {
        SQLWarning sQLWarning = null;
        sQLWarning = new SQLWarning(string, IfxMessage.getSQLSTATE(n), n);
        this.addWarning(sQLWarning);
    }

    private void addWarning(String string, String string2) {
        SQLWarning sQLWarning = null;
        sQLWarning = string2 != null ? IfxWarnMsg.getSQLWarning(string2, string, this.conn) : IfxWarnMsg.getSQLWarning(string, this.conn);
        this.addWarning(sQLWarning);
    }

    private void setWarnings(short s, boolean bl) {
        int n = 0;
        this.SQLState = null;
        if (this.conn.Noansiwarn) {
            s = (short)(s & ~16);
        }
        this.serverWarningsShort = s;
        for (int n2 = 1; n2 <= 6; n2 = (int)((short)(n2 + 1))) {
            n = s & 1;
            if (n == 1) {
                this.serverWarningsString.setCharAt(n2, 'W');
                switch (n2) {
                    case 1: {
                        if (bl) {
                            this.addWarning(null, "01I01");
                            break;
                        }
                        this.addWarning(null, "01006");
                        break;
                    }
                    case 2: {
                        if (bl) {
                            this.addWarning(null, "01I03");
                            break;
                        }
                        this.addWarning(null, "01003");
                        break;
                    }
                    case 3: {
                        if (bl) {
                            this.addWarning(null, "01I04");
                            break;
                        }
                        this.addWarning(null, "01003");
                        break;
                    }
                    case 4: {
                        this.addWarning(null, "01I05");
                        break;
                    }
                    case 5: {
                        this.addWarning(null, "01I06");
                        break;
                    }
                    case 6: {
                        if (bl) {
                            this.addWarning(null, "01I10");
                            break;
                        }
                        this.addWarning(null, "01I11");
                    }
                }
            } else {
                this.serverWarningsString.setCharAt(n2, ' ');
            }
            s = (short)(s >> 1);
        }
    }

    @Override
    public void chainWarnings(SQLWarning sQLWarning) {
        if (sQLWarning != null) {
            if (this.warn != null) {
                this.warn.setNextWarning(sQLWarning);
            } else {
                this.warn = sQLWarning;
            }
        }
    }

    @Override
    public void clearExceptions() {
        this.sqlcode = 0;
        this.isamcode = 0;
        this.SQLState = null;
        this.message = null;
        this.exception = null;
    }

    @Override
    public void clearWarnings() {
        this.SQLState = null;
        this.message = null;
        this.sqlcode = 0;
        this.isamcode = 0;
        this.warn = null;
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warn;
    }

    private void receivePutErr() throws SQLException {
        try {
            int n = this.is.readInt();
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
        this.receiveError();
    }

    private void receiveError() throws SQLException {
        try {
            this.sqlcode = this.is.readSmallInt();
            if (this.sqlcode == -619) {
                this.gobbleSmallInts(2);
                this.is.readChar();
                this.addException(this.sqlcode, null);
                return;
            }
            this.isamcode = this.is.readSmallInt();
            this.setSQLerrd((short)1, this.isamcode);
            short s = this.is.readSmallInt();
            this.setSQLerrd((short)4, s);
            this.conn.setSQLStatementOffset(s);
            if (this.sqlcode != -368) {
                this.sqlerrm = this.is.readChar(this.dbEncoding).trim();
            }
            if (this.sqlcode == 0 && !this.conn.isUSVER()) {
                this.sqlcode = -407;
                this.isamcode = 0;
                this.addException(this.sqlcode, null);
            } else if (this.sqlcode == 100) {
                this.SQLState = IfxMessage.getSQLSTATE(this.sqlcode);
                this.message = IfxMessage.getMessage(36007, this.conn.getclLocale());
                this.addWarning(this.sqlcode, this.message);
            } else if (this.sqlcode != 0 && this.sqlcode != -937) {
                this.addException(this.sqlcode, this.sqlerrm);
                if (this.isamcode != 0) {
                    this.addException(this.isamcode, null);
                }
                SQLException sQLException = IfxErrMsg.getSQLException(this.isamcode, this.conn);
                IfxErrMsg.setSQLExceptionCause(this.exception, sQLException);
            } else {
                byte[] byArray = new byte[5];
                this.is.readPadded(byArray);
                this.SQLState = this.conn.ifxtojava.IfxToJavaChar(byArray);
                this.message = this.is.readChar(this.dbEncoding);
                this.sqlerrm = null;
                if (this.sqlcode == 0) {
                    this.isamcode = 0;
                    this.addWarning(this.message, this.SQLState);
                } else {
                    this.addException(this.message, this.SQLState, this.sqlcode);
                    if (this.isamcode != 0) {
                        this.addException(this.isamcode, null);
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            this.addException(-79716, null);
        }
    }

    public int getSQLCode() {
        return this.sqlcode;
    }

    String getSQLErrm() {
        return this.sqlerrm;
    }

    String getSQLState() {
        return this.SQLState;
    }

    String getMessage() {
        return this.message;
    }

    private void receiveTupleId() throws SQLException {
        try {
            this.Tupid = this.is.readInt();
            if (this.getTupleCount() > 0) {
                this.firstTuple = this.Tupid;
                this.lastTuple = this.firstTuple + this.getTupleCount() - 1;
            } else {
                int n = this.Tupid;
            }
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    void executeInfo(short s) throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendInfo(s);
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw this.handleSocketException(exception, this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendInfo(short s) throws SQLException {
        try {
            this.os.writeSmallInt((short)81);
            if (s != 0) {
                this.os.writeSmallInt((short)1);
                this.os.writeSmallInt((short)0);
            }
            this.os.writeSmallInt((short)0);
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void receiveInfo() throws SQLException {
        try {
            short s;
            block8: while ((s = this.is.readSmallInt()) > 0) {
                int n = this.is.readSmallInt();
                switch (s) {
                    case 2: {
                        if (n < 4) {
                            this.setError(-408);
                            continue block8;
                        }
                        byte[] byArray = new byte[n - 4];
                        n -= 4;
                        continue block8;
                    }
                    case 3: {
                        int n2;
                        int n3;
                        int n4 = 0;
                        for (n2 = 0; n2 < n / 4; n4 |= n3, ++n2) {
                            n3 = this.is.readInt();
                        }
                        this.conn.setTypeList(n4);
                        continue block8;
                    }
                    case 4: {
                        int n3;
                        int n2 = 0;
                        for (int i = 0; i < n / 4; n2 |= n3, ++i) {
                            n3 = this.is.readInt();
                        }
                        this.conn.setCapList(n2);
                        continue block8;
                    }
                }
                this.gobbleChars(n);
            }
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    @Override
    public void executeEnv(Properties properties) throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendEnv(properties);
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw this.handleSocketException(exception, this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendEnv(Properties properties) throws SQLException {
        short s = 0;
        short s2 = 0;
        short s3 = 0;
        short s4 = 0;
        short s5 = 0;
        String string = null;
        String string2 = null;
        int n = 0;
        IfxDataOutputStream ifxDataOutputStream = this.conn.Ifxproto_send();
        if (!this.conn.isASF()) {
            return;
        }
        s = 4;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            string2 = properties.getProperty(string);
            s2 = (short)string.length();
            s3 = (short)string2.length();
            n = s2 & 1;
            if (n == 1) {
                s2 = (short)(s2 + 1);
            }
            if ((n = s3 & 1) == 1) {
                s3 = (short)(s3 + 1);
            }
            s = (short)(s + (s2 + s3 + 4));
            if (s2 > s4) {
                s4 = s2;
            }
            if (s3 <= s5) continue;
            s5 = s3;
        }
        s = (short)(s + 2);
        try {
            ifxDataOutputStream.writeSmallInt((short)81);
            ifxDataOutputStream.writeSmallInt((short)6);
            ifxDataOutputStream.writeSmallInt(s);
            ifxDataOutputStream.writeSmallInt(s4);
            ifxDataOutputStream.writeSmallInt(s5);
            enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                string2 = properties.getProperty(string);
                ifxDataOutputStream.writeChar(string, this.dbEncoding);
                ifxDataOutputStream.writeChar(string2, this.dbEncoding);
            }
            ifxDataOutputStream.writeSmallInt((short)0);
            ifxDataOutputStream.writeSmallInt((short)0);
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private void gobbleChars(int n) throws SQLException {
        try {
            byte[] byArray = new byte[n];
            this.is.readPadded(byArray);
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private void gobbleSmallInts(int n) throws SQLException {
        try {
            for (int i = 0; i < n; ++i) {
                this.is.readSmallInt();
            }
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    @Override
    public void executeVersion() throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendVersion();
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw this.handleSocketException(exception, this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendVersion() throws SQLException {
        try {
            this.os.writeSmallInt((short)53);
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private void receiveVersion() throws SQLException {
        try {
            this.serverVersion = new String(this.is.readChar());
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    int getTupleBufferSize() {
        if (this.tupleBufferSize != -1) {
            return this.tupleBufferSize;
        }
        this.tupleBufferSize = this.desc.getTupleSize() <= 2048 ? 4096 : (this.desc.getTupleSize() <= 4096 ? 8192 : (int)this.desc.getTupleSize());
        if (this.conn.fetchBufSize > this.tupleBufferSize) {
            this.tupleBufferSize = this.conn.getCorrectedFetchBufSize();
        }
        return this.tupleBufferSize;
    }

    @Override
    public boolean isResultSet() throws SQLException {
        int n = 0;
        if (this.desc != null) {
            n = this.desc.getColumnCount();
        }
        return this.statementType == 2 || this.statementType == 56 && n > 0;
    }

    @Override
    public int getTupleCount() {
        return this.totalTuples;
    }

    @Override
    public boolean getaRow(int n, int n2, int n3, int n4, Statement statement) throws SQLException {
        if (n != 1000 && n2 != 1) {
            throw IfxErrMsg.getSQLException(-79751, this.conn);
        }
        if (n4 == 1 && (n3 == 6 || n3 == 1)) {
            if (this.getTupleCount() != 0) {
                this.repositionIfInTupleBuffer(n2);
            }
            if (n2 == 0) {
                this.curRow = -1;
                return false;
            }
        }
        int n5 = this.getTupleCount() - (this.curRow + 1);
        if (n4 == 1) {
            if (!this.SQ_CLOSERecvd && (this.getNumberOfTuplesReceived() != 0 || this.first) && (n5 == 0 || n3 != 1 && n3 != 6)) {
                IfxResultSet ifxResultSet = ((IfxStatement)statement).currentResult;
                int n6 = 0;
                if (ifxResultSet.getFetchSize() != 0) {
                    n6 = ifxResultSet.calculateFetchBufferSize();
                }
                if (n6 != 0) {
                    n6 = Math.min(n6, this.conn.getMaxFetchBufSize());
                }
                this.executeScrollFetch(n3, n2, statement, n6);
                n5 = this.getTupleCount() - (this.curRow + 1);
            }
        } else {
            if (!this.SQ_CLOSERecvd && !this.first) {
                return false;
            }
            if (!this.SQ_CLOSERecvd && this.first && n5 == 0) {
                this.executeFetch();
                ((IfxStatement)statement).cursorOpen = true;
                n5 = this.getTupleCount() - (this.curRow + 1);
            }
        }
        if (n5 == 0) {
            if (n4 != 1 && this.conn.isCommitNeeded() && !this.doneCommit) {
                this.executeCommit();
                this.doneCommit = true;
            }
            this.first = false;
            return false;
        }
        ++this.curRow;
        if (n4 == 1 && n2 != this.getTupid() && (n3 == 6 || n3 == 1)) {
            throw IfxErrMsg.getSQLException(-79716, this.conn);
        }
        this.curOffset = (Integer)this.offsetVector.elementAt(this.curRow);
        this.rowColumn.setOffsetInTuple(this.curOffset);
        return true;
    }

    @Override
    public int getTupleSize() throws SQLException {
        return this.desc.getTupleSize();
    }

    private void repositionIfInTupleBuffer(int n) {
        this.curRow = n >= this.firstTuple && n <= this.lastTuple ? n - this.firstTuple - 1 : this.totalTuples - 1;
    }

    @Override
    public IfxObject getColumnInRow(int n) throws SQLException {
        if (this.rowColumn == null) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        return this.rowColumn.getColumn(n, null);
    }

    IfxObject getColumnInRow(int n, Calendar calendar) throws SQLException {
        if (this.rowColumn == null) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        return this.rowColumn.getColumn(n, calendar);
    }

    @Override
    public void loadColumnData(int n, IfxObject ifxObject) throws SQLException {
        if (this.rowColumn == null) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        this.rowColumn.loadColumnData(n, ifxObject);
    }

    private void sendBlob(Vector vector, int n, int n2, int n3) throws SQLException {
        try {
            this.os.writeSmallInt((short)41);
            this.os.writeSmallInt((short)n);
            this.os.flush();
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
        for (int i = 0; i < n3; ++i) {
            this.isText = false;
            IfxObject ifxObject = (IfxObject)vector.elementAt(n2 + i);
            short s = (short)ifxObject.getIfxType();
            if (s == 12) {
                this.isText = true;
            }
            if (!(ifxObject.isNull() || s != 11 && s != 12)) {
                IfxBlob ifxBlob = (IfxBlob)ifxObject;
                if (s == 11 || this.isText && !this.convText) {
                    if (ifxBlob.isBlobByteType()) {
                        this.sendBytesBlob(this.os, ifxBlob.getBlobBuffer());
                    } else {
                        this.sendStreamBlob(this.os, ifxBlob.getBlobInputStream(), ifxBlob.getBlobLength());
                    }
                } else if (ifxBlob.isBlobByteType()) {
                    this.convTextBlobBuffer(ifxBlob);
                    this.sendBytesBlob(this.os, ifxBlob.getBlobBuffer());
                } else {
                    this.convTextBlobStream(ifxBlob);
                    this.sendStreamBlob(this.os, ifxBlob.getBlobInputStream(), ifxBlob.getBlobLength());
                }
            }
            this.isText = false;
        }
        this.isText = false;
    }

    private void convTextBlobStream(IfxBlob ifxBlob) throws SQLException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        IfxTmpFile ifxTmpFile = null;
        String string = this.conn.getclEncoding();
        String string2 = this.conn.getdbEncoding();
        try {
            int n;
            if (ifxBlob.getBlobLength() <= this.conn.getCodesetLobSize()) {
                inputStream = ifxBlob.getBlobInputStream();
                outputStream = new ByteArrayOutputStream();
            } else {
                inputStream = ifxBlob.getBlobInputStream();
                ifxTmpFile = new IfxTmpFile(this.conn);
                outputStream = ifxTmpFile.getOutputStream();
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, string2));
            char[] cArray = new char[4096];
            while ((n = bufferedReader.read(cArray)) != -1) {
                ((Writer)bufferedWriter).write(cArray, 0, n);
            }
            ((Reader)bufferedReader).close();
            ((Writer)bufferedWriter).flush();
            ((Writer)bufferedWriter).close();
            inputStream.close();
            if (ifxTmpFile == null) {
                IfxByteArrayInputStream ifxByteArrayInputStream = new IfxByteArrayInputStream((ByteArrayOutputStream)outputStream);
                ifxBlob.fromInputStream(ifxByteArrayInputStream, ((ByteArrayOutputStream)outputStream).size());
            } else {
                outputStream.close();
                IfxInputStream ifxInputStream = ifxTmpFile.getInputStream();
                int n2 = ifxTmpFile.length();
                ifxBlob.fromInputStream(ifxInputStream, n2);
            }
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private void convTextBlobBuffer(IfxBlob ifxBlob) throws SQLException {
        IfxByteArrayInputStream ifxByteArrayInputStream = null;
        OutputStream outputStream = null;
        IfxTmpFile ifxTmpFile = null;
        String string = this.conn.getclEncoding();
        String string2 = this.conn.getdbEncoding();
        try {
            int n;
            ifxByteArrayInputStream = new IfxByteArrayInputStream(ifxBlob.getBlobBuffer());
            if (ifxBlob.getBlobLength() <= this.conn.getCodesetLobSize()) {
                outputStream = new ByteArrayOutputStream();
            } else {
                ifxTmpFile = new IfxTmpFile(this.conn);
                outputStream = ifxTmpFile.getOutputStream();
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)ifxByteArrayInputStream, string));
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, string2));
            char[] cArray = new char[4096];
            while ((n = bufferedReader.read(cArray)) != -1) {
                ((Writer)bufferedWriter).write(cArray, 0, n);
            }
            ((Reader)bufferedReader).close();
            ((Writer)bufferedWriter).flush();
            ((Writer)bufferedWriter).close();
            ((InputStream)ifxByteArrayInputStream).close();
            ifxBlob.blobBuffer = null;
            if (ifxTmpFile == null) {
                ifxBlob.setBlobBuffer(((ByteArrayOutputStream)outputStream).toByteArray());
            } else {
                outputStream.close();
                IfxInputStream ifxInputStream = ifxTmpFile.getInputStream();
                int n2 = ifxTmpFile.length();
                byte[] byArray = new byte[n2];
                ifxInputStream.read(byArray, 0, n2);
                ifxBlob.setBlobBuffer(byArray);
            }
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private void sendBytesBlob(IfxDataOutputStream ifxDataOutputStream, byte[] byArray) throws SQLException {
        int n = byArray.length;
        int n2 = 0;
        while (n > 0) {
            try {
                ifxDataOutputStream.writeSmallInt((short)39);
                if (n > 1024) {
                    ifxDataOutputStream.writeSmallInt((short)1024);
                    ifxDataOutputStream.writePadded(byArray, n2, 1024);
                    n -= 1024;
                    n2 += 1024;
                    continue;
                }
                ifxDataOutputStream.writeSmallInt((short)n);
                ifxDataOutputStream.writePadded(byArray, n2, n);
                n = 0;
            }
            catch (Exception exception) {
                throw this.handleSocketException(exception, this.conn);
            }
        }
        try {
            ifxDataOutputStream.writeSmallInt((short)39);
            ifxDataOutputStream.writeSmallInt((short)0);
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private void sendStreamBlob(IfxDataOutputStream ifxDataOutputStream, InputStream inputStream, int n) throws SQLException {
        int n2 = n;
        byte[] byArray = new byte[1024];
        int n3 = 0;
        while (n2 > 0) {
            try {
                if (n2 > 1024) {
                    n3 = inputStream.read(byArray, 0, 1024);
                    if (n3 <= 0) break;
                    ifxDataOutputStream.writeSmallInt((short)39);
                    ifxDataOutputStream.writeSmallInt((short)n3);
                    ifxDataOutputStream.writePadded(byArray, 0, n3);
                    n2 -= n3;
                    continue;
                }
                n3 = inputStream.read(byArray, 0, n2);
                if (n3 <= 0) break;
                ifxDataOutputStream.writeSmallInt((short)39);
                ifxDataOutputStream.writeSmallInt((short)n3);
                ifxDataOutputStream.writePadded(byArray, 0, n3);
                n2 -= n3;
            }
            catch (Exception exception) {
                // empty catch block
                break;
            }
        }
        if (inputStream instanceof IfxInputStream) {
            try {
                ifxDataOutputStream.flush();
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n2 == 0) {
            try {
                ifxDataOutputStream.writeSmallInt((short)39);
                ifxDataOutputStream.writeSmallInt((short)0);
            }
            catch (Exception exception) {
                throw this.handleSocketException(exception, this.conn);
            }
        }
        try {
            ifxDataOutputStream.writeSmallInt((short)40);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            if (this.TxStmt == 2 && this.sqlcode != -255) {
                this.conn.setTxEndState();
            }
            throw IfxErrMsg.getSQLException(-79752, this.conn);
        }
    }

    @Override
    public void executeFetchBlob(IfxObject ifxObject) throws SQLException {
        int n = this.convText ? this.conn.getCodesetLobSize() : this.conn.getBlobCacheSize();
        this.BlobFd = null;
        this.BlobBuffer = null;
        this.BlobWriteFailure = 0;
        this.BlobWriteOffset = 0;
        this.BufferOrStream = 0;
        IfxBlob ifxBlob = (IfxBlob)ifxObject;
        int n2 = ifxBlob.getBlobLength();
        short s = (short)ifxObject.getIfxType();
        this.isText = s == 12;
        if (n < 0 || n > 0 && n2 <= n) {
            try {
                this.BlobBuffer = memoryUtil.allocateMemory(n2, this.conn);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79753, exception.toString(), (IfxConnection)this.conn);
            }
            ifxBlob.setBlobBuffer(this.BlobBuffer);
            ifxBlob.setBlobFileName();
            this.BufferOrStream = 0;
        } else {
            ifxBlob.tempBlobFile = new IfxTmpFile(this.conn);
            try {
                this.BlobFd = ifxBlob.tempBlobFile.getOutputStream();
                this.BlobBuffer = null;
                this.BufferOrStream = 1;
            }
            catch (Exception exception) {
                if (n == 0) {
                    throw IfxErrMsg.getSQLException(-79774, this.conn);
                }
                this.BlobBuffer = memoryUtil.allocateMemory(n2, this.conn);
                this.BlobFd = null;
                ifxBlob.setBlobBuffer(this.BlobBuffer);
                ifxBlob.setBlobFileName();
                this.BufferOrStream = 0;
            }
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendFetchBlob((IfxBlob)ifxObject);
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            try {
                if (this.BlobFd != null) {
                    this.BlobFd.close();
                }
            }
            catch (IOException iOException) {
                this.isText = false;
            }
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            try {
                this.BlobFd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.isText = false;
            throw this.handleSocketException(exception, this.conn);
        }
        this.conn.unlockSession();
        if (this.BlobFd != null) {
            try {
                this.BlobFd.close();
            }
            catch (IOException iOException) {
                this.isText = false;
                throw this.handleSocketException(iOException, this.conn);
            }
        }
        if (this.BlobWriteFailure == 1) {
            this.isText = false;
            throw IfxErrMsg.getSQLException(-79754, this.conn);
        }
        if (this.isText && this.convText) {
            this.fetchCodesetConvertedTextBlob(ifxBlob);
        }
        this.isText = false;
    }

    private void fetchCodesetConvertedTextBlob(IfxBlob ifxBlob) throws SQLException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        String string = this.conn.getdbEncoding();
        String string2 = this.conn.getclEncoding();
        try {
            int n;
            Object object;
            if (ifxBlob.getBlobLength() <= this.conn.getCodesetLobSize()) {
                inputStream = new IfxByteArrayInputStream(ifxBlob.blobBuffer);
                outputStream = new ByteArrayOutputStream();
            } else {
                object = ifxBlob.tempBlobFile;
                inputStream = ((IfxTmpFile)object).getInputStream();
                ifxBlob.tempBlobFile = new IfxTmpFile(this.conn);
                outputStream = ifxBlob.tempBlobFile.getOutputStream();
            }
            object = new BufferedReader(new InputStreamReader(inputStream, string));
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, string2));
            char[] cArray = new char[4096];
            while ((n = ((Reader)object).read(cArray)) != -1) {
                ((Writer)bufferedWriter).write(cArray, 0, n);
            }
            ((Reader)object).close();
            ((Writer)bufferedWriter).flush();
            ((Writer)bufferedWriter).close();
            if (ifxBlob.getBlobLength() > this.conn.getCodesetLobSize()) {
                outputStream.close();
            } else {
                this.BlobBuffer = ((ByteArrayOutputStream)outputStream).toByteArray();
                ifxBlob.setBlobBuffer(this.BlobBuffer);
            }
            inputStream.close();
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private void sendFetchBlob(IfxBlob ifxBlob) throws SQLException {
        try {
            this.sendStatementID();
            this.os.writeSmallInt((short)38);
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
        try {
            this.os.writePadded(ifxBlob.toIfx());
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private void receiveText() throws SQLException {
        int n;
        short s;
        byte[] byArray = null;
        try {
            s = this.is.readSmallInt();
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
        try {
            byArray = new byte[s];
            n = this.is.readPadded(byArray);
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
        if (this.BlobWriteFailure == 0) {
            try {
                this.blobDataWrite(byArray, this.BlobWriteOffset, n);
                this.BlobWriteOffset += n;
            }
            catch (Exception exception) {
                this.BlobWriteFailure = 1;
            }
        }
        if (n < s) {
            int n2 = 0;
            while (n < s) {
                try {
                    byArray = new byte[s - n];
                    n2 = this.is.readPadded(byArray);
                }
                catch (Exception exception) {
                    throw this.handleSocketException(exception, this.conn);
                }
                if (this.BlobWriteFailure == 0) {
                    try {
                        this.blobDataWrite(byArray, this.BlobWriteOffset, n2);
                        this.BlobWriteOffset += n2;
                    }
                    catch (Exception exception) {
                        this.BlobWriteFailure = 1;
                    }
                }
                n += n2;
            }
        }
    }

    private void receiveBlob() throws SQLException {
        int n;
        short s;
        byte[] byArray = null;
        try {
            s = this.is.readSmallInt();
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
        try {
            byArray = new byte[s];
            n = this.is.readPadded(byArray);
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
        if (this.BlobWriteFailure == 0) {
            try {
                this.blobDataWrite(byArray, this.BlobWriteOffset, n);
                this.BlobWriteOffset += n;
            }
            catch (Exception exception) {
                this.BlobWriteFailure = 1;
            }
        }
        if (n < s) {
            int n2 = 0;
            while (n < s) {
                try {
                    byArray = new byte[s - n];
                    n2 = this.is.readPadded(byArray);
                }
                catch (Exception exception) {
                    throw this.handleSocketException(exception, this.conn);
                }
                if (this.BlobWriteFailure == 0) {
                    try {
                        this.blobDataWrite(byArray, this.BlobWriteOffset, n2);
                        this.BlobWriteOffset += n2;
                    }
                    catch (Exception exception) {
                        this.BlobWriteFailure = 1;
                    }
                }
                n += n2;
            }
        }
    }

    private int blobDataWrite(byte[] byArray, int n, int n2) {
        if (this.BufferOrStream == 1) {
            try {
                this.BlobFd.write(byArray, 0, n2);
            }
            catch (Exception exception) {
                return 1;
            }
        } else if (n2 > 0) {
            System.arraycopy(byArray, 0, this.BlobBuffer, n, n2);
        }
        return 0;
    }

    public void executeScrollFetch(int n, int n2, Statement statement, int n3) throws SQLException {
        ++this.numberOfFetches;
        this.resetTuples();
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            IfxResultSetMetaData ifxResultSetMetaData = null;
            if (statement != null && statement instanceof IfxPreparedStatement) {
                IfxPreparedStatement ifxPreparedStatement = (IfxPreparedStatement)statement;
                ifxResultSetMetaData = (IfxResultSetMetaData)ifxPreparedStatement.getOutPutMetaData();
            }
            if (ifxResultSetMetaData != null) {
                this.sendScrollFetch(n, n2, ifxResultSetMetaData, n3);
            } else {
                this.sendScrollFetch(n, n2, this.desc, n3);
            }
            ((IfxStatement)statement).cursorOpen = true;
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            ((IfxStatement)statement).cursorOpen = false;
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw this.handleSocketException(exception, this.conn);
        }
        int n4 = this.tupleSizeReceived;
        this.conn.unlockSession();
        ((IfxStatement)statement).currentResult.setTupleSizeReceived(n4);
    }

    private void sendScrollFetch(int n, int n2, IfxResultSetMetaData ifxResultSetMetaData, int n3) throws SQLException {
        int n4 = 0;
        n4 = n3 != 0 ? n3 : (this.tupleBufferSize = this.getTupleBufferSize());
        try {
            this.sendStatementID();
            if (ifxResultSetMetaData.hasVariableLengthColumns) {
                this.sendType(ifxResultSetMetaData, (short)1);
            }
            this.os.writeSmallInt((short)23);
            this.os.writeSmallInt((short)n);
            this.os.writeInt(n2);
            if (this.conn.isXPSVER8_40()) {
                this.os.writeInt(n4);
            } else {
                this.os.writeSmallInt((short)n4);
            }
            if (this.rowColumn == null || this.rowColumn.getInitialSize() < n4) {
                this.rowColumn = new IfxRowColumn(this.conn, ifxResultSetMetaData, n4);
                this.rowColumn.setTrace(this.trace);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    @Override
    public int getTupid() throws SQLException {
        return this.Tupid + this.curRow;
    }

    public InputStream toClobStream(IfxSmBlob ifxSmBlob) throws SQLException {
        InputStream inputStream = null;
        String string = this.conn.getdbEncoding();
        String string2 = this.conn.getclEncoding();
        InputStream inputStream2 = null;
        OutputStream outputStream = null;
        IfxTmpFile ifxTmpFile = null;
        try {
            int n;
            IfxLobInputStream ifxLobInputStream = (IfxLobInputStream)ifxSmBlob.toAsciiStream();
            int n2 = (int)ifxLobInputStream.lobSize;
            int n3 = this.conn.getCodesetLobSize();
            byte[] byArray = null;
            if (n2 <= n3) {
                try {
                    byArray = memoryUtil.allocateMemory((int)ifxLobInputStream.lobSize, this.conn);
                    ifxLobInputStream.read(byArray);
                    inputStream2 = new ByteArrayInputStream(byArray);
                    outputStream = new ByteArrayOutputStream();
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79753, exception.toString(), (IfxConnection)this.conn);
                }
            }
            try {
                inputStream2 = ifxLobInputStream.getStream();
                ifxTmpFile = new IfxTmpFile(this.conn);
                outputStream = ifxTmpFile.getOutputStream();
            }
            catch (Exception exception) {
                throw this.handleSocketException(exception, this.conn);
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream2, string));
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, string2));
            char[] cArray = new char[4096];
            while ((n = bufferedReader.read(cArray)) != -1) {
                ((Writer)bufferedWriter).write(cArray, 0, n);
            }
            ((Reader)bufferedReader).close();
            ((Writer)bufferedWriter).flush();
            ((Writer)bufferedWriter).close();
            inputStream2.close();
            if (n2 <= n3) {
                inputStream = new IfxByteArrayInputStream((ByteArrayOutputStream)outputStream);
            } else {
                outputStream.close();
                inputStream = ifxTmpFile.getInputStream();
            }
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
        return inputStream;
    }

    @Override
    public Vector executeFastPath(String string, Vector vector, boolean bl) throws SQLException {
        this.executeFastPath(string, null, vector, false, bl);
        return this.fpRet;
    }

    @Override
    public void executeFastPath(String string, Vector vector, boolean bl, boolean bl2) throws SQLException {
        this.executeFastPath(string, null, vector, bl, bl2);
    }

    public void executeFastPath(String string, ResultSetMetaData resultSetMetaData, Vector vector, boolean bl, boolean bl2) throws SQLException {
        if (this.fpRet != null) {
            this.fpRet.removeAllElements();
            this.fpRet = null;
        }
        if (this.fpInput != null) {
            this.fpInput.removeAllElements();
            this.fpInput = null;
        }
        if (string == null || !this.conn.isUSVER()) {
            return;
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!this.conn.autoCommit) {
            try {
                this.initiateTransaction();
            }
            catch (SQLException sQLException) {
                this.conn.unlockSession();
                throw sQLException;
            }
        }
        short s = this.xcNewLevel;
        try {
            this.getHandle(string, bl2, bl);
            this.checkFastPathExp(vector, resultSetMetaData);
            this.sendFastPath(this.fpHandle, resultSetMetaData, vector, bl2);
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            if (this.conn.isCommitNeeded() && s < 1 && this.xcNewLevel == 1) {
                this.executeCommit();
                this.doneCommit = true;
            }
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            if (this.conn.isCommitNeeded() && s < 1 && this.xcNewLevel == 1) {
                this.executeCommit();
                this.doneCommit = true;
            }
            throw this.handleSocketException(exception, this.conn);
        }
        this.conn.unlockSession();
        if (this.conn.isCommitNeeded() && s < 1 && this.xcNewLevel == 1) {
            this.executeCommit();
            this.doneCommit = true;
        }
    }

    @Override
    public Vector getFPReturnVector() {
        return this.fpRet;
    }

    private void getHandle(String string, boolean bl, boolean bl2) throws SQLException {
        this.fpHandle = this.conn.getFPCacheRoutineId(string);
        if (this.fpHandle != -1) {
            this.fparam = bl ? this.conn.getFPCacheFParam(string) : null;
        } else {
            try {
                this.partialFParam = false;
                if (bl) {
                    this.fparam = new IfxFParam();
                    this.fparam.hasOutParameter = bl2;
                }
                this.os.writeSmallInt((short)101);
                if (this.conn.isNamedParametersSupported()) {
                    int n = string.indexOf(94);
                    if (n > 0) {
                        this.os.writeByte(1);
                        this.os.writeChar(string.substring(0, n));
                        int n2 = Integer.parseInt(string.substring(n + 1));
                        this.os.writeInt(n2);
                    } else {
                        this.os.writeByte(0);
                        this.os.writeChar(string);
                    }
                } else {
                    this.os.writeChar(string);
                }
                if (bl) {
                    this.os.writeSmallInt((short)1);
                } else {
                    this.os.writeSmallInt((short)0);
                }
                this.receiveMessage();
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw this.handleSocketException(exception, this.conn);
            }
            this.conn.setFPCacheInfo(this.fpHandle, string, this.fparam);
        }
    }

    private void sendFastPath(int n, ResultSetMetaData resultSetMetaData, Vector vector, boolean bl) throws SQLException {
        int n2 = this.conn.isNamedParametersSupported() && resultSetMetaData != null ? resultSetMetaData.getColumnCount() : (vector != null ? vector.size() : 0);
        if (vector != null) {
            this.fpInput = (Vector)vector.clone();
        }
        try {
            this.os.writeSmallInt((short)102);
            if (this.conn.isNamedParametersSupported()) {
                if (this.routineDbName != null) {
                    this.os.writeChar(this.routineDbName);
                } else {
                    this.os.writeChar("");
                }
            }
            this.os.writeInt(n);
            this.os.writeSmallInt((short)n2);
            if (bl) {
                this.os.writeSmallInt((short)1);
            } else {
                this.os.writeSmallInt((short)0);
            }
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
        if (n2 != 0) {
            this.sendBind(vector, resultSetMetaData, n2, 0, n2);
        }
        if (bl) {
            this.sendFParam();
        }
    }

    private void receiveFastPath() throws SQLException {
        Object var7_1 = null;
        this.fpRet = new Vector();
        try {
            short s = this.is.readSmallInt();
            if (this.fparam != null && this.fparam.colInfoArray.length < s) {
                throw IfxErrMsg.getSQLException(-79716, "receiveFastPath colInfoArray too small", (IfxConnection)this.conn);
            }
            for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
                int n;
                IfxColumnInfo ifxColumnInfo = new IfxColumnInfo();
                if (this.fparam != null) {
                    this.fparam.colInfoArray[s2] = ifxColumnInfo;
                }
                if (((n = this.is.readSmallInt()) & 0x800) > 0) {
                    ifxColumnInfo.IsDistinct = true;
                }
                ifxColumnInfo.SQLtype = n &= 0xFF;
                if (ifxColumnInfo.IsDistinct || n >= 18 && n != 52 && n != 53) {
                    ifxColumnInfo.ExtendedOwner = new String(this.is.readChar());
                    ifxColumnInfo.ExtendedName = new String(this.is.readChar());
                }
                n = this.cleanUpFPTypeInfo(s2, n, ifxColumnInfo);
                ifxColumnInfo.Nullable = 1;
                short s3 = this.is.readSmallInt();
                short s4 = this.is.readSmallInt();
                if (s4 != 0 && ifxColumnInfo.ColLength == 0) {
                    ifxColumnInfo.ColLength = s4;
                }
                IfxObject ifxObject = IfxValue.makeInstance(this.conn, ifxColumnInfo);
                ifxObject.setConnection(this.conn);
                if (s3 == -1) {
                    ifxObject.nullify();
                    this.fpRet.addElement(ifxObject);
                    continue;
                }
                switch (n) {
                    case 0: 
                    case 13: 
                    case 15: 
                    case 16: {
                        ifxObject.fromString(this.is.readChar(this.dbEncoding));
                        break;
                    }
                    case 2: 
                    case 6: {
                        ifxObject.fromInt(this.is.readInt());
                        break;
                    }
                    case 7: {
                        ifxObject.fromDate(this.is.readDate());
                        break;
                    }
                    case 1: {
                        ifxObject.fromShort(this.is.readSmallInt());
                        break;
                    }
                    case 17: 
                    case 18: {
                        ifxObject.fromLong(this.is.readLongInt());
                        break;
                    }
                    case 52: 
                    case 53: {
                        ifxObject.fromLong(this.is.readLongBigint());
                        break;
                    }
                    case 4: {
                        ifxObject.fromFloat(this.is.readReal(s4));
                        break;
                    }
                    case 3: {
                        ifxObject.fromDouble(this.is.readDouble(s4));
                        break;
                    }
                    case 5: 
                    case 8: {
                        ifxObject.fromDecimal(this.is.readDecimal(s4));
                        break;
                    }
                    case 14: {
                        Object var10_9 = null;
                        byte by = Interval.getStartCode(s4);
                        if (by == 0 || by == 2) {
                            ifxObject.fromIntervalYM((IntervalYM)this.is.readInterval(s4));
                            break;
                        }
                        ifxObject.fromIntervalDF((IntervalDF)this.is.readInterval(s4));
                        break;
                    }
                    case 10: {
                        if (IfxDateTime.getStartCode(s4) >= 6 && IfxDateTime.getEndCode(s4) <= 10) {
                            ifxObject.fromTimestamp(this.is.readDateTime(s4));
                            Time time = ifxObject.toTime();
                            ifxObject.fromTime(time);
                            break;
                        }
                        ((IfxDateTime)ifxObject).fromRawDateTime(this.is.readRawDateTime(s4), s4);
                        break;
                    }
                    case 40: 
                    case 41: 
                    case 44: {
                        int n2 = this.is.readInt();
                        if (n2 <= 0) break;
                        int n3 = 5;
                        byte[] byArray = new byte[n2 + n3];
                        byArray[0] = 0;
                        byte[] byArray2 = JavaToIfxType.JavaToIfxInt(n2);
                        System.arraycopy(byArray2, 0, byArray, 1, 4);
                        this.is.readPadded(byArray, n3, n2);
                        if (ifxColumnInfo.ExtendedId == 11 || ifxColumnInfo.ExtendedId == 10) {
                            ((IfxSmBlob)ifxObject).fromIfxFP(byArray);
                            break;
                        }
                        ifxObject.fromIfx(byArray);
                        break;
                    }
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: {
                        int n4 = this.is.readShort();
                        n4 = this.is.readInt();
                        if (n4 <= 0) break;
                        byte[] byArray = new byte[n4 + 4];
                        byte[] byArray3 = JavaToIfxType.JavaToIfxInt(n4);
                        System.arraycopy(byArray3, 0, byArray, 0, 4);
                        this.is.read(byArray, 4, n4);
                        ifxObject.fromIfx(byArray);
                        break;
                    }
                    case 11: 
                    case 12: {
                        byte[] byArray = new byte[56];
                        for (int i = 0; i < 56; ++i) {
                            byArray[i] = this.is.readByte();
                        }
                        ifxObject.fromIfx(byArray);
                        break;
                    }
                }
                this.fpRet.addElement(ifxObject);
            }
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private int cleanUpFPTypeInfo(int n, int n2, IfxColumnInfo ifxColumnInfo) {
        boolean bl = false;
        int n3 = -1;
        int n4 = -1;
        if (this.fparam != null) {
            if (n < this.fparam.numberOfOutParams) {
                bl = true;
                n3 = this.fparam.outParamSequence[n];
            } else {
                n4 = n - this.fparam.numberOfOutParams;
            }
        }
        if (n2 == 45) {
            n2 = 44;
            ifxColumnInfo.SQLtype = 44;
            ifxColumnInfo.ExtendedId = 5;
        } else if (n2 == 43) {
            n2 = 44;
            ifxColumnInfo.SQLtype = 44;
            ifxColumnInfo.ExtendedId = 1;
        } else if (n2 == 102) {
            n2 = 44;
            ifxColumnInfo.SQLtype = 44;
            ifxColumnInfo.ExtendedId = 10;
        } else if (n2 == 101) {
            n2 = 44;
            ifxColumnInfo.SQLtype = 44;
            ifxColumnInfo.ExtendedId = 11;
        } else if (this.fparam != null) {
            ifxColumnInfo.ExtendedId = bl ? this.fparam.argType[n3].xid : this.fparam.retType[n4].xid;
        }
        if (bl) {
            IfxObject ifxObject = (IfxObject)this.fpInput.elementAt(n3);
            String string = ifxObject.getExtendedTypeName();
            if (string != null && string.trim().length() != 0) {
                ifxColumnInfo.ExtendedName = string;
            }
            if (n2 == 40 || n2 == 41) {
                if (ifxObject instanceof IfxRow) {
                    n2 = 22;
                    ifxColumnInfo.SQLtype = 22;
                } else if (ifxObject instanceof IfxCollection) {
                    n2 = 20;
                    ifxColumnInfo.SQLtype = 20;
                }
            }
        }
        return n2;
    }

    private void receiveHandle() throws SQLException {
        try {
            if (this.conn.isNamedParametersSupported()) {
                this.routineDbName = this.is.readChar();
            }
            this.fpHandle = this.is.readInt();
            if (this.idesc != null) {
                this.idesc.routineDbName = this.routineDbName;
                this.idesc.fpHandle = this.fpHandle;
            }
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private void receiveFParam() throws SQLException {
        this.totalOutValues = 0;
        this.totalOutParams = 0;
        if (this.fparam == null) {
            throw IfxErrMsg.getSQLException(-79716, "IfxSqli.receiveFParam() fparam is null", (IfxConnection)this.conn);
        }
        try {
            this.fparam.funcState = this.is.readLong();
            this.fparam.request = this.is.readInt();
            byte by = this.is.readByte();
            this.fparam.isDone = by != 0;
            if (this.partialFParam) {
                return;
            }
            this.fparam.id = this.is.readInt();
            this.fparam.row = this.is.readLong();
            this.fparam.colid = this.is.readInt();
            this.fparam.nrets = this.is.readShort();
            if (this.fparam.nrets > 0) {
                this.fparam.retNull = new boolean[this.fparam.nrets];
                this.fparam.retType = new IfxFParam.FPTypeInfo[this.fparam.nrets];
                this.readFPTypeInfo(false, this.fparam.nrets, this.fparam.retNull, this.fparam.retType, "Return", this.fparam.outParamSequence);
                this.totalOutValues = this.fparam.nrets;
            }
            this.fparam.nargs = this.is.readShort();
            boolean bl = false;
            boolean bl2 = false;
            if (this.conn.isNamedParametersSupported()) {
                short s = this.is.readSmallInt();
                bl = (s & 1) != 0;
                boolean bl3 = bl2 = (s & 2) != 0;
            }
            if (this.fparam.nargs > 0) {
                this.fparam.argNull = new boolean[this.fparam.nargs];
                this.fparam.argType = new IfxFParam.FPTypeInfo[this.fparam.nargs];
                this.fparam.outParamSequence = new int[this.fparam.nargs];
                this.readFPTypeInfo(bl, this.fparam.nargs, this.fparam.argNull, this.fparam.argType, "Parameter", this.fparam.outParamSequence);
            }
            if (this.fparam.hasOutParameter && !this.conn.isMultipleUdrOutSupported()) {
                ++this.totalOutValues;
                this.totalOutParams = 1;
                this.fparam.outParamSequence[0] = this.fparam.nargs - 1;
            }
            this.fparam.numberOfOutParams = this.totalOutParams;
            this.fparam.colInfoArray = new IfxColumnInfo[this.totalOutValues];
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
        this.partialFParam = true;
    }

    private void readFPTypeInfo(boolean bl, int n, boolean[] blArray, IfxFParam.FPTypeInfo[] fPTypeInfoArray, String string, int[] nArray) throws SQLException {
        try {
            for (int i = 0; i < n; ++i) {
                byte by;
                fPTypeInfoArray[i] = new IfxFParam.FPTypeInfo();
                if (bl) {
                    byte by2 = this.is.readByte();
                    String string2 = this.is.readChar();
                }
                blArray[i] = (by = this.is.readByte()) != 0;
                fPTypeInfoArray[i].type = this.is.readShort();
                fPTypeInfoArray[i].xid = this.is.readInt();
                if (!this.conn.is902()) continue;
                fPTypeInfoArray[i].len = this.is.readInt();
                fPTypeInfoArray[i].precision = this.is.readShort();
                fPTypeInfoArray[i].scale = this.is.readShort();
                if (!this.conn.isMultipleUdrOutSupported() || string != "Parameter") continue;
                fPTypeInfoArray[i].mode = this.is.readShort();
                if (fPTypeInfoArray[i].mode != 1) continue;
                ++this.totalOutValues;
                ++this.totalOutParams;
                nArray[this.totalOutParams - 1] = i;
            }
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private void sendFParam() throws SQLException {
        if (this.fparam == null) {
            throw IfxErrMsg.getSQLException(-79716, "IfxSqli.sendFParam() fparam is null", (IfxConnection)this.conn);
        }
        try {
            this.os.writeSmallInt((short)104);
            this.os.writeLong(this.fparam.funcState);
            this.os.writeInt(this.fparam.request);
            if (this.fparam.isDone) {
                this.os.writeByte(0);
            } else {
                this.os.writeByte(1);
            }
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    @Override
    public IfxFParam getFParam() {
        return this.fparam;
    }

    @Override
    public int executeReadSmBlob(int n, byte[] byArray, int n2) throws SQLException {
        this.BlobBuffer = byArray;
        this.BlobRequestSize = n2;
        this.BlobFd = null;
        this.BlobWriteOffset = 0;
        this.BufferOrStream = 0;
        this.BlobWriteFailure = 0;
        this.amountRW = 0;
        return this.doLoData((short)0, n, n2, 0);
    }

    @Override
    public int executeReadSmBlob(int n, byte[] byArray, int n2, int n3) throws SQLException {
        this.BlobBuffer = byArray;
        this.BlobRequestSize = n2;
        this.BlobFd = null;
        this.BlobWriteOffset = 0;
        this.BufferOrStream = 0;
        this.BlobWriteFailure = 0;
        this.amountRW = 0;
        return this.doLoData((short)1, n, n2, n3);
    }

    @Override
    public int executeReadSmBlob(int n, FileOutputStream fileOutputStream, int n2) throws SQLException {
        this.BlobBuffer = null;
        this.BlobRequestSize = n2;
        this.BlobFd = fileOutputStream;
        this.BlobWriteOffset = 0;
        this.BufferOrStream = 1;
        this.amountRW = 0;
        return this.doLoData((short)0, n, n2, 0);
    }

    private int doLoData(short s, int n, int n2, int n3) throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendLoData(s, n, n2, n3);
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            SQLException sQLException = IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
            sQLException = IfxErrMsg.setSQLExceptionCause(sQLException, exception);
            throw sQLException;
        }
        this.conn.unlockSession();
        return this.amountRW;
    }

    @Override
    public int executeWriteSmBlob(int n, byte[] byArray) throws SQLException {
        return this.executeWriteSmBlob(n, byArray, 0, byArray == null ? 0 : byArray.length);
    }

    @Override
    public int executeWriteSmBlob(int n, byte[] byArray, int n2, int n3) throws SQLException {
        int n4 = n3;
        int n5 = n2;
        int n6 = 0;
        this.amountRW = 0;
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendLoData((short)2, n, n4, 0);
            while (n4 > 0) {
                try {
                    n6 = n4 < 32000 ? n4 : 32000;
                    this.os.writeSmallInt((short)n6);
                    this.os.writePadded(byArray, n5, n6);
                    n4 -= n6;
                    n5 += n6;
                }
                catch (Exception exception) {
                    SQLException sQLException = IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
                    sQLException = IfxErrMsg.setSQLExceptionCause(sQLException, exception);
                    throw sQLException;
                }
            }
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw this.handleSocketException(exception, this.conn);
        }
        this.conn.unlockSession();
        return this.amountRW;
    }

    @Override
    public int executeWriteSmBlob(int n, InputStream inputStream, int n2) throws SQLException {
        InputStream inputStream2 = inputStream instanceof IfxLobInputStream ? ((IfxLobInputStream)inputStream).getStream() : inputStream;
        int n3 = n2;
        boolean bl = false;
        int n4 = 0;
        this.amountRW = 0;
        int n5 = 0;
        byte[] byArray = new byte[32000];
        boolean bl2 = false;
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendLoData((short)2, n, n3, 0);
            while (n3 > 0) {
                try {
                    n4 = n3 < 32000 ? n3 : 32000;
                    n5 = inputStream2.read(byArray, 0, n4);
                    if (n5 <= 0) {
                        bl2 = true;
                        n5 = n4;
                    }
                    this.os.writeSmallInt((short)n5);
                    this.os.writePadded(byArray, 0, n5);
                    n3 -= n5;
                }
                catch (Exception exception) {
                    bl2 = true;
                }
            }
            this.receiveMessage();
            if (bl2) {
                throw IfxErrMsg.getSQLException(-79752, this.conn);
            }
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw this.handleSocketException(exception, this.conn);
        }
        this.conn.unlockSession();
        return this.amountRW;
    }

    private void sendLoData(short s, int n, int n2, int n3) throws SQLException {
        try {
            this.os.writeSmallInt((short)97);
            this.os.writeSmallInt(s);
            this.os.writeSmallInt((short)n);
            this.os.writeInt(n2);
            this.os.writeSmallInt((short)32000);
            if (s == 1) {
                this.os.writeLongInt(n3);
                this.os.writeSmallInt((short)1);
            }
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private void receiveLODATA() throws SQLException {
        short s = 0;
        int n = 0;
        try {
            s = this.is.readSmallInt();
            n = this.is.readInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (s == 2) {
            if (n < 0) {
                this.isamcode = n;
                this.amountRW = -1;
                this.setSQLerrd((short)1, this.isamcode);
                this.addException(IfxErrMsg.getSQLException(-9810, this.conn));
                this.addException(this.isamcode, null);
            } else {
                this.amountRW = n;
            }
            return;
        }
        if (n < 1) {
            try {
                short s2 = this.is.readSmallInt();
            }
            catch (Exception exception) {
                throw this.handleSocketException(exception, this.conn);
            }
            this.amountRW = 0;
            return;
        }
        byte[] byArray = null;
        if (this.BlobRequestSize > n) {
            this.BlobRequestSize = n;
        }
        short s3 = 0;
        while (this.BlobRequestSize > 0) {
            try {
                s3 = this.is.readSmallInt();
                if (s3 < 0) {
                    this.amountRW = -1;
                    return;
                }
                byArray = new byte[s3];
                int n2 = this.is.readPadded(byArray);
            }
            catch (Exception exception) {
                throw this.handleSocketException(exception, this.conn);
            }
            if (this.BlobWriteFailure != 0) continue;
            try {
                this.blobDataWrite(byArray, this.BlobWriteOffset, s3);
                this.BlobWriteOffset += s3;
            }
            catch (Exception exception) {
                this.BlobWriteFailure = 1;
            }
            this.amountRW += s3;
            this.BlobRequestSize -= s3;
        }
    }

    private void receiveSQFILE() throws SQLException {
        int n = -1;
        byte[] byArray = null;
        int n2 = -1;
        long l = 0L;
        int n3 = -1;
        int n4 = 0;
        try {
            n = this.is.readSmallInt();
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
        switch (n) {
            case 0: {
                try {
                    short s = this.is.readSmallInt();
                    byte[] byArray2 = new byte[s];
                    this.is.readPadded(byArray2);
                    this.copyToFileName = stringUtil.getString(byArray2, this.dbEncoding);
                    this.copyToFileMode = this.is.readInt();
                    this.copyToFileFlags = this.is.readInt();
                    this.copyToFileOffset = this.is.readInt();
                    n3 = this.is.readSmallInt();
                }
                catch (Exception exception) {
                    throw this.handleSocketException(exception, this.conn);
                }
                if (n3 != 12) {
                    this.sendSQFILEError(-408);
                    break;
                }
                if (System.getProperty("java.vendor").startsWith("Netscape")) {
                    // empty if block
                }
                try {
                    this.copyToFileFd = new File(this.copyToFileName);
                }
                catch (NullPointerException nullPointerException) {
                    this.copyToFileFd = null;
                    this.sendSQFILEError(2);
                    break;
                }
                try {
                    if ((this.copyToFileFlags & 0x10) != 0) {
                        if (!this.copyToFileFd.exists()) {
                            this.copyToFileFd = null;
                            this.sendSQFILEError(2);
                            break;
                        }
                        this.copyToFileFd.setReadOnly();
                    }
                    if ((this.copyToFileFlags & 1) == 0 || !this.copyToFileFd.exists()) break;
                    this.copyToFileFd = null;
                    this.sendSQFILEError(17);
                    break;
                }
                catch (SecurityException securityException) {
                    throw this.handleSocketException(securityException, this.conn);
                }
            }
            case 2: {
                long l2;
                n3 = 0;
                long l3 = 0L;
                boolean bl = false;
                try {
                    n2 = this.is.readSmallInt();
                    l = this.is.readInt();
                    n3 = this.is.readSmallInt();
                }
                catch (Exception exception) {
                    this.sendSQFILEError(-408);
                    break;
                }
                if (n3 != 12) {
                    this.sendSQFILEError(-408);
                    break;
                }
                if (this.copyToFileFd == null) {
                    this.sendSQFILEError(9);
                    break;
                }
                try {
                    this.loFile = new RandomAccessFile(this.copyToFileFd, "r");
                    l2 = this.loFile.length();
                }
                catch (IOException iOException) {
                    this.sendSQFILEError(9);
                    break;
                }
                if ((long)this.copyToFileOffset > l2) {
                    this.sendSQFILEError(9);
                    break;
                }
                try {
                    byArray = new byte[n2];
                }
                catch (Exception exception) {
                    this.sendSQFILEError(-406);
                    break;
                }
                try {
                    this.os.writeSmallInt((short)106);
                }
                catch (Exception exception) {
                    throw this.handleSocketException(exception, this.conn);
                }
                try {
                    this.os.writeInt((int)l);
                }
                catch (Exception exception) {
                    throw this.handleSocketException(exception, this.conn);
                }
                try {
                    this.loFile.seek(this.copyToFileOffset);
                }
                catch (IOException iOException) {
                    this.sendSQFILEError(29);
                    break;
                }
                int n5 = 0;
                try {
                    for (l = l == -1L ? l2 - (long)this.copyToFileOffset : (l2 - (long)this.copyToFileOffset < l ? l2 - (long)this.copyToFileOffset : l); l > 0L; l -= (long)n5) {
                        l3 = (long)n2 < l ? (long)n2 : l;
                        try {
                            n5 = this.loFile.read(byArray, 0, (int)l3);
                        }
                        catch (Exception exception) {
                            break;
                        }
                        this.os.writeSmallInt((short)106);
                        this.os.writeSmallInt((short)n5);
                        this.os.writePadded(byArray, 0, n5);
                    }
                }
                catch (Exception exception) {
                    throw this.handleSocketException(exception, this.conn);
                }
                if (l <= 0L) break;
                this.sendSQFILEError(5);
                break;
            }
            case 3: {
                if (this.copyToFileFd == null) {
                    this.sendSQFILEError(9);
                    break;
                }
                n4 = 0;
                try {
                    this.loFile = new RandomAccessFile(this.copyToFileFd, "rw");
                    if ((this.copyToFileFlags & 2) != 0) {
                        if (this.copyToFileOffset != 0) {
                            this.loFile.seek(this.copyToFileOffset);
                        } else {
                            this.loFile.seek(this.loFile.length());
                        }
                    }
                }
                catch (Exception exception) {
                    this.sendSQFILEError(13);
                    break;
                }
                try {
                    while (true) {
                        short s = this.is.readSmallInt();
                        n3 = s;
                        if (s == 107) {
                            n2 = this.is.readSmallInt();
                            byte[] byArray3 = new byte[n2];
                            this.is.readPadded(byArray3);
                            if ((this.copyToFileFlags & 0x80) != 0) {
                                this.loFile.writeChars(new String(byArray3));
                                continue;
                            }
                            this.loFile.write(byArray3, 0, n2);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    n4 = 2;
                    break;
                }
                try {
                    if (n3 == 13) {
                        n4 = this.is.readSmallInt();
                    }
                    if (n4 != 0) {
                        this.sendSQFILEError(n4);
                        break;
                    }
                    long l4 = this.loFile.length();
                    this.os.writeSmallInt((short)107);
                    this.os.writeInt((int)l4);
                    break;
                }
                catch (IOException iOException) {
                    throw this.handleSocketException(iOException, this.conn);
                }
            }
            case 1: {
                try {
                    n3 = this.is.readSmallInt();
                }
                catch (IOException iOException) {
                    n3 = 0;
                }
                if (n3 != 12) {
                    this.sendSQFILEError(-408);
                    break;
                }
                try {
                    if (this.copyToFileFd == null) break;
                    this.loFile.close();
                }
                catch (IOException iOException) {}
                break;
            }
        }
        this.flip();
    }

    @Override
    public void executeProtocols(byte[] byArray) throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendProtocols(byArray);
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw this.handleSocketException(exception, this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendProtocols(byte[] byArray) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            throw IfxErrMsg.getSQLException(-79716, this.conn);
        }
        try {
            this.os.writeSmallInt((short)126);
            this.os.writeSmallInt((short)byArray.length);
            this.os.writePadded(byArray);
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private void receiveProtocols() throws SQLException {
        short s;
        try {
            s = this.is.readSmallInt();
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
        try {
            this.serverProtocol = new byte[s];
            int n = this.is.readPadded(this.serverProtocol);
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    @Override
    public byte[] getProtocols() {
        return this.serverProtocol;
    }

    private void sendSQFILEError(int n) throws SQLException {
        try {
            this.os.writeSmallInt((short)13);
            this.os.writeSmallInt((short)n);
            this.os.writeSmallInt((short)0);
            this.os.writeSmallInt((short)0);
            this.os.writeSmallInt((short)0);
        }
        catch (IOException iOException) {
            throw this.handleSocketException(iOException, this.conn);
        }
    }

    private void sendPut(IfxPreparedStatement ifxPreparedStatement) throws SQLException {
        IfxResultSetMetaData ifxResultSetMetaData = (IfxResultSetMetaData)ifxPreparedStatement.getOutPutMetaData();
        if (ifxPreparedStatement.executeBatchInProgress) {
            this.executeBatchInProgress = true;
        }
        try {
            if (!ifxPreparedStatement.cursorOpen) {
                this.sendQuery(ifxPreparedStatement, false, null);
            } else {
                this.sendStatementID();
            }
            if (!ifxResultSetMetaData.hasVariableLengthColumns && ifxResultSetMetaData.textByteColumnCount <= 0) {
                byte[] byArray = null;
                byte[] byArray2 = ifxPreparedStatement.getAllRows();
                while ((byArray = ifxPreparedStatement.getNextRowBatch(byArray2)) != null) {
                    this.os.writeSmallInt((short)17);
                    if (!this.conn.isUSVER()) {
                        this.os.writeSmallInt(this.desc.getTupleSize());
                    } else {
                        this.os.writeInt(this.getTupleSize());
                    }
                    if (this.conn.isXPSVER8_40()) {
                        this.os.writeInt(ifxPreparedStatement.getNumRowsCurrBatch());
                    } else {
                        this.os.writeSmallInt((short)ifxPreparedStatement.getNumRowsCurrBatch());
                    }
                    this.os.write(byArray);
                    if (!this.executeBatchInProgress) continue;
                    this.receiveMessage();
                    this.sendStatementID();
                }
            } else {
                if (ifxResultSetMetaData.textByteColumnCount > 0) {
                    // empty if block
                }
                if (ifxResultSetMetaData.hasVariableLengthColumns && !this.typeSent) {
                    this.sendType((IfxResultSetMetaData)ifxPreparedStatement.getOutPutMetaData(), (short)0);
                    this.typeSent = true;
                }
                for (int i = 0; i < ifxPreparedStatement.getBatchCount(); ++i) {
                    this.os.writeSmallInt((short)17);
                    byte[] byArray = ifxPreparedStatement.getNextRow();
                    if (!this.conn.isUSVER()) {
                        this.os.writeSmallInt((short)byArray.length);
                    } else {
                        this.os.writeInt(byArray.length);
                    }
                    if (this.conn.isXPSVER8_40()) {
                        this.os.writeInt(1);
                    } else {
                        this.os.writeSmallInt((short)1);
                    }
                    this.os.writePadded(byArray);
                    for (int j = i * ifxResultSetMetaData.textByteColumnCount; j < i * ifxResultSetMetaData.textByteColumnCount + ifxResultSetMetaData.textByteColumnCount; ++j) {
                        IfxBlob ifxBlob = ifxPreparedStatement.getIfxBlobAt(j);
                        if (ifxBlob == null) continue;
                        if (ifxBlob.isBlobByteType()) {
                            this.sendBytesBlob(this.os, ifxBlob.getBlobBuffer());
                            continue;
                        }
                        this.sendStreamBlob(this.os, ifxBlob.getBlobInputStream(), ifxBlob.getBlobLength());
                    }
                    if (((IfxResultSetMetaData)ifxPreparedStatement.getOutPutMetaData()).usingIMPEXP()) {
                        this.receiveMessage();
                    }
                    if (!this.executeBatchInProgress || this.os.getBytesSentSinceLastEOT() < (this.conn.isXPSVER8_40() ? Short.MAX_VALUE : this.conn.getMaxFetchBufSize())) continue;
                    this.receiveMessage();
                    this.sendStatementID();
                    if (!ifxResultSetMetaData.hasVariableLengthColumns) continue;
                    this.sendType((IfxResultSetMetaData)ifxPreparedStatement.getOutPutMetaData(), (short)0);
                }
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    String parseDbName(Statement statement) {
        String string = null;
        String string2 = null;
        try {
            String string3 = ((IfxStatement)statement).commandString;
            StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
            string = stringTokenizer.nextToken();
            if (string.equalsIgnoreCase("CLOSE")) {
                if (string.equalsIgnoreCase("DATABASE")) {
                    string2 = null;
                }
            } else if (string.equalsIgnoreCase("DATABASE")) {
                string2 = stringTokenizer.nextToken();
            } else if (string.equalsIgnoreCase("CREATE") && (string = stringTokenizer.nextToken()).equalsIgnoreCase("DATABASE")) {
                string2 = stringTokenizer.nextToken();
            }
        }
        catch (Exception exception) {
            string2 = null;
        }
        if (string2 != null && string2.endsWith(";")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    @Override
    public int incRefCount(byte[] byArray) throws SQLException {
        return 0;
    }

    @Override
    public int decRefCount(byte[] byArray) throws SQLException {
        return 0;
    }

    protected void setIsReleased(boolean bl) {
        this.isReleased = bl;
    }

    int getStatementID() {
        return this.statementID;
    }

    void initiateTransaction() throws SQLException {
        if (!this.conn.inXATransaction() && this.conn.db_use_log && !this.conn.AnsiDb && this.TxStmt != 1) {
            if (this.conn.TxState == 1) {
                this.sendBegin();
                this.receiveMessage();
                this.conn.setTxBeginState();
            }
        }
        if (this.conn.AnsiDb && !this.conn.autoCommit) {
            this.conn.TxState = (short)2;
        }
    }

    @Override
    public IfxResultSetMetaData executeDescribeInput() throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendCIDescribe();
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw this.handleSocketException(exception, this.conn);
        }
        this.conn.unlockSession();
        return this.idesc;
    }

    private void sendCIDescribe() throws SQLException {
        try {
            this.sendStatementID();
            this.os.writeSmallInt((short)124);
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private void receiveIDescribe() throws SQLException {
        this.recvIDescribe(false);
    }

    private void recvIDescribe(boolean bl) throws SQLException {
        short s = 0;
        int n = 0;
        try {
            short s2;
            s = this.is.readSmallInt();
            this.idesc = new IfxResultSetMetaData(s, this.conn);
            boolean bl2 = false;
            boolean bl3 = false;
            int n2 = -1;
            if (this.conn.isNamedParametersSupported() && s != 0) {
                s2 = this.is.readSmallInt();
                bl2 = (s2 & 1) != 0;
                boolean bl4 = bl3 = (s2 & 2) != 0;
                if (!bl && bl2) {
                    n2 = this.is.readSmallInt();
                }
                this.idesc.namedFlags = s2;
                this.idesc.numArgsRoutine = n2;
            }
            if (s > 0) {
                for (s2 = 1; s2 <= s; s2 = (short)(s2 + 1)) {
                    if (bl2) {
                        byte by = this.is.readByte();
                        String string = this.is.readChar();
                        this.idesc.setArgumentFlags(s2, by);
                        this.idesc.setArgumentName(s2, string);
                    }
                    short s3 = this.is.readSmallInt();
                    this.idesc.setIfxColumnType(s2, s3);
                    n = this.is.readInt();
                    this.idesc.setColumnExtendedId(s2, n);
                    String string = new String(this.is.readChar());
                    this.idesc.setExtendedOwnerName(s2, string);
                    string = new String(this.is.readChar());
                    this.idesc.setExtendedName(s2, string);
                    s3 = this.is.readSmallInt();
                    this.idesc.setReference(s2, s3);
                    s3 = this.is.readSmallInt();
                    this.idesc.setAlignment(s2, s3);
                    n = this.is.readInt();
                    this.idesc.setSourceType(s2, n);
                    n = this.is.readInt();
                    this.idesc.setEncodedLength(s2, n);
                    if (!bl) continue;
                    s3 = this.is.readSmallInt();
                    this.idesc.setMode(s2, s3);
                }
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private void receiveSGKDescribe() throws SQLException {
        short s = 0;
        int n = 0;
        String string = null;
        short[] sArray = null;
        try {
            short s2;
            this.SGK_statementType = this.is.readSmallInt();
            this.SGK_statementID = this.is.readSmallInt();
            n = this.is.readInt();
            this.setSQLerrd((short)3, n);
            short s3 = this.is.readSmallInt();
            s = this.is.readSmallInt();
            this.SGK_desc = new IfxResultSetMetaData(s, this.conn);
            this.SGK_desc.setTupleSize(s3);
            short s4 = this.is.readSmallInt();
            this.SGK_TxStmt = 0;
            if (this.statementType == 34) {
                this.SGK_TxStmt = 1;
            } else if (this.statementType == 35 || this.statementType == 36) {
                this.SGK_TxStmt = (short)2;
            }
            if (s > 0) {
                sArray = new short[s];
                for (s2 = 1; s2 <= s; s2 = (short)(s2 + 1)) {
                    short s5;
                    sArray[s2 - 1] = this.is.readSmallInt();
                    if (this.conn.isUSVER()) {
                        n = this.is.readInt();
                        this.SGK_desc.setColumnStartPosition(s2, n);
                    } else {
                        s5 = this.is.readSmallInt();
                        this.SGK_desc.setColumnStartPosition(s2, s5);
                    }
                    s5 = this.is.readSmallInt();
                    this.SGK_desc.setIfxColumnType(s2, s5);
                    if (this.conn.isUSVER()) {
                        n = this.is.readInt();
                        this.SGK_desc.setColumnExtendedId(s2, n);
                        String string2 = new String(this.is.readChar(this.dbEncoding));
                        this.SGK_desc.setExtendedOwnerName(s2, string2);
                        string2 = new String(this.is.readChar());
                        this.SGK_desc.setExtendedName(s2, string2);
                        s5 = this.is.readSmallInt();
                        this.SGK_desc.setReference(s2, s5);
                        s5 = this.is.readSmallInt();
                        this.SGK_desc.setAlignment(s2, s5);
                        n = this.is.readInt();
                        this.SGK_desc.setSourceType(s2, n);
                        n = this.is.readInt();
                        this.SGK_desc.setEncodedLength(s2, n);
                        continue;
                    }
                    s5 = this.is.readSmallInt();
                    this.SGK_desc.setEncodedLength(s2, s5);
                }
                this.SGK_desc.setTextByteColumnCount();
            }
            if (s4 > 0) {
                byte[] byArray = new byte[s4];
                this.is.readPadded(byArray);
                string = this.conn.ifxtojava.IfxToJavaChar(byArray, this.dbEncoding);
            }
            s2 = 100;
            this.SGK_rowColumn = new IfxRowColumn(this.conn, this.SGK_desc, 100);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
        if (string != null) {
            String string3 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0000");
            for (short s6 = 0; s6 < s; s6 = (short)(s6 + 1)) {
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    this.SGK_desc.setColumnName(s6 + 1, string3);
                    continue;
                }
                this.SGK_desc.setColumnName(s6 + 1, null);
            }
        }
        if (this.conn != null) {
            this.SGK_desc.setDelimIdent(this.conn.isDelimIdentSet());
        }
    }

    private void receiveSGKTuple() throws SQLException {
        try {
            short s = this.is.readSmallInt();
            int n = this.conn.isUSVER() ? this.is.readInt() : (int)this.is.readSmallInt();
            if (this.SGK_rowColumn == null) {
                throw IfxErrMsg.getSQLException(-79716, "No SGK_DESCRIBE", (IfxConnection)this.conn);
            }
            if (n > 0) {
                this.SGK_rowColumn.readTuple(this.is, this.SGK_totalTupleSize, n);
                this.SGK_totalTupleSize += n;
                if (++this.SGK_totalTuples >= this.SGK_offsetVector.size()) {
                    this.SGK_offsetVector.setSize(this.SGK_totalTuples + 100);
                    this.SGK_offsetVector.setElementAt(new Integer(0), 0);
                }
                this.SGK_offsetVector.setElementAt(new Integer(this.SGK_totalTupleSize), this.SGK_totalTuples);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    @Override
    public void handlePAMAuthentication(String string) throws SQLException {
        IfmxPAM ifmxPAM = null;
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                ifmxPAM = (IfmxPAM)clazz.newInstance();
            }
            catch (Exception exception) {
                throw this.handleSocketException(exception, this.conn);
            }
        }
        boolean bl = false;
        IfxPAMChallenge ifxPAMChallenge = null;
        IfxPAMResponse ifxPAMResponse = null;
        try {
            this.sendACK();
            this.flip();
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
        while (!this.userPAMAuthorized && !bl) {
            boolean bl2;
            ifxPAMChallenge = this.readPAMChallengeMessage();
            if (this.userPAMAuthorized) {
                bl = true;
                continue;
            }
            if (ifxPAMChallenge == null) {
                bl = true;
                continue;
            }
            if (string == null) {
                throw IfxErrMsg.getSQLException(-79716, this.conn);
            }
            switch (ifxPAMChallenge.getChallengeType()) {
                case 3: 
                case 4: {
                    bl2 = false;
                    break;
                }
                default: {
                    bl2 = true;
                }
            }
            ifxPAMResponse = ifmxPAM.IfxPAM(ifxPAMChallenge);
            if (ifxPAMResponse.getTerminateConnection()) {
                this.sendExit();
                bl = true;
                continue;
            }
            if (!bl2) continue;
            this.sendPAMResponseMessage(ifxPAMResponse);
        }
        if (!this.userPAMAuthorized && bl) {
            throw IfxErrMsg.getSQLException(-79885, this.conn);
        }
    }

    private IfxPAMChallenge readPAMChallengeMessage() throws SQLException {
        byte[] byArray = new byte[513];
        IfxPAMChallenge ifxPAMChallenge = null;
        this.clearExceptions();
        try {
            short s = this.is.readSmallInt();
            switch (s) {
                case 56: {
                    this.sendExit();
                    break;
                }
                case 127: {
                    this.userPAMAuthorized = true;
                    this.receiveEOT();
                    break;
                }
                case 129: {
                    short s2 = this.is.readSmallInt();
                    short s3 = this.is.readSmallInt();
                    this.is.readPadded(byArray, 0, s3);
                    ifxPAMChallenge = new IfxPAMChallenge(this.conn.ifxtojava.IfxToJavaChar(byArray), s2);
                    this.receiveEOT();
                    break;
                }
                default: {
                    this.setError(-408);
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            this.addException(sQLException);
        }
        catch (Exception exception) {
            this.addException(IfxErrMsg.getSQLException(-79716, this.conn));
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return ifxPAMChallenge;
    }

    private void sendPAMResponseMessage(IfxPAMResponse ifxPAMResponse) throws SQLException {
        String string = ifxPAMResponse.getResponse();
        short s = 0;
        if (ifxPAMResponse != null && string != null) {
            if (string.length() > 512) {
                throw IfxErrMsg.getSQLException(-79886, this.conn);
            }
            s = (short)string.length();
        }
        try {
            this.os.writeSmallInt((short)130);
            this.os.writeSmallInt(s);
            if (s != 0) {
                byte[] byArray = this.conn.javatoifx.JavaToIfxChar(ifxPAMResponse.challengeResponse);
                this.os.writePadded(byArray, 2, byArray.length - 2);
            }
            this.sendEOT();
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    @Override
    public IfxResultSetMetaData executeFPDescribe(String string, boolean bl, String string2, int n) throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendCFPDescribe(string, bl, string2, n);
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw this.handleSocketException(exception, this.conn);
        }
        this.conn.unlockSession();
        return this.idesc;
    }

    private void sendCFPDescribe(String string, boolean bl, String string2, int n) throws SQLException {
        try {
            this.os.writeSmallInt((short)131);
            if (this.conn.isNamedParametersSupported()) {
                int n2 = string.indexOf(94);
                if (n2 > 0) {
                    this.os.writeByte(1);
                    this.os.writeChar(string.substring(0, n2));
                    int n3 = Integer.parseInt(string.substring(n2 + 1));
                    this.os.writeInt(n3);
                } else {
                    this.os.writeByte(0);
                    if (bl) {
                        this.os.writeSmallInt((short)0);
                    } else {
                        this.os.writeSmallInt((short)1);
                    }
                    this.os.writeChar(string2);
                    this.os.writeInt(n);
                }
            } else {
                if (bl) {
                    this.os.writeSmallInt((short)0);
                } else {
                    this.os.writeSmallInt((short)1);
                }
                this.os.writeChar(string2);
                this.os.writeInt(n);
            }
            this.sendEOT();
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    private void receiveIFPDescribe() throws SQLException {
        try {
            this.recvIDescribe(true);
        }
        catch (SQLException sQLException) {
            this.addException(sQLException);
        }
        catch (Exception exception) {
            this.addException(IfxErrMsg.getSQLException(-79716, this.conn));
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public boolean getNextSGKRow() throws SQLException {
        int n = this.SGK_totalTuples - (this.SGK_curRow + 1);
        int n2 = this.SGK_totalTuples;
        if (n == 0) {
            return false;
        }
        ++this.SGK_curRow;
        this.SGK_curOffset = (Integer)this.SGK_offsetVector.elementAt(this.SGK_curRow);
        this.SGK_rowColumn.setOffsetInTuple(this.SGK_curOffset);
        return true;
    }

    private void sendSGKPrepare(IfxStatement ifxStatement) throws SQLException {
        try {
            this.os.writeSmallInt((short)134);
            this.os.writeSmallInt(ifxStatement.SGK_returnGeneratedKeys);
            if (ifxStatement.SGK_returnGeneratedKeys == 2) {
                int n = 0;
                if (ifxStatement.SGK_indexes != null) {
                    n = ifxStatement.SGK_indexes.length;
                }
                this.os.writeSmallInt((short)n);
                for (int i = 0; i < n; ++i) {
                    this.os.writeSmallInt((short)ifxStatement.SGK_indexes[i]);
                }
            } else if (ifxStatement.SGK_returnGeneratedKeys == 3) {
                int n = 0;
                if (ifxStatement.SGK_names != null) {
                    n = ifxStatement.SGK_names.length;
                }
                this.os.writeSmallInt((short)n);
                for (int i = 0; i < n; ++i) {
                    this.os.writeChar(ifxStatement.SGK_names[i]);
                }
            }
        }
        catch (Exception exception) {
            throw this.handleSocketException(exception, this.conn);
        }
    }

    public int getNumberOfFetches() {
        return this.numberOfFetches;
    }

    protected int getNumberOfTuplesReceived() {
        return this.numberOfTuplesReceived;
    }

    private SQLException handleSocketException(Exception exception, IfxSqliConnect ifxSqliConnect) {
        if (ifxSqliConnect != null) {
            ifxSqliConnect.isOpen = false;
        }
        SQLException sQLException = IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)ifxSqliConnect);
        IfxErrMsg.setSQLExceptionCause(sQLException, exception);
        return sQLException;
    }

    private void checkFastPathExp(Vector vector, ResultSetMetaData resultSetMetaData) throws SQLException {
        int n = this.conn.isNamedParametersSupported() && resultSetMetaData != null ? resultSetMetaData.getColumnCount() : (vector != null ? vector.size() : 0);
        for (int i = 0; i < n; ++i) {
            IfxObject ifxObject = null;
            if (i < vector.size()) {
                ifxObject = (IfxObject)vector.elementAt(i);
            }
            if (ifxObject != null) continue;
            int n2 = i % n + 1;
            if (resultSetMetaData != null && ((IfxResultSetMetaData)resultSetMetaData).hasDefaultValue(n2)) {
                return;
            }
            throw IfxErrMsg.getSQLException(-79823, ((IfxResultSetMetaData)resultSetMetaData).getArgumentName(n2), (IfxConnection)this.conn);
        }
    }

    private class FPCacheInfo {
        int routineId = -1;
        IfxFParam fparam = null;

        private FPCacheInfo() {
        }
    }
}

