/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.util.IfxErrMsg;
import com.informix.util.dateUtil;
import com.informix.util.memoryUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class IfxVarChar
extends IfxObject {
    private static final int MAXVCLEN = 255;
    protected String value;

    IfxVarChar() throws SQLException {
        this.setIfxType(13);
    }

    IfxVarChar(String string) throws SQLException {
        this.setIfxType(13);
        this.value = string;
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    @Override
    public byte[] toIfx() throws SQLException {
        try {
            String string = this.conn.getdbEncoding();
            return ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxChar(this.value, string);
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public byte[] toIfxTuple() throws SQLException {
        try {
            if (this.isNull()) {
                byte[] byArray = ((IfxSqliConnect)this.conn).isVarcharVarLenSupported() ? new byte[2] : new byte[this.encodedLength + 1];
                memoryUtil.byfill(byArray, (byte)0);
                byArray[0] = 1;
                return byArray;
            }
            String string = this.conn.getdbEncoding();
            byte[] byArray = ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxVarChar(this.value, string, this.encodedLength);
            if (((IfxSqliConnect)this.conn).isVarcharVarLenSupported()) {
                int n = 1 + (0xFF & byArray[0]);
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                return byArray2;
            }
            return byArray;
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public void fromIfx(byte[] byArray) throws SQLException {
        this.fromIfx(byArray, 0, byArray.length);
    }

    @Override
    public void fromIfx(byte[] byArray, int n, int n2) throws SQLException {
        try {
            int n3 = byArray[n] & 0xFF;
            if (n3 == 1 && byArray[n + 1] == 0) {
                this.value = null;
                this.nullify();
                return;
            }
            if (n3 == 0) {
                this.value = new String("");
            } else {
                String string = this.conn.getdbEncoding();
                if (n2 > 0) {
                    n3 = Math.min(n3, n2);
                }
                this.value = ((IfxSqliConnect)this.conn).ifxtojava.IfxToJavaChar(byArray, n + 1, n3, string);
            }
            this.unnullify();
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public String toString() {
        if (this.isNull()) {
            return null;
        }
        IfxSqliConnect cfr_ignored_0 = (IfxSqliConnect)this.conn;
        if (IfxSqliConnect.GclEnv) {
            IfxSqliConnect cfr_ignored_1 = (IfxSqliConnect)this.conn;
            if (IfxSqliConnect.ConnEst) {
                try {
                    byte[] byArray = ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxChar(this.value, ((IfxSqliConnect)this.conn).returnEnc());
                    this.value = ((IfxSqliConnect)this.conn).ifxtojava.IfxToJavaChar(byArray, 2, byArray.length - 2, ((IfxSqliConnect)this.conn).returnEnc());
                    IfxSqliConnect cfr_ignored_2 = (IfxSqliConnect)this.conn;
                    IfxSqliConnect.GclEnv = false;
                    return this.value;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
            }
        }
        return this.value;
    }

    @Override
    public void fromString(String string) throws SQLException {
        this.fromString(string, false);
    }

    @Override
    public void fromString(String string, boolean bl) throws SQLException {
        block4: {
            if (string == null) {
                this.nullify();
            } else {
                try {
                    this.clearWarning();
                    String string2 = null;
                    string2 = bl ? string.trim() : string;
                    this.value = string2.length() > 255 ? string2.substring(0, 255) : string2;
                    String string3 = this.conn.getdbEncoding();
                    byte[] byArray = ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxChar(this.value, string3);
                    this.value = ((IfxSqliConnect)this.conn).ifxtojava.IfxToJavaChar(byArray, 2, byArray.length - 2, string3);
                    this.unnullify();
                }
                catch (Exception exception) {
                    this.value = null;
                    exception.printStackTrace();
                    if (!(exception instanceof IOException)) break block4;
                    throw IfxErrMsg.getSQLException(-79783, this.conn);
                }
            }
        }
    }

    @Override
    public byte toByte() throws SQLException {
        byte by;
        if (this.isNull()) {
            return 0;
        }
        try {
            by = Byte.parseByte(this.value);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
        return by;
    }

    @Override
    public void fromByte(Byte by) throws SQLException {
        if (by == null) {
            this.nullify();
        } else {
            this.fromByte((byte)by);
        }
    }

    @Override
    public void fromByte(byte by) throws SQLException {
        this.value = String.valueOf(by);
        this.unnullify();
    }

    @Override
    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value.equalsIgnoreCase("1") || this.value.equalsIgnoreCase("true") || this.value.equalsIgnoreCase("t");
    }

    @Override
    public void fromBoolean(Boolean bl) throws SQLException {
        if (bl == null) {
            this.nullify();
        } else {
            this.fromBoolean((boolean)bl);
        }
    }

    @Override
    public void fromBoolean(boolean bl) throws SQLException {
        this.value = bl ? "true" : "false";
        this.unnullify();
    }

    @Override
    public int toInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        try {
            Integer n = new Integer(this.value);
            return n;
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
    }

    @Override
    public void fromInt(Integer n) throws SQLException {
        if (n == null) {
            this.nullify();
        } else {
            this.fromInt((int)n);
        }
    }

    @Override
    public void fromInt(int n) throws SQLException {
        this.value = Integer.toString(n);
        this.unnullify();
    }

    @Override
    public void fromDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.nullify();
        } else {
            this.value = bigDecimal.toString();
            this.unnullify();
        }
    }

    @Override
    public short toShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        try {
            Short s = new Short(this.value);
            return s;
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
    }

    @Override
    public void fromShort(Short s) throws SQLException {
        if (s == null) {
            this.nullify();
        } else {
            this.fromShort((short)s);
        }
    }

    @Override
    public void fromShort(short s) throws SQLException {
        this.value = String.valueOf(s);
        this.unnullify();
    }

    @Override
    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        try {
            return Long.parseLong(this.value);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
    }

    @Override
    public void fromLong(Long l) throws SQLException {
        if (l == null) {
            this.nullify();
        } else {
            this.fromLong((long)l);
        }
    }

    @Override
    public void fromLong(long l) throws SQLException {
        this.value = String.valueOf(l);
        this.unnullify();
    }

    @Override
    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        Float f = Float.valueOf(this.value);
        return f.floatValue();
    }

    @Override
    public void fromFloat(Float f) throws SQLException {
        if (f == null) {
            this.nullify();
        } else {
            this.fromFloat(f.floatValue());
        }
    }

    @Override
    public void fromFloat(float f) throws SQLException {
        this.value = String.valueOf(f);
        this.unnullify();
    }

    @Override
    public Date toDate() throws SQLException {
        Date date = null;
        if (this.isNull()) {
            return null;
        }
        try {
            date = dateUtil.convertDateObj(this.value, this.conn);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
        return date;
    }

    @Override
    public void fromDate(Date date) throws SQLException {
        if (date == null) {
            this.nullify();
        } else {
            this.value = dateUtil.convertDateStr(date, this.conn);
            this.unnullify();
        }
    }

    @Override
    public Time toTime() throws SQLException {
        Time time;
        long l = 0L;
        if (this.isNull()) {
            return null;
        }
        try {
            boolean bl = true;
            Object object = dateUtil.convertDateTimeObj(this.value, this.conn, bl);
            l = ((java.util.Date)object).getTime();
            time = new Time(l);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
        return time;
    }

    @Override
    public void fromTime(Time time) throws SQLException {
        if (time == null) {
            this.nullify();
        } else {
            long l = time.getTime();
            this.value = dateUtil.convertDateTimeStr(time, this.conn, l);
            this.unnullify();
        }
    }

    @Override
    public Timestamp toTimestamp() throws SQLException {
        Timestamp timestamp;
        if (this.isNull()) {
            return null;
        }
        try {
            boolean bl = false;
            timestamp = (Timestamp)dateUtil.convertDateTimeObj(this.value, this.conn, bl);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
        return timestamp;
    }

    @Override
    public void fromTimestamp(Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.nullify();
        } else {
            long l = timestamp.getTime();
            this.value = dateUtil.convertDateTimeStr(timestamp, this.conn, l);
            this.unnullify();
        }
    }

    @Override
    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        Double d = Double.valueOf(this.value);
        return d;
    }

    @Override
    public void fromDouble(Double d) throws SQLException {
        if (d == null) {
            this.nullify();
        } else {
            this.fromDouble((double)d);
        }
    }

    @Override
    public void fromDouble(double d) throws SQLException {
        this.value = String.valueOf(d);
        this.unnullify();
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        BigDecimal bigDecimal;
        if (this.isNull()) {
            return null;
        }
        try {
            bigDecimal = new BigDecimal(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw IfxErrMsg.getSQLException(-79716, numberFormatException.toString(), this.conn);
        }
        return bigDecimal;
    }

    public void fromBigDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.nullify();
        } else {
            this.value = bigDecimal.toString();
            this.unnullify();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this.isNull() || object == null || !(object instanceof IfxVarChar)) {
            return false;
        }
        IfxVarChar ifxVarChar = (IfxVarChar)object;
        if (ifxVarChar.isNull()) {
            return false;
        }
        return this.value.equals(ifxVarChar.value);
    }

    @Override
    public InputStream toAsciiStream() throws SQLException {
        byte[] byArray;
        if (this.isNull()) {
            return null;
        }
        try {
            String string = this.conn.getdbEncoding();
            byArray = string != null ? this.value.getBytes(string) : this.value.getBytes();
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
        return new ByteArrayInputStream(byArray);
    }

    @Override
    public void fromAsciiStream(InputStream inputStream, int n) throws SQLException {
        this.writeTrace(3, "IfxVarChar: fromAsciiStream()");
        if (inputStream != null) {
            this.writeTrace(3, "IfxVarChar: fromAsciiStream(): length = " + n);
            if (n == 0) {
                this.value = "";
            } else {
                byte[] byArray = new byte[n];
                int n2 = 0;
                try {
                    do {
                        int n3 = inputStream.read(byArray, n2, n);
                        this.writeTrace(3, "IfxVarChar: fromAsciiStream(): readLen=" + n3);
                        this.writeTrace(3, "IfxVarChar: fromAsciiStream(): length = " + (n -= n3));
                        this.writeTrace(3, "IfxVarChar: fromAsciiStream(): offset =" + (n2 += n3));
                    } while (n > 0);
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
                }
                this.value = new String(byArray);
                this.writeTrace(3, "IfxVarChar: value = " + this.value);
            }
            this.unnullify();
        }
    }

    @Override
    public void fromInputStream(InputStream inputStream, int n) throws SQLException {
        this.fromAsciiStream(inputStream, n);
    }

    @Override
    public InputStream toInputStream() throws SQLException {
        return this.toAsciiStream();
    }

    @Override
    public void fromCharacterStream(Reader reader, int n) throws SQLException {
        this.writeTrace(3, "IfxVarChar: fromCharacterStream()");
        if (reader != null) {
            this.writeTrace(3, "IfxVarChar: fromCharacterStream():length =" + n);
            if (n == 0) {
                this.value = "";
            } else {
                char[] cArray = new char[n];
                int n2 = 0;
                BufferedReader bufferedReader = new BufferedReader(reader);
                try {
                    do {
                        int n3 = reader.read(cArray, n2, n);
                        this.writeTrace(3, "IfxVarChar: fromcharacterStream():readLen=" + n3);
                        this.writeTrace(3, "IfxVarChar: fromCharacterStream():length=" + (n -= n3));
                        this.writeTrace(3, "IfxVarChar: fromCharacterStream():offset=" + (n2 += n3));
                    } while (n > 0);
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
                }
                this.value = new String(cArray);
                this.writeTrace(3, "IfxVarChar: value = " + this.value);
            }
            this.unnullify();
        }
    }

    @Override
    public Reader toCharacterStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        this.writeTrace(99, "IfxVarChar: toCharacterStream()");
        this.writeTrace(3, "IfxVarChar: toCharacterStream(): value = " + this.value);
        return new StringReader(this.value);
    }
}

