/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlacklistedCerts;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.DeniedCertStore;
import com.sun.deploy.security.DeploySSLCertStore;
import com.sun.deploy.security.RootCertStore;
import com.sun.deploy.security.SSLRootCertStore;
import com.sun.deploy.security.SessionCertStore;
import com.sun.deploy.security.TrustDeciderDialog;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class X509DeployTrustManager
implements X509TrustManager {
    private X509TrustManager trustManager = null;
    private static CertStore rootStore = null;
    private static CertStore sslRootStore = null;
    private static CertStore permanentStore = null;
    private static CertStore sessionStore = null;
    private static CertStore deniedStore = null;
    private static CertStore browserSSLRootStore = null;
    private static CertStore browserUntrustedStore = null;
    private static boolean browserCertStoresLoaded = false;

    public static void reset() {
        rootStore = RootCertStore.getCertStore();
        sslRootStore = SSLRootCertStore.getCertStore();
        permanentStore = DeploySSLCertStore.getCertStore();
        sessionStore = new SessionCertStore("x509");
        deniedStore = new DeniedCertStore();
        if (Config.getBooleanProperty("deployment.security.browser.keystore.use")) {
            Service service = ServiceManager.getService();
            browserSSLRootStore = service.getBrowserSSLRootCertStore();
            browserUntrustedStore = service.getBrowserUntrustedCertStore();
            browserCertStoresLoaded = false;
        }
    }

    public X509DeployTrustManager() throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("IbmX509");
        trustManagerFactory.init((KeyStore)null);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        this.trustManager = (X509TrustManager)trustManagerArray[0];
    }

    public synchronized void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        boolean bl = false;
        int n = 0;
        if (this.trustManager == null) {
            throw new IllegalStateException("TrustManager should not be null");
        }
        int n2 = -1;
        try {
            rootStore.load();
            sslRootStore.load();
            permanentStore.load();
            sessionStore.load();
            deniedStore.load();
            if (!browserCertStoresLoaded) {
                if (browserSSLRootStore != null) {
                    browserSSLRootStore.load();
                }
                if (browserUntrustedStore != null) {
                    browserUntrustedStore.load();
                }
                browserCertStoresLoaded = true;
            }
            if (deniedStore.contains(x509CertificateArray[0])) {
                throw new CertificateException("Certificate has been denied");
            }
            X509DeployTrustManager.untrustedCertsCheck(browserUntrustedStore, x509CertificateArray);
            try {
                this.trustManager.checkClientTrusted(x509CertificateArray, string);
                return;
            }
            catch (CertificateException certificateException) {
                int n3;
                if (sessionStore.contains(x509CertificateArray[0])) {
                    return;
                }
                if (permanentStore.contains(x509CertificateArray[0])) {
                    return;
                }
                if (!(x509CertificateArray == null || x509CertificateArray.length <= 0 || rootStore.verify(x509CertificateArray[n3 = x509CertificateArray.length - 1]) || sslRootStore.verify(x509CertificateArray[n3]) || browserSSLRootStore != null && browserSSLRootStore.verify(x509CertificateArray[n3]))) {
                    bl = true;
                }
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    try {
                        x509CertificateArray[i].checkValidity();
                        continue;
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        n = -1;
                        continue;
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        n = 1;
                    }
                }
                if (!Trace.isAutomationEnabled()) {
                    n2 = TrustDeciderDialog.showDialog(x509CertificateArray, null, 0, x509CertificateArray.length, bl, n, null, new AppInfo(), true);
                } else {
                    Trace.msgSecurityPrintln("x509trustmgr.automation.ignoreclientcert");
                    n2 = 0;
                }
                if (n2 == 0) {
                    sessionStore.add(x509CertificateArray[0]);
                    sessionStore.save();
                } else if (n2 == 2) {
                    CertStore certStore = DeploySSLCertStore.getUserCertStore();
                    certStore.load(true);
                    if (certStore.add(x509CertificateArray[0])) {
                        certStore.save();
                    }
                } else {
                    deniedStore.add(x509CertificateArray[0]);
                    deniedStore.save();
                }
            }
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (n2 != 0 && n2 != 2) {
            throw new CertificateException("Java couldn't trust Client");
        }
    }

    public synchronized void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        boolean bl = false;
        int n = 0;
        if (this.trustManager == null) {
            throw new IllegalStateException("TrustManager should not be null");
        }
        int n2 = -1;
        try {
            rootStore.load();
            sslRootStore.load();
            permanentStore.load();
            sessionStore.load();
            deniedStore.load();
            if (!browserCertStoresLoaded) {
                if (browserSSLRootStore != null) {
                    browserSSLRootStore.load();
                }
                if (browserUntrustedStore != null) {
                    browserUntrustedStore.load();
                }
                browserCertStoresLoaded = true;
            }
            if (deniedStore.contains(x509CertificateArray[0])) {
                throw new CertificateException("Certificate has been denied");
            }
            X509DeployTrustManager.untrustedCertsCheck(browserUntrustedStore, x509CertificateArray);
            try {
                this.trustManager.checkServerTrusted(x509CertificateArray, string);
                return;
            }
            catch (CertificateException certificateException) {
                int n3;
                if (sessionStore.contains(x509CertificateArray[0])) {
                    return;
                }
                if (permanentStore.contains(x509CertificateArray[0])) {
                    return;
                }
                if (!(x509CertificateArray == null || x509CertificateArray.length <= 0 || rootStore.verify(x509CertificateArray[n3 = x509CertificateArray.length - 1]) || sslRootStore.verify(x509CertificateArray[n3]) || browserSSLRootStore != null && browserSSLRootStore.verify(x509CertificateArray[n3]))) {
                    bl = true;
                }
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    try {
                        x509CertificateArray[i].checkValidity();
                        continue;
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        n = -1;
                        continue;
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        n = 1;
                    }
                }
                if (!Trace.isAutomationEnabled()) {
                    n2 = TrustDeciderDialog.showDialog(x509CertificateArray, null, 0, x509CertificateArray.length, bl, n, null, new AppInfo(), true);
                } else {
                    Trace.msgSecurityPrintln("x509trustmgr.automation.ignoreservercert");
                    n2 = 0;
                }
                if (n2 == 0) {
                    sessionStore.add(x509CertificateArray[0]);
                    sessionStore.save();
                } else if (n2 == 2) {
                    CertStore certStore = DeploySSLCertStore.getUserCertStore();
                    certStore.load(true);
                    if (certStore.add(x509CertificateArray[0])) {
                        certStore.save();
                    }
                } else {
                    deniedStore.add(x509CertificateArray[0]);
                    deniedStore.save();
                }
            }
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (n2 != 0 && n2 != 2) {
            throw new CertificateException("Java couldn't trust Server");
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    static void untrustedCertsCheck(CertStore certStore, X509Certificate[] x509CertificateArray) throws CertificateException {
        boolean bl = false;
        KeyStoreException keyStoreException = null;
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            BlacklistedCerts.check(x509CertificateArray[i]);
            if (certStore == null) continue;
            try {
                if (!certStore.contains(x509CertificateArray[i])) continue;
                bl = true;
            }
            catch (KeyStoreException keyStoreException2) {
                bl = true;
                keyStoreException = keyStoreException2;
            }
            break;
        }
        if (bl) {
            String string = ResourceManager.getMessage("untrusted.certificate");
            Trace.println(string, TraceLevel.SECURITY);
            throw new CertificateException(string, keyStoreException);
        }
    }

    static {
        X509DeployTrustManager.reset();
    }
}

