/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.collector;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

class DCIpStreamHandler
implements Runnable {
    private StringBuffer output;
    private String commandLabel;
    private InputStream input;
    private boolean isStdOut;
    private boolean tee;
    private String streamName;
    private Logger logger;

    public DCIpStreamHandler(StringBuffer buf, String commandLabel, InputStream inputStream, boolean isStdOut, boolean tee, Logger logger) throws IllegalArgumentException {
        if (buf == null) {
            throw new IllegalArgumentException("buf is null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null");
        }
        if (logger == null) {
            throw new IllegalArgumentException("logger is null");
        }
        this.output = buf;
        this.commandLabel = commandLabel;
        this.input = inputStream;
        this.isStdOut = isStdOut;
        this.tee = tee;
        this.streamName = isStdOut ? "stdout" : "stderr";
        this.logger = logger;
    }

    public void run() {
        BufferedReader br = new BufferedReader(new InputStreamReader(this.input));
        String line = null;
        String lineSep = System.getProperty("line.separator");
        try {
            while ((line = br.readLine()) != null) {
                this.output.append(line + lineSep);
                if (!this.tee) continue;
                if (this.isStdOut) {
                    System.out.println(line);
                    continue;
                }
                System.err.println(line);
            }
        }
        catch (IOException e) {
            this.logger.log(Level.FINE, "IOException reading " + this.streamName, e);
        }
        this.logger.fine(this.streamName + " output for " + this.commandLabel + " command: " + lineSep + this.output.toString());
        try {
            br.close();
        }
        catch (IOException e) {
            this.logger.log(Level.FINE, "IOException closing BufferedReader", e);
        }
    }
}

