/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.collector;

import com.ibm.java.diagnostics.collector.DCBlockingCommandRunner;
import com.ibm.java.diagnostics.collector.DCCommandResult;
import com.ibm.java.diagnostics.collector.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DCUlimitCheck {
    protected String ulimitHardAllOutput = "";
    protected String ulimitHardCoreOutput = "";
    protected String ulimitHardFileOutput = "";
    private boolean commandSuccess;
    private boolean isAIX;
    private boolean isLinux;
    private Logger logger;
    private String osName;
    private static final String[] ULIMIT_AIX_ALL = new String[]{"/usr/bin/ulimit", "-H", "-a"};
    private static final String[] ULIMIT_AIX_CORE = new String[]{"/usr/bin/ulimit", "-H", "-c"};
    private static final String[] ULIMIT_AIX_FILE = new String[]{"/usr/bin/ulimit", "-H", "-f"};
    private static final String[] ULIMIT_LINUX_CORE = new String[]{"/bin/bash", "-c", "ulimit -H -c"};
    private static final String[] ULIMIT_LINUX_FILE = new String[]{"/bin/bash", "-c", "ulimit -H -f"};
    private static final String[] ULIMIT_LINUX_ALL = new String[]{"/bin/bash", "-c", "ulimit -H -a"};
    private static final int ULIMIT_CHECK_ALL = 1;
    private static final int ULIMIT_CHECK_CORE = 2;
    private static final int ULIMIT_CHECK_FILE = 3;

    public DCUlimitCheck(Logger l) {
        this.logger = l;
        this.osName = System.getProperty("os.name");
        this.isAIX = this.osName.equals("AIX");
        this.isLinux = this.osName.equals("Linux");
        if (this.isAIX || this.isLinux) {
            this.ulimitHardAllOutput = this.getUlimitStdOut(1);
            this.ulimitHardCoreOutput = this.getUlimitStdOut(2);
            this.ulimitHardFileOutput = this.getUlimitStdOut(3);
        }
    }

    private String getUlimitStdOut(int limitType) {
        if (!this.appliesToPlatform()) {
            return null;
        }
        String[] cmdArray = null;
        String cmdLabel = null;
        switch (limitType) {
            case 1: {
                cmdLabel = "ulimit all";
                if (this.isAIX) {
                    cmdArray = ULIMIT_AIX_ALL;
                    break;
                }
                cmdArray = ULIMIT_LINUX_ALL;
                break;
            }
            case 2: {
                cmdLabel = "ulimit core";
                if (this.isAIX) {
                    cmdArray = ULIMIT_AIX_CORE;
                    break;
                }
                cmdArray = ULIMIT_LINUX_CORE;
                break;
            }
            case 3: {
                cmdLabel = "ulimit file";
                if (this.isAIX) {
                    cmdArray = ULIMIT_AIX_FILE;
                    break;
                }
                cmdArray = ULIMIT_LINUX_FILE;
                break;
            }
            default: {
                return null;
            }
        }
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(cmdArray));
        DCBlockingCommandRunner ulimitRunner = new DCBlockingCommandRunner(cmd, cmdLabel, false, this.logger);
        DCCommandResult cr = ulimitRunner.runCommand(60, false);
        int rc = cr.getRc();
        if (rc == 0) {
            this.commandSuccess = true;
            return cr.getStdOut();
        }
        this.commandSuccess = false;
        String errorMsg = MessageFormat.format(Messages.getString("UlimitCheck.4"), cmdLabel, String.valueOf(rc), cr.getStdErr());
        return errorMsg;
    }

    public boolean appliesToPlatform() {
        return this.isAIX || this.isLinux;
    }

    public Level getUlimitReportPriority() {
        Level l = null;
        if (this.appliesToPlatform()) {
            l = this.commandSuccess && this.isUnlimited(this.ulimitHardCoreOutput) && this.isUnlimited(this.ulimitHardFileOutput) ? Level.CONFIG : Level.WARNING;
        }
        return l;
    }

    private boolean isUnlimited(String ulimit) {
        if (this.commandSuccess && ulimit != null) {
            return ulimit.startsWith("unlimited");
        }
        return false;
    }

    public String getReport() {
        if (!this.appliesToPlatform()) {
            return null;
        }
        String lineSep = System.getProperty("line.separator");
        StringBuffer report = new StringBuffer(lineSep);
        if (this.commandSuccess) {
            if (this.isUnlimited(this.ulimitHardCoreOutput) && this.isUnlimited(this.ulimitHardFileOutput)) {
                report.append(Messages.getString("UlimitCheck.0") + lineSep);
                report.append(Messages.getString("UlimitCheck.6") + lineSep);
            }
            if (!this.isUnlimited(this.ulimitHardCoreOutput)) {
                report.append(Messages.getString("UlimitCheck.1") + lineSep);
            }
            if (!this.isUnlimited(this.ulimitHardFileOutput)) {
                report.append(Messages.getString("UlimitCheck.7") + lineSep);
            }
            report.append(lineSep + Messages.getString("UlimitCheck.3") + lineSep + this.ulimitHardAllOutput);
        } else {
            report.append(Messages.getString("UlimitCheck.5"));
        }
        return report.toString();
    }

    public void setUlimitCore(String s) {
        this.ulimitHardCoreOutput = s;
    }

    public void setUlimitFile(String s) {
        this.ulimitHardFileOutput = s;
    }
}

