/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.collector;

import com.ibm.java.diagnostics.collector.CommandLineDumpOptionChecker;
import com.ibm.java.diagnostics.collector.Messages;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EnvVarChecker {
    private Logger logger;
    private boolean riskFound;
    private StringBuffer configReport = new StringBuffer();
    private StringBuffer warningReport = new StringBuffer();
    private String envVarList;
    private String lineSep;
    private Map<String, String> envMap;

    public EnvVarChecker(Logger logger) {
        this.logger = logger;
        this.lineSep = System.getProperty("line.separator");
        this.envMap = System.getenv();
        this.initReports();
    }

    private void initReports() {
        this.configReport.append(Messages.getString("EnvVarChecker.0") + this.lineSep);
        this.warningReport.append(Messages.getString("EnvVarChecker.1") + this.lineSep);
        this.report("DISABLE_JAVADUMP", new String[]{"true", "1"}, Messages.getString("EnvVarChecker.3"));
        this.report("IBM_HEAPDUMP", new String[]{"false", "0"}, Messages.getString("EnvVarChecker.4"));
        this.report("IBM_HEAP_DUMP", new String[]{"false", "0"}, Messages.getString("EnvVarChecker.5"));
        this.report("IBM_HEAPDUMP_OUTOFMEMORY", new String[]{"false", "0"}, Messages.getString("EnvVarChecker.6"));
        this.report("IBM_JAVA_HEAPDUMP_TEST", null, Messages.getString("EnvVarChecker.7"));
        this.report("IBM_JAVA_HEAPDUMP_TEXT", new String[]{"true", "1"}, Messages.getString("EnvVarChecker.8"));
        this.report("IBM_JAVADUMP_OUTOFMEMORY", new String[]{"false", "0"}, Messages.getString("EnvVarChecker.9"));
        this.report("IBM_NOSIGHANDLER", new String[]{"true", "1"}, Messages.getString("EnvVarChecker.10"));
        this.report("IBM_XE_COE_NAME", null, Messages.getString("EnvVarChecker.11"));
        this.report("JAVA_DUMP_OPTS", null, Messages.getString("EnvVarChecker.12"));
        if (System.getProperty("os.name").contains("z/OS")) {
            this.report("_CEE_DMPTARG", null, Messages.getString("EnvVarChecker.13"));
            this.report("JAVA_DUMP_TDUMP_PATTERN", null, Messages.getString("EnvVarChecker.14"));
        } else {
            this.report("IBM_JAVACOREDIR", null, Messages.getString("EnvVarChecker.15"));
            this.report("IBM_HEAPDUMPDIR", null, Messages.getString("EnvVarChecker.16"));
            this.report("IBM_COREDIR", null, Messages.getString("EnvVarChecker.17"));
        }
        this.report("TMPDIR", null, Messages.getString("EnvVarChecker.18"));
        this.ibmJavaOptionsReport();
        this.coreMmapReport();
    }

    private void report(String varName, String[] badValues, String warning) {
        String value = this.envMap.get(varName);
        if (value == null) {
            this.configReport.append("    " + varName + Messages.getString("EnvVarChecker.19") + this.lineSep);
        } else {
            this.configReport.append(varName + "=" + value + this.lineSep);
            boolean warn = false;
            if (badValues == null) {
                warn = true;
            } else {
                for (String target : badValues) {
                    if (!value.equalsIgnoreCase(target)) continue;
                    warn = true;
                }
            }
            if (warn) {
                this.warningReport.append(varName + "=" + value + " : " + warning + this.lineSep);
                this.riskFound = true;
            }
        }
    }

    private void ibmJavaOptionsReport() {
        String varName = "IBM_JAVA_OPTIONS";
        String ibmJavaOptions = this.envMap.get(varName);
        if (ibmJavaOptions == null) {
            this.configReport.append("    " + varName + "=" + Messages.getString("EnvVarChecker.19") + this.lineSep);
        } else {
            this.configReport.append(varName + "=" + ibmJavaOptions + this.lineSep);
            String[] optionArray = ibmJavaOptions.split(" ");
            HashSet<String> optionSet = new HashSet<String>();
            optionSet.addAll(Arrays.asList(optionArray));
            CommandLineDumpOptionChecker cmdChk = new CommandLineDumpOptionChecker(this.logger, optionSet);
            Level priority = cmdChk.getReportPriority();
            if (priority != null) {
                this.warningReport.append(varName + "=" + ibmJavaOptions + " : " + this.lineSep + cmdChk.getReport() + this.lineSep);
                this.riskFound = true;
            }
        }
    }

    private void coreMmapReport() {
        String osName = System.getProperty("os.name");
        if (osName.contains("AIX")) {
            String varName = "CORE_MMAP";
            String coreMmapVal = this.envMap.get(varName);
            boolean valueIsCorrect = false;
            if (coreMmapVal == null) {
                this.configReport.append("    " + varName + Messages.getString("EnvVarChecker.20") + this.lineSep);
            } else {
                this.configReport.append(varName + "=" + coreMmapVal);
                valueIsCorrect = coreMmapVal.equals("yes");
            }
            if (!valueIsCorrect) {
                this.warningReport.append(varName + "=" + coreMmapVal + " :" + this.lineSep + Messages.getString("EnvVarChecker.21"));
            }
        }
    }

    public String getConfigReport() {
        return this.configReport.toString();
    }

    public String getWarningReport() {
        if (this.warningReport.length() == 0 || !this.riskFound()) {
            return null;
        }
        return this.warningReport.toString();
    }

    public String getEnvVarList() {
        if (this.envVarList == null) {
            StringBuffer list = new StringBuffer();
            for (String varName : this.envMap.keySet()) {
                list.append(varName + "=" + this.envMap.get(varName) + this.lineSep);
            }
            this.envVarList = list.toString();
        }
        return this.envVarList;
    }

    public boolean riskFound() {
        return this.riskFound;
    }
}

