/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.collector;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

class InputStreamHandler
implements Runnable {
    private InputStream input;
    private boolean isStdOut;
    private String streamName;
    private Logger logger;

    public InputStreamHandler(InputStream inputStream, boolean isStdOut, Logger logger) {
        this.input = inputStream;
        this.isStdOut = isStdOut;
        this.streamName = isStdOut ? "stdout" : "stderr";
        this.logger = logger;
    }

    public void run() {
        BufferedReader br = new BufferedReader(new InputStreamReader(this.input));
        String line = null;
        String lineSep = System.getProperty("line.separator");
        StringBuffer output = new StringBuffer();
        if (this.isStdOut) {
            output.append("Stdout from jextract process:" + lineSep);
        } else {
            output.append("Stderr from jextract process:" + lineSep);
        }
        try {
            while ((line = br.readLine()) != null) {
                output.append(line + lineSep);
                if (this.isStdOut) continue;
                System.err.println(line);
            }
        }
        catch (IOException e) {
            this.logger.log(Level.FINE, "IOException reading " + this.streamName, e);
        }
        this.logger.fine(output.toString());
        try {
            br.close();
        }
        catch (IOException e) {
            this.logger.log(Level.FINE, "IOException closing BufferedReader", e);
        }
    }
}

