/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.collector;

import com.ibm.java.diagnostics.collector.DumpDescriptor;
import com.ibm.java.diagnostics.collector.DumpSet;
import com.ibm.java.diagnostics.collector.InputStreamHandler;
import com.ibm.java.diagnostics.collector.Messages;
import com.ibm.java.diagnostics.collector.Util;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JextractRunner {
    private Logger logger;
    private String jextract;
    private static final long INTERVAL = 2000L;
    private static final int TIMEOUT = 3600;

    public JextractRunner(Logger l) {
        this.logger = l;
    }

    public void process(DumpDescriptor[] dda) {
        DumpDescriptor[] systemDumps = this.selectSystemDumps(dda);
        for (int i = 0; i < systemDumps.length; ++i) {
            DumpDescriptor systemDump = systemDumps[i];
            if (systemDump == null) continue;
            if (this.jextract == null) {
                this.jextract = this.findJextract();
                if (this.jextract == null) {
                    this.logger.warning("Java Diagnostics Collector" + Messages.getString("JextractRunner.0"));
                    break;
                }
            }
            System.err.println("Java Diagnostics Collector" + Messages.getString("JextractRunner.2"));
            if (System.getProperty("os.name").indexOf("z/OS") == -1) {
                this.runJextract(systemDump);
                continue;
            }
            this.runJextractZOS(systemDump);
        }
    }

    void runJextractZOS(DumpDescriptor systemDump) {
        String dumpPattern = systemDump.getZosDatasetLabel();
        String dumpLabel = dumpPattern.replace("&DS", "001");
        String outName = dumpLabel + ".zip";
        ArrayList<String> jextractCmd = new ArrayList<String>();
        jextractCmd.add(this.jextract);
        jextractCmd.add(dumpLabel);
        jextractCmd.add(outName);
        StringBuffer cmdString = new StringBuffer();
        for (String cmdItem : jextractCmd) {
            cmdString.append(cmdItem);
            cmdString.append(" ");
        }
        this.logger.fine("Running jextract command: " + cmdString);
        ProcessBuilder pb = new ProcessBuilder(jextractCmd);
        systemDump.setJextractRun(true);
        Process p = null;
        try {
            p = pb.start();
        }
        catch (IOException e) {
            this.logger.log(Level.FINE, "IOException when starting jextract process", e);
            systemDump.setJextractRC(-1);
        }
        if (p != null) {
            this.logger.fine("jextract launched, output follows");
            InputStreamHandler outHandler = new InputStreamHandler(p.getInputStream(), true, this.logger);
            InputStreamHandler errHandler = new InputStreamHandler(p.getErrorStream(), false, this.logger);
            Thread outT = new Thread(outHandler);
            Thread errT = new Thread(errHandler);
            outT.start();
            errT.start();
            int jextractRC = -1;
            for (int i = 0; i < 3600; ++i) {
                try {
                    jextractRC = p.exitValue();
                    this.logger.fine("jextract return code: " + jextractRC);
                    break;
                }
                catch (IllegalThreadStateException itse) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        this.logger.log(Level.FINE, "Interrupted waiting for jextract process", e);
                    }
                    if (i + 1 < 3600) continue;
                    this.logger.fine("Timed out waiting for jextract to complete");
                    this.logger.fine("Requesting to terminate jextract process");
                    p.destroy();
                    continue;
                }
            }
            systemDump.setJextractRC(jextractRC);
            this.logger.fine("jextract return code: " + jextractRC);
            File jextractZip = new File(outName);
            if (jextractZip.canRead()) {
                this.logger.fine("Found jextract output file: " + outName);
                systemDump.setJextractZip(jextractZip);
            } else if (jextractZip.exists()) {
                this.logger.fine("jextract output file exists but is not readable: " + outName);
            } else {
                this.logger.fine("jextract output file not found: " + outName);
            }
        }
    }

    void runJextract(DumpDescriptor systemDump) {
        File systemDumpFile = systemDump.getFile();
        String systemDumpPath = systemDumpFile.getAbsolutePath();
        if (!systemDumpFile.canRead()) {
            String msg = MessageFormat.format("{0}{1} {2}", "Java Diagnostics Collector", Messages.getString("JextractRunner.3"), systemDumpPath);
            this.logger.warning(msg);
            return;
        }
        if (systemDumpFile.length() == 0L) {
            String msg = MessageFormat.format("{0}{1} {2}", "Java Diagnostics Collector", Messages.getString("JextractRunner.4"), systemDumpPath);
            this.logger.warning(msg);
            return;
        }
        String jextractOutputPath = systemDumpPath + ".zip";
        String quote = "";
        if (Util.isOnWindows()) {
            quote = "\"";
        }
        ArrayList<String> jextractCmd = new ArrayList<String>();
        jextractCmd.add(quote + this.jextract + quote);
        jextractCmd.add(quote + systemDumpPath + quote);
        jextractCmd.add(quote + jextractOutputPath + quote);
        StringBuffer cmdString = new StringBuffer();
        for (String cmdItem : jextractCmd) {
            cmdString.append(cmdItem);
            cmdString.append(" ");
        }
        this.logger.fine("Running jextract command: " + cmdString);
        ProcessBuilder pb = new ProcessBuilder(jextractCmd);
        Process p = null;
        try {
            p = pb.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.log(Level.FINE, "IOException when starting jextract process", e);
            systemDump.setJextractRC(-1);
        }
        if (p != null) {
            systemDump.setJextractRun(true);
            this.logger.fine("jextract launched, output follows");
            InputStreamHandler outHandler = new InputStreamHandler(p.getInputStream(), true, this.logger);
            InputStreamHandler errHandler = new InputStreamHandler(p.getErrorStream(), false, this.logger);
            Thread outT = new Thread(outHandler);
            Thread errT = new Thread(errHandler);
            outT.start();
            errT.start();
            int jextractRC = -1;
            for (int i = 0; i < 3600; ++i) {
                try {
                    jextractRC = p.exitValue();
                    this.logger.fine("jextract return code: " + jextractRC);
                    break;
                }
                catch (IllegalThreadStateException itse) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        this.logger.log(Level.FINE, "Interrupted waiting for jextract process", e);
                    }
                    if (i + 1 < 3600) continue;
                    this.logger.fine("Timed out waiting for jextract to complete");
                    this.logger.fine("Requesting to terminate jextract process");
                    p.destroy();
                    continue;
                }
            }
            systemDump.setJextractRC(jextractRC);
            File jextractZip = new File(jextractOutputPath);
            if (jextractZip.canRead()) {
                this.logger.fine("Found jextract output file: " + jextractOutputPath);
                systemDump.setJextractZip(jextractZip);
            } else if (jextractZip.exists()) {
                this.logger.fine("jextract output file exists but is not readable: " + jextractOutputPath);
            } else {
                this.logger.fine("jextract output file not found: " + jextractOutputPath);
            }
        }
    }

    public String findJextract() {
        String je = Util.isOnWindows() ? "jextract.exe" : "jextract";
        String slash = System.getProperty("file.separator");
        File f = new File(System.getProperty("java.home") + slash + "bin" + slash + je);
        boolean found = false;
        if (f.canRead()) {
            found = true;
            this.logger.fine("jextract located at: " + f.getAbsolutePath());
        } else {
            this.logger.fine("jextract not found at: " + f.getAbsolutePath());
            f = new File(System.getProperty("java.home") + slash + "jre" + slash + "bin" + slash + je);
            if (f.canRead()) {
                found = true;
                this.logger.fine("jextract located at: " + f.getAbsolutePath());
            } else {
                this.logger.fine("jextract not found at: " + f.getAbsolutePath());
            }
        }
        if (found) {
            return f.getAbsolutePath();
        }
        return null;
    }

    public DumpDescriptor[] selectSystemDumps(DumpDescriptor[] dda) {
        DumpSet ds = new DumpSet();
        for (int i = 0; i < dda.length; ++i) {
            if (dda[i] == null || dda[i].getDumpType() != DumpDescriptor.DumpType.SYSTEM) continue;
            ds.add(dda[i]);
        }
        return ds.getDumpSet();
    }
}

