/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.collector;

import com.ibm.java.diagnostics.collector.Messages;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemPropertyChecker {
    Map<String, String> systemPropertyMap;
    final String lineSep;
    StringBuffer configReport = new StringBuffer();
    StringBuffer warningReport = new StringBuffer();
    boolean riskFound;

    public SystemPropertyChecker(Logger logger, Map<String, String> systemPropertyMap) throws IllegalArgumentException {
        if (systemPropertyMap == null) {
            IllegalArgumentException e = new IllegalArgumentException("systemPropertyMap is null");
            logger.log(Level.FINE, e.getLocalizedMessage(), e);
            throw e;
        }
        this.systemPropertyMap = systemPropertyMap;
        this.lineSep = System.getProperty("line.separator");
        this.initReports();
    }

    private void initReports() {
        this.report("ibm.signalhandling.rs", "true", Messages.getString("SystemPropertyChecker.0") + Messages.getString("SystemPropertyChecker.1"));
        this.report("ibm.signalhandling.sigint", "false", Messages.getString("SystemPropertyChecker.2"));
        this.report("ibm.signalhandling.sigchain", "false", Messages.getString("SystemPropertyChecker.3"));
    }

    private void report(String name, String badValue, String warning) {
        if (this.systemPropertyMap.containsKey(name)) {
            String pVal = this.systemPropertyMap.get(name);
            this.configReport.append(name + "=" + pVal + this.lineSep);
            if (pVal != null && pVal.equals(badValue)) {
                this.riskFound = true;
                this.warningReport.append(name + "=" + pVal + this.lineSep);
                this.warningReport.append(warning + this.lineSep + this.lineSep);
            }
        } else {
            this.configReport.append("    " + name + Messages.getString("SystemPropertyChecker.4") + this.lineSep);
        }
    }

    public String getConfigReport() {
        return this.configReport.toString();
    }

    public boolean riskFound() {
        return this.riskFound;
    }

    public String getWarningReport() {
        return this.warningReport.toString();
    }
}

