/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import sun.org.mozilla.javascript.internal.Callable;
import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.EvaluatorException;
import sun.org.mozilla.javascript.internal.FieldAndMethods;
import sun.org.mozilla.javascript.internal.Function;
import sun.org.mozilla.javascript.internal.InterfaceAdapter;
import sun.org.mozilla.javascript.internal.JavaMembers;
import sun.org.mozilla.javascript.internal.Kit;
import sun.org.mozilla.javascript.internal.NativeArray;
import sun.org.mozilla.javascript.internal.NativeDate;
import sun.org.mozilla.javascript.internal.NativeJavaArray;
import sun.org.mozilla.javascript.internal.NativeJavaClass;
import sun.org.mozilla.javascript.internal.ScriptRuntime;
import sun.org.mozilla.javascript.internal.Scriptable;
import sun.org.mozilla.javascript.internal.ScriptableObject;
import sun.org.mozilla.javascript.internal.Undefined;
import sun.org.mozilla.javascript.internal.Wrapper;

public class NativeJavaObject
implements Scriptable,
Wrapper {
    private static final int JSTYPE_UNDEFINED = 0;
    private static final int JSTYPE_NULL = 1;
    private static final int JSTYPE_BOOLEAN = 2;
    private static final int JSTYPE_NUMBER = 3;
    private static final int JSTYPE_STRING = 4;
    private static final int JSTYPE_JAVA_CLASS = 5;
    private static final int JSTYPE_JAVA_OBJECT = 6;
    private static final int JSTYPE_JAVA_ARRAY = 7;
    private static final int JSTYPE_OBJECT = 8;
    static final byte CONVERSION_TRIVIAL = 1;
    static final byte CONVERSION_NONTRIVIAL = 0;
    static final byte CONVERSION_NONE = 99;
    protected Scriptable prototype;
    protected Scriptable parent;
    protected transient Object javaObject;
    protected transient Class<?> staticType;
    protected transient JavaMembers members;
    private transient Map<String, FieldAndMethods> fieldAndMethods;
    private transient boolean isAdapter;
    private static final Object COERCED_INTERFACE_KEY = "Coerced Interface";
    private static Method adapter_writeAdapterObject;
    private static Method adapter_readAdapterObject;

    public NativeJavaObject() {
    }

    public NativeJavaObject(Scriptable scriptable, Object object, Class<?> clazz) {
        this(scriptable, object, clazz, false);
    }

    public NativeJavaObject(Scriptable scriptable, Object object, Class<?> clazz, boolean bl) {
        this.parent = scriptable;
        this.javaObject = object;
        this.staticType = clazz;
        this.isAdapter = bl;
        this.initMembers();
    }

    protected void initMembers() {
        Class<?> clazz = this.javaObject != null ? this.javaObject.getClass() : this.staticType;
        this.members = JavaMembers.lookupClass(this.parent, clazz, this.staticType, this.isAdapter);
        this.fieldAndMethods = this.members.getFieldAndMethodsObjects(this, this.javaObject, false);
    }

    @Override
    public boolean has(String string, Scriptable scriptable) {
        return this.members.has(string, false);
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        return false;
    }

    @Override
    public Object get(String string, Scriptable scriptable) {
        FieldAndMethods fieldAndMethods;
        if (this.fieldAndMethods != null && (fieldAndMethods = this.fieldAndMethods.get(string)) != null) {
            return fieldAndMethods;
        }
        return this.members.get(this, string, this.javaObject, false);
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        throw this.members.reportMemberNotFound(Integer.toString(n));
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
        if (this.prototype == null || this.members.has(string, false)) {
            this.members.put(this, string, this.javaObject, object, false);
        } else {
            this.prototype.put(string, this.prototype, object);
        }
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        throw this.members.reportMemberNotFound(Integer.toString(n));
    }

    @Override
    public boolean hasInstance(Scriptable scriptable) {
        return false;
    }

    @Override
    public void delete(String string) {
    }

    @Override
    public void delete(int n) {
    }

    @Override
    public Scriptable getPrototype() {
        if (this.prototype == null && this.javaObject instanceof String) {
            return ScriptableObject.getClassPrototype(this.parent, "String");
        }
        return this.prototype;
    }

    @Override
    public void setPrototype(Scriptable scriptable) {
        this.prototype = scriptable;
    }

    @Override
    public Scriptable getParentScope() {
        return this.parent;
    }

    @Override
    public void setParentScope(Scriptable scriptable) {
        this.parent = scriptable;
    }

    @Override
    public Object[] getIds() {
        return this.members.getIds(false);
    }

    public static Object wrap(Scriptable scriptable, Object object, Class<?> clazz) {
        Context context = Context.getContext();
        return context.getWrapFactory().wrap(context, scriptable, object, clazz);
    }

    @Override
    public Object unwrap() {
        return this.javaObject;
    }

    @Override
    public String getClassName() {
        return "JavaObject";
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        Object object;
        if (clazz == null && this.javaObject instanceof Boolean) {
            clazz = ScriptRuntime.BooleanClass;
        }
        if (clazz == null || clazz == ScriptRuntime.StringClass) {
            object = this.javaObject.toString();
        } else {
            String string;
            if (clazz == ScriptRuntime.BooleanClass) {
                string = "booleanValue";
            } else if (clazz == ScriptRuntime.NumberClass) {
                string = "doubleValue";
            } else {
                throw Context.reportRuntimeError0("msg.default.value");
            }
            Object object2 = this.get(string, (Scriptable)this);
            if (object2 instanceof Function) {
                Function function = (Function)object2;
                object = function.call(Context.getContext(), function.getParentScope(), this, ScriptRuntime.emptyArgs);
            } else {
                boolean bl;
                object = clazz == ScriptRuntime.NumberClass && this.javaObject instanceof Boolean ? ScriptRuntime.wrapNumber((bl = ((Boolean)this.javaObject).booleanValue()) ? 1.0 : 0.0) : this.javaObject.toString();
            }
        }
        return object;
    }

    public static boolean canConvert(Object object, Class<?> clazz) {
        int n = NativeJavaObject.getConversionWeight(object, clazz);
        return n < 99;
    }

    static int getConversionWeight(Object object, Class<?> clazz) {
        int n = NativeJavaObject.getJSTypeCode(object);
        switch (n) {
            case 0: {
                if (clazz != ScriptRuntime.StringClass && clazz != ScriptRuntime.ObjectClass) break;
                return 1;
            }
            case 1: {
                if (clazz.isPrimitive()) break;
                return 1;
            }
            case 2: {
                if (clazz == Boolean.TYPE) {
                    return 1;
                }
                if (clazz == ScriptRuntime.BooleanClass) {
                    return 2;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    return 3;
                }
                if (clazz != ScriptRuntime.StringClass) break;
                return 4;
            }
            case 3: {
                if (clazz.isPrimitive()) {
                    if (clazz == Double.TYPE) {
                        return 1;
                    }
                    if (clazz == Boolean.TYPE) break;
                    return 1 + NativeJavaObject.getSizeRank(clazz);
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return 9;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    return 10;
                }
                if (!ScriptRuntime.NumberClass.isAssignableFrom(clazz)) break;
                return 2;
            }
            case 4: {
                if (clazz == ScriptRuntime.StringClass) {
                    return 1;
                }
                if (clazz.isInstance(object)) {
                    return 2;
                }
                if (!clazz.isPrimitive()) break;
                if (clazz == Character.TYPE) {
                    return 3;
                }
                if (clazz == Boolean.TYPE) break;
                return 4;
            }
            case 5: {
                if (clazz == ScriptRuntime.ClassClass) {
                    return 1;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    return 3;
                }
                if (clazz != ScriptRuntime.StringClass) break;
                return 4;
            }
            case 6: 
            case 7: {
                Object object2 = object;
                if (object2 instanceof Wrapper) {
                    object2 = ((Wrapper)object2).unwrap();
                }
                if (clazz.isInstance(object2)) {
                    return 0;
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return 2;
                }
                if (!clazz.isPrimitive() || clazz == Boolean.TYPE) break;
                return n == 7 ? 99 : 2 + NativeJavaObject.getSizeRank(clazz);
            }
            case 8: {
                if (clazz != ScriptRuntime.ObjectClass && clazz.isInstance(object)) {
                    return 1;
                }
                if (clazz.isArray()) {
                    if (!(object instanceof NativeArray)) break;
                    return 1;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    return 2;
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return 3;
                }
                if (clazz == ScriptRuntime.DateClass) {
                    if (!(object instanceof NativeDate)) break;
                    return 1;
                }
                if (clazz.isInterface()) {
                    if (object instanceof Function && clazz.getMethods().length == 1) {
                        return 1;
                    }
                    return 11;
                }
                if (!clazz.isPrimitive() || clazz == Boolean.TYPE) break;
                return 3 + NativeJavaObject.getSizeRank(clazz);
            }
        }
        return 99;
    }

    static int getSizeRank(Class<?> clazz) {
        if (clazz == Double.TYPE) {
            return 1;
        }
        if (clazz == Float.TYPE) {
            return 2;
        }
        if (clazz == Long.TYPE) {
            return 3;
        }
        if (clazz == Integer.TYPE) {
            return 4;
        }
        if (clazz == Short.TYPE) {
            return 5;
        }
        if (clazz == Character.TYPE) {
            return 6;
        }
        if (clazz == Byte.TYPE) {
            return 7;
        }
        if (clazz == Boolean.TYPE) {
            return 99;
        }
        return 8;
    }

    private static int getJSTypeCode(Object object) {
        if (object == null) {
            return 1;
        }
        if (object == Undefined.instance) {
            return 0;
        }
        if (object instanceof String) {
            return 4;
        }
        if (object instanceof Number) {
            return 3;
        }
        if (object instanceof Boolean) {
            return 2;
        }
        if (object instanceof Scriptable) {
            if (object instanceof NativeJavaClass) {
                return 5;
            }
            if (object instanceof NativeJavaArray) {
                return 7;
            }
            if (object instanceof Wrapper) {
                return 6;
            }
            return 8;
        }
        if (object instanceof Class) {
            return 5;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            return 7;
        }
        return 6;
    }

    public static Object coerceType(Class<?> clazz, Object object) {
        return NativeJavaObject.coerceTypeImpl(clazz, object);
    }

    static Object coerceTypeImpl(Class<?> clazz, Object object) {
        if (object != null && object.getClass() == clazz) {
            return object;
        }
        switch (NativeJavaObject.getJSTypeCode(object)) {
            case 1: {
                if (clazz.isPrimitive()) {
                    NativeJavaObject.reportConversionError(object, clazz);
                }
                return null;
            }
            case 0: {
                if (clazz == ScriptRuntime.StringClass || clazz == ScriptRuntime.ObjectClass) {
                    return "undefined";
                }
                NativeJavaObject.reportConversionError("undefined", clazz);
                break;
            }
            case 2: {
                if (clazz == Boolean.TYPE || clazz == ScriptRuntime.BooleanClass || clazz == ScriptRuntime.ObjectClass) {
                    return object;
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return object.toString();
                }
                NativeJavaObject.reportConversionError(object, clazz);
                break;
            }
            case 3: {
                if (clazz == ScriptRuntime.StringClass) {
                    return ScriptRuntime.toString(object);
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    return NativeJavaObject.coerceToNumber(Double.TYPE, object);
                }
                if (clazz.isPrimitive() && clazz != Boolean.TYPE || ScriptRuntime.NumberClass.isAssignableFrom(clazz)) {
                    return NativeJavaObject.coerceToNumber(clazz, object);
                }
                NativeJavaObject.reportConversionError(object, clazz);
                break;
            }
            case 4: {
                if (clazz == ScriptRuntime.StringClass || clazz.isInstance(object)) {
                    return object;
                }
                if (clazz == Character.TYPE || clazz == ScriptRuntime.CharacterClass) {
                    if (((String)object).length() == 1) {
                        return Character.valueOf(((String)object).charAt(0));
                    }
                    return NativeJavaObject.coerceToNumber(clazz, object);
                }
                if (clazz.isPrimitive() && clazz != Boolean.TYPE || ScriptRuntime.NumberClass.isAssignableFrom(clazz)) {
                    return NativeJavaObject.coerceToNumber(clazz, object);
                }
                NativeJavaObject.reportConversionError(object, clazz);
                break;
            }
            case 5: {
                if (object instanceof Wrapper) {
                    object = ((Wrapper)object).unwrap();
                }
                if (clazz == ScriptRuntime.ClassClass || clazz == ScriptRuntime.ObjectClass) {
                    return object;
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return object.toString();
                }
                NativeJavaObject.reportConversionError(object, clazz);
                break;
            }
            case 6: 
            case 7: {
                if (object instanceof Wrapper) {
                    object = ((Wrapper)object).unwrap();
                }
                if (clazz.isPrimitive()) {
                    if (clazz == Boolean.TYPE) {
                        NativeJavaObject.reportConversionError(object, clazz);
                    }
                    return NativeJavaObject.coerceToNumber(clazz, object);
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return object.toString();
                }
                if (clazz.isInstance(object)) {
                    return object;
                }
                NativeJavaObject.reportConversionError(object, clazz);
                break;
            }
            case 8: {
                if (clazz == ScriptRuntime.StringClass) {
                    return ScriptRuntime.toString(object);
                }
                if (clazz.isPrimitive()) {
                    if (clazz == Boolean.TYPE) {
                        NativeJavaObject.reportConversionError(object, clazz);
                    }
                    return NativeJavaObject.coerceToNumber(clazz, object);
                }
                if (clazz.isInstance(object)) {
                    return object;
                }
                if (clazz == ScriptRuntime.DateClass && object instanceof NativeDate) {
                    double d = ((NativeDate)object).getJSTimeValue();
                    return new Date((long)d);
                }
                if (clazz.isArray() && object instanceof NativeArray) {
                    NativeArray nativeArray = (NativeArray)object;
                    long l = nativeArray.getLength();
                    Class<?> clazz2 = clazz.getComponentType();
                    Object object2 = Array.newInstance(clazz2, (int)l);
                    int n = 0;
                    while ((long)n < l) {
                        try {
                            Array.set(object2, n, NativeJavaObject.coerceType(clazz2, nativeArray.get(n, (Scriptable)nativeArray)));
                        }
                        catch (EvaluatorException evaluatorException) {
                            NativeJavaObject.reportConversionError(object, clazz);
                        }
                        ++n;
                    }
                    return object2;
                }
                if (object instanceof Wrapper) {
                    if (clazz.isInstance(object = ((Wrapper)object).unwrap())) {
                        return object;
                    }
                    NativeJavaObject.reportConversionError(object, clazz);
                    break;
                }
                if (clazz.isInterface() && object instanceof Callable) {
                    if (object instanceof ScriptableObject) {
                        ScriptableObject scriptableObject = (ScriptableObject)object;
                        Object object3 = Kit.makeHashKeyFromPair(COERCED_INTERFACE_KEY, clazz);
                        Object object4 = scriptableObject.getAssociatedValue(object3);
                        if (object4 != null) {
                            return object4;
                        }
                        Context context = Context.getContext();
                        Object object5 = InterfaceAdapter.create(context, clazz, (Callable)object);
                        object5 = scriptableObject.associateValue(object3, object5);
                        return object5;
                    }
                    NativeJavaObject.reportConversionError(object, clazz);
                    break;
                }
                NativeJavaObject.reportConversionError(object, clazz);
            }
        }
        return object;
    }

    private static Object coerceToNumber(Class<?> clazz, Object object) {
        Class<?> clazz2 = object.getClass();
        if (clazz == Character.TYPE || clazz == ScriptRuntime.CharacterClass) {
            if (clazz2 == ScriptRuntime.CharacterClass) {
                return object;
            }
            return Character.valueOf((char)NativeJavaObject.toInteger(object, ScriptRuntime.CharacterClass, 0.0, 65535.0));
        }
        if (clazz == ScriptRuntime.ObjectClass || clazz == ScriptRuntime.DoubleClass || clazz == Double.TYPE) {
            return clazz2 == ScriptRuntime.DoubleClass ? object : new Double(NativeJavaObject.toDouble(object));
        }
        if (clazz == ScriptRuntime.FloatClass || clazz == Float.TYPE) {
            if (clazz2 == ScriptRuntime.FloatClass) {
                return object;
            }
            double d = NativeJavaObject.toDouble(object);
            if (Double.isInfinite(d) || Double.isNaN(d) || d == 0.0) {
                return new Float((float)d);
            }
            double d2 = Math.abs(d);
            if (d2 < (double)1.4E-45f) {
                return new Float(d > 0.0 ? 0.0 : -0.0);
            }
            if (d2 > 3.4028234663852886E38) {
                return new Float(d > 0.0 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY);
            }
            return new Float((float)d);
        }
        if (clazz == ScriptRuntime.IntegerClass || clazz == Integer.TYPE) {
            if (clazz2 == ScriptRuntime.IntegerClass) {
                return object;
            }
            return (int)NativeJavaObject.toInteger(object, ScriptRuntime.IntegerClass, -2.147483648E9, 2.147483647E9);
        }
        if (clazz == ScriptRuntime.LongClass || clazz == Long.TYPE) {
            if (clazz2 == ScriptRuntime.LongClass) {
                return object;
            }
            double d = Double.longBitsToDouble(4890909195324358655L);
            double d3 = Double.longBitsToDouble(-4332462841530417152L);
            return NativeJavaObject.toInteger(object, ScriptRuntime.LongClass, d3, d);
        }
        if (clazz == ScriptRuntime.ShortClass || clazz == Short.TYPE) {
            if (clazz2 == ScriptRuntime.ShortClass) {
                return object;
            }
            return (short)NativeJavaObject.toInteger(object, ScriptRuntime.ShortClass, -32768.0, 32767.0);
        }
        if (clazz == ScriptRuntime.ByteClass || clazz == Byte.TYPE) {
            if (clazz2 == ScriptRuntime.ByteClass) {
                return object;
            }
            return (byte)NativeJavaObject.toInteger(object, ScriptRuntime.ByteClass, -128.0, 127.0);
        }
        return new Double(NativeJavaObject.toDouble(object));
    }

    private static double toDouble(Object object) {
        Method method;
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            return ScriptRuntime.toNumber((String)object);
        }
        if (object instanceof Scriptable) {
            if (object instanceof Wrapper) {
                return NativeJavaObject.toDouble(((Wrapper)object).unwrap());
            }
            return ScriptRuntime.toNumber(object);
        }
        try {
            method = object.getClass().getMethod("doubleValue", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        catch (SecurityException securityException) {
            method = null;
        }
        if (method != null) {
            try {
                return ((Number)method.invoke(object, (Object[])null)).doubleValue();
            }
            catch (IllegalAccessException illegalAccessException) {
                NativeJavaObject.reportConversionError(object, Double.TYPE);
            }
            catch (InvocationTargetException invocationTargetException) {
                NativeJavaObject.reportConversionError(object, Double.TYPE);
            }
        }
        return ScriptRuntime.toNumber(object.toString());
    }

    private static long toInteger(Object object, Class<?> clazz, double d, double d2) {
        double d3 = NativeJavaObject.toDouble(object);
        if (Double.isInfinite(d3) || Double.isNaN(d3)) {
            NativeJavaObject.reportConversionError(ScriptRuntime.toString(object), clazz);
        }
        if ((d3 = d3 > 0.0 ? Math.floor(d3) : Math.ceil(d3)) < d || d3 > d2) {
            NativeJavaObject.reportConversionError(ScriptRuntime.toString(object), clazz);
        }
        return (long)d3;
    }

    static void reportConversionError(Object object, Class<?> clazz) {
        throw Context.reportRuntimeError2("msg.conversion.not.allowed", String.valueOf(object), JavaMembers.javaSignature(clazz));
    }

    static {
        Class[] classArray = new Class[2];
        Class<?> clazz = Kit.classOrNull("sun.org.mozilla.javascript.internal.JavaAdapter");
        if (clazz != null) {
            try {
                classArray[0] = ScriptRuntime.ObjectClass;
                classArray[1] = Kit.classOrNull("java.io.ObjectOutputStream");
                adapter_writeAdapterObject = clazz.getMethod("writeAdapterObject", classArray);
                classArray[0] = ScriptRuntime.ScriptableClass;
                classArray[1] = Kit.classOrNull("java.io.ObjectInputStream");
                adapter_readAdapterObject = clazz.getMethod("readAdapterObject", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                adapter_writeAdapterObject = null;
                adapter_readAdapterObject = null;
            }
        }
    }
}

