/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.ByteStream;
import com.ibm.jvm.trace.format.api.Message;
import com.ibm.jvm.trace.format.api.MessageFile;
import com.ibm.jvm.trace.format.api.TraceContext;
import com.ibm.jvm.trace.format.api.TracePoint;
import com.ibm.jvm.trace.format.api.TracePointDebugInfo;
import com.ibm.jvm.trace.format.api.TraceThread;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteOrder;

public class TracePointImpl
implements TracePoint {
    TraceContext context;
    String componentName = null;
    String containerComponentName = null;
    int tracepointID = -1;
    private byte[] parameterData = null;
    TraceThread thread = null;
    int tracepointLength = -1;
    private String padding = null;
    private static String compNamePadding = "          ";
    private static String tpIDPadding = "    ";
    private boolean isNormalTracepoint = true;
    private boolean isInvalid = false;
    long lostRecordCount = 0L;
    private long newTimerUpperWord = 0L;
    long time_lowerWord;
    BigInteger time_merged = BigInteger.ZERO;
    private Message message;
    byte[] debugData;
    TracePointDebugInfo debugInfo;
    static final String[] internedNames = new String[]{"j9vm", "j9mm", "j9jit", "j9bcu", "j9jcl", "j9scar", "j9bcverify"};
    static final byte[][] internedNamesAsBytes = new byte[internedNames.length][];

    public TracePointImpl(TraceContext context, ByteStream stream, TraceThread thread) {
        this.context = context;
        this.thread = thread;
        this.parseDataIntoTracepoint(stream);
        this.padding = context.getPointerSize() == 4 ? "            " : "                    ";
    }

    private TracePointImpl parseDataIntoTracepoint(ByteStream stream) {
        int parmDataStartsAt;
        int parmDataLength;
        int length;
        this.tracepointLength = length = stream.get() & 0xFF;
        boolean skipped = false;
        if (length == 0) {
            this.context.error(this, "found a 0 byte length tracepoint on thread " + this.thread);
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return this;
        }
        if (this.context.debugLevel > 0 && this.tracepointLength != 4) {
            this.debugData = new byte[length - 1];
            stream.get(this.debugData);
            stream = this.context.createByteStream(this.debugData);
            if (this.context.debugStream != null && this.context.debugLevel >= 5) {
                for (int i = 0; i < this.debugData.length; ++i) {
                    this.context.debugStream.print(this.debugData[i] + ", ");
                }
                this.context.debugStream.println();
            }
            skipped = true;
        }
        byte[] id = new byte[3];
        stream.get(id);
        if (this.tracepointLength == 4) {
            byte high = stream.get();
            if (id[1] == 0 && id[2] == 0) {
                this.tracepointLength = length = (high & 0xFF) << 8 | id[0] & 0xFF;
                if (this.context.debugLevel > 0) {
                    this.debugData = new byte[length - 1];
                    stream.get(this.debugData);
                    stream = this.context.createByteStream(this.debugData);
                    if (this.context.debugStream != null && this.context.debugLevel >= 5) {
                        for (int i = 0; i < this.debugData.length; ++i) {
                            this.context.debugStream.print(this.debugData[i] + ", ");
                        }
                        this.context.debugStream.println();
                    }
                    skipped = true;
                }
                stream.get(id);
            } else {
                this.context.error(this, "found a 4 byte length tracepoint, but it's center bytes are not null");
                this.isInvalid = true;
                this.isNormalTracepoint = false;
                return null;
            }
        }
        this.tracepointID = id[0] << 16 & 0xFF0000 | id[1] << 8 & 0xFF00 | id[2] & 0xFF;
        this.tracepointID &= 0x3FFF;
        if (this.tracepointLength == 8) {
            if (id[0] == 0 && id[1] == 1 && id[2] == 0) {
                this.lostRecordCount = stream.getUnsignedInt();
                if (this.lostRecordCount == 0L) {
                    this.lostRecordCount = -1L;
                }
                this.isNormalTracepoint = false;
                return this;
            }
            if (this.tracepointID == 0) {
                long sequence;
                this.isNormalTracepoint = false;
                this.newTimerUpperWord = sequence = stream.getUnsignedInt();
                if (this.context.debugStream != null) {
                    this.context.debug(this, 4, "Sequence wrap found, value = 0x" + Long.toString(sequence, 16));
                }
                return this;
            }
            this.context.error(this, "Special tracepoint (length is 8 bytes) but not sequence wrap or lost record, id = [" + id[0] + "," + id[1] + "," + id[2] + "]");
            if (!skipped) {
                stream.skip(4);
            }
            this.isInvalid = true;
            return this;
        }
        this.time_lowerWord = stream.getUnsignedInt();
        int compNameLength = stream.getInt();
        if (compNameLength <= 0 || compNameLength > this.tracepointLength - 8) {
            this.context.warning(this, "TracePoint.parseDataIntoTracepoint() detected bad component name length: " + compNameLength);
            if (!skipped) {
                stream.skip(this.tracepointLength - 8);
            }
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return this;
        }
        byte[] nameBytes = new byte[compNameLength];
        stream.get(nameBytes);
        this.componentName = this.componentIntern(nameBytes, 0, compNameLength);
        if (this.componentName == null || this.componentName.length() == 0) {
            this.context.warning(this, "TracePoint.parseDataIntoTracepoint() detected bad component name");
            if (!skipped) {
                stream.skip(this.tracepointLength - 8);
            }
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return this;
        }
        if (this.componentName.equals("INTERNALTRACECOMPONENT")) {
            this.componentName = "dg";
        } else {
            this.tracepointID -= 257;
        }
        int openBracketIndex = this.componentName.indexOf("(");
        if (openBracketIndex >= 0) {
            String newComponentName;
            int closeBracketIndex = this.componentName.indexOf(")");
            if (closeBracketIndex < 0 || closeBracketIndex < openBracketIndex) {
                this.context.debug(this, 3, "Overriding closeBracketIndex - not found in [" + this.componentName + "]");
                closeBracketIndex = this.componentName.length();
            }
            this.containerComponentName = this.componentName.substring(openBracketIndex + 1, closeBracketIndex);
            this.componentName = newComponentName = this.componentName.substring(0, openBracketIndex);
        }
        if ((parmDataLength = this.tracepointLength - (parmDataStartsAt = 12 + compNameLength)) > 0) {
            this.parameterData = new byte[parmDataLength];
            stream.get(this.parameterData);
        }
        this.message = this.context.messageFile.getMessageFromID(this.componentName, this.tracepointID);
        for (int i = 0; this.message.getType() == 13 && i < this.context.auxiliaryMessageFiles.size(); ++i) {
            MessageFile file = (MessageFile)this.context.auxiliaryMessageFiles.get(i);
            if (this.context.debugStream != null) {
                this.context.debug(this, 4, "Looking in auxiliary message file " + file.toString() + " for tracepoint " + this.componentName + "." + this.tracepointID);
            }
            this.message = file.getMessageFromID(this.componentName, this.tracepointID);
        }
        if (this.message.getType() == 13 && !this.componentName.equals("ApplicationTrace")) {
            if (parmDataLength > 0) {
                byte[] newParmData = new byte[parmDataLength + 2];
                System.arraycopy(this.parameterData, 0, newParmData, 2, this.parameterData.length);
                this.parameterData = newParmData;
                short len = (short)parmDataLength;
                if (stream.order() == ByteOrder.LITTLE_ENDIAN) {
                    this.parameterData[0] = (byte)(0xFF & len);
                    this.parameterData[1] = (byte)(0xFF00 & len);
                } else {
                    this.parameterData[0] = (byte)(0xFF00 & len);
                    this.parameterData[1] = (byte)(0xFF & len);
                }
            } else {
                this.message = new Message(13, "trace point not present in dat file", this.tracepointID, -1, this.componentName, "", this.context);
            }
        }
        if (this.message != null) {
            this.message.addStatistic("bytes", this.tracepointLength);
            this.message.addStatistic("count", 1L);
        }
        return this;
    }

    long getLostRecordCount() {
        return this.lostRecordCount;
    }

    private boolean internListCompare(byte[] traceData, int offset, int internedNamesIndex, int length) {
        int j;
        int l = internedNamesAsBytes[internedNamesIndex].length;
        if (l != length) {
            return false;
        }
        for (j = 0; j < l; ++j) {
            if (traceData[offset + j] == internedNamesAsBytes[internedNamesIndex][j]) continue;
            return false;
        }
        return j == traceData.length;
    }

    private String componentIntern(byte[] traceData, int offset, int length) {
        String t;
        int s = internedNames.length;
        for (int i = 0; i < s; ++i) {
            if (!this.internListCompare(traceData, offset, i, length)) continue;
            return internedNames[i];
        }
        try {
            t = new String(traceData, offset, length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            t = new String(traceData, offset, length);
        }
        return t;
    }

    public String toString() {
        StringBuffer tpFormatted = new StringBuffer();
        String threadIDString = "0x" + Long.toString(this.thread.getThreadID(), 16);
        tpFormatted.append(this.padding.substring(threadIDString.length()));
        tpFormatted.append(threadIDString);
        if (this.componentName.length() < compNamePadding.length()) {
            tpFormatted.append(compNamePadding.substring(this.componentName.length()));
        }
        tpFormatted.append(" ");
        tpFormatted.append(this.componentName);
        if (this.containerComponentName != null) {
            tpFormatted.append("(" + this.containerComponentName + ")");
        }
        tpFormatted.append(".");
        tpFormatted.append(this.tracepointID);
        if (Integer.toString(this.tracepointID).length() < tpIDPadding.length()) {
            tpFormatted.append(tpIDPadding.substring(Integer.toString(this.tracepointID).length()));
        }
        return tpFormatted.toString();
    }

    public int getTPID() {
        return this.tracepointID;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getContainerComponentName() {
        return this.containerComponentName;
    }

    public TraceThread getThread() {
        return this.thread;
    }

    public String getParameterDataFormatted() {
        Message msg = this.message;
        byte[] parmData = this.getParmData();
        String formattedData = null;
        if (parmData == null) {
            parmData = new byte[1];
            try {
                formattedData = msg.getMessage(parmData, 0, 0);
            }
            catch (Exception e) {
                formattedData = "FORMATTING PROBLEM OCCURRED WHILE PROCESSING THE RAW DATA FOR THIS TRACEPOINT - PARAMETER DATA UNAVAILABLE";
            }
        } else {
            try {
                formattedData = msg.getMessage(parmData, 0, parmData.length);
            }
            catch (Exception e) {
                formattedData = "FORMATTING PROBLEM OCCURRED WHILE PROCESSING THE RAW DATA FOR THIS TRACEPOINT - PARAMETER DATA MISMATCH";
            }
        }
        return formattedData;
    }

    public byte[] getParmData() {
        return this.parameterData;
    }

    public BigInteger getRawTime() {
        return this.time_merged;
    }

    public long getNewTimerUpperWord() {
        return this.newTimerUpperWord;
    }

    public boolean isNormalTracepoint() {
        return this.isNormalTracepoint;
    }

    public String getFormattedParameters() {
        return this.getParameterDataFormatted();
    }

    public String getFormattedTime() {
        return this.context.getFormattedTime(this.getRawTime());
    }

    public boolean isInvalid() {
        return this.isInvalid;
    }

    public int getTypeAsInt() {
        return this.message.getType();
    }

    public int getID() {
        return this.getTPID();
    }

    public long getTimestampMillis() {
        return 0L;
    }

    public int getMicrosecondsCount() {
        return 0;
    }

    public String getComponent() {
        return this.getComponentName();
    }

    public String getContainerComponent() {
        return this.getContainerComponentName();
    }

    public String getParameterFormattingTemplate() {
        return this.message.getFormattingTemplate();
    }

    public Object[] getParameters() {
        try {
            return this.message.parseMessage(this.getParmData(), 0);
        }
        catch (RuntimeException e) {
            RuntimeException n = new RuntimeException("Tracepoint: " + this.componentName + "." + this.tracepointID + ", template: " + this.getParameterFormattingTemplate(), e);
            n.setStackTrace(e.getStackTrace());
            throw n;
        }
    }

    public String[] getGroups() {
        return null;
    }

    public int getLevel() {
        return -1;
    }

    public String getType() {
        int type = this.message.getType();
        return TracePoint.types[type];
    }

    public String getDebugInfo() {
        if (this.debugInfo != null) {
            return "Record: " + this.debugInfo.record + ", offset: " + this.debugInfo.offset;
        }
        return "";
    }

    static {
        for (String current : internedNames) {
            int strlen = current.length();
            TracePointImpl.internedNamesAsBytes[i] = new byte[strlen];
            for (int j = 0; j < strlen; ++j) {
                TracePointImpl.internedNamesAsBytes[i][j] = (byte)current.charAt(j);
            }
        }
    }
}

